import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubDpsSharedAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#enrollment_read IothubDpsSharedAccessPolicy#enrollment_read}.
     *
     * @stability stable
     */
    readonly enrollmentRead?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#enrollment_write IothubDpsSharedAccessPolicy#enrollment_write}.
     *
     * @stability stable
     */
    readonly enrollmentWrite?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#iothub_dps_name IothubDpsSharedAccessPolicy#iothub_dps_name}.
     *
     * @stability stable
     */
    readonly iothubDpsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#name IothubDpsSharedAccessPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#registration_read IothubDpsSharedAccessPolicy#registration_read}.
     *
     * @stability stable
     */
    readonly registrationRead?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#registration_write IothubDpsSharedAccessPolicy#registration_write}.
     *
     * @stability stable
     */
    readonly registrationWrite?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#resource_group_name IothubDpsSharedAccessPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#service_config IothubDpsSharedAccessPolicy#service_config}.
     *
     * @stability stable
     */
    readonly serviceConfig?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#timeouts IothubDpsSharedAccessPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubDpsSharedAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface IothubDpsSharedAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#create IothubDpsSharedAccessPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#delete IothubDpsSharedAccessPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#read IothubDpsSharedAccessPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html#update IothubDpsSharedAccessPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubDpsSharedAccessPolicyTimeoutsToTerraform(struct?: IothubDpsSharedAccessPolicyTimeoutsOutputReference | IothubDpsSharedAccessPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubDpsSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubDpsSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubDpsSharedAccessPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html azurerm_iothub_dps_shared_access_policy}.
 *
 * @stability stable
 */
export declare class IothubDpsSharedAccessPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps_shared_access_policy.html azurerm_iothub_dps_shared_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubDpsSharedAccessPolicyConfig);
    private _enrollmentRead?;
    /**
     * @stability stable
     */
    get enrollmentRead(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enrollmentRead(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnrollmentRead(): void;
    /**
     * @stability stable
     */
    get enrollmentReadInput(): boolean | cdktf.IResolvable | undefined;
    private _enrollmentWrite?;
    /**
     * @stability stable
     */
    get enrollmentWrite(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enrollmentWrite(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnrollmentWrite(): void;
    /**
     * @stability stable
     */
    get enrollmentWriteInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubDpsName?;
    /**
     * @stability stable
     */
    get iothubDpsName(): string;
    /**
     * @stability stable
     */
    set iothubDpsName(value: string);
    /**
     * @stability stable
     */
    get iothubDpsNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _registrationRead?;
    /**
     * @stability stable
     */
    get registrationRead(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set registrationRead(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegistrationRead(): void;
    /**
     * @stability stable
     */
    get registrationReadInput(): boolean | cdktf.IResolvable | undefined;
    private _registrationWrite?;
    /**
     * @stability stable
     */
    get registrationWrite(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set registrationWrite(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegistrationWrite(): void;
    /**
     * @stability stable
     */
    get registrationWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _serviceConfig?;
    /**
     * @stability stable
     */
    get serviceConfig(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serviceConfig(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServiceConfig(): void;
    /**
     * @stability stable
     */
    get serviceConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubDpsSharedAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubDpsSharedAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubDpsSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
