import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubSharedAccessPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#device_connect IothubSharedAccessPolicyA#device_connect}.
     *
     * @stability stable
     */
    readonly deviceConnect?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#iothub_name IothubSharedAccessPolicyA#iothub_name}.
     *
     * @stability stable
     */
    readonly iothubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#name IothubSharedAccessPolicyA#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#registry_read IothubSharedAccessPolicyA#registry_read}.
     *
     * @stability stable
     */
    readonly registryRead?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#registry_write IothubSharedAccessPolicyA#registry_write}.
     *
     * @stability stable
     */
    readonly registryWrite?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#resource_group_name IothubSharedAccessPolicyA#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#service_connect IothubSharedAccessPolicyA#service_connect}.
     *
     * @stability stable
     */
    readonly serviceConnect?: boolean | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#timeouts IothubSharedAccessPolicyA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubSharedAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface IothubSharedAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#create IothubSharedAccessPolicyA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#delete IothubSharedAccessPolicyA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#read IothubSharedAccessPolicyA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html#update IothubSharedAccessPolicyA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubSharedAccessPolicyTimeoutsToTerraform(struct?: IothubSharedAccessPolicyTimeoutsOutputReference | IothubSharedAccessPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubSharedAccessPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html azurerm_iothub_shared_access_policy}.
 *
 * @stability stable
 */
export declare class IothubSharedAccessPolicyA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_shared_access_policy.html azurerm_iothub_shared_access_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubSharedAccessPolicyAConfig);
    private _deviceConnect?;
    /**
     * @stability stable
     */
    get deviceConnect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deviceConnect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeviceConnect(): void;
    /**
     * @stability stable
     */
    get deviceConnectInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubName?;
    /**
     * @stability stable
     */
    get iothubName(): string;
    /**
     * @stability stable
     */
    set iothubName(value: string);
    /**
     * @stability stable
     */
    get iothubNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _registryRead?;
    /**
     * @stability stable
     */
    get registryRead(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set registryRead(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegistryRead(): void;
    /**
     * @stability stable
     */
    get registryReadInput(): boolean | cdktf.IResolvable | undefined;
    private _registryWrite?;
    /**
     * @stability stable
     */
    get registryWrite(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set registryWrite(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegistryWrite(): void;
    /**
     * @stability stable
     */
    get registryWriteInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _serviceConnect?;
    /**
     * @stability stable
     */
    get serviceConnect(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set serviceConnect(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetServiceConnect(): void;
    /**
     * @stability stable
     */
    get serviceConnectInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubSharedAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubSharedAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
