import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#endpoint Iothub#endpoint}.
     *
     * @stability stable
     */
    readonly endpoint?: IothubEndpoint[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#enrichment Iothub#enrichment}.
     *
     * @stability stable
     */
    readonly enrichment?: IothubEnrichment[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#event_hub_partition_count Iothub#event_hub_partition_count}.
     *
     * @stability stable
     */
    readonly eventHubPartitionCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#event_hub_retention_in_days Iothub#event_hub_retention_in_days}.
     *
     * @stability stable
     */
    readonly eventHubRetentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#location Iothub#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#min_tls_version Iothub#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#name Iothub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#public_network_access_enabled Iothub#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#resource_group_name Iothub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#route Iothub#route}.
     *
     * @stability stable
     */
    readonly route?: IothubRoute[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#tags Iothub#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * fallback_route block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#fallback_route Iothub#fallback_route}
     *
     * @stability stable
     */
    readonly fallbackRoute?: IothubFallbackRoute;
    /**
     * file_upload block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#file_upload Iothub#file_upload}
     *
     * @stability stable
     */
    readonly fileUpload?: IothubFileUpload;
    /**
     * ip_filter_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#ip_filter_rule Iothub#ip_filter_rule}
     *
     * @stability stable
     */
    readonly ipFilterRule?: IothubIpFilterRule[];
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#sku Iothub#sku}
     *
     * @stability stable
     */
    readonly sku: IothubSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#timeouts Iothub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubTimeouts;
}
/**
 * @stability stable
 */
export interface IothubEndpoint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#batch_frequency_in_seconds Iothub#batch_frequency_in_seconds}.
     *
     * @stability stable
     */
    readonly batchFrequencyInSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#connection_string Iothub#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#container_name Iothub#container_name}.
     *
     * @stability stable
     */
    readonly containerName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#encoding Iothub#encoding}.
     *
     * @stability stable
     */
    readonly encoding?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#file_name_format Iothub#file_name_format}.
     *
     * @stability stable
     */
    readonly fileNameFormat?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#max_chunk_size_in_bytes Iothub#max_chunk_size_in_bytes}.
     *
     * @stability stable
     */
    readonly maxChunkSizeInBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#name Iothub#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#resource_group_name Iothub#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#type Iothub#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function iothubEndpointToTerraform(struct?: IothubEndpoint): any;
/**
 * @stability stable
 */
export interface IothubEnrichment {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#endpoint_names Iothub#endpoint_names}.
     *
     * @stability stable
     */
    readonly endpointNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#key Iothub#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#value Iothub#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function iothubEnrichmentToTerraform(struct?: IothubEnrichment): any;
/**
 * @stability stable
 */
export interface IothubRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#condition Iothub#condition}.
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#enabled Iothub#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#endpoint_names Iothub#endpoint_names}.
     *
     * @stability stable
     */
    readonly endpointNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#name Iothub#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#source Iothub#source}.
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function iothubRouteToTerraform(struct?: IothubRoute): any;
/**
 * @stability stable
 */
export declare class IothubSharedAccessPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    get permissions(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
}
/**
 * @stability stable
 */
export interface IothubFallbackRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#condition Iothub#condition}.
     *
     * @stability stable
     */
    readonly condition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#enabled Iothub#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#endpoint_names Iothub#endpoint_names}.
     *
     * @stability stable
     */
    readonly endpointNames?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#source Iothub#source}.
     *
     * @stability stable
     */
    readonly source?: string;
}
export declare function iothubFallbackRouteToTerraform(struct?: IothubFallbackRouteOutputReference | IothubFallbackRoute): any;
/**
 * @stability stable
 */
export declare class IothubFallbackRouteOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubFallbackRoute | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubFallbackRoute | undefined);
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): string;
    /**
     * @stability stable
     */
    set condition(value: string);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointNames?;
    /**
     * @stability stable
     */
    get endpointNames(): string[];
    /**
     * @stability stable
     */
    set endpointNames(value: string[]);
    /**
     * @stability stable
     */
    resetEndpointNames(): void;
    /**
     * @stability stable
     */
    get endpointNamesInput(): string[] | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IothubFileUpload {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#connection_string Iothub#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#container_name Iothub#container_name}.
     *
     * @stability stable
     */
    readonly containerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#default_ttl Iothub#default_ttl}.
     *
     * @stability stable
     */
    readonly defaultTtl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#lock_duration Iothub#lock_duration}.
     *
     * @stability stable
     */
    readonly lockDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#max_delivery_count Iothub#max_delivery_count}.
     *
     * @stability stable
     */
    readonly maxDeliveryCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#notifications Iothub#notifications}.
     *
     * @stability stable
     */
    readonly notifications?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#sas_ttl Iothub#sas_ttl}.
     *
     * @stability stable
     */
    readonly sasTtl?: string;
}
export declare function iothubFileUploadToTerraform(struct?: IothubFileUploadOutputReference | IothubFileUpload): any;
/**
 * @stability stable
 */
export declare class IothubFileUploadOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubFileUpload | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubFileUpload | undefined);
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _containerName?;
    /**
     * @stability stable
     */
    get containerName(): string;
    /**
     * @stability stable
     */
    set containerName(value: string);
    /**
     * @stability stable
     */
    get containerNameInput(): string | undefined;
    private _defaultTtl?;
    /**
     * @stability stable
     */
    get defaultTtl(): string;
    /**
     * @stability stable
     */
    set defaultTtl(value: string);
    /**
     * @stability stable
     */
    resetDefaultTtl(): void;
    /**
     * @stability stable
     */
    get defaultTtlInput(): string | undefined;
    private _lockDuration?;
    /**
     * @stability stable
     */
    get lockDuration(): string;
    /**
     * @stability stable
     */
    set lockDuration(value: string);
    /**
     * @stability stable
     */
    resetLockDuration(): void;
    /**
     * @stability stable
     */
    get lockDurationInput(): string | undefined;
    private _maxDeliveryCount?;
    /**
     * @stability stable
     */
    get maxDeliveryCount(): number;
    /**
     * @stability stable
     */
    set maxDeliveryCount(value: number);
    /**
     * @stability stable
     */
    resetMaxDeliveryCount(): void;
    /**
     * @stability stable
     */
    get maxDeliveryCountInput(): number | undefined;
    private _notifications?;
    /**
     * @stability stable
     */
    get notifications(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set notifications(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNotifications(): void;
    /**
     * @stability stable
     */
    get notificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _sasTtl?;
    /**
     * @stability stable
     */
    get sasTtl(): string;
    /**
     * @stability stable
     */
    set sasTtl(value: string);
    /**
     * @stability stable
     */
    resetSasTtl(): void;
    /**
     * @stability stable
     */
    get sasTtlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IothubIpFilterRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#action Iothub#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#ip_mask Iothub#ip_mask}.
     *
     * @stability stable
     */
    readonly ipMask: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#name Iothub#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function iothubIpFilterRuleToTerraform(struct?: IothubIpFilterRule): any;
/**
 * @stability stable
 */
export interface IothubSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#capacity Iothub#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#name Iothub#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function iothubSkuToTerraform(struct?: IothubSkuOutputReference | IothubSku): any;
/**
 * @stability stable
 */
export declare class IothubSkuOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IothubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#create Iothub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#delete Iothub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#read Iothub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html#update Iothub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubTimeoutsToTerraform(struct?: IothubTimeoutsOutputReference | IothubTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html azurerm_iothub}.
 *
 * @stability stable
 */
export declare class Iothub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub.html azurerm_iothub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubConfig);
    private _endpoint?;
    /**
     * @stability stable
     */
    get endpoint(): IothubEndpoint[];
    /**
     * @stability stable
     */
    set endpoint(value: IothubEndpoint[]);
    /**
     * @stability stable
     */
    resetEndpoint(): void;
    /**
     * @stability stable
     */
    get endpointInput(): IothubEndpoint[] | undefined;
    private _enrichment?;
    /**
     * @stability stable
     */
    get enrichment(): IothubEnrichment[];
    /**
     * @stability stable
     */
    set enrichment(value: IothubEnrichment[]);
    /**
     * @stability stable
     */
    resetEnrichment(): void;
    /**
     * @stability stable
     */
    get enrichmentInput(): IothubEnrichment[] | undefined;
    /**
     * @stability stable
     */
    get eventHubEventsEndpoint(): string;
    /**
     * @stability stable
     */
    get eventHubEventsPath(): string;
    /**
     * @stability stable
     */
    get eventHubOperationsEndpoint(): string;
    /**
     * @stability stable
     */
    get eventHubOperationsPath(): string;
    private _eventHubPartitionCount?;
    /**
     * @stability stable
     */
    get eventHubPartitionCount(): number;
    /**
     * @stability stable
     */
    set eventHubPartitionCount(value: number);
    /**
     * @stability stable
     */
    resetEventHubPartitionCount(): void;
    /**
     * @stability stable
     */
    get eventHubPartitionCountInput(): number | undefined;
    private _eventHubRetentionInDays?;
    /**
     * @stability stable
     */
    get eventHubRetentionInDays(): number;
    /**
     * @stability stable
     */
    set eventHubRetentionInDays(value: number);
    /**
     * @stability stable
     */
    resetEventHubRetentionInDays(): void;
    /**
     * @stability stable
     */
    get eventHubRetentionInDaysInput(): number | undefined;
    /**
     * @stability stable
     */
    get hostname(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _route?;
    /**
     * @stability stable
     */
    get route(): IothubRoute[];
    /**
     * @stability stable
     */
    set route(value: IothubRoute[]);
    /**
     * @stability stable
     */
    resetRoute(): void;
    /**
     * @stability stable
     */
    get routeInput(): IothubRoute[] | undefined;
    /**
     * @stability stable
     */
    sharedAccessPolicy(index: string): IothubSharedAccessPolicy;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _fallbackRoute;
    /**
     * @stability stable
     */
    get fallbackRoute(): IothubFallbackRouteOutputReference;
    /**
     * @stability stable
     */
    putFallbackRoute(value: IothubFallbackRoute): void;
    /**
     * @stability stable
     */
    resetFallbackRoute(): void;
    /**
     * @stability stable
     */
    get fallbackRouteInput(): IothubFallbackRoute | undefined;
    private _fileUpload;
    /**
     * @stability stable
     */
    get fileUpload(): IothubFileUploadOutputReference;
    /**
     * @stability stable
     */
    putFileUpload(value: IothubFileUpload): void;
    /**
     * @stability stable
     */
    resetFileUpload(): void;
    /**
     * @stability stable
     */
    get fileUploadInput(): IothubFileUpload | undefined;
    private _ipFilterRule?;
    /**
     * @stability stable
     */
    get ipFilterRule(): IothubIpFilterRule[];
    /**
     * @stability stable
     */
    set ipFilterRule(value: IothubIpFilterRule[]);
    /**
     * @stability stable
     */
    resetIpFilterRule(): void;
    /**
     * @stability stable
     */
    get ipFilterRuleInput(): IothubIpFilterRule[] | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): IothubSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: IothubSku): void;
    /**
     * @stability stable
     */
    get skuInput(): IothubSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
