import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KeyVaultManagedStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#key_vault_id KeyVaultManagedStorageAccount#key_vault_id}.
     *
     * @stability stable
     */
    readonly keyVaultId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#name KeyVaultManagedStorageAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#regenerate_key_automatically KeyVaultManagedStorageAccount#regenerate_key_automatically}.
     *
     * @stability stable
     */
    readonly regenerateKeyAutomatically?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#regeneration_period KeyVaultManagedStorageAccount#regeneration_period}.
     *
     * @stability stable
     */
    readonly regenerationPeriod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#storage_account_id KeyVaultManagedStorageAccount#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#storage_account_key KeyVaultManagedStorageAccount#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#tags KeyVaultManagedStorageAccount#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#timeouts KeyVaultManagedStorageAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KeyVaultManagedStorageAccountTimeouts;
}
/**
 * @stability stable
 */
export interface KeyVaultManagedStorageAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#create KeyVaultManagedStorageAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#delete KeyVaultManagedStorageAccount#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#read KeyVaultManagedStorageAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html#update KeyVaultManagedStorageAccount#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function keyVaultManagedStorageAccountTimeoutsToTerraform(struct?: KeyVaultManagedStorageAccountTimeoutsOutputReference | KeyVaultManagedStorageAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class KeyVaultManagedStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KeyVaultManagedStorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KeyVaultManagedStorageAccountTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html azurerm_key_vault_managed_storage_account}.
 *
 * @stability stable
 */
export declare class KeyVaultManagedStorageAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/key_vault_managed_storage_account.html azurerm_key_vault_managed_storage_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KeyVaultManagedStorageAccountConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultId?;
    /**
     * @stability stable
     */
    get keyVaultId(): string;
    /**
     * @stability stable
     */
    set keyVaultId(value: string);
    /**
     * @stability stable
     */
    get keyVaultIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _regenerateKeyAutomatically?;
    /**
     * @stability stable
     */
    get regenerateKeyAutomatically(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set regenerateKeyAutomatically(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegenerateKeyAutomatically(): void;
    /**
     * @stability stable
     */
    get regenerateKeyAutomaticallyInput(): boolean | cdktf.IResolvable | undefined;
    private _regenerationPeriod?;
    /**
     * @stability stable
     */
    get regenerationPeriod(): string;
    /**
     * @stability stable
     */
    set regenerationPeriod(value: string);
    /**
     * @stability stable
     */
    resetRegenerationPeriod(): void;
    /**
     * @stability stable
     */
    get regenerationPeriodInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _storageAccountKey?;
    /**
     * @stability stable
     */
    get storageAccountKey(): string;
    /**
     * @stability stable
     */
    set storageAccountKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountKeyInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KeyVaultManagedStorageAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KeyVaultManagedStorageAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KeyVaultManagedStorageAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
