import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#api_server_authorized_ip_ranges KubernetesCluster#api_server_authorized_ip_ranges}.
     *
     * @stability stable
     */
    readonly apiServerAuthorizedIpRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#automatic_channel_upgrade KubernetesCluster#automatic_channel_upgrade}.
     *
     * @stability stable
     */
    readonly automaticChannelUpgrade?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#disk_encryption_set_id KubernetesCluster#disk_encryption_set_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionSetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#dns_prefix KubernetesCluster#dns_prefix}.
     *
     * @stability stable
     */
    readonly dnsPrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#dns_prefix_private_cluster KubernetesCluster#dns_prefix_private_cluster}.
     *
     * @stability stable
     */
    readonly dnsPrefixPrivateCluster?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enable_pod_security_policy KubernetesCluster#enable_pod_security_policy}.
     *
     * @stability stable
     */
    readonly enablePodSecurityPolicy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kubernetes_version KubernetesCluster#kubernetes_version}.
     *
     * @stability stable
     */
    readonly kubernetesVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#local_account_disabled KubernetesCluster#local_account_disabled}.
     *
     * @stability stable
     */
    readonly localAccountDisabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#location KubernetesCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#name KubernetesCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#node_resource_group KubernetesCluster#node_resource_group}.
     *
     * @stability stable
     */
    readonly nodeResourceGroup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#private_cluster_enabled KubernetesCluster#private_cluster_enabled}.
     *
     * @stability stable
     */
    readonly privateClusterEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#private_cluster_public_fqdn_enabled KubernetesCluster#private_cluster_public_fqdn_enabled}.
     *
     * @stability stable
     */
    readonly privateClusterPublicFqdnEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#private_dns_zone_id KubernetesCluster#private_dns_zone_id}.
     *
     * @stability stable
     */
    readonly privateDnsZoneId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#private_link_enabled KubernetesCluster#private_link_enabled}.
     *
     * @stability stable
     */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#resource_group_name KubernetesCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#sku_tier KubernetesCluster#sku_tier}.
     *
     * @stability stable
     */
    readonly skuTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#tags KubernetesCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * addon_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#addon_profile KubernetesCluster#addon_profile}
     *
     * @stability stable
     */
    readonly addonProfile?: KubernetesClusterAddonProfile;
    /**
     * auto_scaler_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#auto_scaler_profile KubernetesCluster#auto_scaler_profile}
     *
     * @stability stable
     */
    readonly autoScalerProfile?: KubernetesClusterAutoScalerProfile;
    /**
     * default_node_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#default_node_pool KubernetesCluster#default_node_pool}
     *
     * @stability stable
     */
    readonly defaultNodePool: KubernetesClusterDefaultNodePool;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#identity KubernetesCluster#identity}
     *
     * @stability stable
     */
    readonly identity?: KubernetesClusterIdentity;
    /**
     * kubelet_identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kubelet_identity KubernetesCluster#kubelet_identity}
     *
     * @stability stable
     */
    readonly kubeletIdentity?: KubernetesClusterKubeletIdentity;
    /**
     * linux_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#linux_profile KubernetesCluster#linux_profile}
     *
     * @stability stable
     */
    readonly linuxProfile?: KubernetesClusterLinuxProfile;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#maintenance_window KubernetesCluster#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: KubernetesClusterMaintenanceWindow;
    /**
     * network_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_profile KubernetesCluster#network_profile}
     *
     * @stability stable
     */
    readonly networkProfile?: KubernetesClusterNetworkProfile;
    /**
     * role_based_access_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#role_based_access_control KubernetesCluster#role_based_access_control}
     *
     * @stability stable
     */
    readonly roleBasedAccessControl?: KubernetesClusterRoleBasedAccessControl;
    /**
     * service_principal block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#service_principal KubernetesCluster#service_principal}
     *
     * @stability stable
     */
    readonly servicePrincipal?: KubernetesClusterServicePrincipal;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#timeouts KubernetesCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KubernetesClusterTimeouts;
    /**
     * windows_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#windows_profile KubernetesCluster#windows_profile}
     *
     * @stability stable
     */
    readonly windowsProfile?: KubernetesClusterWindowsProfile;
}
/**
 * @stability stable
 */
export declare class KubernetesClusterKubeAdminConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get clusterCaCertificate(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class KubernetesClusterKubeConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get clusterCaCertificate(): string;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileAciConnectorLinux {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#subnet_name KubernetesCluster#subnet_name}.
     *
     * @stability stable
     */
    readonly subnetName?: string;
}
export declare function kubernetesClusterAddonProfileAciConnectorLinuxToTerraform(struct?: KubernetesClusterAddonProfileAciConnectorLinuxOutputReference | KubernetesClusterAddonProfileAciConnectorLinux): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileAciConnectorLinuxOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileAciConnectorLinux | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileAciConnectorLinux | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetName?;
    /**
     * @stability stable
     */
    get subnetName(): string;
    /**
     * @stability stable
     */
    set subnetName(value: string);
    /**
     * @stability stable
     */
    resetSubnetName(): void;
    /**
     * @stability stable
     */
    get subnetNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileAzurePolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAddonProfileAzurePolicyToTerraform(struct?: KubernetesClusterAddonProfileAzurePolicyOutputReference | KubernetesClusterAddonProfileAzurePolicy): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileAzurePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileAzurePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileAzurePolicy | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileHttpApplicationRouting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAddonProfileHttpApplicationRoutingToTerraform(struct?: KubernetesClusterAddonProfileHttpApplicationRoutingOutputReference | KubernetesClusterAddonProfileHttpApplicationRouting): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileHttpApplicationRoutingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileHttpApplicationRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileHttpApplicationRouting | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileIngressApplicationGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#gateway_id KubernetesCluster#gateway_id}.
     *
     * @stability stable
     */
    readonly gatewayId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#gateway_name KubernetesCluster#gateway_name}.
     *
     * @stability stable
     */
    readonly gatewayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#subnet_cidr KubernetesCluster#subnet_cidr}.
     *
     * @stability stable
     */
    readonly subnetCidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#subnet_id KubernetesCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function kubernetesClusterAddonProfileIngressApplicationGatewayToTerraform(struct?: KubernetesClusterAddonProfileIngressApplicationGatewayOutputReference | KubernetesClusterAddonProfileIngressApplicationGateway): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileIngressApplicationGatewayOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileIngressApplicationGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileIngressApplicationGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _gatewayId?;
    /**
     * @stability stable
     */
    get gatewayId(): string;
    /**
     * @stability stable
     */
    set gatewayId(value: string);
    /**
     * @stability stable
     */
    resetGatewayId(): void;
    /**
     * @stability stable
     */
    get gatewayIdInput(): string | undefined;
    private _gatewayName?;
    /**
     * @stability stable
     */
    get gatewayName(): string;
    /**
     * @stability stable
     */
    set gatewayName(value: string);
    /**
     * @stability stable
     */
    resetGatewayName(): void;
    /**
     * @stability stable
     */
    get gatewayNameInput(): string | undefined;
    private _subnetCidr?;
    /**
     * @stability stable
     */
    get subnetCidr(): string;
    /**
     * @stability stable
     */
    set subnetCidr(value: string);
    /**
     * @stability stable
     */
    resetSubnetCidr(): void;
    /**
     * @stability stable
     */
    get subnetCidrInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileKubeDashboard {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAddonProfileKubeDashboardToTerraform(struct?: KubernetesClusterAddonProfileKubeDashboardOutputReference | KubernetesClusterAddonProfileKubeDashboard): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileKubeDashboardOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileKubeDashboard | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileKubeDashboard | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileOmsAgent {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#log_analytics_workspace_id KubernetesCluster#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId?: string;
}
export declare function kubernetesClusterAddonProfileOmsAgentToTerraform(struct?: KubernetesClusterAddonProfileOmsAgentOutputReference | KubernetesClusterAddonProfileOmsAgent): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileOmsAgentOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileOmsAgent | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileOmsAgent | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetLogAnalyticsWorkspaceId(): void;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfileOpenServiceMesh {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAddonProfileOpenServiceMeshToTerraform(struct?: KubernetesClusterAddonProfileOpenServiceMeshOutputReference | KubernetesClusterAddonProfileOpenServiceMesh): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileOpenServiceMeshOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfileOpenServiceMesh | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfileOpenServiceMesh | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAddonProfile {
    /**
     * aci_connector_linux block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#aci_connector_linux KubernetesCluster#aci_connector_linux}
     *
     * @stability stable
     */
    readonly aciConnectorLinux?: KubernetesClusterAddonProfileAciConnectorLinux;
    /**
     * azure_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#azure_policy KubernetesCluster#azure_policy}
     *
     * @stability stable
     */
    readonly azurePolicy?: KubernetesClusterAddonProfileAzurePolicy;
    /**
     * http_application_routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#http_application_routing KubernetesCluster#http_application_routing}
     *
     * @stability stable
     */
    readonly httpApplicationRouting?: KubernetesClusterAddonProfileHttpApplicationRouting;
    /**
     * ingress_application_gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#ingress_application_gateway KubernetesCluster#ingress_application_gateway}
     *
     * @stability stable
     */
    readonly ingressApplicationGateway?: KubernetesClusterAddonProfileIngressApplicationGateway;
    /**
     * kube_dashboard block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kube_dashboard KubernetesCluster#kube_dashboard}
     *
     * @stability stable
     */
    readonly kubeDashboard?: KubernetesClusterAddonProfileKubeDashboard;
    /**
     * oms_agent block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#oms_agent KubernetesCluster#oms_agent}
     *
     * @stability stable
     */
    readonly omsAgent?: KubernetesClusterAddonProfileOmsAgent;
    /**
     * open_service_mesh block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#open_service_mesh KubernetesCluster#open_service_mesh}
     *
     * @stability stable
     */
    readonly openServiceMesh?: KubernetesClusterAddonProfileOpenServiceMesh;
}
export declare function kubernetesClusterAddonProfileToTerraform(struct?: KubernetesClusterAddonProfileOutputReference | KubernetesClusterAddonProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAddonProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAddonProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAddonProfile | undefined);
    private _aciConnectorLinux;
    /**
     * @stability stable
     */
    get aciConnectorLinux(): KubernetesClusterAddonProfileAciConnectorLinuxOutputReference;
    /**
     * @stability stable
     */
    putAciConnectorLinux(value: KubernetesClusterAddonProfileAciConnectorLinux): void;
    /**
     * @stability stable
     */
    resetAciConnectorLinux(): void;
    /**
     * @stability stable
     */
    get aciConnectorLinuxInput(): KubernetesClusterAddonProfileAciConnectorLinux | undefined;
    private _azurePolicy;
    /**
     * @stability stable
     */
    get azurePolicy(): KubernetesClusterAddonProfileAzurePolicyOutputReference;
    /**
     * @stability stable
     */
    putAzurePolicy(value: KubernetesClusterAddonProfileAzurePolicy): void;
    /**
     * @stability stable
     */
    resetAzurePolicy(): void;
    /**
     * @stability stable
     */
    get azurePolicyInput(): KubernetesClusterAddonProfileAzurePolicy | undefined;
    private _httpApplicationRouting;
    /**
     * @stability stable
     */
    get httpApplicationRouting(): KubernetesClusterAddonProfileHttpApplicationRoutingOutputReference;
    /**
     * @stability stable
     */
    putHttpApplicationRouting(value: KubernetesClusterAddonProfileHttpApplicationRouting): void;
    /**
     * @stability stable
     */
    resetHttpApplicationRouting(): void;
    /**
     * @stability stable
     */
    get httpApplicationRoutingInput(): KubernetesClusterAddonProfileHttpApplicationRouting | undefined;
    private _ingressApplicationGateway;
    /**
     * @stability stable
     */
    get ingressApplicationGateway(): KubernetesClusterAddonProfileIngressApplicationGatewayOutputReference;
    /**
     * @stability stable
     */
    putIngressApplicationGateway(value: KubernetesClusterAddonProfileIngressApplicationGateway): void;
    /**
     * @stability stable
     */
    resetIngressApplicationGateway(): void;
    /**
     * @stability stable
     */
    get ingressApplicationGatewayInput(): KubernetesClusterAddonProfileIngressApplicationGateway | undefined;
    private _kubeDashboard;
    /**
     * @stability stable
     */
    get kubeDashboard(): KubernetesClusterAddonProfileKubeDashboardOutputReference;
    /**
     * @stability stable
     */
    putKubeDashboard(value: KubernetesClusterAddonProfileKubeDashboard): void;
    /**
     * @stability stable
     */
    resetKubeDashboard(): void;
    /**
     * @stability stable
     */
    get kubeDashboardInput(): KubernetesClusterAddonProfileKubeDashboard | undefined;
    private _omsAgent;
    /**
     * @stability stable
     */
    get omsAgent(): KubernetesClusterAddonProfileOmsAgentOutputReference;
    /**
     * @stability stable
     */
    putOmsAgent(value: KubernetesClusterAddonProfileOmsAgent): void;
    /**
     * @stability stable
     */
    resetOmsAgent(): void;
    /**
     * @stability stable
     */
    get omsAgentInput(): KubernetesClusterAddonProfileOmsAgent | undefined;
    private _openServiceMesh;
    /**
     * @stability stable
     */
    get openServiceMesh(): KubernetesClusterAddonProfileOpenServiceMeshOutputReference;
    /**
     * @stability stable
     */
    putOpenServiceMesh(value: KubernetesClusterAddonProfileOpenServiceMesh): void;
    /**
     * @stability stable
     */
    resetOpenServiceMesh(): void;
    /**
     * @stability stable
     */
    get openServiceMeshInput(): KubernetesClusterAddonProfileOpenServiceMesh | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterAutoScalerProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#balance_similar_node_groups KubernetesCluster#balance_similar_node_groups}.
     *
     * @stability stable
     */
    readonly balanceSimilarNodeGroups?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#empty_bulk_delete_max KubernetesCluster#empty_bulk_delete_max}.
     *
     * @stability stable
     */
    readonly emptyBulkDeleteMax?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#expander KubernetesCluster#expander}.
     *
     * @stability stable
     */
    readonly expander?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_graceful_termination_sec KubernetesCluster#max_graceful_termination_sec}.
     *
     * @stability stable
     */
    readonly maxGracefulTerminationSec?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_node_provisioning_time KubernetesCluster#max_node_provisioning_time}.
     *
     * @stability stable
     */
    readonly maxNodeProvisioningTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_unready_nodes KubernetesCluster#max_unready_nodes}.
     *
     * @stability stable
     */
    readonly maxUnreadyNodes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_unready_percentage KubernetesCluster#max_unready_percentage}.
     *
     * @stability stable
     */
    readonly maxUnreadyPercentage?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#new_pod_scale_up_delay KubernetesCluster#new_pod_scale_up_delay}.
     *
     * @stability stable
     */
    readonly newPodScaleUpDelay?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_delay_after_add KubernetesCluster#scale_down_delay_after_add}.
     *
     * @stability stable
     */
    readonly scaleDownDelayAfterAdd?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_delay_after_delete KubernetesCluster#scale_down_delay_after_delete}.
     *
     * @stability stable
     */
    readonly scaleDownDelayAfterDelete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_delay_after_failure KubernetesCluster#scale_down_delay_after_failure}.
     *
     * @stability stable
     */
    readonly scaleDownDelayAfterFailure?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_unneeded KubernetesCluster#scale_down_unneeded}.
     *
     * @stability stable
     */
    readonly scaleDownUnneeded?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_unready KubernetesCluster#scale_down_unready}.
     *
     * @stability stable
     */
    readonly scaleDownUnready?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scale_down_utilization_threshold KubernetesCluster#scale_down_utilization_threshold}.
     *
     * @stability stable
     */
    readonly scaleDownUtilizationThreshold?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#scan_interval KubernetesCluster#scan_interval}.
     *
     * @stability stable
     */
    readonly scanInterval?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#skip_nodes_with_local_storage KubernetesCluster#skip_nodes_with_local_storage}.
     *
     * @stability stable
     */
    readonly skipNodesWithLocalStorage?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#skip_nodes_with_system_pods KubernetesCluster#skip_nodes_with_system_pods}.
     *
     * @stability stable
     */
    readonly skipNodesWithSystemPods?: boolean | cdktf.IResolvable;
}
export declare function kubernetesClusterAutoScalerProfileToTerraform(struct?: KubernetesClusterAutoScalerProfileOutputReference | KubernetesClusterAutoScalerProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterAutoScalerProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterAutoScalerProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterAutoScalerProfile | undefined);
    private _balanceSimilarNodeGroups?;
    /**
     * @stability stable
     */
    get balanceSimilarNodeGroups(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set balanceSimilarNodeGroups(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBalanceSimilarNodeGroups(): void;
    /**
     * @stability stable
     */
    get balanceSimilarNodeGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _emptyBulkDeleteMax?;
    /**
     * @stability stable
     */
    get emptyBulkDeleteMax(): string;
    /**
     * @stability stable
     */
    set emptyBulkDeleteMax(value: string);
    /**
     * @stability stable
     */
    resetEmptyBulkDeleteMax(): void;
    /**
     * @stability stable
     */
    get emptyBulkDeleteMaxInput(): string | undefined;
    private _expander?;
    /**
     * @stability stable
     */
    get expander(): string;
    /**
     * @stability stable
     */
    set expander(value: string);
    /**
     * @stability stable
     */
    resetExpander(): void;
    /**
     * @stability stable
     */
    get expanderInput(): string | undefined;
    private _maxGracefulTerminationSec?;
    /**
     * @stability stable
     */
    get maxGracefulTerminationSec(): string;
    /**
     * @stability stable
     */
    set maxGracefulTerminationSec(value: string);
    /**
     * @stability stable
     */
    resetMaxGracefulTerminationSec(): void;
    /**
     * @stability stable
     */
    get maxGracefulTerminationSecInput(): string | undefined;
    private _maxNodeProvisioningTime?;
    /**
     * @stability stable
     */
    get maxNodeProvisioningTime(): string;
    /**
     * @stability stable
     */
    set maxNodeProvisioningTime(value: string);
    /**
     * @stability stable
     */
    resetMaxNodeProvisioningTime(): void;
    /**
     * @stability stable
     */
    get maxNodeProvisioningTimeInput(): string | undefined;
    private _maxUnreadyNodes?;
    /**
     * @stability stable
     */
    get maxUnreadyNodes(): number;
    /**
     * @stability stable
     */
    set maxUnreadyNodes(value: number);
    /**
     * @stability stable
     */
    resetMaxUnreadyNodes(): void;
    /**
     * @stability stable
     */
    get maxUnreadyNodesInput(): number | undefined;
    private _maxUnreadyPercentage?;
    /**
     * @stability stable
     */
    get maxUnreadyPercentage(): number;
    /**
     * @stability stable
     */
    set maxUnreadyPercentage(value: number);
    /**
     * @stability stable
     */
    resetMaxUnreadyPercentage(): void;
    /**
     * @stability stable
     */
    get maxUnreadyPercentageInput(): number | undefined;
    private _newPodScaleUpDelay?;
    /**
     * @stability stable
     */
    get newPodScaleUpDelay(): string;
    /**
     * @stability stable
     */
    set newPodScaleUpDelay(value: string);
    /**
     * @stability stable
     */
    resetNewPodScaleUpDelay(): void;
    /**
     * @stability stable
     */
    get newPodScaleUpDelayInput(): string | undefined;
    private _scaleDownDelayAfterAdd?;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterAdd(): string;
    /**
     * @stability stable
     */
    set scaleDownDelayAfterAdd(value: string);
    /**
     * @stability stable
     */
    resetScaleDownDelayAfterAdd(): void;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterAddInput(): string | undefined;
    private _scaleDownDelayAfterDelete?;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterDelete(): string;
    /**
     * @stability stable
     */
    set scaleDownDelayAfterDelete(value: string);
    /**
     * @stability stable
     */
    resetScaleDownDelayAfterDelete(): void;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterDeleteInput(): string | undefined;
    private _scaleDownDelayAfterFailure?;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterFailure(): string;
    /**
     * @stability stable
     */
    set scaleDownDelayAfterFailure(value: string);
    /**
     * @stability stable
     */
    resetScaleDownDelayAfterFailure(): void;
    /**
     * @stability stable
     */
    get scaleDownDelayAfterFailureInput(): string | undefined;
    private _scaleDownUnneeded?;
    /**
     * @stability stable
     */
    get scaleDownUnneeded(): string;
    /**
     * @stability stable
     */
    set scaleDownUnneeded(value: string);
    /**
     * @stability stable
     */
    resetScaleDownUnneeded(): void;
    /**
     * @stability stable
     */
    get scaleDownUnneededInput(): string | undefined;
    private _scaleDownUnready?;
    /**
     * @stability stable
     */
    get scaleDownUnready(): string;
    /**
     * @stability stable
     */
    set scaleDownUnready(value: string);
    /**
     * @stability stable
     */
    resetScaleDownUnready(): void;
    /**
     * @stability stable
     */
    get scaleDownUnreadyInput(): string | undefined;
    private _scaleDownUtilizationThreshold?;
    /**
     * @stability stable
     */
    get scaleDownUtilizationThreshold(): string;
    /**
     * @stability stable
     */
    set scaleDownUtilizationThreshold(value: string);
    /**
     * @stability stable
     */
    resetScaleDownUtilizationThreshold(): void;
    /**
     * @stability stable
     */
    get scaleDownUtilizationThresholdInput(): string | undefined;
    private _scanInterval?;
    /**
     * @stability stable
     */
    get scanInterval(): string;
    /**
     * @stability stable
     */
    set scanInterval(value: string);
    /**
     * @stability stable
     */
    resetScanInterval(): void;
    /**
     * @stability stable
     */
    get scanIntervalInput(): string | undefined;
    private _skipNodesWithLocalStorage?;
    /**
     * @stability stable
     */
    get skipNodesWithLocalStorage(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipNodesWithLocalStorage(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipNodesWithLocalStorage(): void;
    /**
     * @stability stable
     */
    get skipNodesWithLocalStorageInput(): boolean | cdktf.IResolvable | undefined;
    private _skipNodesWithSystemPods?;
    /**
     * @stability stable
     */
    get skipNodesWithSystemPods(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set skipNodesWithSystemPods(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSkipNodesWithSystemPods(): void;
    /**
     * @stability stable
     */
    get skipNodesWithSystemPodsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterDefaultNodePoolKubeletConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#allowed_unsafe_sysctls KubernetesCluster#allowed_unsafe_sysctls}.
     *
     * @stability stable
     */
    readonly allowedUnsafeSysctls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#container_log_max_line KubernetesCluster#container_log_max_line}.
     *
     * @stability stable
     */
    readonly containerLogMaxLine?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#container_log_max_size_mb KubernetesCluster#container_log_max_size_mb}.
     *
     * @stability stable
     */
    readonly containerLogMaxSizeMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#cpu_cfs_quota_enabled KubernetesCluster#cpu_cfs_quota_enabled}.
     *
     * @stability stable
     */
    readonly cpuCfsQuotaEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#cpu_cfs_quota_period KubernetesCluster#cpu_cfs_quota_period}.
     *
     * @stability stable
     */
    readonly cpuCfsQuotaPeriod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#cpu_manager_policy KubernetesCluster#cpu_manager_policy}.
     *
     * @stability stable
     */
    readonly cpuManagerPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#image_gc_high_threshold KubernetesCluster#image_gc_high_threshold}.
     *
     * @stability stable
     */
    readonly imageGcHighThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#image_gc_low_threshold KubernetesCluster#image_gc_low_threshold}.
     *
     * @stability stable
     */
    readonly imageGcLowThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#pod_max_pid KubernetesCluster#pod_max_pid}.
     *
     * @stability stable
     */
    readonly podMaxPid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#topology_manager_policy KubernetesCluster#topology_manager_policy}.
     *
     * @stability stable
     */
    readonly topologyManagerPolicy?: string;
}
export declare function kubernetesClusterDefaultNodePoolKubeletConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolKubeletConfigOutputReference | KubernetesClusterDefaultNodePoolKubeletConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterDefaultNodePoolKubeletConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterDefaultNodePoolKubeletConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterDefaultNodePoolKubeletConfig | undefined);
    private _allowedUnsafeSysctls?;
    /**
     * @stability stable
     */
    get allowedUnsafeSysctls(): string[];
    /**
     * @stability stable
     */
    set allowedUnsafeSysctls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedUnsafeSysctls(): void;
    /**
     * @stability stable
     */
    get allowedUnsafeSysctlsInput(): string[] | undefined;
    private _containerLogMaxLine?;
    /**
     * @stability stable
     */
    get containerLogMaxLine(): number;
    /**
     * @stability stable
     */
    set containerLogMaxLine(value: number);
    /**
     * @stability stable
     */
    resetContainerLogMaxLine(): void;
    /**
     * @stability stable
     */
    get containerLogMaxLineInput(): number | undefined;
    private _containerLogMaxSizeMb?;
    /**
     * @stability stable
     */
    get containerLogMaxSizeMb(): number;
    /**
     * @stability stable
     */
    set containerLogMaxSizeMb(value: number);
    /**
     * @stability stable
     */
    resetContainerLogMaxSizeMb(): void;
    /**
     * @stability stable
     */
    get containerLogMaxSizeMbInput(): number | undefined;
    private _cpuCfsQuotaEnabled?;
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set cpuCfsQuotaEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCpuCfsQuotaEnabled(): void;
    /**
     * @stability stable
     */
    get cpuCfsQuotaEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cpuCfsQuotaPeriod?;
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriod(): string;
    /**
     * @stability stable
     */
    set cpuCfsQuotaPeriod(value: string);
    /**
     * @stability stable
     */
    resetCpuCfsQuotaPeriod(): void;
    /**
     * @stability stable
     */
    get cpuCfsQuotaPeriodInput(): string | undefined;
    private _cpuManagerPolicy?;
    /**
     * @stability stable
     */
    get cpuManagerPolicy(): string;
    /**
     * @stability stable
     */
    set cpuManagerPolicy(value: string);
    /**
     * @stability stable
     */
    resetCpuManagerPolicy(): void;
    /**
     * @stability stable
     */
    get cpuManagerPolicyInput(): string | undefined;
    private _imageGcHighThreshold?;
    /**
     * @stability stable
     */
    get imageGcHighThreshold(): number;
    /**
     * @stability stable
     */
    set imageGcHighThreshold(value: number);
    /**
     * @stability stable
     */
    resetImageGcHighThreshold(): void;
    /**
     * @stability stable
     */
    get imageGcHighThresholdInput(): number | undefined;
    private _imageGcLowThreshold?;
    /**
     * @stability stable
     */
    get imageGcLowThreshold(): number;
    /**
     * @stability stable
     */
    set imageGcLowThreshold(value: number);
    /**
     * @stability stable
     */
    resetImageGcLowThreshold(): void;
    /**
     * @stability stable
     */
    get imageGcLowThresholdInput(): number | undefined;
    private _podMaxPid?;
    /**
     * @stability stable
     */
    get podMaxPid(): number;
    /**
     * @stability stable
     */
    set podMaxPid(value: number);
    /**
     * @stability stable
     */
    resetPodMaxPid(): void;
    /**
     * @stability stable
     */
    get podMaxPidInput(): number | undefined;
    private _topologyManagerPolicy?;
    /**
     * @stability stable
     */
    get topologyManagerPolicy(): string;
    /**
     * @stability stable
     */
    set topologyManagerPolicy(value: string);
    /**
     * @stability stable
     */
    resetTopologyManagerPolicy(): void;
    /**
     * @stability stable
     */
    get topologyManagerPolicyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#fs_aio_max_nr KubernetesCluster#fs_aio_max_nr}.
     *
     * @stability stable
     */
    readonly fsAioMaxNr?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#fs_file_max KubernetesCluster#fs_file_max}.
     *
     * @stability stable
     */
    readonly fsFileMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#fs_inotify_max_user_watches KubernetesCluster#fs_inotify_max_user_watches}.
     *
     * @stability stable
     */
    readonly fsInotifyMaxUserWatches?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#fs_nr_open KubernetesCluster#fs_nr_open}.
     *
     * @stability stable
     */
    readonly fsNrOpen?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kernel_threads_max KubernetesCluster#kernel_threads_max}.
     *
     * @stability stable
     */
    readonly kernelThreadsMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_netdev_max_backlog KubernetesCluster#net_core_netdev_max_backlog}.
     *
     * @stability stable
     */
    readonly netCoreNetdevMaxBacklog?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_optmem_max KubernetesCluster#net_core_optmem_max}.
     *
     * @stability stable
     */
    readonly netCoreOptmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_rmem_default KubernetesCluster#net_core_rmem_default}.
     *
     * @stability stable
     */
    readonly netCoreRmemDefault?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_rmem_max KubernetesCluster#net_core_rmem_max}.
     *
     * @stability stable
     */
    readonly netCoreRmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_somaxconn KubernetesCluster#net_core_somaxconn}.
     *
     * @stability stable
     */
    readonly netCoreSomaxconn?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_wmem_default KubernetesCluster#net_core_wmem_default}.
     *
     * @stability stable
     */
    readonly netCoreWmemDefault?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_core_wmem_max KubernetesCluster#net_core_wmem_max}.
     *
     * @stability stable
     */
    readonly netCoreWmemMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_ip_local_port_range_max KubernetesCluster#net_ipv4_ip_local_port_range_max}.
     *
     * @stability stable
     */
    readonly netIpv4IpLocalPortRangeMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_ip_local_port_range_min KubernetesCluster#net_ipv4_ip_local_port_range_min}.
     *
     * @stability stable
     */
    readonly netIpv4IpLocalPortRangeMin?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_neigh_default_gc_thresh1 KubernetesCluster#net_ipv4_neigh_default_gc_thresh1}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh1?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_neigh_default_gc_thresh2 KubernetesCluster#net_ipv4_neigh_default_gc_thresh2}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh2?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_neigh_default_gc_thresh3 KubernetesCluster#net_ipv4_neigh_default_gc_thresh3}.
     *
     * @stability stable
     */
    readonly netIpv4NeighDefaultGcThresh3?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_fin_timeout KubernetesCluster#net_ipv4_tcp_fin_timeout}.
     *
     * @stability stable
     */
    readonly netIpv4TcpFinTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_keepalive_intvl KubernetesCluster#net_ipv4_tcp_keepalive_intvl}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveIntvl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_keepalive_probes KubernetesCluster#net_ipv4_tcp_keepalive_probes}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveProbes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_keepalive_time KubernetesCluster#net_ipv4_tcp_keepalive_time}.
     *
     * @stability stable
     */
    readonly netIpv4TcpKeepaliveTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_max_syn_backlog KubernetesCluster#net_ipv4_tcp_max_syn_backlog}.
     *
     * @stability stable
     */
    readonly netIpv4TcpMaxSynBacklog?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_max_tw_buckets KubernetesCluster#net_ipv4_tcp_max_tw_buckets}.
     *
     * @stability stable
     */
    readonly netIpv4TcpMaxTwBuckets?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_ipv4_tcp_tw_reuse KubernetesCluster#net_ipv4_tcp_tw_reuse}.
     *
     * @stability stable
     */
    readonly netIpv4TcpTwReuse?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_netfilter_nf_conntrack_buckets KubernetesCluster#net_netfilter_nf_conntrack_buckets}.
     *
     * @stability stable
     */
    readonly netNetfilterNfConntrackBuckets?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#net_netfilter_nf_conntrack_max KubernetesCluster#net_netfilter_nf_conntrack_max}.
     *
     * @stability stable
     */
    readonly netNetfilterNfConntrackMax?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#vm_max_map_count KubernetesCluster#vm_max_map_count}.
     *
     * @stability stable
     */
    readonly vmMaxMapCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#vm_swappiness KubernetesCluster#vm_swappiness}.
     *
     * @stability stable
     */
    readonly vmSwappiness?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#vm_vfs_cache_pressure KubernetesCluster#vm_vfs_cache_pressure}.
     *
     * @stability stable
     */
    readonly vmVfsCachePressure?: number;
}
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined);
    private _fsAioMaxNr?;
    /**
     * @stability stable
     */
    get fsAioMaxNr(): number;
    /**
     * @stability stable
     */
    set fsAioMaxNr(value: number);
    /**
     * @stability stable
     */
    resetFsAioMaxNr(): void;
    /**
     * @stability stable
     */
    get fsAioMaxNrInput(): number | undefined;
    private _fsFileMax?;
    /**
     * @stability stable
     */
    get fsFileMax(): number;
    /**
     * @stability stable
     */
    set fsFileMax(value: number);
    /**
     * @stability stable
     */
    resetFsFileMax(): void;
    /**
     * @stability stable
     */
    get fsFileMaxInput(): number | undefined;
    private _fsInotifyMaxUserWatches?;
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatches(): number;
    /**
     * @stability stable
     */
    set fsInotifyMaxUserWatches(value: number);
    /**
     * @stability stable
     */
    resetFsInotifyMaxUserWatches(): void;
    /**
     * @stability stable
     */
    get fsInotifyMaxUserWatchesInput(): number | undefined;
    private _fsNrOpen?;
    /**
     * @stability stable
     */
    get fsNrOpen(): number;
    /**
     * @stability stable
     */
    set fsNrOpen(value: number);
    /**
     * @stability stable
     */
    resetFsNrOpen(): void;
    /**
     * @stability stable
     */
    get fsNrOpenInput(): number | undefined;
    private _kernelThreadsMax?;
    /**
     * @stability stable
     */
    get kernelThreadsMax(): number;
    /**
     * @stability stable
     */
    set kernelThreadsMax(value: number);
    /**
     * @stability stable
     */
    resetKernelThreadsMax(): void;
    /**
     * @stability stable
     */
    get kernelThreadsMaxInput(): number | undefined;
    private _netCoreNetdevMaxBacklog?;
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklog(): number;
    /**
     * @stability stable
     */
    set netCoreNetdevMaxBacklog(value: number);
    /**
     * @stability stable
     */
    resetNetCoreNetdevMaxBacklog(): void;
    /**
     * @stability stable
     */
    get netCoreNetdevMaxBacklogInput(): number | undefined;
    private _netCoreOptmemMax?;
    /**
     * @stability stable
     */
    get netCoreOptmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreOptmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreOptmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreOptmemMaxInput(): number | undefined;
    private _netCoreRmemDefault?;
    /**
     * @stability stable
     */
    get netCoreRmemDefault(): number;
    /**
     * @stability stable
     */
    set netCoreRmemDefault(value: number);
    /**
     * @stability stable
     */
    resetNetCoreRmemDefault(): void;
    /**
     * @stability stable
     */
    get netCoreRmemDefaultInput(): number | undefined;
    private _netCoreRmemMax?;
    /**
     * @stability stable
     */
    get netCoreRmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreRmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreRmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreRmemMaxInput(): number | undefined;
    private _netCoreSomaxconn?;
    /**
     * @stability stable
     */
    get netCoreSomaxconn(): number;
    /**
     * @stability stable
     */
    set netCoreSomaxconn(value: number);
    /**
     * @stability stable
     */
    resetNetCoreSomaxconn(): void;
    /**
     * @stability stable
     */
    get netCoreSomaxconnInput(): number | undefined;
    private _netCoreWmemDefault?;
    /**
     * @stability stable
     */
    get netCoreWmemDefault(): number;
    /**
     * @stability stable
     */
    set netCoreWmemDefault(value: number);
    /**
     * @stability stable
     */
    resetNetCoreWmemDefault(): void;
    /**
     * @stability stable
     */
    get netCoreWmemDefaultInput(): number | undefined;
    private _netCoreWmemMax?;
    /**
     * @stability stable
     */
    get netCoreWmemMax(): number;
    /**
     * @stability stable
     */
    set netCoreWmemMax(value: number);
    /**
     * @stability stable
     */
    resetNetCoreWmemMax(): void;
    /**
     * @stability stable
     */
    get netCoreWmemMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMax?;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMax(): number;
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMax(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMax(): void;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMaxInput(): number | undefined;
    private _netIpv4IpLocalPortRangeMin?;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMin(): number;
    /**
     * @stability stable
     */
    set netIpv4IpLocalPortRangeMin(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4IpLocalPortRangeMin(): void;
    /**
     * @stability stable
     */
    get netIpv4IpLocalPortRangeMinInput(): number | undefined;
    private _netIpv4NeighDefaultGcThresh1?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh1(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh1(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh1Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh2?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh2(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh2(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh2Input(): number | undefined;
    private _netIpv4NeighDefaultGcThresh3?;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3(): number;
    /**
     * @stability stable
     */
    set netIpv4NeighDefaultGcThresh3(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4NeighDefaultGcThresh3(): void;
    /**
     * @stability stable
     */
    get netIpv4NeighDefaultGcThresh3Input(): number | undefined;
    private _netIpv4TcpFinTimeout?;
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeout(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpFinTimeout(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpFinTimeout(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpFinTimeoutInput(): number | undefined;
    private _netIpv4TcpKeepaliveIntvl?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvl(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveIntvl(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveIntvl(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveIntvlInput(): number | undefined;
    private _netIpv4TcpKeepaliveProbes?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbes(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveProbes(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveProbes(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveProbesInput(): number | undefined;
    private _netIpv4TcpKeepaliveTime?;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTime(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpKeepaliveTime(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpKeepaliveTime(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpKeepaliveTimeInput(): number | undefined;
    private _netIpv4TcpMaxSynBacklog?;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklog(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpMaxSynBacklog(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxSynBacklog(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxSynBacklogInput(): number | undefined;
    private _netIpv4TcpMaxTwBuckets?;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBuckets(): number;
    /**
     * @stability stable
     */
    set netIpv4TcpMaxTwBuckets(value: number);
    /**
     * @stability stable
     */
    resetNetIpv4TcpMaxTwBuckets(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpMaxTwBucketsInput(): number | undefined;
    private _netIpv4TcpTwReuse?;
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuse(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set netIpv4TcpTwReuse(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNetIpv4TcpTwReuse(): void;
    /**
     * @stability stable
     */
    get netIpv4TcpTwReuseInput(): boolean | cdktf.IResolvable | undefined;
    private _netNetfilterNfConntrackBuckets?;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBuckets(): number;
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackBuckets(value: number);
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackBuckets(): void;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackBucketsInput(): number | undefined;
    private _netNetfilterNfConntrackMax?;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMax(): number;
    /**
     * @stability stable
     */
    set netNetfilterNfConntrackMax(value: number);
    /**
     * @stability stable
     */
    resetNetNetfilterNfConntrackMax(): void;
    /**
     * @stability stable
     */
    get netNetfilterNfConntrackMaxInput(): number | undefined;
    private _vmMaxMapCount?;
    /**
     * @stability stable
     */
    get vmMaxMapCount(): number;
    /**
     * @stability stable
     */
    set vmMaxMapCount(value: number);
    /**
     * @stability stable
     */
    resetVmMaxMapCount(): void;
    /**
     * @stability stable
     */
    get vmMaxMapCountInput(): number | undefined;
    private _vmSwappiness?;
    /**
     * @stability stable
     */
    get vmSwappiness(): number;
    /**
     * @stability stable
     */
    set vmSwappiness(value: number);
    /**
     * @stability stable
     */
    resetVmSwappiness(): void;
    /**
     * @stability stable
     */
    get vmSwappinessInput(): number | undefined;
    private _vmVfsCachePressure?;
    /**
     * @stability stable
     */
    get vmVfsCachePressure(): number;
    /**
     * @stability stable
     */
    set vmVfsCachePressure(value: number);
    /**
     * @stability stable
     */
    resetVmVfsCachePressure(): void;
    /**
     * @stability stable
     */
    get vmVfsCachePressureInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterDefaultNodePoolLinuxOsConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#swap_file_size_mb KubernetesCluster#swap_file_size_mb}.
     *
     * @stability stable
     */
    readonly swapFileSizeMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#transparent_huge_page_defrag KubernetesCluster#transparent_huge_page_defrag}.
     *
     * @stability stable
     */
    readonly transparentHugePageDefrag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#transparent_huge_page_enabled KubernetesCluster#transparent_huge_page_enabled}.
     *
     * @stability stable
     */
    readonly transparentHugePageEnabled?: string;
    /**
     * sysctl_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#sysctl_config KubernetesCluster#sysctl_config}
     *
     * @stability stable
     */
    readonly sysctlConfig?: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig;
}
export declare function kubernetesClusterDefaultNodePoolLinuxOsConfigToTerraform(struct?: KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference | KubernetesClusterDefaultNodePoolLinuxOsConfig): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined);
    private _swapFileSizeMb?;
    /**
     * @stability stable
     */
    get swapFileSizeMb(): number;
    /**
     * @stability stable
     */
    set swapFileSizeMb(value: number);
    /**
     * @stability stable
     */
    resetSwapFileSizeMb(): void;
    /**
     * @stability stable
     */
    get swapFileSizeMbInput(): number | undefined;
    private _transparentHugePageDefrag?;
    /**
     * @stability stable
     */
    get transparentHugePageDefrag(): string;
    /**
     * @stability stable
     */
    set transparentHugePageDefrag(value: string);
    /**
     * @stability stable
     */
    resetTransparentHugePageDefrag(): void;
    /**
     * @stability stable
     */
    get transparentHugePageDefragInput(): string | undefined;
    private _transparentHugePageEnabled?;
    /**
     * @stability stable
     */
    get transparentHugePageEnabled(): string;
    /**
     * @stability stable
     */
    set transparentHugePageEnabled(value: string);
    /**
     * @stability stable
     */
    resetTransparentHugePageEnabled(): void;
    /**
     * @stability stable
     */
    get transparentHugePageEnabledInput(): string | undefined;
    private _sysctlConfig;
    /**
     * @stability stable
     */
    get sysctlConfig(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfigOutputReference;
    /**
     * @stability stable
     */
    putSysctlConfig(value: KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig): void;
    /**
     * @stability stable
     */
    resetSysctlConfig(): void;
    /**
     * @stability stable
     */
    get sysctlConfigInput(): KubernetesClusterDefaultNodePoolLinuxOsConfigSysctlConfig | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterDefaultNodePoolUpgradeSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_surge KubernetesCluster#max_surge}.
     *
     * @stability stable
     */
    readonly maxSurge: string;
}
export declare function kubernetesClusterDefaultNodePoolUpgradeSettingsToTerraform(struct?: KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference | KubernetesClusterDefaultNodePoolUpgradeSettings): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterDefaultNodePoolUpgradeSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterDefaultNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    /**
     * @stability stable
     */
    get maxSurge(): string;
    /**
     * @stability stable
     */
    set maxSurge(value: string);
    /**
     * @stability stable
     */
    get maxSurgeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterDefaultNodePool {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#availability_zones KubernetesCluster#availability_zones}.
     *
     * @stability stable
     */
    readonly availabilityZones?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enable_auto_scaling KubernetesCluster#enable_auto_scaling}.
     *
     * @stability stable
     */
    readonly enableAutoScaling?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enable_host_encryption KubernetesCluster#enable_host_encryption}.
     *
     * @stability stable
     */
    readonly enableHostEncryption?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enable_node_public_ip KubernetesCluster#enable_node_public_ip}.
     *
     * @stability stable
     */
    readonly enableNodePublicIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#fips_enabled KubernetesCluster#fips_enabled}.
     *
     * @stability stable
     */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kubelet_disk_type KubernetesCluster#kubelet_disk_type}.
     *
     * @stability stable
     */
    readonly kubeletDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_count KubernetesCluster#max_count}.
     *
     * @stability stable
     */
    readonly maxCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#max_pods KubernetesCluster#max_pods}.
     *
     * @stability stable
     */
    readonly maxPods?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#min_count KubernetesCluster#min_count}.
     *
     * @stability stable
     */
    readonly minCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#name KubernetesCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#node_count KubernetesCluster#node_count}.
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#node_labels KubernetesCluster#node_labels}.
     *
     * @stability stable
     */
    readonly nodeLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#node_public_ip_prefix_id KubernetesCluster#node_public_ip_prefix_id}.
     *
     * @stability stable
     */
    readonly nodePublicIpPrefixId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#node_taints KubernetesCluster#node_taints}.
     *
     * @stability stable
     */
    readonly nodeTaints?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#only_critical_addons_enabled KubernetesCluster#only_critical_addons_enabled}.
     *
     * @stability stable
     */
    readonly onlyCriticalAddonsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#orchestrator_version KubernetesCluster#orchestrator_version}.
     *
     * @stability stable
     */
    readonly orchestratorVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#os_disk_size_gb KubernetesCluster#os_disk_size_gb}.
     *
     * @stability stable
     */
    readonly osDiskSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#os_disk_type KubernetesCluster#os_disk_type}.
     *
     * @stability stable
     */
    readonly osDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#os_sku KubernetesCluster#os_sku}.
     *
     * @stability stable
     */
    readonly osSku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#pod_subnet_id KubernetesCluster#pod_subnet_id}.
     *
     * @stability stable
     */
    readonly podSubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#proximity_placement_group_id KubernetesCluster#proximity_placement_group_id}.
     *
     * @stability stable
     */
    readonly proximityPlacementGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#tags KubernetesCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#type KubernetesCluster#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#ultra_ssd_enabled KubernetesCluster#ultra_ssd_enabled}.
     *
     * @stability stable
     */
    readonly ultraSsdEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#vm_size KubernetesCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#vnet_subnet_id KubernetesCluster#vnet_subnet_id}.
     *
     * @stability stable
     */
    readonly vnetSubnetId?: string;
    /**
     * kubelet_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#kubelet_config KubernetesCluster#kubelet_config}
     *
     * @stability stable
     */
    readonly kubeletConfig?: KubernetesClusterDefaultNodePoolKubeletConfig;
    /**
     * linux_os_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#linux_os_config KubernetesCluster#linux_os_config}
     *
     * @stability stable
     */
    readonly linuxOsConfig?: KubernetesClusterDefaultNodePoolLinuxOsConfig;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#upgrade_settings KubernetesCluster#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: KubernetesClusterDefaultNodePoolUpgradeSettings;
}
export declare function kubernetesClusterDefaultNodePoolToTerraform(struct?: KubernetesClusterDefaultNodePoolOutputReference | KubernetesClusterDefaultNodePool): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterDefaultNodePoolOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterDefaultNodePool | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterDefaultNodePool | undefined);
    private _availabilityZones?;
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    set availabilityZones(value: string[]);
    /**
     * @stability stable
     */
    resetAvailabilityZones(): void;
    /**
     * @stability stable
     */
    get availabilityZonesInput(): string[] | undefined;
    private _enableAutoScaling?;
    /**
     * @stability stable
     */
    get enableAutoScaling(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutoScaling(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutoScaling(): void;
    /**
     * @stability stable
     */
    get enableAutoScalingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableHostEncryption?;
    /**
     * @stability stable
     */
    get enableHostEncryption(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableHostEncryption(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableHostEncryption(): void;
    /**
     * @stability stable
     */
    get enableHostEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _enableNodePublicIp?;
    /**
     * @stability stable
     */
    get enableNodePublicIp(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNodePublicIp(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNodePublicIp(): void;
    /**
     * @stability stable
     */
    get enableNodePublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _fipsEnabled?;
    /**
     * @stability stable
     */
    get fipsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFipsEnabled(): void;
    /**
     * @stability stable
     */
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kubeletDiskType?;
    /**
     * @stability stable
     */
    get kubeletDiskType(): string;
    /**
     * @stability stable
     */
    set kubeletDiskType(value: string);
    /**
     * @stability stable
     */
    resetKubeletDiskType(): void;
    /**
     * @stability stable
     */
    get kubeletDiskTypeInput(): string | undefined;
    private _maxCount?;
    /**
     * @stability stable
     */
    get maxCount(): number;
    /**
     * @stability stable
     */
    set maxCount(value: number);
    /**
     * @stability stable
     */
    resetMaxCount(): void;
    /**
     * @stability stable
     */
    get maxCountInput(): number | undefined;
    private _maxPods?;
    /**
     * @stability stable
     */
    get maxPods(): number;
    /**
     * @stability stable
     */
    set maxPods(value: number);
    /**
     * @stability stable
     */
    resetMaxPods(): void;
    /**
     * @stability stable
     */
    get maxPodsInput(): number | undefined;
    private _minCount?;
    /**
     * @stability stable
     */
    get minCount(): number;
    /**
     * @stability stable
     */
    set minCount(value: number);
    /**
     * @stability stable
     */
    resetMinCount(): void;
    /**
     * @stability stable
     */
    get minCountInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeLabels?;
    /**
     * @stability stable
     */
    get nodeLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set nodeLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNodeLabels(): void;
    /**
     * @stability stable
     */
    get nodeLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _nodePublicIpPrefixId?;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixId(): string;
    /**
     * @stability stable
     */
    set nodePublicIpPrefixId(value: string);
    /**
     * @stability stable
     */
    resetNodePublicIpPrefixId(): void;
    /**
     * @stability stable
     */
    get nodePublicIpPrefixIdInput(): string | undefined;
    private _nodeTaints?;
    /**
     * @stability stable
     */
    get nodeTaints(): string[];
    /**
     * @stability stable
     */
    set nodeTaints(value: string[]);
    /**
     * @stability stable
     */
    resetNodeTaints(): void;
    /**
     * @stability stable
     */
    get nodeTaintsInput(): string[] | undefined;
    private _onlyCriticalAddonsEnabled?;
    /**
     * @stability stable
     */
    get onlyCriticalAddonsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set onlyCriticalAddonsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOnlyCriticalAddonsEnabled(): void;
    /**
     * @stability stable
     */
    get onlyCriticalAddonsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _orchestratorVersion?;
    /**
     * @stability stable
     */
    get orchestratorVersion(): string;
    /**
     * @stability stable
     */
    set orchestratorVersion(value: string);
    /**
     * @stability stable
     */
    resetOrchestratorVersion(): void;
    /**
     * @stability stable
     */
    get orchestratorVersionInput(): string | undefined;
    private _osDiskSizeGb?;
    /**
     * @stability stable
     */
    get osDiskSizeGb(): number;
    /**
     * @stability stable
     */
    set osDiskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetOsDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get osDiskSizeGbInput(): number | undefined;
    private _osDiskType?;
    /**
     * @stability stable
     */
    get osDiskType(): string;
    /**
     * @stability stable
     */
    set osDiskType(value: string);
    /**
     * @stability stable
     */
    resetOsDiskType(): void;
    /**
     * @stability stable
     */
    get osDiskTypeInput(): string | undefined;
    private _osSku?;
    /**
     * @stability stable
     */
    get osSku(): string;
    /**
     * @stability stable
     */
    set osSku(value: string);
    /**
     * @stability stable
     */
    resetOsSku(): void;
    /**
     * @stability stable
     */
    get osSkuInput(): string | undefined;
    private _podSubnetId?;
    /**
     * @stability stable
     */
    get podSubnetId(): string;
    /**
     * @stability stable
     */
    set podSubnetId(value: string);
    /**
     * @stability stable
     */
    resetPodSubnetId(): void;
    /**
     * @stability stable
     */
    get podSubnetIdInput(): string | undefined;
    private _proximityPlacementGroupId?;
    /**
     * @stability stable
     */
    get proximityPlacementGroupId(): string;
    /**
     * @stability stable
     */
    set proximityPlacementGroupId(value: string);
    /**
     * @stability stable
     */
    resetProximityPlacementGroupId(): void;
    /**
     * @stability stable
     */
    get proximityPlacementGroupIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _ultraSsdEnabled?;
    /**
     * @stability stable
     */
    get ultraSsdEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ultraSsdEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUltraSsdEnabled(): void;
    /**
     * @stability stable
     */
    get ultraSsdEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _vnetSubnetId?;
    /**
     * @stability stable
     */
    get vnetSubnetId(): string;
    /**
     * @stability stable
     */
    set vnetSubnetId(value: string);
    /**
     * @stability stable
     */
    resetVnetSubnetId(): void;
    /**
     * @stability stable
     */
    get vnetSubnetIdInput(): string | undefined;
    private _kubeletConfig;
    /**
     * @stability stable
     */
    get kubeletConfig(): KubernetesClusterDefaultNodePoolKubeletConfigOutputReference;
    /**
     * @stability stable
     */
    putKubeletConfig(value: KubernetesClusterDefaultNodePoolKubeletConfig): void;
    /**
     * @stability stable
     */
    resetKubeletConfig(): void;
    /**
     * @stability stable
     */
    get kubeletConfigInput(): KubernetesClusterDefaultNodePoolKubeletConfig | undefined;
    private _linuxOsConfig;
    /**
     * @stability stable
     */
    get linuxOsConfig(): KubernetesClusterDefaultNodePoolLinuxOsConfigOutputReference;
    /**
     * @stability stable
     */
    putLinuxOsConfig(value: KubernetesClusterDefaultNodePoolLinuxOsConfig): void;
    /**
     * @stability stable
     */
    resetLinuxOsConfig(): void;
    /**
     * @stability stable
     */
    get linuxOsConfigInput(): KubernetesClusterDefaultNodePoolLinuxOsConfig | undefined;
    private _upgradeSettings;
    /**
     * @stability stable
     */
    get upgradeSettings(): KubernetesClusterDefaultNodePoolUpgradeSettingsOutputReference;
    /**
     * @stability stable
     */
    putUpgradeSettings(value: KubernetesClusterDefaultNodePoolUpgradeSettings): void;
    /**
     * @stability stable
     */
    resetUpgradeSettings(): void;
    /**
     * @stability stable
     */
    get upgradeSettingsInput(): KubernetesClusterDefaultNodePoolUpgradeSettings | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#type KubernetesCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#user_assigned_identity_id KubernetesCluster#user_assigned_identity_id}.
     *
     * @stability stable
     */
    readonly userAssignedIdentityId?: string;
}
export declare function kubernetesClusterIdentityToTerraform(struct?: KubernetesClusterIdentityOutputReference | KubernetesClusterIdentity): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentityId?;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentityId(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentityId(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterKubeletIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#client_id KubernetesCluster#client_id}.
     *
     * @stability stable
     */
    readonly clientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#object_id KubernetesCluster#object_id}.
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#user_assigned_identity_id KubernetesCluster#user_assigned_identity_id}.
     *
     * @stability stable
     */
    readonly userAssignedIdentityId?: string;
}
export declare function kubernetesClusterKubeletIdentityToTerraform(struct?: KubernetesClusterKubeletIdentityOutputReference | KubernetesClusterKubeletIdentity): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterKubeletIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterKubeletIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterKubeletIdentity | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    resetClientId(): void;
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    resetObjectId(): void;
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    /**
     * @stability stable
     */
    get userAssignedIdentityId(): string;
    /**
     * @stability stable
     */
    set userAssignedIdentityId(value: string);
    /**
     * @stability stable
     */
    resetUserAssignedIdentityId(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterLinuxProfileSshKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#key_data KubernetesCluster#key_data}.
     *
     * @stability stable
     */
    readonly keyData: string;
}
export declare function kubernetesClusterLinuxProfileSshKeyToTerraform(struct?: KubernetesClusterLinuxProfileSshKeyOutputReference | KubernetesClusterLinuxProfileSshKey): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterLinuxProfileSshKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterLinuxProfileSshKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterLinuxProfileSshKey | undefined);
    private _keyData?;
    /**
     * @stability stable
     */
    get keyData(): string;
    /**
     * @stability stable
     */
    set keyData(value: string);
    /**
     * @stability stable
     */
    get keyDataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterLinuxProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#admin_username KubernetesCluster#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * ssh_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#ssh_key KubernetesCluster#ssh_key}
     *
     * @stability stable
     */
    readonly sshKey: KubernetesClusterLinuxProfileSshKey;
}
export declare function kubernetesClusterLinuxProfileToTerraform(struct?: KubernetesClusterLinuxProfileOutputReference | KubernetesClusterLinuxProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterLinuxProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterLinuxProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterLinuxProfile | undefined);
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _sshKey;
    /**
     * @stability stable
     */
    get sshKey(): KubernetesClusterLinuxProfileSshKeyOutputReference;
    /**
     * @stability stable
     */
    putSshKey(value: KubernetesClusterLinuxProfileSshKey): void;
    /**
     * @stability stable
     */
    get sshKeyInput(): KubernetesClusterLinuxProfileSshKey | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterMaintenanceWindowAllowed {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#day KubernetesCluster#day}.
     *
     * @stability stable
     */
    readonly day: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#hours KubernetesCluster#hours}.
     *
     * @stability stable
     */
    readonly hours: number[];
}
export declare function kubernetesClusterMaintenanceWindowAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowAllowed): any;
/**
 * @stability stable
 */
export interface KubernetesClusterMaintenanceWindowNotAllowed {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#end KubernetesCluster#end}.
     *
     * @stability stable
     */
    readonly end: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#start KubernetesCluster#start}.
     *
     * @stability stable
     */
    readonly start: string;
}
export declare function kubernetesClusterMaintenanceWindowNotAllowedToTerraform(struct?: KubernetesClusterMaintenanceWindowNotAllowed): any;
/**
 * @stability stable
 */
export interface KubernetesClusterMaintenanceWindow {
    /**
     * allowed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#allowed KubernetesCluster#allowed}
     *
     * @stability stable
     */
    readonly allowed?: KubernetesClusterMaintenanceWindowAllowed[];
    /**
     * not_allowed block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#not_allowed KubernetesCluster#not_allowed}
     *
     * @stability stable
     */
    readonly notAllowed?: KubernetesClusterMaintenanceWindowNotAllowed[];
}
export declare function kubernetesClusterMaintenanceWindowToTerraform(struct?: KubernetesClusterMaintenanceWindowOutputReference | KubernetesClusterMaintenanceWindow): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterMaintenanceWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterMaintenanceWindow | undefined);
    private _allowed?;
    /**
     * @stability stable
     */
    get allowed(): KubernetesClusterMaintenanceWindowAllowed[];
    /**
     * @stability stable
     */
    set allowed(value: KubernetesClusterMaintenanceWindowAllowed[]);
    /**
     * @stability stable
     */
    resetAllowed(): void;
    /**
     * @stability stable
     */
    get allowedInput(): KubernetesClusterMaintenanceWindowAllowed[] | undefined;
    private _notAllowed?;
    /**
     * @stability stable
     */
    get notAllowed(): KubernetesClusterMaintenanceWindowNotAllowed[];
    /**
     * @stability stable
     */
    set notAllowed(value: KubernetesClusterMaintenanceWindowNotAllowed[]);
    /**
     * @stability stable
     */
    resetNotAllowed(): void;
    /**
     * @stability stable
     */
    get notAllowedInput(): KubernetesClusterMaintenanceWindowNotAllowed[] | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNetworkProfileLoadBalancerProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#idle_timeout_in_minutes KubernetesCluster#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#managed_outbound_ip_count KubernetesCluster#managed_outbound_ip_count}.
     *
     * @stability stable
     */
    readonly managedOutboundIpCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#outbound_ip_address_ids KubernetesCluster#outbound_ip_address_ids}.
     *
     * @stability stable
     */
    readonly outboundIpAddressIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#outbound_ip_prefix_ids KubernetesCluster#outbound_ip_prefix_ids}.
     *
     * @stability stable
     */
    readonly outboundIpPrefixIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#outbound_ports_allocated KubernetesCluster#outbound_ports_allocated}.
     *
     * @stability stable
     */
    readonly outboundPortsAllocated?: number;
}
export declare function kubernetesClusterNetworkProfileLoadBalancerProfileToTerraform(struct?: KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference | KubernetesClusterNetworkProfileLoadBalancerProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNetworkProfileLoadBalancerProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNetworkProfileLoadBalancerProfile | undefined);
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _managedOutboundIpCount?;
    /**
     * @stability stable
     */
    get managedOutboundIpCount(): number;
    /**
     * @stability stable
     */
    set managedOutboundIpCount(value: number);
    /**
     * @stability stable
     */
    resetManagedOutboundIpCount(): void;
    /**
     * @stability stable
     */
    get managedOutboundIpCountInput(): number | undefined;
    private _outboundIpAddressIds?;
    /**
     * @stability stable
     */
    get outboundIpAddressIds(): string[];
    /**
     * @stability stable
     */
    set outboundIpAddressIds(value: string[]);
    /**
     * @stability stable
     */
    resetOutboundIpAddressIds(): void;
    /**
     * @stability stable
     */
    get outboundIpAddressIdsInput(): string[] | undefined;
    private _outboundIpPrefixIds?;
    /**
     * @stability stable
     */
    get outboundIpPrefixIds(): string[];
    /**
     * @stability stable
     */
    set outboundIpPrefixIds(value: string[]);
    /**
     * @stability stable
     */
    resetOutboundIpPrefixIds(): void;
    /**
     * @stability stable
     */
    get outboundIpPrefixIdsInput(): string[] | undefined;
    private _outboundPortsAllocated?;
    /**
     * @stability stable
     */
    get outboundPortsAllocated(): number;
    /**
     * @stability stable
     */
    set outboundPortsAllocated(value: number);
    /**
     * @stability stable
     */
    resetOutboundPortsAllocated(): void;
    /**
     * @stability stable
     */
    get outboundPortsAllocatedInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNetworkProfileNatGatewayProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#idle_timeout_in_minutes KubernetesCluster#idle_timeout_in_minutes}.
     *
     * @stability stable
     */
    readonly idleTimeoutInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#managed_outbound_ip_count KubernetesCluster#managed_outbound_ip_count}.
     *
     * @stability stable
     */
    readonly managedOutboundIpCount?: number;
}
export declare function kubernetesClusterNetworkProfileNatGatewayProfileToTerraform(struct?: KubernetesClusterNetworkProfileNatGatewayProfileOutputReference | KubernetesClusterNetworkProfileNatGatewayProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNetworkProfileNatGatewayProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNetworkProfileNatGatewayProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNetworkProfileNatGatewayProfile | undefined);
    private _idleTimeoutInMinutes?;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutes(): number;
    /**
     * @stability stable
     */
    set idleTimeoutInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIdleTimeoutInMinutes(): void;
    /**
     * @stability stable
     */
    get idleTimeoutInMinutesInput(): number | undefined;
    private _managedOutboundIpCount?;
    /**
     * @stability stable
     */
    get managedOutboundIpCount(): number;
    /**
     * @stability stable
     */
    set managedOutboundIpCount(value: number);
    /**
     * @stability stable
     */
    resetManagedOutboundIpCount(): void;
    /**
     * @stability stable
     */
    get managedOutboundIpCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterNetworkProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#dns_service_ip KubernetesCluster#dns_service_ip}.
     *
     * @stability stable
     */
    readonly dnsServiceIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#docker_bridge_cidr KubernetesCluster#docker_bridge_cidr}.
     *
     * @stability stable
     */
    readonly dockerBridgeCidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#load_balancer_sku KubernetesCluster#load_balancer_sku}.
     *
     * @stability stable
     */
    readonly loadBalancerSku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_mode KubernetesCluster#network_mode}.
     *
     * @stability stable
     */
    readonly networkMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_plugin KubernetesCluster#network_plugin}.
     *
     * @stability stable
     */
    readonly networkPlugin: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#network_policy KubernetesCluster#network_policy}.
     *
     * @stability stable
     */
    readonly networkPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#outbound_type KubernetesCluster#outbound_type}.
     *
     * @stability stable
     */
    readonly outboundType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#pod_cidr KubernetesCluster#pod_cidr}.
     *
     * @stability stable
     */
    readonly podCidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#service_cidr KubernetesCluster#service_cidr}.
     *
     * @stability stable
     */
    readonly serviceCidr?: string;
    /**
     * load_balancer_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#load_balancer_profile KubernetesCluster#load_balancer_profile}
     *
     * @stability stable
     */
    readonly loadBalancerProfile?: KubernetesClusterNetworkProfileLoadBalancerProfile;
    /**
     * nat_gateway_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#nat_gateway_profile KubernetesCluster#nat_gateway_profile}
     *
     * @stability stable
     */
    readonly natGatewayProfile?: KubernetesClusterNetworkProfileNatGatewayProfile;
}
export declare function kubernetesClusterNetworkProfileToTerraform(struct?: KubernetesClusterNetworkProfileOutputReference | KubernetesClusterNetworkProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterNetworkProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterNetworkProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterNetworkProfile | undefined);
    private _dnsServiceIp?;
    /**
     * @stability stable
     */
    get dnsServiceIp(): string;
    /**
     * @stability stable
     */
    set dnsServiceIp(value: string);
    /**
     * @stability stable
     */
    resetDnsServiceIp(): void;
    /**
     * @stability stable
     */
    get dnsServiceIpInput(): string | undefined;
    private _dockerBridgeCidr?;
    /**
     * @stability stable
     */
    get dockerBridgeCidr(): string;
    /**
     * @stability stable
     */
    set dockerBridgeCidr(value: string);
    /**
     * @stability stable
     */
    resetDockerBridgeCidr(): void;
    /**
     * @stability stable
     */
    get dockerBridgeCidrInput(): string | undefined;
    private _loadBalancerSku?;
    /**
     * @stability stable
     */
    get loadBalancerSku(): string;
    /**
     * @stability stable
     */
    set loadBalancerSku(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancerSku(): void;
    /**
     * @stability stable
     */
    get loadBalancerSkuInput(): string | undefined;
    private _networkMode?;
    /**
     * @stability stable
     */
    get networkMode(): string;
    /**
     * @stability stable
     */
    set networkMode(value: string);
    /**
     * @stability stable
     */
    resetNetworkMode(): void;
    /**
     * @stability stable
     */
    get networkModeInput(): string | undefined;
    private _networkPlugin?;
    /**
     * @stability stable
     */
    get networkPlugin(): string;
    /**
     * @stability stable
     */
    set networkPlugin(value: string);
    /**
     * @stability stable
     */
    get networkPluginInput(): string | undefined;
    private _networkPolicy?;
    /**
     * @stability stable
     */
    get networkPolicy(): string;
    /**
     * @stability stable
     */
    set networkPolicy(value: string);
    /**
     * @stability stable
     */
    resetNetworkPolicy(): void;
    /**
     * @stability stable
     */
    get networkPolicyInput(): string | undefined;
    private _outboundType?;
    /**
     * @stability stable
     */
    get outboundType(): string;
    /**
     * @stability stable
     */
    set outboundType(value: string);
    /**
     * @stability stable
     */
    resetOutboundType(): void;
    /**
     * @stability stable
     */
    get outboundTypeInput(): string | undefined;
    private _podCidr?;
    /**
     * @stability stable
     */
    get podCidr(): string;
    /**
     * @stability stable
     */
    set podCidr(value: string);
    /**
     * @stability stable
     */
    resetPodCidr(): void;
    /**
     * @stability stable
     */
    get podCidrInput(): string | undefined;
    private _serviceCidr?;
    /**
     * @stability stable
     */
    get serviceCidr(): string;
    /**
     * @stability stable
     */
    set serviceCidr(value: string);
    /**
     * @stability stable
     */
    resetServiceCidr(): void;
    /**
     * @stability stable
     */
    get serviceCidrInput(): string | undefined;
    private _loadBalancerProfile;
    /**
     * @stability stable
     */
    get loadBalancerProfile(): KubernetesClusterNetworkProfileLoadBalancerProfileOutputReference;
    /**
     * @stability stable
     */
    putLoadBalancerProfile(value: KubernetesClusterNetworkProfileLoadBalancerProfile): void;
    /**
     * @stability stable
     */
    resetLoadBalancerProfile(): void;
    /**
     * @stability stable
     */
    get loadBalancerProfileInput(): KubernetesClusterNetworkProfileLoadBalancerProfile | undefined;
    private _natGatewayProfile;
    /**
     * @stability stable
     */
    get natGatewayProfile(): KubernetesClusterNetworkProfileNatGatewayProfileOutputReference;
    /**
     * @stability stable
     */
    putNatGatewayProfile(value: KubernetesClusterNetworkProfileNatGatewayProfile): void;
    /**
     * @stability stable
     */
    resetNatGatewayProfile(): void;
    /**
     * @stability stable
     */
    get natGatewayProfileInput(): KubernetesClusterNetworkProfileNatGatewayProfile | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterRoleBasedAccessControlAzureActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#admin_group_object_ids KubernetesCluster#admin_group_object_ids}.
     *
     * @stability stable
     */
    readonly adminGroupObjectIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#azure_rbac_enabled KubernetesCluster#azure_rbac_enabled}.
     *
     * @stability stable
     */
    readonly azureRbacEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#client_app_id KubernetesCluster#client_app_id}.
     *
     * @stability stable
     */
    readonly clientAppId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#managed KubernetesCluster#managed}.
     *
     * @stability stable
     */
    readonly managed?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#server_app_id KubernetesCluster#server_app_id}.
     *
     * @stability stable
     */
    readonly serverAppId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#server_app_secret KubernetesCluster#server_app_secret}.
     *
     * @stability stable
     */
    readonly serverAppSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#tenant_id KubernetesCluster#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function kubernetesClusterRoleBasedAccessControlAzureActiveDirectoryToTerraform(struct?: KubernetesClusterRoleBasedAccessControlAzureActiveDirectoryOutputReference | KubernetesClusterRoleBasedAccessControlAzureActiveDirectory): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterRoleBasedAccessControlAzureActiveDirectoryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterRoleBasedAccessControlAzureActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterRoleBasedAccessControlAzureActiveDirectory | undefined);
    private _adminGroupObjectIds?;
    /**
     * @stability stable
     */
    get adminGroupObjectIds(): string[];
    /**
     * @stability stable
     */
    set adminGroupObjectIds(value: string[]);
    /**
     * @stability stable
     */
    resetAdminGroupObjectIds(): void;
    /**
     * @stability stable
     */
    get adminGroupObjectIdsInput(): string[] | undefined;
    private _azureRbacEnabled?;
    /**
     * @stability stable
     */
    get azureRbacEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureRbacEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureRbacEnabled(): void;
    /**
     * @stability stable
     */
    get azureRbacEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientAppId?;
    /**
     * @stability stable
     */
    get clientAppId(): string;
    /**
     * @stability stable
     */
    set clientAppId(value: string);
    /**
     * @stability stable
     */
    resetClientAppId(): void;
    /**
     * @stability stable
     */
    get clientAppIdInput(): string | undefined;
    private _managed?;
    /**
     * @stability stable
     */
    get managed(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set managed(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManaged(): void;
    /**
     * @stability stable
     */
    get managedInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAppId?;
    /**
     * @stability stable
     */
    get serverAppId(): string;
    /**
     * @stability stable
     */
    set serverAppId(value: string);
    /**
     * @stability stable
     */
    resetServerAppId(): void;
    /**
     * @stability stable
     */
    get serverAppIdInput(): string | undefined;
    private _serverAppSecret?;
    /**
     * @stability stable
     */
    get serverAppSecret(): string;
    /**
     * @stability stable
     */
    set serverAppSecret(value: string);
    /**
     * @stability stable
     */
    resetServerAppSecret(): void;
    /**
     * @stability stable
     */
    get serverAppSecretInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterRoleBasedAccessControl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#enabled KubernetesCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * azure_active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#azure_active_directory KubernetesCluster#azure_active_directory}
     *
     * @stability stable
     */
    readonly azureActiveDirectory?: KubernetesClusterRoleBasedAccessControlAzureActiveDirectory;
}
export declare function kubernetesClusterRoleBasedAccessControlToTerraform(struct?: KubernetesClusterRoleBasedAccessControlOutputReference | KubernetesClusterRoleBasedAccessControl): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterRoleBasedAccessControlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterRoleBasedAccessControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterRoleBasedAccessControl | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _azureActiveDirectory;
    /**
     * @stability stable
     */
    get azureActiveDirectory(): KubernetesClusterRoleBasedAccessControlAzureActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putAzureActiveDirectory(value: KubernetesClusterRoleBasedAccessControlAzureActiveDirectory): void;
    /**
     * @stability stable
     */
    resetAzureActiveDirectory(): void;
    /**
     * @stability stable
     */
    get azureActiveDirectoryInput(): KubernetesClusterRoleBasedAccessControlAzureActiveDirectory | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterServicePrincipal {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#client_id KubernetesCluster#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#client_secret KubernetesCluster#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
}
export declare function kubernetesClusterServicePrincipalToTerraform(struct?: KubernetesClusterServicePrincipalOutputReference | KubernetesClusterServicePrincipal): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterServicePrincipalOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterServicePrincipal | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterServicePrincipal | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#create KubernetesCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#delete KubernetesCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#read KubernetesCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#update KubernetesCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function kubernetesClusterTimeoutsToTerraform(struct?: KubernetesClusterTimeoutsOutputReference | KubernetesClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface KubernetesClusterWindowsProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#admin_password KubernetesCluster#admin_password}.
     *
     * @stability stable
     */
    readonly adminPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#admin_username KubernetesCluster#admin_username}.
     *
     * @stability stable
     */
    readonly adminUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html#license KubernetesCluster#license}.
     *
     * @stability stable
     */
    readonly license?: string;
}
export declare function kubernetesClusterWindowsProfileToTerraform(struct?: KubernetesClusterWindowsProfileOutputReference | KubernetesClusterWindowsProfile): any;
/**
 * @stability stable
 */
export declare class KubernetesClusterWindowsProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KubernetesClusterWindowsProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KubernetesClusterWindowsProfile | undefined);
    private _adminPassword?;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    set adminPassword(value: string);
    /**
     * @stability stable
     */
    resetAdminPassword(): void;
    /**
     * @stability stable
     */
    get adminPasswordInput(): string | undefined;
    private _adminUsername?;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    /**
     * @stability stable
     */
    set adminUsername(value: string);
    /**
     * @stability stable
     */
    get adminUsernameInput(): string | undefined;
    private _license?;
    /**
     * @stability stable
     */
    get license(): string;
    /**
     * @stability stable
     */
    set license(value: string);
    /**
     * @stability stable
     */
    resetLicense(): void;
    /**
     * @stability stable
     */
    get licenseInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html azurerm_kubernetes_cluster}.
 *
 * @stability stable
 */
export declare class KubernetesCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/kubernetes_cluster.html azurerm_kubernetes_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KubernetesClusterConfig);
    private _apiServerAuthorizedIpRanges?;
    /**
     * @stability stable
     */
    get apiServerAuthorizedIpRanges(): string[];
    /**
     * @stability stable
     */
    set apiServerAuthorizedIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetApiServerAuthorizedIpRanges(): void;
    /**
     * @stability stable
     */
    get apiServerAuthorizedIpRangesInput(): string[] | undefined;
    private _automaticChannelUpgrade?;
    /**
     * @stability stable
     */
    get automaticChannelUpgrade(): string;
    /**
     * @stability stable
     */
    set automaticChannelUpgrade(value: string);
    /**
     * @stability stable
     */
    resetAutomaticChannelUpgrade(): void;
    /**
     * @stability stable
     */
    get automaticChannelUpgradeInput(): string | undefined;
    private _diskEncryptionSetId?;
    /**
     * @stability stable
     */
    get diskEncryptionSetId(): string;
    /**
     * @stability stable
     */
    set diskEncryptionSetId(value: string);
    /**
     * @stability stable
     */
    resetDiskEncryptionSetId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionSetIdInput(): string | undefined;
    private _dnsPrefix?;
    /**
     * @stability stable
     */
    get dnsPrefix(): string;
    /**
     * @stability stable
     */
    set dnsPrefix(value: string);
    /**
     * @stability stable
     */
    resetDnsPrefix(): void;
    /**
     * @stability stable
     */
    get dnsPrefixInput(): string | undefined;
    private _dnsPrefixPrivateCluster?;
    /**
     * @stability stable
     */
    get dnsPrefixPrivateCluster(): string;
    /**
     * @stability stable
     */
    set dnsPrefixPrivateCluster(value: string);
    /**
     * @stability stable
     */
    resetDnsPrefixPrivateCluster(): void;
    /**
     * @stability stable
     */
    get dnsPrefixPrivateClusterInput(): string | undefined;
    private _enablePodSecurityPolicy?;
    /**
     * @stability stable
     */
    get enablePodSecurityPolicy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePodSecurityPolicy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePodSecurityPolicy(): void;
    /**
     * @stability stable
     */
    get enablePodSecurityPolicyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    kubeAdminConfig(index: string): KubernetesClusterKubeAdminConfig;
    /**
     * @stability stable
     */
    get kubeAdminConfigRaw(): string;
    /**
     * @stability stable
     */
    kubeConfig(index: string): KubernetesClusterKubeConfig;
    /**
     * @stability stable
     */
    get kubeConfigRaw(): string;
    private _kubernetesVersion?;
    /**
     * @stability stable
     */
    get kubernetesVersion(): string;
    /**
     * @stability stable
     */
    set kubernetesVersion(value: string);
    /**
     * @stability stable
     */
    resetKubernetesVersion(): void;
    /**
     * @stability stable
     */
    get kubernetesVersionInput(): string | undefined;
    private _localAccountDisabled?;
    /**
     * @stability stable
     */
    get localAccountDisabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localAccountDisabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalAccountDisabled(): void;
    /**
     * @stability stable
     */
    get localAccountDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeResourceGroup?;
    /**
     * @stability stable
     */
    get nodeResourceGroup(): string;
    /**
     * @stability stable
     */
    set nodeResourceGroup(value: string);
    /**
     * @stability stable
     */
    resetNodeResourceGroup(): void;
    /**
     * @stability stable
     */
    get nodeResourceGroupInput(): string | undefined;
    /**
     * @stability stable
     */
    get portalFqdn(): string;
    private _privateClusterEnabled?;
    /**
     * @stability stable
     */
    get privateClusterEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateClusterEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateClusterEnabled(): void;
    /**
     * @stability stable
     */
    get privateClusterEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateClusterPublicFqdnEnabled?;
    /**
     * @stability stable
     */
    get privateClusterPublicFqdnEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateClusterPublicFqdnEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateClusterPublicFqdnEnabled(): void;
    /**
     * @stability stable
     */
    get privateClusterPublicFqdnEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateDnsZoneId?;
    /**
     * @stability stable
     */
    get privateDnsZoneId(): string;
    /**
     * @stability stable
     */
    set privateDnsZoneId(value: string);
    /**
     * @stability stable
     */
    resetPrivateDnsZoneId(): void;
    /**
     * @stability stable
     */
    get privateDnsZoneIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateFqdn(): string;
    private _privateLinkEnabled?;
    /**
     * @stability stable
     */
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateLinkEnabled(): void;
    /**
     * @stability stable
     */
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuTier?;
    /**
     * @stability stable
     */
    get skuTier(): string;
    /**
     * @stability stable
     */
    set skuTier(value: string);
    /**
     * @stability stable
     */
    resetSkuTier(): void;
    /**
     * @stability stable
     */
    get skuTierInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _addonProfile;
    /**
     * @stability stable
     */
    get addonProfile(): KubernetesClusterAddonProfileOutputReference;
    /**
     * @stability stable
     */
    putAddonProfile(value: KubernetesClusterAddonProfile): void;
    /**
     * @stability stable
     */
    resetAddonProfile(): void;
    /**
     * @stability stable
     */
    get addonProfileInput(): KubernetesClusterAddonProfile | undefined;
    private _autoScalerProfile;
    /**
     * @stability stable
     */
    get autoScalerProfile(): KubernetesClusterAutoScalerProfileOutputReference;
    /**
     * @stability stable
     */
    putAutoScalerProfile(value: KubernetesClusterAutoScalerProfile): void;
    /**
     * @stability stable
     */
    resetAutoScalerProfile(): void;
    /**
     * @stability stable
     */
    get autoScalerProfileInput(): KubernetesClusterAutoScalerProfile | undefined;
    private _defaultNodePool;
    /**
     * @stability stable
     */
    get defaultNodePool(): KubernetesClusterDefaultNodePoolOutputReference;
    /**
     * @stability stable
     */
    putDefaultNodePool(value: KubernetesClusterDefaultNodePool): void;
    /**
     * @stability stable
     */
    get defaultNodePoolInput(): KubernetesClusterDefaultNodePool | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): KubernetesClusterIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: KubernetesClusterIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): KubernetesClusterIdentity | undefined;
    private _kubeletIdentity;
    /**
     * @stability stable
     */
    get kubeletIdentity(): KubernetesClusterKubeletIdentityOutputReference;
    /**
     * @stability stable
     */
    putKubeletIdentity(value: KubernetesClusterKubeletIdentity): void;
    /**
     * @stability stable
     */
    resetKubeletIdentity(): void;
    /**
     * @stability stable
     */
    get kubeletIdentityInput(): KubernetesClusterKubeletIdentity | undefined;
    private _linuxProfile;
    /**
     * @stability stable
     */
    get linuxProfile(): KubernetesClusterLinuxProfileOutputReference;
    /**
     * @stability stable
     */
    putLinuxProfile(value: KubernetesClusterLinuxProfile): void;
    /**
     * @stability stable
     */
    resetLinuxProfile(): void;
    /**
     * @stability stable
     */
    get linuxProfileInput(): KubernetesClusterLinuxProfile | undefined;
    private _maintenanceWindow;
    /**
     * @stability stable
     */
    get maintenanceWindow(): KubernetesClusterMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putMaintenanceWindow(value: KubernetesClusterMaintenanceWindow): void;
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): KubernetesClusterMaintenanceWindow | undefined;
    private _networkProfile;
    /**
     * @stability stable
     */
    get networkProfile(): KubernetesClusterNetworkProfileOutputReference;
    /**
     * @stability stable
     */
    putNetworkProfile(value: KubernetesClusterNetworkProfile): void;
    /**
     * @stability stable
     */
    resetNetworkProfile(): void;
    /**
     * @stability stable
     */
    get networkProfileInput(): KubernetesClusterNetworkProfile | undefined;
    private _roleBasedAccessControl;
    /**
     * @stability stable
     */
    get roleBasedAccessControl(): KubernetesClusterRoleBasedAccessControlOutputReference;
    /**
     * @stability stable
     */
    putRoleBasedAccessControl(value: KubernetesClusterRoleBasedAccessControl): void;
    /**
     * @stability stable
     */
    resetRoleBasedAccessControl(): void;
    /**
     * @stability stable
     */
    get roleBasedAccessControlInput(): KubernetesClusterRoleBasedAccessControl | undefined;
    private _servicePrincipal;
    /**
     * @stability stable
     */
    get servicePrincipal(): KubernetesClusterServicePrincipalOutputReference;
    /**
     * @stability stable
     */
    putServicePrincipal(value: KubernetesClusterServicePrincipal): void;
    /**
     * @stability stable
     */
    resetServicePrincipal(): void;
    /**
     * @stability stable
     */
    get servicePrincipalInput(): KubernetesClusterServicePrincipal | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KubernetesClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KubernetesClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KubernetesClusterTimeouts | undefined;
    private _windowsProfile;
    /**
     * @stability stable
     */
    get windowsProfile(): KubernetesClusterWindowsProfileOutputReference;
    /**
     * @stability stable
     */
    putWindowsProfile(value: KubernetesClusterWindowsProfile): void;
    /**
     * @stability stable
     */
    resetWindowsProfile(): void;
    /**
     * @stability stable
     */
    get windowsProfileInput(): KubernetesClusterWindowsProfile | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
