import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#address_space LocalNetworkGateway#address_space}.
     *
     * @stability stable
     */
    readonly addressSpace?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#gateway_address LocalNetworkGateway#gateway_address}.
     *
     * @stability stable
     */
    readonly gatewayAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#gateway_fqdn LocalNetworkGateway#gateway_fqdn}.
     *
     * @stability stable
     */
    readonly gatewayFqdn?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#location LocalNetworkGateway#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#name LocalNetworkGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#resource_group_name LocalNetworkGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#tags LocalNetworkGateway#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * bgp_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#bgp_settings LocalNetworkGateway#bgp_settings}
     *
     * @stability stable
     */
    readonly bgpSettings?: LocalNetworkGatewayBgpSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#timeouts LocalNetworkGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LocalNetworkGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface LocalNetworkGatewayBgpSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#asn LocalNetworkGateway#asn}.
     *
     * @stability stable
     */
    readonly asn: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#bgp_peering_address LocalNetworkGateway#bgp_peering_address}.
     *
     * @stability stable
     */
    readonly bgpPeeringAddress: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#peer_weight LocalNetworkGateway#peer_weight}.
     *
     * @stability stable
     */
    readonly peerWeight?: number;
}
export declare function localNetworkGatewayBgpSettingsToTerraform(struct?: LocalNetworkGatewayBgpSettingsOutputReference | LocalNetworkGatewayBgpSettings): any;
/**
 * @stability stable
 */
export declare class LocalNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LocalNetworkGatewayBgpSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LocalNetworkGatewayBgpSettings | undefined);
    private _asn?;
    /**
     * @stability stable
     */
    get asn(): number;
    /**
     * @stability stable
     */
    set asn(value: number);
    /**
     * @stability stable
     */
    get asnInput(): number | undefined;
    private _bgpPeeringAddress?;
    /**
     * @stability stable
     */
    get bgpPeeringAddress(): string;
    /**
     * @stability stable
     */
    set bgpPeeringAddress(value: string);
    /**
     * @stability stable
     */
    get bgpPeeringAddressInput(): string | undefined;
    private _peerWeight?;
    /**
     * @stability stable
     */
    get peerWeight(): number;
    /**
     * @stability stable
     */
    set peerWeight(value: number);
    /**
     * @stability stable
     */
    resetPeerWeight(): void;
    /**
     * @stability stable
     */
    get peerWeightInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface LocalNetworkGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#create LocalNetworkGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#delete LocalNetworkGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#read LocalNetworkGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html#update LocalNetworkGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function localNetworkGatewayTimeoutsToTerraform(struct?: LocalNetworkGatewayTimeoutsOutputReference | LocalNetworkGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class LocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LocalNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LocalNetworkGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html azurerm_local_network_gateway}.
 *
 * @stability stable
 */
export declare class LocalNetworkGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/local_network_gateway.html azurerm_local_network_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LocalNetworkGatewayConfig);
    private _addressSpace?;
    /**
     * @stability stable
     */
    get addressSpace(): string[];
    /**
     * @stability stable
     */
    set addressSpace(value: string[]);
    /**
     * @stability stable
     */
    resetAddressSpace(): void;
    /**
     * @stability stable
     */
    get addressSpaceInput(): string[] | undefined;
    private _gatewayAddress?;
    /**
     * @stability stable
     */
    get gatewayAddress(): string;
    /**
     * @stability stable
     */
    set gatewayAddress(value: string);
    /**
     * @stability stable
     */
    resetGatewayAddress(): void;
    /**
     * @stability stable
     */
    get gatewayAddressInput(): string | undefined;
    private _gatewayFqdn?;
    /**
     * @stability stable
     */
    get gatewayFqdn(): string;
    /**
     * @stability stable
     */
    set gatewayFqdn(value: string);
    /**
     * @stability stable
     */
    resetGatewayFqdn(): void;
    /**
     * @stability stable
     */
    get gatewayFqdnInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _bgpSettings;
    /**
     * @stability stable
     */
    get bgpSettings(): LocalNetworkGatewayBgpSettingsOutputReference;
    /**
     * @stability stable
     */
    putBgpSettings(value: LocalNetworkGatewayBgpSettings): void;
    /**
     * @stability stable
     */
    resetBgpSettings(): void;
    /**
     * @stability stable
     */
    get bgpSettingsInput(): LocalNetworkGatewayBgpSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): LocalNetworkGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LocalNetworkGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LocalNetworkGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
