import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MachineLearningInferenceClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#cluster_purpose MachineLearningInferenceCluster#cluster_purpose}.
     *
     * @stability stable
     */
    readonly clusterPurpose?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#description MachineLearningInferenceCluster#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#kubernetes_cluster_id MachineLearningInferenceCluster#kubernetes_cluster_id}.
     *
     * @stability stable
     */
    readonly kubernetesClusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#location MachineLearningInferenceCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#machine_learning_workspace_id MachineLearningInferenceCluster#machine_learning_workspace_id}.
     *
     * @stability stable
     */
    readonly machineLearningWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#name MachineLearningInferenceCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#tags MachineLearningInferenceCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#identity MachineLearningInferenceCluster#identity}
     *
     * @stability stable
     */
    readonly identity?: MachineLearningInferenceClusterIdentity;
    /**
     * ssl block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#ssl MachineLearningInferenceCluster#ssl}
     *
     * @stability stable
     */
    readonly ssl?: MachineLearningInferenceClusterSsl;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#timeouts MachineLearningInferenceCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MachineLearningInferenceClusterTimeouts;
}
/**
 * @stability stable
 */
export interface MachineLearningInferenceClusterIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#identity_ids MachineLearningInferenceCluster#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#type MachineLearningInferenceCluster#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function machineLearningInferenceClusterIdentityToTerraform(struct?: MachineLearningInferenceClusterIdentityOutputReference | MachineLearningInferenceClusterIdentity): any;
/**
 * @stability stable
 */
export declare class MachineLearningInferenceClusterIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningInferenceClusterIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningInferenceClusterIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningInferenceClusterSsl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#cert MachineLearningInferenceCluster#cert}.
     *
     * @stability stable
     */
    readonly cert?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#cname MachineLearningInferenceCluster#cname}.
     *
     * @stability stable
     */
    readonly cname?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#key MachineLearningInferenceCluster#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#leaf_domain_label MachineLearningInferenceCluster#leaf_domain_label}.
     *
     * @stability stable
     */
    readonly leafDomainLabel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#overwrite_existing_domain MachineLearningInferenceCluster#overwrite_existing_domain}.
     *
     * @stability stable
     */
    readonly overwriteExistingDomain?: boolean | cdktf.IResolvable;
}
export declare function machineLearningInferenceClusterSslToTerraform(struct?: MachineLearningInferenceClusterSslOutputReference | MachineLearningInferenceClusterSsl): any;
/**
 * @stability stable
 */
export declare class MachineLearningInferenceClusterSslOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningInferenceClusterSsl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningInferenceClusterSsl | undefined);
    private _cert?;
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    set cert(value: string);
    /**
     * @stability stable
     */
    resetCert(): void;
    /**
     * @stability stable
     */
    get certInput(): string | undefined;
    private _cname?;
    /**
     * @stability stable
     */
    get cname(): string;
    /**
     * @stability stable
     */
    set cname(value: string);
    /**
     * @stability stable
     */
    resetCname(): void;
    /**
     * @stability stable
     */
    get cnameInput(): string | undefined;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _leafDomainLabel?;
    /**
     * @stability stable
     */
    get leafDomainLabel(): string;
    /**
     * @stability stable
     */
    set leafDomainLabel(value: string);
    /**
     * @stability stable
     */
    resetLeafDomainLabel(): void;
    /**
     * @stability stable
     */
    get leafDomainLabelInput(): string | undefined;
    private _overwriteExistingDomain?;
    /**
     * @stability stable
     */
    get overwriteExistingDomain(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set overwriteExistingDomain(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOverwriteExistingDomain(): void;
    /**
     * @stability stable
     */
    get overwriteExistingDomainInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MachineLearningInferenceClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#create MachineLearningInferenceCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#delete MachineLearningInferenceCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#read MachineLearningInferenceCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html#update MachineLearningInferenceCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function machineLearningInferenceClusterTimeoutsToTerraform(struct?: MachineLearningInferenceClusterTimeoutsOutputReference | MachineLearningInferenceClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class MachineLearningInferenceClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MachineLearningInferenceClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MachineLearningInferenceClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html azurerm_machine_learning_inference_cluster}.
 *
 * @stability stable
 */
export declare class MachineLearningInferenceCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/machine_learning_inference_cluster.html azurerm_machine_learning_inference_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MachineLearningInferenceClusterConfig);
    private _clusterPurpose?;
    /**
     * @stability stable
     */
    get clusterPurpose(): string;
    /**
     * @stability stable
     */
    set clusterPurpose(value: string);
    /**
     * @stability stable
     */
    resetClusterPurpose(): void;
    /**
     * @stability stable
     */
    get clusterPurposeInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kubernetesClusterId?;
    /**
     * @stability stable
     */
    get kubernetesClusterId(): string;
    /**
     * @stability stable
     */
    set kubernetesClusterId(value: string);
    /**
     * @stability stable
     */
    get kubernetesClusterIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    /**
     * @stability stable
     */
    get machineLearningWorkspaceId(): string;
    /**
     * @stability stable
     */
    set machineLearningWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MachineLearningInferenceClusterIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MachineLearningInferenceClusterIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MachineLearningInferenceClusterIdentity | undefined;
    private _ssl;
    /**
     * @stability stable
     */
    get ssl(): MachineLearningInferenceClusterSslOutputReference;
    /**
     * @stability stable
     */
    putSsl(value: MachineLearningInferenceClusterSsl): void;
    /**
     * @stability stable
     */
    resetSsl(): void;
    /**
     * @stability stable
     */
    get sslInput(): MachineLearningInferenceClusterSsl | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MachineLearningInferenceClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MachineLearningInferenceClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MachineLearningInferenceClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
