"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaContentKeyPolicy = exports.MediaContentKeyPolicyTimeoutsOutputReference = exports.mediaContentKeyPolicyTimeoutsToTerraform = exports.mediaContentKeyPolicyPolicyOptionToTerraform = exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        playback_duration_seconds: cdktf.numberToTerraform(struct.playbackDurationSeconds),
        storage_duration_seconds: cdktf.numberToTerraform(struct.storageDurationSeconds),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._playbackDurationSeconds) {
            hasAnyValues = true;
            internalValueResult.playbackDurationSeconds = this._playbackDurationSeconds;
        }
        if (this._storageDurationSeconds) {
            hasAnyValues = true;
            internalValueResult.storageDurationSeconds = this._storageDurationSeconds;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._playbackDurationSeconds = undefined;
            this._storageDurationSeconds = undefined;
        }
        else {
            this._playbackDurationSeconds = value.playbackDurationSeconds;
            this._storageDurationSeconds = value.storageDurationSeconds;
        }
    }
    /**
     * @stability stable
     */
    get playbackDurationSeconds() {
        return this.getNumberAttribute('playback_duration_seconds');
    }
    /**
     * @stability stable
     */
    set playbackDurationSeconds(value) {
        this._playbackDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetPlaybackDurationSeconds() {
        this._playbackDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get playbackDurationSecondsInput() {
        return this._playbackDurationSeconds;
    }
    /**
     * @stability stable
     */
    get storageDurationSeconds() {
        return this.getNumberAttribute('storage_duration_seconds');
    }
    /**
     * @stability stable
     */
    set storageDurationSeconds(value) {
        this._storageDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetStorageDurationSeconds() {
        this._storageDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageDurationSecondsInput() {
        return this._storageDurationSeconds;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference", version: "0.3.4" };
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ask: cdktf.stringToTerraform(struct.ask),
        pfx: cdktf.stringToTerraform(struct.pfx),
        pfx_password: cdktf.stringToTerraform(struct.pfxPassword),
        rental_and_lease_key_type: cdktf.stringToTerraform(struct.rentalAndLeaseKeyType),
        rental_duration_seconds: cdktf.numberToTerraform(struct.rentalDurationSeconds),
        offline_rental_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct.offlineRentalConfiguration),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        // offline_rental_configuration - computed: false, optional: true, required: false
        this._offlineRentalConfiguration = new MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference(this, "offline_rental_configuration", true);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        var _g;
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._ask) {
            hasAnyValues = true;
            internalValueResult.ask = this._ask;
        }
        if (this._pfx) {
            hasAnyValues = true;
            internalValueResult.pfx = this._pfx;
        }
        if (this._pfxPassword) {
            hasAnyValues = true;
            internalValueResult.pfxPassword = this._pfxPassword;
        }
        if (this._rentalAndLeaseKeyType) {
            hasAnyValues = true;
            internalValueResult.rentalAndLeaseKeyType = this._rentalAndLeaseKeyType;
        }
        if (this._rentalDurationSeconds) {
            hasAnyValues = true;
            internalValueResult.rentalDurationSeconds = this._rentalDurationSeconds;
        }
        if (this._offlineRentalConfiguration) {
            hasAnyValues = true;
            internalValueResult.offlineRentalConfiguration = (_g = this._offlineRentalConfiguration) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._ask = undefined;
            this._pfx = undefined;
            this._pfxPassword = undefined;
            this._rentalAndLeaseKeyType = undefined;
            this._rentalDurationSeconds = undefined;
            this._offlineRentalConfiguration.internalValue = undefined;
        }
        else {
            this._ask = value.ask;
            this._pfx = value.pfx;
            this._pfxPassword = value.pfxPassword;
            this._rentalAndLeaseKeyType = value.rentalAndLeaseKeyType;
            this._rentalDurationSeconds = value.rentalDurationSeconds;
            this._offlineRentalConfiguration.internalValue = value.offlineRentalConfiguration;
        }
    }
    /**
     * @stability stable
     */
    get ask() {
        return this.getStringAttribute('ask');
    }
    /**
     * @stability stable
     */
    set ask(value) {
        this._ask = value;
    }
    /**
     * @stability stable
     */
    resetAsk() {
        this._ask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get askInput() {
        return this._ask;
    }
    /**
     * @stability stable
     */
    get pfx() {
        return this.getStringAttribute('pfx');
    }
    /**
     * @stability stable
     */
    set pfx(value) {
        this._pfx = value;
    }
    /**
     * @stability stable
     */
    resetPfx() {
        this._pfx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pfxInput() {
        return this._pfx;
    }
    /**
     * @stability stable
     */
    get pfxPassword() {
        return this.getStringAttribute('pfx_password');
    }
    /**
     * @stability stable
     */
    set pfxPassword(value) {
        this._pfxPassword = value;
    }
    /**
     * @stability stable
     */
    resetPfxPassword() {
        this._pfxPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get pfxPasswordInput() {
        return this._pfxPassword;
    }
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyType() {
        return this.getStringAttribute('rental_and_lease_key_type');
    }
    /**
     * @stability stable
     */
    set rentalAndLeaseKeyType(value) {
        this._rentalAndLeaseKeyType = value;
    }
    /**
     * @stability stable
     */
    resetRentalAndLeaseKeyType() {
        this._rentalAndLeaseKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rentalAndLeaseKeyTypeInput() {
        return this._rentalAndLeaseKeyType;
    }
    /**
     * @stability stable
     */
    get rentalDurationSeconds() {
        return this.getNumberAttribute('rental_duration_seconds');
    }
    /**
     * @stability stable
     */
    set rentalDurationSeconds(value) {
        this._rentalDurationSeconds = value;
    }
    /**
     * @stability stable
     */
    resetRentalDurationSeconds() {
        this._rentalDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get rentalDurationSecondsInput() {
        return this._rentalDurationSeconds;
    }
    /**
     * @stability stable
     */
    get offlineRentalConfiguration() {
        return this._offlineRentalConfiguration;
    }
    /**
     * @stability stable
     */
    putOfflineRentalConfiguration(value) {
        this._offlineRentalConfiguration.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetOfflineRentalConfiguration() {
        this._offlineRentalConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get offlineRentalConfigurationInput() {
        return this._offlineRentalConfiguration.internalValue;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference", version: "0.3.4" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        agc_and_color_stripe_restriction: cdktf.numberToTerraform(struct.agcAndColorStripeRestriction),
        allow_passing_video_content_to_unknown_output: cdktf.stringToTerraform(struct.allowPassingVideoContentToUnknownOutput),
        analog_video_opl: cdktf.numberToTerraform(struct.analogVideoOpl),
        compressed_digital_audio_opl: cdktf.numberToTerraform(struct.compressedDigitalAudioOpl),
        digital_video_only_content_restriction: cdktf.booleanToTerraform(struct.digitalVideoOnlyContentRestriction),
        first_play_expiration: cdktf.stringToTerraform(struct.firstPlayExpiration),
        image_constraint_for_analog_component_video_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComponentVideoRestriction),
        image_constraint_for_analog_computer_monitor_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComputerMonitorRestriction),
        scms_restriction: cdktf.numberToTerraform(struct.scmsRestriction),
        uncompressed_digital_audio_opl: cdktf.numberToTerraform(struct.uncompressedDigitalAudioOpl),
        uncompressed_digital_video_opl: cdktf.numberToTerraform(struct.uncompressedDigitalVideoOpl),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._agcAndColorStripeRestriction) {
            hasAnyValues = true;
            internalValueResult.agcAndColorStripeRestriction = this._agcAndColorStripeRestriction;
        }
        if (this._allowPassingVideoContentToUnknownOutput) {
            hasAnyValues = true;
            internalValueResult.allowPassingVideoContentToUnknownOutput = this._allowPassingVideoContentToUnknownOutput;
        }
        if (this._analogVideoOpl) {
            hasAnyValues = true;
            internalValueResult.analogVideoOpl = this._analogVideoOpl;
        }
        if (this._compressedDigitalAudioOpl) {
            hasAnyValues = true;
            internalValueResult.compressedDigitalAudioOpl = this._compressedDigitalAudioOpl;
        }
        if (this._digitalVideoOnlyContentRestriction) {
            hasAnyValues = true;
            internalValueResult.digitalVideoOnlyContentRestriction = this._digitalVideoOnlyContentRestriction;
        }
        if (this._firstPlayExpiration) {
            hasAnyValues = true;
            internalValueResult.firstPlayExpiration = this._firstPlayExpiration;
        }
        if (this._imageConstraintForAnalogComponentVideoRestriction) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComponentVideoRestriction = this._imageConstraintForAnalogComponentVideoRestriction;
        }
        if (this._imageConstraintForAnalogComputerMonitorRestriction) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComputerMonitorRestriction = this._imageConstraintForAnalogComputerMonitorRestriction;
        }
        if (this._scmsRestriction) {
            hasAnyValues = true;
            internalValueResult.scmsRestriction = this._scmsRestriction;
        }
        if (this._uncompressedDigitalAudioOpl) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalAudioOpl = this._uncompressedDigitalAudioOpl;
        }
        if (this._uncompressedDigitalVideoOpl) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalVideoOpl = this._uncompressedDigitalVideoOpl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._agcAndColorStripeRestriction = undefined;
            this._allowPassingVideoContentToUnknownOutput = undefined;
            this._analogVideoOpl = undefined;
            this._compressedDigitalAudioOpl = undefined;
            this._digitalVideoOnlyContentRestriction = undefined;
            this._firstPlayExpiration = undefined;
            this._imageConstraintForAnalogComponentVideoRestriction = undefined;
            this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
            this._scmsRestriction = undefined;
            this._uncompressedDigitalAudioOpl = undefined;
            this._uncompressedDigitalVideoOpl = undefined;
        }
        else {
            this._agcAndColorStripeRestriction = value.agcAndColorStripeRestriction;
            this._allowPassingVideoContentToUnknownOutput = value.allowPassingVideoContentToUnknownOutput;
            this._analogVideoOpl = value.analogVideoOpl;
            this._compressedDigitalAudioOpl = value.compressedDigitalAudioOpl;
            this._digitalVideoOnlyContentRestriction = value.digitalVideoOnlyContentRestriction;
            this._firstPlayExpiration = value.firstPlayExpiration;
            this._imageConstraintForAnalogComponentVideoRestriction = value.imageConstraintForAnalogComponentVideoRestriction;
            this._imageConstraintForAnalogComputerMonitorRestriction = value.imageConstraintForAnalogComputerMonitorRestriction;
            this._scmsRestriction = value.scmsRestriction;
            this._uncompressedDigitalAudioOpl = value.uncompressedDigitalAudioOpl;
            this._uncompressedDigitalVideoOpl = value.uncompressedDigitalVideoOpl;
        }
    }
    /**
     * @stability stable
     */
    get agcAndColorStripeRestriction() {
        return this.getNumberAttribute('agc_and_color_stripe_restriction');
    }
    /**
     * @stability stable
     */
    set agcAndColorStripeRestriction(value) {
        this._agcAndColorStripeRestriction = value;
    }
    /**
     * @stability stable
     */
    resetAgcAndColorStripeRestriction() {
        this._agcAndColorStripeRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get agcAndColorStripeRestrictionInput() {
        return this._agcAndColorStripeRestriction;
    }
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutput() {
        return this.getStringAttribute('allow_passing_video_content_to_unknown_output');
    }
    /**
     * @stability stable
     */
    set allowPassingVideoContentToUnknownOutput(value) {
        this._allowPassingVideoContentToUnknownOutput = value;
    }
    /**
     * @stability stable
     */
    resetAllowPassingVideoContentToUnknownOutput() {
        this._allowPassingVideoContentToUnknownOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get allowPassingVideoContentToUnknownOutputInput() {
        return this._allowPassingVideoContentToUnknownOutput;
    }
    /**
     * @stability stable
     */
    get analogVideoOpl() {
        return this.getNumberAttribute('analog_video_opl');
    }
    /**
     * @stability stable
     */
    set analogVideoOpl(value) {
        this._analogVideoOpl = value;
    }
    /**
     * @stability stable
     */
    resetAnalogVideoOpl() {
        this._analogVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get analogVideoOplInput() {
        return this._analogVideoOpl;
    }
    /**
     * @stability stable
     */
    get compressedDigitalAudioOpl() {
        return this.getNumberAttribute('compressed_digital_audio_opl');
    }
    /**
     * @stability stable
     */
    set compressedDigitalAudioOpl(value) {
        this._compressedDigitalAudioOpl = value;
    }
    /**
     * @stability stable
     */
    resetCompressedDigitalAudioOpl() {
        this._compressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get compressedDigitalAudioOplInput() {
        return this._compressedDigitalAudioOpl;
    }
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestriction() {
        return this.getBooleanAttribute('digital_video_only_content_restriction');
    }
    /**
     * @stability stable
     */
    set digitalVideoOnlyContentRestriction(value) {
        this._digitalVideoOnlyContentRestriction = value;
    }
    /**
     * @stability stable
     */
    resetDigitalVideoOnlyContentRestriction() {
        this._digitalVideoOnlyContentRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get digitalVideoOnlyContentRestrictionInput() {
        return this._digitalVideoOnlyContentRestriction;
    }
    /**
     * @stability stable
     */
    get firstPlayExpiration() {
        return this.getStringAttribute('first_play_expiration');
    }
    /**
     * @stability stable
     */
    set firstPlayExpiration(value) {
        this._firstPlayExpiration = value;
    }
    /**
     * @stability stable
     */
    resetFirstPlayExpiration() {
        this._firstPlayExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get firstPlayExpirationInput() {
        return this._firstPlayExpiration;
    }
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_component_video_restriction');
    }
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComponentVideoRestriction(value) {
        this._imageConstraintForAnalogComponentVideoRestriction = value;
    }
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComponentVideoRestriction() {
        this._imageConstraintForAnalogComponentVideoRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComponentVideoRestrictionInput() {
        return this._imageConstraintForAnalogComponentVideoRestriction;
    }
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_computer_monitor_restriction');
    }
    /**
     * @stability stable
     */
    set imageConstraintForAnalogComputerMonitorRestriction(value) {
        this._imageConstraintForAnalogComputerMonitorRestriction = value;
    }
    /**
     * @stability stable
     */
    resetImageConstraintForAnalogComputerMonitorRestriction() {
        this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get imageConstraintForAnalogComputerMonitorRestrictionInput() {
        return this._imageConstraintForAnalogComputerMonitorRestriction;
    }
    /**
     * @stability stable
     */
    get scmsRestriction() {
        return this.getNumberAttribute('scms_restriction');
    }
    /**
     * @stability stable
     */
    set scmsRestriction(value) {
        this._scmsRestriction = value;
    }
    /**
     * @stability stable
     */
    resetScmsRestriction() {
        this._scmsRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get scmsRestrictionInput() {
        return this._scmsRestriction;
    }
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOpl() {
        return this.getNumberAttribute('uncompressed_digital_audio_opl');
    }
    /**
     * @stability stable
     */
    set uncompressedDigitalAudioOpl(value) {
        this._uncompressedDigitalAudioOpl = value;
    }
    /**
     * @stability stable
     */
    resetUncompressedDigitalAudioOpl() {
        this._uncompressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get uncompressedDigitalAudioOplInput() {
        return this._uncompressedDigitalAudioOpl;
    }
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOpl() {
        return this.getNumberAttribute('uncompressed_digital_video_opl');
    }
    /**
     * @stability stable
     */
    set uncompressedDigitalVideoOpl(value) {
        this._uncompressedDigitalVideoOpl = value;
    }
    /**
     * @stability stable
     */
    resetUncompressedDigitalVideoOpl() {
        this._uncompressedDigitalVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get uncompressedDigitalVideoOplInput() {
        return this._uncompressedDigitalVideoOpl;
    }
}
exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference", version: "0.3.4" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allow_test_devices: cdktf.booleanToTerraform(struct.allowTestDevices),
        begin_date: cdktf.stringToTerraform(struct.beginDate),
        content_key_location_from_header_enabled: cdktf.booleanToTerraform(struct.contentKeyLocationFromHeaderEnabled),
        content_key_location_from_key_id: cdktf.stringToTerraform(struct.contentKeyLocationFromKeyId),
        content_type: cdktf.stringToTerraform(struct.contentType),
        expiration_date: cdktf.stringToTerraform(struct.expirationDate),
        grace_period: cdktf.stringToTerraform(struct.gracePeriod),
        license_type: cdktf.stringToTerraform(struct.licenseType),
        relative_begin_date: cdktf.stringToTerraform(struct.relativeBeginDate),
        relative_expiration_date: cdktf.stringToTerraform(struct.relativeExpirationDate),
        play_right: mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct.playRight),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        type: cdktf.stringToTerraform(struct.type),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        issuer: cdktf.stringToTerraform(struct.issuer),
        open_id_connect_discovery_document: cdktf.stringToTerraform(struct.openIdConnectDiscoveryDocument),
        primary_rsa_token_key_exponent: cdktf.stringToTerraform(struct.primaryRsaTokenKeyExponent),
        primary_rsa_token_key_modulus: cdktf.stringToTerraform(struct.primaryRsaTokenKeyModulus),
        primary_symmetric_token_key: cdktf.stringToTerraform(struct.primarySymmetricTokenKey),
        primary_x509_token_key_raw: cdktf.stringToTerraform(struct.primaryX509TokenKeyRaw),
        token_type: cdktf.stringToTerraform(struct.tokenType),
        required_claim: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform)(struct.requiredClaim),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._audience) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._issuer) {
            hasAnyValues = true;
            internalValueResult.issuer = this._issuer;
        }
        if (this._openIdConnectDiscoveryDocument) {
            hasAnyValues = true;
            internalValueResult.openIdConnectDiscoveryDocument = this._openIdConnectDiscoveryDocument;
        }
        if (this._primaryRsaTokenKeyExponent) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyExponent = this._primaryRsaTokenKeyExponent;
        }
        if (this._primaryRsaTokenKeyModulus) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyModulus = this._primaryRsaTokenKeyModulus;
        }
        if (this._primarySymmetricTokenKey) {
            hasAnyValues = true;
            internalValueResult.primarySymmetricTokenKey = this._primarySymmetricTokenKey;
        }
        if (this._primaryX509TokenKeyRaw) {
            hasAnyValues = true;
            internalValueResult.primaryX509TokenKeyRaw = this._primaryX509TokenKeyRaw;
        }
        if (this._tokenType) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        if (this._requiredClaim) {
            hasAnyValues = true;
            internalValueResult.requiredClaim = this._requiredClaim;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._audience = undefined;
            this._issuer = undefined;
            this._openIdConnectDiscoveryDocument = undefined;
            this._primaryRsaTokenKeyExponent = undefined;
            this._primaryRsaTokenKeyModulus = undefined;
            this._primarySymmetricTokenKey = undefined;
            this._primaryX509TokenKeyRaw = undefined;
            this._tokenType = undefined;
            this._requiredClaim = undefined;
        }
        else {
            this._audience = value.audience;
            this._issuer = value.issuer;
            this._openIdConnectDiscoveryDocument = value.openIdConnectDiscoveryDocument;
            this._primaryRsaTokenKeyExponent = value.primaryRsaTokenKeyExponent;
            this._primaryRsaTokenKeyModulus = value.primaryRsaTokenKeyModulus;
            this._primarySymmetricTokenKey = value.primarySymmetricTokenKey;
            this._primaryX509TokenKeyRaw = value.primaryX509TokenKeyRaw;
            this._tokenType = value.tokenType;
            this._requiredClaim = value.requiredClaim;
        }
    }
    /**
     * @stability stable
     */
    get audience() {
        return this.getStringAttribute('audience');
    }
    /**
     * @stability stable
     */
    set audience(value) {
        this._audience = value;
    }
    /**
     * @stability stable
     */
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get audienceInput() {
        return this._audience;
    }
    /**
     * @stability stable
     */
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    /**
     * @stability stable
     */
    set issuer(value) {
        this._issuer = value;
    }
    /**
     * @stability stable
     */
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get issuerInput() {
        return this._issuer;
    }
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocument() {
        return this.getStringAttribute('open_id_connect_discovery_document');
    }
    /**
     * @stability stable
     */
    set openIdConnectDiscoveryDocument(value) {
        this._openIdConnectDiscoveryDocument = value;
    }
    /**
     * @stability stable
     */
    resetOpenIdConnectDiscoveryDocument() {
        this._openIdConnectDiscoveryDocument = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get openIdConnectDiscoveryDocumentInput() {
        return this._openIdConnectDiscoveryDocument;
    }
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponent() {
        return this.getStringAttribute('primary_rsa_token_key_exponent');
    }
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyExponent(value) {
        this._primaryRsaTokenKeyExponent = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyExponent() {
        this._primaryRsaTokenKeyExponent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyExponentInput() {
        return this._primaryRsaTokenKeyExponent;
    }
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulus() {
        return this.getStringAttribute('primary_rsa_token_key_modulus');
    }
    /**
     * @stability stable
     */
    set primaryRsaTokenKeyModulus(value) {
        this._primaryRsaTokenKeyModulus = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryRsaTokenKeyModulus() {
        this._primaryRsaTokenKeyModulus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryRsaTokenKeyModulusInput() {
        return this._primaryRsaTokenKeyModulus;
    }
    /**
     * @stability stable
     */
    get primarySymmetricTokenKey() {
        return this.getStringAttribute('primary_symmetric_token_key');
    }
    /**
     * @stability stable
     */
    set primarySymmetricTokenKey(value) {
        this._primarySymmetricTokenKey = value;
    }
    /**
     * @stability stable
     */
    resetPrimarySymmetricTokenKey() {
        this._primarySymmetricTokenKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primarySymmetricTokenKeyInput() {
        return this._primarySymmetricTokenKey;
    }
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRaw() {
        return this.getStringAttribute('primary_x509_token_key_raw');
    }
    /**
     * @stability stable
     */
    set primaryX509TokenKeyRaw(value) {
        this._primaryX509TokenKeyRaw = value;
    }
    /**
     * @stability stable
     */
    resetPrimaryX509TokenKeyRaw() {
        this._primaryX509TokenKeyRaw = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get primaryX509TokenKeyRawInput() {
        return this._primaryX509TokenKeyRaw;
    }
    /**
     * @stability stable
     */
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    /**
     * @stability stable
     */
    set tokenType(value) {
        this._tokenType = value;
    }
    /**
     * @stability stable
     */
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tokenTypeInput() {
        return this._tokenType;
    }
    /**
     * @stability stable
     */
    get requiredClaim() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('required_claim');
    }
    /**
     * @stability stable
     */
    set requiredClaim(value) {
        this._requiredClaim = value;
    }
    /**
     * @stability stable
     */
    resetRequiredClaim() {
        this._requiredClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get requiredClaimInput() {
        return this._requiredClaim;
    }
}
exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference", version: "0.3.4" };
function mediaContentKeyPolicyPolicyOptionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        clear_key_configuration_enabled: cdktf.booleanToTerraform(struct.clearKeyConfigurationEnabled),
        name: cdktf.stringToTerraform(struct.name),
        open_restriction_enabled: cdktf.booleanToTerraform(struct.openRestrictionEnabled),
        widevine_configuration_template: cdktf.stringToTerraform(struct.widevineConfigurationTemplate),
        fairplay_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct.fairplayConfiguration),
        playready_configuration_license: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform)(struct.playreadyConfigurationLicense),
        token_restriction: mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct.tokenRestriction),
    };
}
exports.mediaContentKeyPolicyPolicyOptionToTerraform = mediaContentKeyPolicyPolicyOptionToTerraform;
function mediaContentKeyPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mediaContentKeyPolicyTimeoutsToTerraform = mediaContentKeyPolicyTimeoutsToTerraform;
/**
 * @stability stable
 */
class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._create) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    /**
     * @stability stable
     */
    get create() {
        return this.getStringAttribute('create');
    }
    /**
     * @stability stable
     */
    set create(value) {
        this._create = value;
    }
    /**
     * @stability stable
     */
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get createInput() {
        return this._create;
    }
    /**
     * @stability stable
     */
    get delete() {
        return this.getStringAttribute('delete');
    }
    /**
     * @stability stable
     */
    set delete(value) {
        this._delete = value;
    }
    /**
     * @stability stable
     */
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteInput() {
        return this._delete;
    }
    /**
     * @stability stable
     */
    get read() {
        return this.getStringAttribute('read');
    }
    /**
     * @stability stable
     */
    set read(value) {
        this._read = value;
    }
    /**
     * @stability stable
     */
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readInput() {
        return this._read;
    }
    /**
     * @stability stable
     */
    get update() {
        return this.getStringAttribute('update');
    }
    /**
     * @stability stable
     */
    set update(value) {
        this._update = value;
    }
    /**
     * @stability stable
     */
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateInput() {
        return this._update;
    }
}
exports.MediaContentKeyPolicyTimeoutsOutputReference = MediaContentKeyPolicyTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyTimeoutsOutputReference", version: "0.3.4" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy.html azurerm_media_content_key_policy}.
 *
 * @stability stable
 */
class MediaContentKeyPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy.html azurerm_media_content_key_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_media_content_key_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MediaContentKeyPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._description = config.description;
        this._mediaServicesAccountName = config.mediaServicesAccountName;
        this._name = config.name;
        this._resourceGroupName = config.resourceGroupName;
        this._policyOption = config.policyOption;
        this._timeouts.internalValue = config.timeouts;
    }
    /**
     * @stability stable
     */
    get description() {
        return this.getStringAttribute('description');
    }
    /**
     * @stability stable
     */
    set description(value) {
        this._description = value;
    }
    /**
     * @stability stable
     */
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get mediaServicesAccountName() {
        return this.getStringAttribute('media_services_account_name');
    }
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value) {
        this._mediaServicesAccountName = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput() {
        return this._mediaServicesAccountName;
    }
    /**
     * @stability stable
     */
    get name() {
        return this.getStringAttribute('name');
    }
    /**
     * @stability stable
     */
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get nameInput() {
        return this._name;
    }
    /**
     * @stability stable
     */
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    /**
     * @stability stable
     */
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    /**
     * @stability stable
     */
    get policyOption() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('policy_option');
    }
    /**
     * @stability stable
     */
    set policyOption(value) {
        this._policyOption = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get policyOptionInput() {
        return this._policyOption;
    }
    /**
     * @stability stable
     */
    get timeouts() {
        return this._timeouts;
    }
    /**
     * @stability stable
     */
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            media_services_account_name: cdktf.stringToTerraform(this._mediaServicesAccountName),
            name: cdktf.stringToTerraform(this._name),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            policy_option: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionToTerraform)(this._policyOption),
            timeouts: mediaContentKeyPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MediaContentKeyPolicy = MediaContentKeyPolicy;
_f = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicy[_f] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicy", version: "0.3.4" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
MediaContentKeyPolicy.tfResourceType = "azurerm_media_content_key_policy";
//# sourceMappingURL=data:application/json;base64,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