import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaLiveEventConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#auto_start_enabled MediaLiveEvent#auto_start_enabled}.
     *
     * @stability stable
     */
    readonly autoStartEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#description MediaLiveEvent#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#hostname_prefix MediaLiveEvent#hostname_prefix}.
     *
     * @stability stable
     */
    readonly hostnamePrefix?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#location MediaLiveEvent#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#media_services_account_name MediaLiveEvent#media_services_account_name}.
     *
     * @stability stable
     */
    readonly mediaServicesAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#name MediaLiveEvent#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#resource_group_name MediaLiveEvent#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#tags MediaLiveEvent#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#transcription_languages MediaLiveEvent#transcription_languages}.
     *
     * @stability stable
     */
    readonly transcriptionLanguages?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#use_static_hostname MediaLiveEvent#use_static_hostname}.
     *
     * @stability stable
     */
    readonly useStaticHostname?: boolean | cdktf.IResolvable;
    /**
     * cross_site_access_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#cross_site_access_policy MediaLiveEvent#cross_site_access_policy}
     *
     * @stability stable
     */
    readonly crossSiteAccessPolicy?: MediaLiveEventCrossSiteAccessPolicy;
    /**
     * encoding block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#encoding MediaLiveEvent#encoding}
     *
     * @stability stable
     */
    readonly encoding?: MediaLiveEventEncoding;
    /**
     * input block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#input MediaLiveEvent#input}
     *
     * @stability stable
     */
    readonly input: MediaLiveEventInput;
    /**
     * preview block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#preview MediaLiveEvent#preview}
     *
     * @stability stable
     */
    readonly preview?: MediaLiveEventPreview;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#timeouts MediaLiveEvent#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaLiveEventTimeouts;
}
/**
 * @stability stable
 */
export interface MediaLiveEventCrossSiteAccessPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#client_access_policy MediaLiveEvent#client_access_policy}.
     *
     * @stability stable
     */
    readonly clientAccessPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#cross_domain_policy MediaLiveEvent#cross_domain_policy}.
     *
     * @stability stable
     */
    readonly crossDomainPolicy?: string;
}
export declare function mediaLiveEventCrossSiteAccessPolicyToTerraform(struct?: MediaLiveEventCrossSiteAccessPolicyOutputReference | MediaLiveEventCrossSiteAccessPolicy): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventCrossSiteAccessPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventCrossSiteAccessPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventCrossSiteAccessPolicy | undefined);
    private _clientAccessPolicy?;
    /**
     * @stability stable
     */
    get clientAccessPolicy(): string;
    /**
     * @stability stable
     */
    set clientAccessPolicy(value: string);
    /**
     * @stability stable
     */
    resetClientAccessPolicy(): void;
    /**
     * @stability stable
     */
    get clientAccessPolicyInput(): string | undefined;
    private _crossDomainPolicy?;
    /**
     * @stability stable
     */
    get crossDomainPolicy(): string;
    /**
     * @stability stable
     */
    set crossDomainPolicy(value: string);
    /**
     * @stability stable
     */
    resetCrossDomainPolicy(): void;
    /**
     * @stability stable
     */
    get crossDomainPolicyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaLiveEventEncoding {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#key_frame_interval MediaLiveEvent#key_frame_interval}.
     *
     * @stability stable
     */
    readonly keyFrameInterval?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#preset_name MediaLiveEvent#preset_name}.
     *
     * @stability stable
     */
    readonly presetName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#stretch_mode MediaLiveEvent#stretch_mode}.
     *
     * @stability stable
     */
    readonly stretchMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#type MediaLiveEvent#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function mediaLiveEventEncodingToTerraform(struct?: MediaLiveEventEncodingOutputReference | MediaLiveEventEncoding): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventEncodingOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventEncoding | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventEncoding | undefined);
    private _keyFrameInterval?;
    /**
     * @stability stable
     */
    get keyFrameInterval(): string;
    /**
     * @stability stable
     */
    set keyFrameInterval(value: string);
    /**
     * @stability stable
     */
    resetKeyFrameInterval(): void;
    /**
     * @stability stable
     */
    get keyFrameIntervalInput(): string | undefined;
    private _presetName?;
    /**
     * @stability stable
     */
    get presetName(): string;
    /**
     * @stability stable
     */
    set presetName(value: string);
    /**
     * @stability stable
     */
    resetPresetName(): void;
    /**
     * @stability stable
     */
    get presetNameInput(): string | undefined;
    private _stretchMode?;
    /**
     * @stability stable
     */
    get stretchMode(): string;
    /**
     * @stability stable
     */
    set stretchMode(value: string);
    /**
     * @stability stable
     */
    resetStretchMode(): void;
    /**
     * @stability stable
     */
    get stretchModeInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaLiveEventInputIpAccessControlAllow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#address MediaLiveEvent#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#name MediaLiveEvent#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#subnet_prefix_length MediaLiveEvent#subnet_prefix_length}.
     *
     * @stability stable
     */
    readonly subnetPrefixLength?: number;
}
export declare function mediaLiveEventInputIpAccessControlAllowToTerraform(struct?: MediaLiveEventInputIpAccessControlAllow): any;
/**
 * @stability stable
 */
export interface MediaLiveEventInput {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#access_token MediaLiveEvent#access_token}.
     *
     * @stability stable
     */
    readonly accessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#key_frame_interval_duration MediaLiveEvent#key_frame_interval_duration}.
     *
     * @stability stable
     */
    readonly keyFrameIntervalDuration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#streaming_protocol MediaLiveEvent#streaming_protocol}.
     *
     * @stability stable
     */
    readonly streamingProtocol?: string;
    /**
     * ip_access_control_allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#ip_access_control_allow MediaLiveEvent#ip_access_control_allow}
     *
     * @stability stable
     */
    readonly ipAccessControlAllow?: MediaLiveEventInputIpAccessControlAllow[];
}
export declare function mediaLiveEventInputToTerraform(struct?: MediaLiveEventInputOutputReference | MediaLiveEventInput): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventInputOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventInput | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventInput | undefined);
    private _accessToken?;
    /**
     * @stability stable
     */
    get accessToken(): string;
    /**
     * @stability stable
     */
    set accessToken(value: string);
    /**
     * @stability stable
     */
    resetAccessToken(): void;
    /**
     * @stability stable
     */
    get accessTokenInput(): string | undefined;
    private _keyFrameIntervalDuration?;
    /**
     * @stability stable
     */
    get keyFrameIntervalDuration(): string;
    /**
     * @stability stable
     */
    set keyFrameIntervalDuration(value: string);
    /**
     * @stability stable
     */
    resetKeyFrameIntervalDuration(): void;
    /**
     * @stability stable
     */
    get keyFrameIntervalDurationInput(): string | undefined;
    private _streamingProtocol?;
    /**
     * @stability stable
     */
    get streamingProtocol(): string;
    /**
     * @stability stable
     */
    set streamingProtocol(value: string);
    /**
     * @stability stable
     */
    resetStreamingProtocol(): void;
    /**
     * @stability stable
     */
    get streamingProtocolInput(): string | undefined;
    private _ipAccessControlAllow?;
    /**
     * @stability stable
     */
    get ipAccessControlAllow(): MediaLiveEventInputIpAccessControlAllow[];
    /**
     * @stability stable
     */
    set ipAccessControlAllow(value: MediaLiveEventInputIpAccessControlAllow[]);
    /**
     * @stability stable
     */
    resetIpAccessControlAllow(): void;
    /**
     * @stability stable
     */
    get ipAccessControlAllowInput(): MediaLiveEventInputIpAccessControlAllow[] | undefined;
}
/**
 * @stability stable
 */
export interface MediaLiveEventPreviewIpAccessControlAllow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#address MediaLiveEvent#address}.
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#name MediaLiveEvent#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#subnet_prefix_length MediaLiveEvent#subnet_prefix_length}.
     *
     * @stability stable
     */
    readonly subnetPrefixLength?: number;
}
export declare function mediaLiveEventPreviewIpAccessControlAllowToTerraform(struct?: MediaLiveEventPreviewIpAccessControlAllow): any;
/**
 * @stability stable
 */
export interface MediaLiveEventPreview {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#alternative_media_id MediaLiveEvent#alternative_media_id}.
     *
     * @stability stable
     */
    readonly alternativeMediaId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#preview_locator MediaLiveEvent#preview_locator}.
     *
     * @stability stable
     */
    readonly previewLocator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#streaming_policy_name MediaLiveEvent#streaming_policy_name}.
     *
     * @stability stable
     */
    readonly streamingPolicyName?: string;
    /**
     * ip_access_control_allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#ip_access_control_allow MediaLiveEvent#ip_access_control_allow}
     *
     * @stability stable
     */
    readonly ipAccessControlAllow?: MediaLiveEventPreviewIpAccessControlAllow[];
}
export declare function mediaLiveEventPreviewToTerraform(struct?: MediaLiveEventPreviewOutputReference | MediaLiveEventPreview): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventPreviewOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventPreview | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventPreview | undefined);
    private _alternativeMediaId?;
    /**
     * @stability stable
     */
    get alternativeMediaId(): string;
    /**
     * @stability stable
     */
    set alternativeMediaId(value: string);
    /**
     * @stability stable
     */
    resetAlternativeMediaId(): void;
    /**
     * @stability stable
     */
    get alternativeMediaIdInput(): string | undefined;
    private _previewLocator?;
    /**
     * @stability stable
     */
    get previewLocator(): string;
    /**
     * @stability stable
     */
    set previewLocator(value: string);
    /**
     * @stability stable
     */
    resetPreviewLocator(): void;
    /**
     * @stability stable
     */
    get previewLocatorInput(): string | undefined;
    private _streamingPolicyName?;
    /**
     * @stability stable
     */
    get streamingPolicyName(): string;
    /**
     * @stability stable
     */
    set streamingPolicyName(value: string);
    /**
     * @stability stable
     */
    resetStreamingPolicyName(): void;
    /**
     * @stability stable
     */
    get streamingPolicyNameInput(): string | undefined;
    private _ipAccessControlAllow?;
    /**
     * @stability stable
     */
    get ipAccessControlAllow(): MediaLiveEventPreviewIpAccessControlAllow[];
    /**
     * @stability stable
     */
    set ipAccessControlAllow(value: MediaLiveEventPreviewIpAccessControlAllow[]);
    /**
     * @stability stable
     */
    resetIpAccessControlAllow(): void;
    /**
     * @stability stable
     */
    get ipAccessControlAllowInput(): MediaLiveEventPreviewIpAccessControlAllow[] | undefined;
}
/**
 * @stability stable
 */
export interface MediaLiveEventTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#create MediaLiveEvent#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#delete MediaLiveEvent#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#read MediaLiveEvent#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html#update MediaLiveEvent#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaLiveEventTimeoutsToTerraform(struct?: MediaLiveEventTimeoutsOutputReference | MediaLiveEventTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaLiveEventTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaLiveEventTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaLiveEventTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html azurerm_media_live_event}.
 *
 * @stability stable
 */
export declare class MediaLiveEvent extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_live_event.html azurerm_media_live_event} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaLiveEventConfig);
    private _autoStartEnabled?;
    /**
     * @stability stable
     */
    get autoStartEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoStartEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoStartEnabled(): void;
    /**
     * @stability stable
     */
    get autoStartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _hostnamePrefix?;
    /**
     * @stability stable
     */
    get hostnamePrefix(): string;
    /**
     * @stability stable
     */
    set hostnamePrefix(value: string);
    /**
     * @stability stable
     */
    resetHostnamePrefix(): void;
    /**
     * @stability stable
     */
    get hostnamePrefixInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _mediaServicesAccountName?;
    /**
     * @stability stable
     */
    get mediaServicesAccountName(): string;
    /**
     * @stability stable
     */
    set mediaServicesAccountName(value: string);
    /**
     * @stability stable
     */
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _transcriptionLanguages?;
    /**
     * @stability stable
     */
    get transcriptionLanguages(): string[];
    /**
     * @stability stable
     */
    set transcriptionLanguages(value: string[]);
    /**
     * @stability stable
     */
    resetTranscriptionLanguages(): void;
    /**
     * @stability stable
     */
    get transcriptionLanguagesInput(): string[] | undefined;
    private _useStaticHostname?;
    /**
     * @stability stable
     */
    get useStaticHostname(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useStaticHostname(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseStaticHostname(): void;
    /**
     * @stability stable
     */
    get useStaticHostnameInput(): boolean | cdktf.IResolvable | undefined;
    private _crossSiteAccessPolicy;
    /**
     * @stability stable
     */
    get crossSiteAccessPolicy(): MediaLiveEventCrossSiteAccessPolicyOutputReference;
    /**
     * @stability stable
     */
    putCrossSiteAccessPolicy(value: MediaLiveEventCrossSiteAccessPolicy): void;
    /**
     * @stability stable
     */
    resetCrossSiteAccessPolicy(): void;
    /**
     * @stability stable
     */
    get crossSiteAccessPolicyInput(): MediaLiveEventCrossSiteAccessPolicy | undefined;
    private _encoding;
    /**
     * @stability stable
     */
    get encoding(): MediaLiveEventEncodingOutputReference;
    /**
     * @stability stable
     */
    putEncoding(value: MediaLiveEventEncoding): void;
    /**
     * @stability stable
     */
    resetEncoding(): void;
    /**
     * @stability stable
     */
    get encodingInput(): MediaLiveEventEncoding | undefined;
    private _input;
    /**
     * @stability stable
     */
    get input(): MediaLiveEventInputOutputReference;
    /**
     * @stability stable
     */
    putInput(value: MediaLiveEventInput): void;
    /**
     * @stability stable
     */
    get inputInput(): MediaLiveEventInput | undefined;
    private _preview;
    /**
     * @stability stable
     */
    get preview(): MediaLiveEventPreviewOutputReference;
    /**
     * @stability stable
     */
    putPreview(value: MediaLiveEventPreview): void;
    /**
     * @stability stable
     */
    resetPreview(): void;
    /**
     * @stability stable
     */
    get previewInput(): MediaLiveEventPreview | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaLiveEventTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaLiveEventTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaLiveEventTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
