import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MediaServicesAccountConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#location MediaServicesAccount#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#name MediaServicesAccount#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#resource_group_name MediaServicesAccount#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#storage_authentication_type MediaServicesAccount#storage_authentication_type}.
     *
     * @stability stable
     */
    readonly storageAuthenticationType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#tags MediaServicesAccount#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#identity MediaServicesAccount#identity}
     *
     * @stability stable
     */
    readonly identity?: MediaServicesAccountIdentity;
    /**
     * key_delivery_access_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#key_delivery_access_control MediaServicesAccount#key_delivery_access_control}
     *
     * @stability stable
     */
    readonly keyDeliveryAccessControl?: MediaServicesAccountKeyDeliveryAccessControl;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#storage_account MediaServicesAccount#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount: MediaServicesAccountStorageAccount[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#timeouts MediaServicesAccount#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MediaServicesAccountTimeouts;
}
/**
 * @stability stable
 */
export interface MediaServicesAccountIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#type MediaServicesAccount#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function mediaServicesAccountIdentityToTerraform(struct?: MediaServicesAccountIdentityOutputReference | MediaServicesAccountIdentity): any;
/**
 * @stability stable
 */
export declare class MediaServicesAccountIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaServicesAccountIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaServicesAccountIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MediaServicesAccountKeyDeliveryAccessControl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#default_action MediaServicesAccount#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#ip_allow_list MediaServicesAccount#ip_allow_list}.
     *
     * @stability stable
     */
    readonly ipAllowList?: string[];
}
export declare function mediaServicesAccountKeyDeliveryAccessControlToTerraform(struct?: MediaServicesAccountKeyDeliveryAccessControlOutputReference | MediaServicesAccountKeyDeliveryAccessControl): any;
/**
 * @stability stable
 */
export declare class MediaServicesAccountKeyDeliveryAccessControlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaServicesAccountKeyDeliveryAccessControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaServicesAccountKeyDeliveryAccessControl | undefined);
    private _defaultAction?;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    set defaultAction(value: string);
    /**
     * @stability stable
     */
    resetDefaultAction(): void;
    /**
     * @stability stable
     */
    get defaultActionInput(): string | undefined;
    private _ipAllowList?;
    /**
     * @stability stable
     */
    get ipAllowList(): string[];
    /**
     * @stability stable
     */
    set ipAllowList(value: string[]);
    /**
     * @stability stable
     */
    resetIpAllowList(): void;
    /**
     * @stability stable
     */
    get ipAllowListInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MediaServicesAccountStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#id MediaServicesAccount#id}.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#is_primary MediaServicesAccount#is_primary}.
     *
     * @stability stable
     */
    readonly isPrimary?: boolean | cdktf.IResolvable;
}
export declare function mediaServicesAccountStorageAccountToTerraform(struct?: MediaServicesAccountStorageAccount): any;
/**
 * @stability stable
 */
export interface MediaServicesAccountTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#create MediaServicesAccount#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#delete MediaServicesAccount#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#read MediaServicesAccount#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html#update MediaServicesAccount#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mediaServicesAccountTimeoutsToTerraform(struct?: MediaServicesAccountTimeoutsOutputReference | MediaServicesAccountTimeouts): any;
/**
 * @stability stable
 */
export declare class MediaServicesAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MediaServicesAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MediaServicesAccountTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html azurerm_media_services_account}.
 *
 * @stability stable
 */
export declare class MediaServicesAccount extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_services_account.html azurerm_media_services_account} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MediaServicesAccountConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAuthenticationType?;
    /**
     * @stability stable
     */
    get storageAuthenticationType(): string;
    /**
     * @stability stable
     */
    set storageAuthenticationType(value: string);
    /**
     * @stability stable
     */
    resetStorageAuthenticationType(): void;
    /**
     * @stability stable
     */
    get storageAuthenticationTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MediaServicesAccountIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MediaServicesAccountIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MediaServicesAccountIdentity | undefined;
    private _keyDeliveryAccessControl;
    /**
     * @stability stable
     */
    get keyDeliveryAccessControl(): MediaServicesAccountKeyDeliveryAccessControlOutputReference;
    /**
     * @stability stable
     */
    putKeyDeliveryAccessControl(value: MediaServicesAccountKeyDeliveryAccessControl): void;
    /**
     * @stability stable
     */
    resetKeyDeliveryAccessControl(): void;
    /**
     * @stability stable
     */
    get keyDeliveryAccessControlInput(): MediaServicesAccountKeyDeliveryAccessControl | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): MediaServicesAccountStorageAccount[];
    /**
     * @stability stable
     */
    set storageAccount(value: MediaServicesAccountStorageAccount[]);
    /**
     * @stability stable
     */
    get storageAccountInput(): MediaServicesAccountStorageAccount[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MediaServicesAccountTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MediaServicesAccountTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MediaServicesAccountTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
