import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorAadDiagnosticSettingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#eventhub_authorization_rule_id MonitorAadDiagnosticSetting#eventhub_authorization_rule_id}.
     *
     * @stability stable
     */
    readonly eventhubAuthorizationRuleId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#eventhub_name MonitorAadDiagnosticSetting#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#log_analytics_workspace_id MonitorAadDiagnosticSetting#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#name MonitorAadDiagnosticSetting#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#storage_account_id MonitorAadDiagnosticSetting#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * log block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#log MonitorAadDiagnosticSetting#log}
     *
     * @stability stable
     */
    readonly log: MonitorAadDiagnosticSettingLog[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#timeouts MonitorAadDiagnosticSetting#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorAadDiagnosticSettingTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorAadDiagnosticSettingLogRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#days MonitorAadDiagnosticSetting#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#enabled MonitorAadDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function monitorAadDiagnosticSettingLogRetentionPolicyToTerraform(struct?: MonitorAadDiagnosticSettingLogRetentionPolicyOutputReference | MonitorAadDiagnosticSettingLogRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MonitorAadDiagnosticSettingLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAadDiagnosticSettingLogRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAadDiagnosticSettingLogRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    resetDays(): void;
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface MonitorAadDiagnosticSettingLog {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#category MonitorAadDiagnosticSetting#category}.
     *
     * @stability stable
     */
    readonly category: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#enabled MonitorAadDiagnosticSetting#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#retention_policy MonitorAadDiagnosticSetting#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy: MonitorAadDiagnosticSettingLogRetentionPolicy;
}
export declare function monitorAadDiagnosticSettingLogToTerraform(struct?: MonitorAadDiagnosticSettingLog): any;
/**
 * @stability stable
 */
export interface MonitorAadDiagnosticSettingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#create MonitorAadDiagnosticSetting#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#delete MonitorAadDiagnosticSetting#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#read MonitorAadDiagnosticSetting#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html#update MonitorAadDiagnosticSetting#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorAadDiagnosticSettingTimeoutsToTerraform(struct?: MonitorAadDiagnosticSettingTimeoutsOutputReference | MonitorAadDiagnosticSettingTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorAadDiagnosticSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorAadDiagnosticSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorAadDiagnosticSettingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html azurerm_monitor_aad_diagnostic_setting}.
 *
 * @stability stable
 */
export declare class MonitorAadDiagnosticSetting extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_aad_diagnostic_setting.html azurerm_monitor_aad_diagnostic_setting} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorAadDiagnosticSettingConfig);
    private _eventhubAuthorizationRuleId?;
    /**
     * @stability stable
     */
    get eventhubAuthorizationRuleId(): string;
    /**
     * @stability stable
     */
    set eventhubAuthorizationRuleId(value: string);
    /**
     * @stability stable
     */
    resetEventhubAuthorizationRuleId(): void;
    /**
     * @stability stable
     */
    get eventhubAuthorizationRuleIdInput(): string | undefined;
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    resetEventhubName(): void;
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetLogAnalyticsWorkspaceId(): void;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _log?;
    /**
     * @stability stable
     */
    get log(): MonitorAadDiagnosticSettingLog[];
    /**
     * @stability stable
     */
    set log(value: MonitorAadDiagnosticSettingLog[]);
    /**
     * @stability stable
     */
    get logInput(): MonitorAadDiagnosticSettingLog[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorAadDiagnosticSettingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorAadDiagnosticSettingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorAadDiagnosticSettingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
