import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitorPrivateLinkScopedServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#linked_resource_id MonitorPrivateLinkScopedService#linked_resource_id}.
     *
     * @stability stable
     */
    readonly linkedResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#name MonitorPrivateLinkScopedService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#resource_group_name MonitorPrivateLinkScopedService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#scope_name MonitorPrivateLinkScopedService#scope_name}.
     *
     * @stability stable
     */
    readonly scopeName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#timeouts MonitorPrivateLinkScopedService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitorPrivateLinkScopedServiceTimeouts;
}
/**
 * @stability stable
 */
export interface MonitorPrivateLinkScopedServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#create MonitorPrivateLinkScopedService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#delete MonitorPrivateLinkScopedService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#read MonitorPrivateLinkScopedService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html#update MonitorPrivateLinkScopedService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitorPrivateLinkScopedServiceTimeoutsToTerraform(struct?: MonitorPrivateLinkScopedServiceTimeoutsOutputReference | MonitorPrivateLinkScopedServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitorPrivateLinkScopedServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitorPrivateLinkScopedServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitorPrivateLinkScopedServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html azurerm_monitor_private_link_scoped_service}.
 *
 * @stability stable
 */
export declare class MonitorPrivateLinkScopedService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_private_link_scoped_service.html azurerm_monitor_private_link_scoped_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitorPrivateLinkScopedServiceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedResourceId?;
    /**
     * @stability stable
     */
    get linkedResourceId(): string;
    /**
     * @stability stable
     */
    set linkedResourceId(value: string);
    /**
     * @stability stable
     */
    get linkedResourceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scopeName?;
    /**
     * @stability stable
     */
    get scopeName(): string;
    /**
     * @stability stable
     */
    set scopeName(value: string);
    /**
     * @stability stable
     */
    get scopeNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitorPrivateLinkScopedServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitorPrivateLinkScopedServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitorPrivateLinkScopedServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
