import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#administrator_login MssqlServer#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#administrator_login_password MssqlServer#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#connection_policy MssqlServer#connection_policy}.
     *
     * @stability stable
     */
    readonly connectionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#extended_auditing_policy MssqlServer#extended_auditing_policy}.
     *
     * @stability stable
     */
    readonly extendedAuditingPolicy?: MssqlServerExtendedAuditingPolicy[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#location MssqlServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#minimum_tls_version MssqlServer#minimum_tls_version}.
     *
     * @stability stable
     */
    readonly minimumTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#name MssqlServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#primary_user_assigned_identity_id MssqlServer#primary_user_assigned_identity_id}.
     *
     * @stability stable
     */
    readonly primaryUserAssignedIdentityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#public_network_access_enabled MssqlServer#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#resource_group_name MssqlServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#tags MssqlServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#version MssqlServer#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * azuread_administrator block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#azuread_administrator MssqlServer#azuread_administrator}
     *
     * @stability stable
     */
    readonly azureadAdministrator?: MssqlServerAzureadAdministrator;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#identity MssqlServer#identity}
     *
     * @stability stable
     */
    readonly identity?: MssqlServerIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#timeouts MssqlServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlServerTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlServerExtendedAuditingPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#log_monitoring_enabled MssqlServer#log_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#retention_in_days MssqlServer#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#storage_account_access_key MssqlServer#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#storage_account_access_key_is_secondary MssqlServer#storage_account_access_key_is_secondary}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#storage_endpoint MssqlServer#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
}
export declare function mssqlServerExtendedAuditingPolicyToTerraform(struct?: MssqlServerExtendedAuditingPolicy): any;
/**
 * @stability stable
 */
export interface MssqlServerAzureadAdministrator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#azuread_authentication_only MssqlServer#azuread_authentication_only}.
     *
     * @stability stable
     */
    readonly azureadAuthenticationOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#login_username MssqlServer#login_username}.
     *
     * @stability stable
     */
    readonly loginUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#object_id MssqlServer#object_id}.
     *
     * @stability stable
     */
    readonly objectId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#tenant_id MssqlServer#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function mssqlServerAzureadAdministratorToTerraform(struct?: MssqlServerAzureadAdministratorOutputReference | MssqlServerAzureadAdministrator): any;
/**
 * @stability stable
 */
export declare class MssqlServerAzureadAdministratorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlServerAzureadAdministrator | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlServerAzureadAdministrator | undefined);
    private _azureadAuthenticationOnly?;
    /**
     * @stability stable
     */
    get azureadAuthenticationOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set azureadAuthenticationOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAzureadAuthenticationOnly(): void;
    /**
     * @stability stable
     */
    get azureadAuthenticationOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _loginUsername?;
    /**
     * @stability stable
     */
    get loginUsername(): string;
    /**
     * @stability stable
     */
    set loginUsername(value: string);
    /**
     * @stability stable
     */
    get loginUsernameInput(): string | undefined;
    private _objectId?;
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    set objectId(value: string);
    /**
     * @stability stable
     */
    get objectIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlServerIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#type MssqlServer#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#user_assigned_identity_ids MssqlServer#user_assigned_identity_ids}.
     *
     * @stability stable
     */
    readonly userAssignedIdentityIds?: string[];
}
export declare function mssqlServerIdentityToTerraform(struct?: MssqlServerIdentityOutputReference | MssqlServerIdentity): any;
/**
 * @stability stable
 */
export declare class MssqlServerIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlServerIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlServerIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userAssignedIdentityIds?;
    /**
     * @stability stable
     */
    get userAssignedIdentityIds(): string[];
    /**
     * @stability stable
     */
    set userAssignedIdentityIds(value: string[]);
    /**
     * @stability stable
     */
    resetUserAssignedIdentityIds(): void;
    /**
     * @stability stable
     */
    get userAssignedIdentityIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface MssqlServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#create MssqlServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#delete MssqlServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#read MssqlServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html#update MssqlServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlServerTimeoutsToTerraform(struct?: MssqlServerTimeoutsOutputReference | MssqlServerTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html azurerm_mssql_server}.
 *
 * @stability stable
 */
export declare class MssqlServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_server.html azurerm_mssql_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlServerConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _connectionPolicy?;
    /**
     * @stability stable
     */
    get connectionPolicy(): string;
    /**
     * @stability stable
     */
    set connectionPolicy(value: string);
    /**
     * @stability stable
     */
    resetConnectionPolicy(): void;
    /**
     * @stability stable
     */
    get connectionPolicyInput(): string | undefined;
    private _extendedAuditingPolicy?;
    /**
     * @stability stable
     */
    get extendedAuditingPolicy(): MssqlServerExtendedAuditingPolicy[];
    /**
     * @stability stable
     */
    set extendedAuditingPolicy(value: MssqlServerExtendedAuditingPolicy[]);
    /**
     * @stability stable
     */
    resetExtendedAuditingPolicy(): void;
    /**
     * @stability stable
     */
    get extendedAuditingPolicyInput(): MssqlServerExtendedAuditingPolicy[] | undefined;
    /**
     * @stability stable
     */
    get fullyQualifiedDomainName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _minimumTlsVersion?;
    /**
     * @stability stable
     */
    get minimumTlsVersion(): string;
    /**
     * @stability stable
     */
    set minimumTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinimumTlsVersion(): void;
    /**
     * @stability stable
     */
    get minimumTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _primaryUserAssignedIdentityId?;
    /**
     * @stability stable
     */
    get primaryUserAssignedIdentityId(): string;
    /**
     * @stability stable
     */
    set primaryUserAssignedIdentityId(value: string);
    /**
     * @stability stable
     */
    resetPrimaryUserAssignedIdentityId(): void;
    /**
     * @stability stable
     */
    get primaryUserAssignedIdentityIdInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get restorableDroppedDatabaseIds(): string[];
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _azureadAdministrator;
    /**
     * @stability stable
     */
    get azureadAdministrator(): MssqlServerAzureadAdministratorOutputReference;
    /**
     * @stability stable
     */
    putAzureadAdministrator(value: MssqlServerAzureadAdministrator): void;
    /**
     * @stability stable
     */
    resetAzureadAdministrator(): void;
    /**
     * @stability stable
     */
    get azureadAdministratorInput(): MssqlServerAzureadAdministrator | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MssqlServerIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MssqlServerIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MssqlServerIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
