import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkInterfaceApplicationSecurityGroupAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#application_security_group_id NetworkInterfaceApplicationSecurityGroupAssociation#application_security_group_id}.
     *
     * @stability stable
     */
    readonly applicationSecurityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#network_interface_id NetworkInterfaceApplicationSecurityGroupAssociation#network_interface_id}.
     *
     * @stability stable
     */
    readonly networkInterfaceId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#timeouts NetworkInterfaceApplicationSecurityGroupAssociation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkInterfaceApplicationSecurityGroupAssociationTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkInterfaceApplicationSecurityGroupAssociationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#create NetworkInterfaceApplicationSecurityGroupAssociation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#delete NetworkInterfaceApplicationSecurityGroupAssociation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#read NetworkInterfaceApplicationSecurityGroupAssociation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html#update NetworkInterfaceApplicationSecurityGroupAssociation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkInterfaceApplicationSecurityGroupAssociationTimeoutsToTerraform(struct?: NetworkInterfaceApplicationSecurityGroupAssociationTimeoutsOutputReference | NetworkInterfaceApplicationSecurityGroupAssociationTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkInterfaceApplicationSecurityGroupAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkInterfaceApplicationSecurityGroupAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkInterfaceApplicationSecurityGroupAssociationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html azurerm_network_interface_application_security_group_association}.
 *
 * @stability stable
 */
export declare class NetworkInterfaceApplicationSecurityGroupAssociation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface_application_security_group_association.html azurerm_network_interface_application_security_group_association} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkInterfaceApplicationSecurityGroupAssociationConfig);
    private _applicationSecurityGroupId?;
    /**
     * @stability stable
     */
    get applicationSecurityGroupId(): string;
    /**
     * @stability stable
     */
    set applicationSecurityGroupId(value: string);
    /**
     * @stability stable
     */
    get applicationSecurityGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _networkInterfaceId?;
    /**
     * @stability stable
     */
    get networkInterfaceId(): string;
    /**
     * @stability stable
     */
    set networkInterfaceId(value: string);
    /**
     * @stability stable
     */
    get networkInterfaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkInterfaceApplicationSecurityGroupAssociationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkInterfaceApplicationSecurityGroupAssociationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkInterfaceApplicationSecurityGroupAssociationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
