import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkWatcherFlowLogConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#enabled NetworkWatcherFlowLog#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#location NetworkWatcherFlowLog#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#network_security_group_id NetworkWatcherFlowLog#network_security_group_id}.
     *
     * @stability stable
     */
    readonly networkSecurityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#network_watcher_name NetworkWatcherFlowLog#network_watcher_name}.
     *
     * @stability stable
     */
    readonly networkWatcherName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#resource_group_name NetworkWatcherFlowLog#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#storage_account_id NetworkWatcherFlowLog#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#tags NetworkWatcherFlowLog#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#version NetworkWatcherFlowLog#version}.
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#retention_policy NetworkWatcherFlowLog#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy: NetworkWatcherFlowLogRetentionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#timeouts NetworkWatcherFlowLog#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkWatcherFlowLogTimeouts;
    /**
     * traffic_analytics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#traffic_analytics NetworkWatcherFlowLog#traffic_analytics}
     *
     * @stability stable
     */
    readonly trafficAnalytics?: NetworkWatcherFlowLogTrafficAnalytics;
}
/**
 * @stability stable
 */
export interface NetworkWatcherFlowLogRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#days NetworkWatcherFlowLog#days}.
     *
     * @stability stable
     */
    readonly days: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#enabled NetworkWatcherFlowLog#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function networkWatcherFlowLogRetentionPolicyToTerraform(struct?: NetworkWatcherFlowLogRetentionPolicyOutputReference | NetworkWatcherFlowLogRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class NetworkWatcherFlowLogRetentionPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkWatcherFlowLogRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkWatcherFlowLogRetentionPolicy | undefined);
    private _days?;
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    set days(value: number);
    /**
     * @stability stable
     */
    get daysInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface NetworkWatcherFlowLogTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#create NetworkWatcherFlowLog#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#delete NetworkWatcherFlowLog#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#read NetworkWatcherFlowLog#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#update NetworkWatcherFlowLog#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkWatcherFlowLogTimeoutsToTerraform(struct?: NetworkWatcherFlowLogTimeoutsOutputReference | NetworkWatcherFlowLogTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkWatcherFlowLogTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkWatcherFlowLogTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkWatcherFlowLogTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface NetworkWatcherFlowLogTrafficAnalytics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#enabled NetworkWatcherFlowLog#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#interval_in_minutes NetworkWatcherFlowLog#interval_in_minutes}.
     *
     * @stability stable
     */
    readonly intervalInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#workspace_id NetworkWatcherFlowLog#workspace_id}.
     *
     * @stability stable
     */
    readonly workspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#workspace_region NetworkWatcherFlowLog#workspace_region}.
     *
     * @stability stable
     */
    readonly workspaceRegion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html#workspace_resource_id NetworkWatcherFlowLog#workspace_resource_id}.
     *
     * @stability stable
     */
    readonly workspaceResourceId: string;
}
export declare function networkWatcherFlowLogTrafficAnalyticsToTerraform(struct?: NetworkWatcherFlowLogTrafficAnalyticsOutputReference | NetworkWatcherFlowLogTrafficAnalytics): any;
/**
 * @stability stable
 */
export declare class NetworkWatcherFlowLogTrafficAnalyticsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkWatcherFlowLogTrafficAnalytics | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkWatcherFlowLogTrafficAnalytics | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _intervalInMinutes?;
    /**
     * @stability stable
     */
    get intervalInMinutes(): number;
    /**
     * @stability stable
     */
    set intervalInMinutes(value: number);
    /**
     * @stability stable
     */
    resetIntervalInMinutes(): void;
    /**
     * @stability stable
     */
    get intervalInMinutesInput(): number | undefined;
    private _workspaceId?;
    /**
     * @stability stable
     */
    get workspaceId(): string;
    /**
     * @stability stable
     */
    set workspaceId(value: string);
    /**
     * @stability stable
     */
    get workspaceIdInput(): string | undefined;
    private _workspaceRegion?;
    /**
     * @stability stable
     */
    get workspaceRegion(): string;
    /**
     * @stability stable
     */
    set workspaceRegion(value: string);
    /**
     * @stability stable
     */
    get workspaceRegionInput(): string | undefined;
    private _workspaceResourceId?;
    /**
     * @stability stable
     */
    get workspaceResourceId(): string;
    /**
     * @stability stable
     */
    set workspaceResourceId(value: string);
    /**
     * @stability stable
     */
    get workspaceResourceIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html azurerm_network_watcher_flow_log}.
 *
 * @stability stable
 */
export declare class NetworkWatcherFlowLog extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_watcher_flow_log.html azurerm_network_watcher_flow_log} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkWatcherFlowLogConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _networkSecurityGroupId?;
    /**
     * @stability stable
     */
    get networkSecurityGroupId(): string;
    /**
     * @stability stable
     */
    set networkSecurityGroupId(value: string);
    /**
     * @stability stable
     */
    get networkSecurityGroupIdInput(): string | undefined;
    private _networkWatcherName?;
    /**
     * @stability stable
     */
    get networkWatcherName(): string;
    /**
     * @stability stable
     */
    set networkWatcherName(value: string);
    /**
     * @stability stable
     */
    get networkWatcherNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _retentionPolicy;
    /**
     * @stability stable
     */
    get retentionPolicy(): NetworkWatcherFlowLogRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetentionPolicy(value: NetworkWatcherFlowLogRetentionPolicy): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): NetworkWatcherFlowLogRetentionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkWatcherFlowLogTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkWatcherFlowLogTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkWatcherFlowLogTimeouts | undefined;
    private _trafficAnalytics;
    /**
     * @stability stable
     */
    get trafficAnalytics(): NetworkWatcherFlowLogTrafficAnalyticsOutputReference;
    /**
     * @stability stable
     */
    putTrafficAnalytics(value: NetworkWatcherFlowLogTrafficAnalytics): void;
    /**
     * @stability stable
     */
    resetTrafficAnalytics(): void;
    /**
     * @stability stable
     */
    get trafficAnalyticsInput(): NetworkWatcherFlowLogTrafficAnalytics | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
