import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#dns_servers PointToSiteVpnGateway#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#location PointToSiteVpnGateway#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#name PointToSiteVpnGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#resource_group_name PointToSiteVpnGateway#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#scale_unit PointToSiteVpnGateway#scale_unit}.
     *
     * @stability stable
     */
    readonly scaleUnit: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#tags PointToSiteVpnGateway#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#virtual_hub_id PointToSiteVpnGateway#virtual_hub_id}.
     *
     * @stability stable
     */
    readonly virtualHubId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#vpn_server_configuration_id PointToSiteVpnGateway#vpn_server_configuration_id}.
     *
     * @stability stable
     */
    readonly vpnServerConfigurationId: string;
    /**
     * connection_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#connection_configuration PointToSiteVpnGateway#connection_configuration}
     *
     * @stability stable
     */
    readonly connectionConfiguration: PointToSiteVpnGatewayConnectionConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#timeouts PointToSiteVpnGateway#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PointToSiteVpnGatewayTimeouts;
}
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#ids PointToSiteVpnGateway#ids}.
     *
     * @stability stable
     */
    readonly ids: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#labels PointToSiteVpnGateway#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
}
export declare function pointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable): any;
/**
 * @stability stable
 */
export declare class PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined);
    private _ids?;
    /**
     * @stability stable
     */
    get ids(): string[];
    /**
     * @stability stable
     */
    set ids(value: string[]);
    /**
     * @stability stable
     */
    get idsInput(): string[] | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    set labels(value: string[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayConnectionConfigurationRoute {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#associated_route_table_id PointToSiteVpnGateway#associated_route_table_id}.
     *
     * @stability stable
     */
    readonly associatedRouteTableId: string;
    /**
     * propagated_route_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#propagated_route_table PointToSiteVpnGateway#propagated_route_table}
     *
     * @stability stable
     */
    readonly propagatedRouteTable?: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable;
}
export declare function pointToSiteVpnGatewayConnectionConfigurationRouteToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference | PointToSiteVpnGatewayConnectionConfigurationRoute): any;
/**
 * @stability stable
 */
export declare class PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationRoute | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationRoute | undefined);
    private _associatedRouteTableId?;
    /**
     * @stability stable
     */
    get associatedRouteTableId(): string;
    /**
     * @stability stable
     */
    set associatedRouteTableId(value: string);
    /**
     * @stability stable
     */
    get associatedRouteTableIdInput(): string | undefined;
    private _propagatedRouteTable;
    /**
     * @stability stable
     */
    get propagatedRouteTable(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTableOutputReference;
    /**
     * @stability stable
     */
    putPropagatedRouteTable(value: PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable): void;
    /**
     * @stability stable
     */
    resetPropagatedRouteTable(): void;
    /**
     * @stability stable
     */
    get propagatedRouteTableInput(): PointToSiteVpnGatewayConnectionConfigurationRoutePropagatedRouteTable | undefined;
}
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#address_prefixes PointToSiteVpnGateway#address_prefixes}.
     *
     * @stability stable
     */
    readonly addressPrefixes: string[];
}
export declare function pointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference | PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool): any;
/**
 * @stability stable
 */
export declare class PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined);
    private _addressPrefixes?;
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
    /**
     * @stability stable
     */
    set addressPrefixes(value: string[]);
    /**
     * @stability stable
     */
    get addressPrefixesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayConnectionConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#name PointToSiteVpnGateway#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * route block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#route PointToSiteVpnGateway#route}
     *
     * @stability stable
     */
    readonly route?: PointToSiteVpnGatewayConnectionConfigurationRoute;
    /**
     * vpn_client_address_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#vpn_client_address_pool PointToSiteVpnGateway#vpn_client_address_pool}
     *
     * @stability stable
     */
    readonly vpnClientAddressPool: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool;
}
export declare function pointToSiteVpnGatewayConnectionConfigurationToTerraform(struct?: PointToSiteVpnGatewayConnectionConfigurationOutputReference | PointToSiteVpnGatewayConnectionConfiguration): any;
/**
 * @stability stable
 */
export declare class PointToSiteVpnGatewayConnectionConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PointToSiteVpnGatewayConnectionConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PointToSiteVpnGatewayConnectionConfiguration | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _route;
    /**
     * @stability stable
     */
    get route(): PointToSiteVpnGatewayConnectionConfigurationRouteOutputReference;
    /**
     * @stability stable
     */
    putRoute(value: PointToSiteVpnGatewayConnectionConfigurationRoute): void;
    /**
     * @stability stable
     */
    resetRoute(): void;
    /**
     * @stability stable
     */
    get routeInput(): PointToSiteVpnGatewayConnectionConfigurationRoute | undefined;
    private _vpnClientAddressPool;
    /**
     * @stability stable
     */
    get vpnClientAddressPool(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPoolOutputReference;
    /**
     * @stability stable
     */
    putVpnClientAddressPool(value: PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool): void;
    /**
     * @stability stable
     */
    get vpnClientAddressPoolInput(): PointToSiteVpnGatewayConnectionConfigurationVpnClientAddressPool | undefined;
}
/**
 * @stability stable
 */
export interface PointToSiteVpnGatewayTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#create PointToSiteVpnGateway#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#delete PointToSiteVpnGateway#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#read PointToSiteVpnGateway#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html#update PointToSiteVpnGateway#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function pointToSiteVpnGatewayTimeoutsToTerraform(struct?: PointToSiteVpnGatewayTimeoutsOutputReference | PointToSiteVpnGatewayTimeouts): any;
/**
 * @stability stable
 */
export declare class PointToSiteVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PointToSiteVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PointToSiteVpnGatewayTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html azurerm_point_to_site_vpn_gateway}.
 *
 * @stability stable
 */
export declare class PointToSiteVpnGateway extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/point_to_site_vpn_gateway.html azurerm_point_to_site_vpn_gateway} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PointToSiteVpnGatewayConfig);
    private _dnsServers?;
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    set dnsServers(value: string[]);
    /**
     * @stability stable
     */
    resetDnsServers(): void;
    /**
     * @stability stable
     */
    get dnsServersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scaleUnit?;
    /**
     * @stability stable
     */
    get scaleUnit(): number;
    /**
     * @stability stable
     */
    set scaleUnit(value: number);
    /**
     * @stability stable
     */
    get scaleUnitInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _virtualHubId?;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
    /**
     * @stability stable
     */
    set virtualHubId(value: string);
    /**
     * @stability stable
     */
    get virtualHubIdInput(): string | undefined;
    private _vpnServerConfigurationId?;
    /**
     * @stability stable
     */
    get vpnServerConfigurationId(): string;
    /**
     * @stability stable
     */
    set vpnServerConfigurationId(value: string);
    /**
     * @stability stable
     */
    get vpnServerConfigurationIdInput(): string | undefined;
    private _connectionConfiguration;
    /**
     * @stability stable
     */
    get connectionConfiguration(): PointToSiteVpnGatewayConnectionConfigurationOutputReference;
    /**
     * @stability stable
     */
    putConnectionConfiguration(value: PointToSiteVpnGatewayConnectionConfiguration): void;
    /**
     * @stability stable
     */
    get connectionConfigurationInput(): PointToSiteVpnGatewayConnectionConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PointToSiteVpnGatewayTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PointToSiteVpnGatewayTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PointToSiteVpnGatewayTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
