import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PostgresqlVirtualNetworkRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#ignore_missing_vnet_service_endpoint PostgresqlVirtualNetworkRule#ignore_missing_vnet_service_endpoint}.
     *
     * @stability stable
     */
    readonly ignoreMissingVnetServiceEndpoint?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#name PostgresqlVirtualNetworkRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#resource_group_name PostgresqlVirtualNetworkRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#server_name PostgresqlVirtualNetworkRule#server_name}.
     *
     * @stability stable
     */
    readonly serverName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#subnet_id PostgresqlVirtualNetworkRule#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#timeouts PostgresqlVirtualNetworkRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PostgresqlVirtualNetworkRuleTimeouts;
}
/**
 * @stability stable
 */
export interface PostgresqlVirtualNetworkRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#create PostgresqlVirtualNetworkRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#delete PostgresqlVirtualNetworkRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#read PostgresqlVirtualNetworkRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html#update PostgresqlVirtualNetworkRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function postgresqlVirtualNetworkRuleTimeoutsToTerraform(struct?: PostgresqlVirtualNetworkRuleTimeoutsOutputReference | PostgresqlVirtualNetworkRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class PostgresqlVirtualNetworkRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PostgresqlVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PostgresqlVirtualNetworkRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html azurerm_postgresql_virtual_network_rule}.
 *
 * @stability stable
 */
export declare class PostgresqlVirtualNetworkRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_virtual_network_rule.html azurerm_postgresql_virtual_network_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PostgresqlVirtualNetworkRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoreMissingVnetServiceEndpoint?;
    /**
     * @stability stable
     */
    get ignoreMissingVnetServiceEndpoint(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ignoreMissingVnetServiceEndpoint(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIgnoreMissingVnetServiceEndpoint(): void;
    /**
     * @stability stable
     */
    get ignoreMissingVnetServiceEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    /**
     * @stability stable
     */
    get serverName(): string;
    /**
     * @stability stable
     */
    set serverName(value: string);
    /**
     * @stability stable
     */
    get serverNameInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PostgresqlVirtualNetworkRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PostgresqlVirtualNetworkRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PostgresqlVirtualNetworkRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
