import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivateDnsZoneVirtualNetworkLinkConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#name PrivateDnsZoneVirtualNetworkLink#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#private_dns_zone_name PrivateDnsZoneVirtualNetworkLink#private_dns_zone_name}.
     *
     * @stability stable
     */
    readonly privateDnsZoneName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#registration_enabled PrivateDnsZoneVirtualNetworkLink#registration_enabled}.
     *
     * @stability stable
     */
    readonly registrationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#resource_group_name PrivateDnsZoneVirtualNetworkLink#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#tags PrivateDnsZoneVirtualNetworkLink#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#virtual_network_id PrivateDnsZoneVirtualNetworkLink#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#timeouts PrivateDnsZoneVirtualNetworkLink#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivateDnsZoneVirtualNetworkLinkTimeouts;
}
/**
 * @stability stable
 */
export interface PrivateDnsZoneVirtualNetworkLinkTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#create PrivateDnsZoneVirtualNetworkLink#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#delete PrivateDnsZoneVirtualNetworkLink#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#read PrivateDnsZoneVirtualNetworkLink#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html#update PrivateDnsZoneVirtualNetworkLink#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function privateDnsZoneVirtualNetworkLinkTimeoutsToTerraform(struct?: PrivateDnsZoneVirtualNetworkLinkTimeoutsOutputReference | PrivateDnsZoneVirtualNetworkLinkTimeouts): any;
/**
 * @stability stable
 */
export declare class PrivateDnsZoneVirtualNetworkLinkTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PrivateDnsZoneVirtualNetworkLinkTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PrivateDnsZoneVirtualNetworkLinkTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html azurerm_private_dns_zone_virtual_network_link}.
 *
 * @stability stable
 */
export declare class PrivateDnsZoneVirtualNetworkLink extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/private_dns_zone_virtual_network_link.html azurerm_private_dns_zone_virtual_network_link} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivateDnsZoneVirtualNetworkLinkConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateDnsZoneName?;
    /**
     * @stability stable
     */
    get privateDnsZoneName(): string;
    /**
     * @stability stable
     */
    set privateDnsZoneName(value: string);
    /**
     * @stability stable
     */
    get privateDnsZoneNameInput(): string | undefined;
    private _registrationEnabled?;
    /**
     * @stability stable
     */
    get registrationEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set registrationEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRegistrationEnabled(): void;
    /**
     * @stability stable
     */
    get registrationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PrivateDnsZoneVirtualNetworkLinkTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivateDnsZoneVirtualNetworkLinkTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivateDnsZoneVirtualNetworkLinkTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
