import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#assignable_scopes RoleDefinition#assignable_scopes}.
     *
     * @stability stable
     */
    readonly assignableScopes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#description RoleDefinition#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#name RoleDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#role_definition_id RoleDefinition#role_definition_id}.
     *
     * @stability stable
     */
    readonly roleDefinitionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#scope RoleDefinition#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * permissions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#permissions RoleDefinition#permissions}
     *
     * @stability stable
     */
    readonly permissions?: RoleDefinitionPermissions[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#timeouts RoleDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RoleDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface RoleDefinitionPermissions {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#actions RoleDefinition#actions}.
     *
     * @stability stable
     */
    readonly actions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#data_actions RoleDefinition#data_actions}.
     *
     * @stability stable
     */
    readonly dataActions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#not_actions RoleDefinition#not_actions}.
     *
     * @stability stable
     */
    readonly notActions?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#not_data_actions RoleDefinition#not_data_actions}.
     *
     * @stability stable
     */
    readonly notDataActions?: string[];
}
export declare function roleDefinitionPermissionsToTerraform(struct?: RoleDefinitionPermissions): any;
/**
 * @stability stable
 */
export interface RoleDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#create RoleDefinition#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#delete RoleDefinition#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#read RoleDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html#update RoleDefinition#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function roleDefinitionTimeoutsToTerraform(struct?: RoleDefinitionTimeoutsOutputReference | RoleDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class RoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RoleDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RoleDefinitionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html azurerm_role_definition}.
 *
 * @stability stable
 */
export declare class RoleDefinition extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/role_definition.html azurerm_role_definition} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RoleDefinitionConfig);
    private _assignableScopes?;
    /**
     * @stability stable
     */
    get assignableScopes(): string[];
    /**
     * @stability stable
     */
    set assignableScopes(value: string[]);
    /**
     * @stability stable
     */
    resetAssignableScopes(): void;
    /**
     * @stability stable
     */
    get assignableScopesInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _roleDefinitionId?;
    /**
     * @stability stable
     */
    get roleDefinitionId(): string;
    /**
     * @stability stable
     */
    set roleDefinitionId(value: string);
    /**
     * @stability stable
     */
    resetRoleDefinitionId(): void;
    /**
     * @stability stable
     */
    get roleDefinitionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get roleDefinitionResourceId(): string;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    private _permissions?;
    /**
     * @stability stable
     */
    get permissions(): RoleDefinitionPermissions[];
    /**
     * @stability stable
     */
    set permissions(value: RoleDefinitionPermissions[]);
    /**
     * @stability stable
     */
    resetPermissions(): void;
    /**
     * @stability stable
     */
    get permissionsInput(): RoleDefinitionPermissions[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RoleDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RoleDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RoleDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
