import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterAutomationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#description SecurityCenterAutomation#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#enabled SecurityCenterAutomation#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#location SecurityCenterAutomation#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#name SecurityCenterAutomation#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#resource_group_name SecurityCenterAutomation#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#scopes SecurityCenterAutomation#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#tags SecurityCenterAutomation#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#action SecurityCenterAutomation#action}
     *
     * @stability stable
     */
    readonly action: SecurityCenterAutomationAction[];
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#source SecurityCenterAutomation#source}
     *
     * @stability stable
     */
    readonly source: SecurityCenterAutomationSource[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#timeouts SecurityCenterAutomation#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterAutomationTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterAutomationAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#connection_string SecurityCenterAutomation#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#resource_id SecurityCenterAutomation#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#trigger_url SecurityCenterAutomation#trigger_url}.
     *
     * @stability stable
     */
    readonly triggerUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#type SecurityCenterAutomation#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function securityCenterAutomationActionToTerraform(struct?: SecurityCenterAutomationAction): any;
/**
 * @stability stable
 */
export interface SecurityCenterAutomationSourceRuleSetRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#expected_value SecurityCenterAutomation#expected_value}.
     *
     * @stability stable
     */
    readonly expectedValue: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#operator SecurityCenterAutomation#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#property_path SecurityCenterAutomation#property_path}.
     *
     * @stability stable
     */
    readonly propertyPath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#property_type SecurityCenterAutomation#property_type}.
     *
     * @stability stable
     */
    readonly propertyType: string;
}
export declare function securityCenterAutomationSourceRuleSetRuleToTerraform(struct?: SecurityCenterAutomationSourceRuleSetRule): any;
/**
 * @stability stable
 */
export interface SecurityCenterAutomationSourceRuleSet {
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#rule SecurityCenterAutomation#rule}
     *
     * @stability stable
     */
    readonly rule: SecurityCenterAutomationSourceRuleSetRule[];
}
export declare function securityCenterAutomationSourceRuleSetToTerraform(struct?: SecurityCenterAutomationSourceRuleSet): any;
/**
 * @stability stable
 */
export interface SecurityCenterAutomationSource {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#event_source SecurityCenterAutomation#event_source}.
     *
     * @stability stable
     */
    readonly eventSource: string;
    /**
     * rule_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#rule_set SecurityCenterAutomation#rule_set}
     *
     * @stability stable
     */
    readonly ruleSet?: SecurityCenterAutomationSourceRuleSet[];
}
export declare function securityCenterAutomationSourceToTerraform(struct?: SecurityCenterAutomationSource): any;
/**
 * @stability stable
 */
export interface SecurityCenterAutomationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#create SecurityCenterAutomation#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#delete SecurityCenterAutomation#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#read SecurityCenterAutomation#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html#update SecurityCenterAutomation#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function securityCenterAutomationTimeoutsToTerraform(struct?: SecurityCenterAutomationTimeoutsOutputReference | SecurityCenterAutomationTimeouts): any;
/**
 * @stability stable
 */
export declare class SecurityCenterAutomationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterAutomationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterAutomationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html azurerm_security_center_automation}.
 *
 * @stability stable
 */
export declare class SecurityCenterAutomation extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_automation.html azurerm_security_center_automation} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityCenterAutomationConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _action?;
    /**
     * @stability stable
     */
    get action(): SecurityCenterAutomationAction[];
    /**
     * @stability stable
     */
    set action(value: SecurityCenterAutomationAction[]);
    /**
     * @stability stable
     */
    get actionInput(): SecurityCenterAutomationAction[] | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): SecurityCenterAutomationSource[];
    /**
     * @stability stable
     */
    set source(value: SecurityCenterAutomationSource[]);
    /**
     * @stability stable
     */
    get sourceInput(): SecurityCenterAutomationSource[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterAutomationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterAutomationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterAutomationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
