import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SentinelAlertRuleMsSecurityIncidentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#alert_rule_template_guid SentinelAlertRuleMsSecurityIncident#alert_rule_template_guid}.
     *
     * @stability stable
     */
    readonly alertRuleTemplateGuid?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#description SentinelAlertRuleMsSecurityIncident#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#display_name SentinelAlertRuleMsSecurityIncident#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#display_name_exclude_filter SentinelAlertRuleMsSecurityIncident#display_name_exclude_filter}.
     *
     * @stability stable
     */
    readonly displayNameExcludeFilter?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#display_name_filter SentinelAlertRuleMsSecurityIncident#display_name_filter}.
     *
     * @stability stable
     */
    readonly displayNameFilter?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#enabled SentinelAlertRuleMsSecurityIncident#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#log_analytics_workspace_id SentinelAlertRuleMsSecurityIncident#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#name SentinelAlertRuleMsSecurityIncident#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#product_filter SentinelAlertRuleMsSecurityIncident#product_filter}.
     *
     * @stability stable
     */
    readonly productFilter: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#severity_filter SentinelAlertRuleMsSecurityIncident#severity_filter}.
     *
     * @stability stable
     */
    readonly severityFilter: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#text_whitelist SentinelAlertRuleMsSecurityIncident#text_whitelist}.
     *
     * @stability stable
     */
    readonly textWhitelist?: string[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#timeouts SentinelAlertRuleMsSecurityIncident#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SentinelAlertRuleMsSecurityIncidentTimeouts;
}
/**
 * @stability stable
 */
export interface SentinelAlertRuleMsSecurityIncidentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#create SentinelAlertRuleMsSecurityIncident#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#delete SentinelAlertRuleMsSecurityIncident#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#read SentinelAlertRuleMsSecurityIncident#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html#update SentinelAlertRuleMsSecurityIncident#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sentinelAlertRuleMsSecurityIncidentTimeoutsToTerraform(struct?: SentinelAlertRuleMsSecurityIncidentTimeoutsOutputReference | SentinelAlertRuleMsSecurityIncidentTimeouts): any;
/**
 * @stability stable
 */
export declare class SentinelAlertRuleMsSecurityIncidentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAlertRuleMsSecurityIncidentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAlertRuleMsSecurityIncidentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html azurerm_sentinel_alert_rule_ms_security_incident}.
 *
 * @stability stable
 */
export declare class SentinelAlertRuleMsSecurityIncident extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_alert_rule_ms_security_incident.html azurerm_sentinel_alert_rule_ms_security_incident} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SentinelAlertRuleMsSecurityIncidentConfig);
    private _alertRuleTemplateGuid?;
    /**
     * @stability stable
     */
    get alertRuleTemplateGuid(): string;
    /**
     * @stability stable
     */
    set alertRuleTemplateGuid(value: string);
    /**
     * @stability stable
     */
    resetAlertRuleTemplateGuid(): void;
    /**
     * @stability stable
     */
    get alertRuleTemplateGuidInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _displayNameExcludeFilter?;
    /**
     * @stability stable
     */
    get displayNameExcludeFilter(): string[];
    /**
     * @stability stable
     */
    set displayNameExcludeFilter(value: string[]);
    /**
     * @stability stable
     */
    resetDisplayNameExcludeFilter(): void;
    /**
     * @stability stable
     */
    get displayNameExcludeFilterInput(): string[] | undefined;
    private _displayNameFilter?;
    /**
     * @stability stable
     */
    get displayNameFilter(): string[];
    /**
     * @stability stable
     */
    set displayNameFilter(value: string[]);
    /**
     * @stability stable
     */
    resetDisplayNameFilter(): void;
    /**
     * @stability stable
     */
    get displayNameFilterInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _productFilter?;
    /**
     * @stability stable
     */
    get productFilter(): string;
    /**
     * @stability stable
     */
    set productFilter(value: string);
    /**
     * @stability stable
     */
    get productFilterInput(): string | undefined;
    private _severityFilter?;
    /**
     * @stability stable
     */
    get severityFilter(): string[];
    /**
     * @stability stable
     */
    set severityFilter(value: string[]);
    /**
     * @stability stable
     */
    get severityFilterInput(): string[] | undefined;
    private _textWhitelist?;
    /**
     * @stability stable
     */
    get textWhitelist(): string[];
    /**
     * @stability stable
     */
    set textWhitelist(value: string[]);
    /**
     * @stability stable
     */
    resetTextWhitelist(): void;
    /**
     * @stability stable
     */
    get textWhitelistInput(): string[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SentinelAlertRuleMsSecurityIncidentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SentinelAlertRuleMsSecurityIncidentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SentinelAlertRuleMsSecurityIncidentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
