import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SentinelAutomationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#display_name SentinelAutomationRule#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#enabled SentinelAutomationRule#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#expiration SentinelAutomationRule#expiration}.
     *
     * @stability stable
     */
    readonly expiration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#log_analytics_workspace_id SentinelAutomationRule#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#name SentinelAutomationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#order SentinelAutomationRule#order}.
     *
     * @stability stable
     */
    readonly order: number;
    /**
     * action_incident block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#action_incident SentinelAutomationRule#action_incident}
     *
     * @stability stable
     */
    readonly actionIncident?: SentinelAutomationRuleActionIncident[];
    /**
     * action_playbook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#action_playbook SentinelAutomationRule#action_playbook}
     *
     * @stability stable
     */
    readonly actionPlaybook?: SentinelAutomationRuleActionPlaybook[];
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#condition SentinelAutomationRule#condition}
     *
     * @stability stable
     */
    readonly condition?: SentinelAutomationRuleCondition[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#timeouts SentinelAutomationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SentinelAutomationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface SentinelAutomationRuleActionIncident {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#classification SentinelAutomationRule#classification}.
     *
     * @stability stable
     */
    readonly classification?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#classification_comment SentinelAutomationRule#classification_comment}.
     *
     * @stability stable
     */
    readonly classificationComment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#labels SentinelAutomationRule#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#order SentinelAutomationRule#order}.
     *
     * @stability stable
     */
    readonly order: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#owner_id SentinelAutomationRule#owner_id}.
     *
     * @stability stable
     */
    readonly ownerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#severity SentinelAutomationRule#severity}.
     *
     * @stability stable
     */
    readonly severity?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#status SentinelAutomationRule#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
export declare function sentinelAutomationRuleActionIncidentToTerraform(struct?: SentinelAutomationRuleActionIncident): any;
/**
 * @stability stable
 */
export interface SentinelAutomationRuleActionPlaybook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#logic_app_id SentinelAutomationRule#logic_app_id}.
     *
     * @stability stable
     */
    readonly logicAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#order SentinelAutomationRule#order}.
     *
     * @stability stable
     */
    readonly order: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#tenant_id SentinelAutomationRule#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function sentinelAutomationRuleActionPlaybookToTerraform(struct?: SentinelAutomationRuleActionPlaybook): any;
/**
 * @stability stable
 */
export interface SentinelAutomationRuleCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#operator SentinelAutomationRule#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#property SentinelAutomationRule#property}.
     *
     * @stability stable
     */
    readonly property: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#values SentinelAutomationRule#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function sentinelAutomationRuleConditionToTerraform(struct?: SentinelAutomationRuleCondition): any;
/**
 * @stability stable
 */
export interface SentinelAutomationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#create SentinelAutomationRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#delete SentinelAutomationRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#read SentinelAutomationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html#update SentinelAutomationRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function sentinelAutomationRuleTimeoutsToTerraform(struct?: SentinelAutomationRuleTimeoutsOutputReference | SentinelAutomationRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class SentinelAutomationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SentinelAutomationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SentinelAutomationRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html azurerm_sentinel_automation_rule}.
 *
 * @stability stable
 */
export declare class SentinelAutomationRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/sentinel_automation_rule.html azurerm_sentinel_automation_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SentinelAutomationRuleConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    set expiration(value: string);
    /**
     * @stability stable
     */
    resetExpiration(): void;
    /**
     * @stability stable
     */
    get expirationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _order?;
    /**
     * @stability stable
     */
    get order(): number;
    /**
     * @stability stable
     */
    set order(value: number);
    /**
     * @stability stable
     */
    get orderInput(): number | undefined;
    private _actionIncident?;
    /**
     * @stability stable
     */
    get actionIncident(): SentinelAutomationRuleActionIncident[];
    /**
     * @stability stable
     */
    set actionIncident(value: SentinelAutomationRuleActionIncident[]);
    /**
     * @stability stable
     */
    resetActionIncident(): void;
    /**
     * @stability stable
     */
    get actionIncidentInput(): SentinelAutomationRuleActionIncident[] | undefined;
    private _actionPlaybook?;
    /**
     * @stability stable
     */
    get actionPlaybook(): SentinelAutomationRuleActionPlaybook[];
    /**
     * @stability stable
     */
    set actionPlaybook(value: SentinelAutomationRuleActionPlaybook[]);
    /**
     * @stability stable
     */
    resetActionPlaybook(): void;
    /**
     * @stability stable
     */
    get actionPlaybookInput(): SentinelAutomationRuleActionPlaybook[] | undefined;
    private _condition?;
    /**
     * @stability stable
     */
    get condition(): SentinelAutomationRuleCondition[];
    /**
     * @stability stable
     */
    set condition(value: SentinelAutomationRuleCondition[]);
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): SentinelAutomationRuleCondition[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SentinelAutomationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SentinelAutomationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SentinelAutomationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
