"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageManagementPolicy = exports.StorageManagementPolicyTimeoutsOutputReference = exports.storageManagementPolicyTimeoutsToTerraform = exports.storageManagementPolicyRuleToTerraform = exports.StorageManagementPolicyRuleFiltersOutputReference = exports.storageManagementPolicyRuleFiltersToTerraform = exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = exports.StorageManagementPolicyRuleActionsOutputReference = exports.storageManagementPolicyRuleActionsToTerraform = exports.StorageManagementPolicyRuleActionsVersionOutputReference = exports.storageManagementPolicyRuleActionsVersionToTerraform = exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = exports.storageManagementPolicyRuleActionsSnapshotToTerraform = exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceModificationGreaterThan),
        tier_to_archive_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceModificationGreaterThan),
        tier_to_cool_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceModificationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = storageManagementPolicyRuleActionsBaseBlobToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._deleteAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceModificationGreaterThan = this._deleteAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceModificationGreaterThan = this._tierToArchiveAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceModificationGreaterThan = this._tierToCoolAfterDaysSinceModificationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._deleteAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
        }
        else {
            this._deleteAfterDaysSinceModificationGreaterThan = value.deleteAfterDaysSinceModificationGreaterThan;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = value.tierToArchiveAfterDaysSinceModificationGreaterThan;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = value.tierToCoolAfterDaysSinceModificationGreaterThan;
        }
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceModificationGreaterThan(value) {
        this._deleteAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceModificationGreaterThan() {
        this._deleteAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThanInput() {
        return this._deleteAfterDaysSinceModificationGreaterThan;
    }
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetTierToArchiveAfterDaysSinceModificationGreaterThan() {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceModificationGreaterThan;
    }
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set tierToCoolAfterDaysSinceModificationGreaterThan(value) {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetTierToCoolAfterDaysSinceModificationGreaterThan() {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceModificationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = StorageManagementPolicyRuleActionsBaseBlobOutputReference;
_a = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsBaseBlobOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsBaseBlobOutputReference", version: "0.3.4" };
function storageManagementPolicyRuleActionsSnapshotToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsSnapshotToTerraform = storageManagementPolicyRuleActionsSnapshotToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreationGreaterThan = this._deleteAfterDaysSinceCreationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreationGreaterThan = undefined;
        }
        else {
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreationGreaterThan = value.deleteAfterDaysSinceCreationGreaterThan;
        }
    }
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_creation_greater_than');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreationGreaterThan(value) {
        this._deleteAfterDaysSinceCreationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreationGreaterThan() {
        this._deleteAfterDaysSinceCreationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThanInput() {
        return this._deleteAfterDaysSinceCreationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = StorageManagementPolicyRuleActionsSnapshotOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsSnapshotOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsSnapshotOutputReference", version: "0.3.4" };
function storageManagementPolicyRuleActionsVersionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreation),
    };
}
exports.storageManagementPolicyRuleActionsVersionToTerraform = storageManagementPolicyRuleActionsVersionToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreation = this._deleteAfterDaysSinceCreation;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreation = undefined;
        }
        else {
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreation = value.deleteAfterDaysSinceCreation;
        }
    }
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreation() {
        return this.getNumberAttribute('delete_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreation(value) {
        this._deleteAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreation() {
        this._deleteAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationInput() {
        return this._deleteAfterDaysSinceCreation;
    }
}
exports.StorageManagementPolicyRuleActionsVersionOutputReference = StorageManagementPolicyRuleActionsVersionOutputReference;
_c = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsVersionOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsVersionOutputReference", version: "0.3.4" };
function storageManagementPolicyRuleActionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        base_blob: storageManagementPolicyRuleActionsBaseBlobToTerraform(struct.baseBlob),
        snapshot: storageManagementPolicyRuleActionsSnapshotToTerraform(struct.snapshot),
        version: storageManagementPolicyRuleActionsVersionToTerraform(struct.version),
    };
}
exports.storageManagementPolicyRuleActionsToTerraform = storageManagementPolicyRuleActionsToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        // base_blob - computed: false, optional: true, required: false
        this._baseBlob = new StorageManagementPolicyRuleActionsBaseBlobOutputReference(this, "base_blob", true);
        // snapshot - computed: false, optional: true, required: false
        this._snapshot = new StorageManagementPolicyRuleActionsSnapshotOutputReference(this, "snapshot", true);
        // version - computed: false, optional: true, required: false
        this._version = new StorageManagementPolicyRuleActionsVersionOutputReference(this, "version", true);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        var _h, _j, _k;
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._baseBlob) {
            hasAnyValues = true;
            internalValueResult.baseBlob = (_h = this._baseBlob) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        if (this._snapshot) {
            hasAnyValues = true;
            internalValueResult.snapshot = (_j = this._snapshot) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        if (this._version) {
            hasAnyValues = true;
            internalValueResult.version = (_k = this._version) === null || _k === void 0 ? void 0 : _k.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._baseBlob.internalValue = undefined;
            this._snapshot.internalValue = undefined;
            this._version.internalValue = undefined;
        }
        else {
            this._baseBlob.internalValue = value.baseBlob;
            this._snapshot.internalValue = value.snapshot;
            this._version.internalValue = value.version;
        }
    }
    /**
     * @stability stable
     */
    get baseBlob() {
        return this._baseBlob;
    }
    /**
     * @stability stable
     */
    putBaseBlob(value) {
        this._baseBlob.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetBaseBlob() {
        this._baseBlob.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get baseBlobInput() {
        return this._baseBlob.internalValue;
    }
    /**
     * @stability stable
     */
    get snapshot() {
        return this._snapshot;
    }
    /**
     * @stability stable
     */
    putSnapshot(value) {
        this._snapshot.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetSnapshot() {
        this._snapshot.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get snapshotInput() {
        return this._snapshot.internalValue;
    }
    /**
     * @stability stable
     */
    get version() {
        return this._version;
    }
    /**
     * @stability stable
     */
    putVersion(value) {
        this._version.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetVersion() {
        this._version.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get versionInput() {
        return this._version.internalValue;
    }
}
exports.StorageManagementPolicyRuleActionsOutputReference = StorageManagementPolicyRuleActionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsOutputReference", version: "0.3.4" };
function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        operation: cdktf.stringToTerraform(struct.operation),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform;
function storageManagementPolicyRuleFiltersToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        blob_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.blobTypes),
        prefix_match: cdktf.listMapper(cdktf.stringToTerraform)(struct.prefixMatch),
        match_blob_index_tag: cdktf.listMapper(storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform)(struct.matchBlobIndexTag),
    };
}
exports.storageManagementPolicyRuleFiltersToTerraform = storageManagementPolicyRuleFiltersToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._blobTypes) {
            hasAnyValues = true;
            internalValueResult.blobTypes = this._blobTypes;
        }
        if (this._prefixMatch) {
            hasAnyValues = true;
            internalValueResult.prefixMatch = this._prefixMatch;
        }
        if (this._matchBlobIndexTag) {
            hasAnyValues = true;
            internalValueResult.matchBlobIndexTag = this._matchBlobIndexTag;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._blobTypes = undefined;
            this._prefixMatch = undefined;
            this._matchBlobIndexTag = undefined;
        }
        else {
            this._blobTypes = value.blobTypes;
            this._prefixMatch = value.prefixMatch;
            this._matchBlobIndexTag = value.matchBlobIndexTag;
        }
    }
    /**
     * @stability stable
     */
    get blobTypes() {
        return this.getListAttribute('blob_types');
    }
    /**
     * @stability stable
     */
    set blobTypes(value) {
        this._blobTypes = value;
    }
    /**
     * @stability stable
     */
    resetBlobTypes() {
        this._blobTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get blobTypesInput() {
        return this._blobTypes;
    }
    /**
     * @stability stable
     */
    get prefixMatch() {
        return this.getListAttribute('prefix_match');
    }
    /**
     * @stability stable
     */
    set prefixMatch(value) {
        this._prefixMatch = value;
    }
    /**
     * @stability stable
     */
    resetPrefixMatch() {
        this._prefixMatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get prefixMatchInput() {
        return this._prefixMatch;
    }
    /**
     * @stability stable
     */
    get matchBlobIndexTag() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('match_blob_index_tag');
    }
    /**
     * @stability stable
     */
    set matchBlobIndexTag(value) {
        this._matchBlobIndexTag = value;
    }
    /**
     * @stability stable
     */
    resetMatchBlobIndexTag() {
        this._matchBlobIndexTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get matchBlobIndexTagInput() {
        return this._matchBlobIndexTag;
    }
}
exports.StorageManagementPolicyRuleFiltersOutputReference = StorageManagementPolicyRuleFiltersOutputReference;
_e = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersOutputReference", version: "0.3.4" };
function storageManagementPolicyRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        name: cdktf.stringToTerraform(struct.name),
        actions: storageManagementPolicyRuleActionsToTerraform(struct.actions),
        filters: storageManagementPolicyRuleFiltersToTerraform(struct.filters),
    };
}
exports.storageManagementPolicyRuleToTerraform = storageManagementPolicyRuleToTerraform;
function storageManagementPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.storageManagementPolicyTimeoutsToTerraform = storageManagementPolicyTimeoutsToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = false;
        const internalValueResult = {};
        if (this._create) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    /**
     * @stability stable
     */
    get create() {
        return this.getStringAttribute('create');
    }
    /**
     * @stability stable
     */
    set create(value) {
        this._create = value;
    }
    /**
     * @stability stable
     */
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get createInput() {
        return this._create;
    }
    /**
     * @stability stable
     */
    get delete() {
        return this.getStringAttribute('delete');
    }
    /**
     * @stability stable
     */
    set delete(value) {
        this._delete = value;
    }
    /**
     * @stability stable
     */
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteInput() {
        return this._delete;
    }
    /**
     * @stability stable
     */
    get read() {
        return this.getStringAttribute('read');
    }
    /**
     * @stability stable
     */
    set read(value) {
        this._read = value;
    }
    /**
     * @stability stable
     */
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readInput() {
        return this._read;
    }
    /**
     * @stability stable
     */
    get update() {
        return this.getStringAttribute('update');
    }
    /**
     * @stability stable
     */
    set update(value) {
        this._update = value;
    }
    /**
     * @stability stable
     */
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateInput() {
        return this._update;
    }
}
exports.StorageManagementPolicyTimeoutsOutputReference = StorageManagementPolicyTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyTimeoutsOutputReference", version: "0.3.4" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy.html azurerm_storage_management_policy}.
 *
 * @stability stable
 */
class StorageManagementPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy.html azurerm_storage_management_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_storage_management_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new StorageManagementPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._storageAccountId = config.storageAccountId;
        this._rule = config.rule;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get storageAccountId() {
        return this.getStringAttribute('storage_account_id');
    }
    /**
     * @stability stable
     */
    set storageAccountId(value) {
        this._storageAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageAccountIdInput() {
        return this._storageAccountId;
    }
    /**
     * @stability stable
     */
    get rule() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('rule');
    }
    /**
     * @stability stable
     */
    set rule(value) {
        this._rule = value;
    }
    /**
     * @stability stable
     */
    resetRule() {
        this._rule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get ruleInput() {
        return this._rule;
    }
    /**
     * @stability stable
     */
    get timeouts() {
        return this._timeouts;
    }
    /**
     * @stability stable
     */
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            storage_account_id: cdktf.stringToTerraform(this._storageAccountId),
            rule: cdktf.listMapper(storageManagementPolicyRuleToTerraform)(this._rule),
            timeouts: storageManagementPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.StorageManagementPolicy = StorageManagementPolicy;
_g = JSII_RTTI_SYMBOL_1;
StorageManagementPolicy[_g] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicy", version: "0.3.4" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
StorageManagementPolicy.tfResourceType = "azurerm_storage_management_policy";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcmFnZS1tYW5hZ2VtZW50LXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zdG9yYWdlLW1hbmFnZW1lbnQtcG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBcUIvQixTQUFnQixxREFBcUQsQ0FBQyxNQUErRztJQUNuTCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDakQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLGlEQUFpRCxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsMkNBQTJDLENBQUM7UUFDL0gsMERBQTBELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxrREFBa0QsQ0FBQztRQUMvSSx1REFBdUQsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLCtDQUErQyxDQUFDO0tBQzFJLENBQUE7QUFDSCxDQUFDO0FBVkQsc0hBVUM7Ozs7QUFFRCxNQUFhLHlEQUEwRCxTQUFRLEtBQUssQ0FBQyxhQUFhOzs7Ozs7O0lBRWhHLFlBQW1CLGlCQUEyQyxFQUFFLGtCQUEwQixFQUFFLFlBQXFCO1FBQy9HLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLEtBQUssQ0FBQztRQUN6QixNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyw0Q0FBNEMsRUFBRTtZQUNyRCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLDJDQUEyQyxHQUFHLElBQUksQ0FBQyw0Q0FBNEMsQ0FBQztTQUNySDtRQUNELElBQUksSUFBSSxDQUFDLG1EQUFtRCxFQUFFO1lBQzVELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsa0RBQWtELEdBQUcsSUFBSSxDQUFDLG1EQUFtRCxDQUFDO1NBQ25JO1FBQ0QsSUFBSSxJQUFJLENBQUMsZ0RBQWdELEVBQUU7WUFDekQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywrQ0FBK0MsR0FBRyxJQUFJLENBQUMsZ0RBQWdELENBQUM7U0FDN0g7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBNkQ7UUFDcEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyw0Q0FBNEMsR0FBRyxTQUFTLENBQUM7WUFDOUQsSUFBSSxDQUFDLG1EQUFtRCxHQUFHLFNBQVMsQ0FBQztZQUNyRSxJQUFJLENBQUMsZ0RBQWdELEdBQUcsU0FBUyxDQUFDO1NBQ25FO2FBQ0k7WUFDSCxJQUFJLENBQUMsNENBQTRDLEdBQUcsS0FBSyxDQUFDLDJDQUEyQyxDQUFDO1lBQ3RHLElBQUksQ0FBQyxtREFBbUQsR0FBRyxLQUFLLENBQUMsa0RBQWtELENBQUM7WUFDcEgsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQztTQUMvRztJQUNILENBQUM7Ozs7SUFJRCxJQUFXLDJDQUEyQztRQUNwRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxtREFBbUQsQ0FBQyxDQUFDO0lBQ3RGLENBQUM7Ozs7SUFDRCxJQUFXLDJDQUEyQyxDQUFDLEtBQWE7UUFDbEUsSUFBSSxDQUFDLDRDQUE0QyxHQUFHLEtBQUssQ0FBQztJQUM1RCxDQUFDOzs7O0lBQ00sZ0RBQWdEO1FBQ3JELElBQUksQ0FBQyw0Q0FBNEMsR0FBRyxTQUFTLENBQUM7SUFDaEUsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGdEQUFnRDtRQUN6RCxPQUFPLElBQUksQ0FBQyw0Q0FBNEMsQ0FBQztJQUMzRCxDQUFDOzs7O0lBSUQsSUFBVyxrREFBa0Q7UUFDM0QsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsNERBQTRELENBQUMsQ0FBQztJQUMvRixDQUFDOzs7O0lBQ0QsSUFBVyxrREFBa0QsQ0FBQyxLQUFhO1FBQ3pFLElBQUksQ0FBQyxtREFBbUQsR0FBRyxLQUFLLENBQUM7SUFDbkUsQ0FBQzs7OztJQUNNLHVEQUF1RDtRQUM1RCxJQUFJLENBQUMsbURBQW1ELEdBQUcsU0FBUyxDQUFDO0lBQ3ZFLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyx1REFBdUQ7UUFDaEUsT0FBTyxJQUFJLENBQUMsbURBQW1ELENBQUM7SUFDbEUsQ0FBQzs7OztJQUlELElBQVcsK0NBQStDO1FBQ3hELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHlEQUF5RCxDQUFDLENBQUM7SUFDNUYsQ0FBQzs7OztJQUNELElBQVcsK0NBQStDLENBQUMsS0FBYTtRQUN0RSxJQUFJLENBQUMsZ0RBQWdELEdBQUcsS0FBSyxDQUFDO0lBQ2hFLENBQUM7Ozs7SUFDTSxvREFBb0Q7UUFDekQsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLFNBQVMsQ0FBQztJQUNwRSxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsb0RBQW9EO1FBQzdELE9BQU8sSUFBSSxDQUFDLGdEQUFnRCxDQUFDO0lBQy9ELENBQUM7O0FBbkZILDhIQW9GQzs7O0FBVUQsU0FBZ0IscURBQXFELENBQUMsTUFBK0c7SUFDbkwsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQ2pELElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxnREFBZ0QsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHlDQUF5QyxDQUFDO1FBQzVILDZDQUE2QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsc0NBQXNDLENBQUM7UUFDdEgsNkNBQTZDLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyx1Q0FBdUMsQ0FBQztLQUN4SCxDQUFBO0FBQ0gsQ0FBQztBQVZELHNIQVVDOzs7O0FBRUQsTUFBYSx5REFBMEQsU0FBUSxLQUFLLENBQUMsYUFBYTs7Ozs7OztJQUVoRyxZQUFtQixpQkFBMkMsRUFBRSxrQkFBMEIsRUFBRSxZQUFxQjtRQUMvRyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsWUFBWSxDQUFDLENBQUM7SUFDN0QsQ0FBQzs7OztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxLQUFLLENBQUM7UUFDekIsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsMENBQTBDLEVBQUU7WUFDbkQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyx5Q0FBeUMsR0FBRyxJQUFJLENBQUMsMENBQTBDLENBQUM7U0FDakg7UUFDRCxJQUFJLElBQUksQ0FBQyx1Q0FBdUMsRUFBRTtZQUNoRCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHNDQUFzQyxHQUFHLElBQUksQ0FBQyx1Q0FBdUMsQ0FBQztTQUMzRztRQUNELElBQUksSUFBSSxDQUFDLHdDQUF3QyxFQUFFO1lBQ2pELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsdUNBQXVDLEdBQUcsSUFBSSxDQUFDLHdDQUF3QyxDQUFDO1NBQzdHO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTZEO1FBQ3BGLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsMENBQTBDLEdBQUcsU0FBUyxDQUFDO1lBQzVELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxTQUFTLENBQUM7WUFDekQsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLFNBQVMsQ0FBQztTQUMzRDthQUNJO1lBQ0gsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLEtBQUssQ0FBQyx5Q0FBeUMsQ0FBQztZQUNsRyxJQUFJLENBQUMsdUNBQXVDLEdBQUcsS0FBSyxDQUFDLHNDQUFzQyxDQUFDO1lBQzVGLElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxLQUFLLENBQUMsdUNBQXVDLENBQUM7U0FDL0Y7SUFDSCxDQUFDOzs7O0lBSUQsSUFBVyx5Q0FBeUM7UUFDbEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0RBQWtELENBQUMsQ0FBQztJQUNyRixDQUFDOzs7O0lBQ0QsSUFBVyx5Q0FBeUMsQ0FBQyxLQUFhO1FBQ2hFLElBQUksQ0FBQywwQ0FBMEMsR0FBRyxLQUFLLENBQUM7SUFDMUQsQ0FBQzs7OztJQUNNLDhDQUE4QztRQUNuRCxJQUFJLENBQUMsMENBQTBDLEdBQUcsU0FBUyxDQUFDO0lBQzlELENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyw4Q0FBOEM7UUFDdkQsT0FBTyxJQUFJLENBQUMsMENBQTBDLENBQUM7SUFDekQsQ0FBQzs7OztJQUlELElBQVcsc0NBQXNDO1FBQy9DLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLCtDQUErQyxDQUFDLENBQUM7SUFDbEYsQ0FBQzs7OztJQUNELElBQVcsc0NBQXNDLENBQUMsS0FBYTtRQUM3RCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsS0FBSyxDQUFDO0lBQ3ZELENBQUM7Ozs7SUFDTSwyQ0FBMkM7UUFDaEQsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLFNBQVMsQ0FBQztJQUMzRCxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsMkNBQTJDO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHVDQUF1QyxDQUFDO0lBQ3RELENBQUM7Ozs7SUFJRCxJQUFXLHVDQUF1QztRQUNoRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQ2xGLENBQUM7Ozs7SUFDRCxJQUFXLHVDQUF1QyxDQUFDLEtBQWE7UUFDOUQsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLEtBQUssQ0FBQztJQUN4RCxDQUFDOzs7O0lBQ00sNENBQTRDO1FBQ2pELElBQUksQ0FBQyx3Q0FBd0MsR0FBRyxTQUFTLENBQUM7SUFDNUQsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLDRDQUE0QztRQUNyRCxPQUFPLElBQUksQ0FBQyx3Q0FBd0MsQ0FBQztJQUN2RCxDQUFDOztBQW5GSCw4SEFvRkM7OztBQVVELFNBQWdCLG9EQUFvRCxDQUFDLE1BQTZHO0lBQ2hMLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsZ0RBQWdELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyx5Q0FBeUMsQ0FBQztRQUM1SCw2Q0FBNkMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHNDQUFzQyxDQUFDO1FBQ3RILGdDQUFnQyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsNEJBQTRCLENBQUM7S0FDaEcsQ0FBQTtBQUNILENBQUM7QUFWRCxvSEFVQzs7OztBQUVELE1BQWEsd0RBQXlELFNBQVEsS0FBSyxDQUFDLGFBQWE7Ozs7Ozs7SUFFL0YsWUFBbUIsaUJBQTJDLEVBQUUsa0JBQTBCLEVBQUUsWUFBcUI7UUFDL0csS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxDQUFDO0lBQzdELENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsS0FBSyxDQUFDO1FBQ3pCLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLDBDQUEwQyxFQUFFO1lBQ25ELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMseUNBQXlDLEdBQUcsSUFBSSxDQUFDLDBDQUEwQyxDQUFDO1NBQ2pIO1FBQ0QsSUFBSSxJQUFJLENBQUMsdUNBQXVDLEVBQUU7WUFDaEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxzQ0FBc0MsR0FBRyxJQUFJLENBQUMsdUNBQXVDLENBQUM7U0FDM0c7UUFDRCxJQUFJLElBQUksQ0FBQyw2QkFBNkIsRUFBRTtZQUN0QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLDRCQUE0QixHQUFHLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztTQUN2RjtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7Ozs7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE0RDtRQUNuRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztZQUM1RCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsU0FBUyxDQUFDO1lBQ3pELElBQUksQ0FBQyw2QkFBNkIsR0FBRyxTQUFTLENBQUM7U0FDaEQ7YUFDSTtZQUNILElBQUksQ0FBQywwQ0FBMEMsR0FBRyxLQUFLLENBQUMseUNBQXlDLENBQUM7WUFDbEcsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQyxzQ0FBc0MsQ0FBQztZQUM1RixJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixDQUFDO1NBQ3pFO0lBQ0gsQ0FBQzs7OztJQUlELElBQVcseUNBQXlDO1FBQ2xELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtEQUFrRCxDQUFDLENBQUM7SUFDckYsQ0FBQzs7OztJQUNELElBQVcseUNBQXlDLENBQUMsS0FBYTtRQUNoRSxJQUFJLENBQUMsMENBQTBDLEdBQUcsS0FBSyxDQUFDO0lBQzFELENBQUM7Ozs7SUFDTSw4Q0FBOEM7UUFDbkQsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztJQUM5RCxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsOENBQThDO1FBQ3ZELE9BQU8sSUFBSSxDQUFDLDBDQUEwQyxDQUFDO0lBQ3pELENBQUM7Ozs7SUFJRCxJQUFXLHNDQUFzQztRQUMvQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQ2xGLENBQUM7Ozs7SUFDRCxJQUFXLHNDQUFzQyxDQUFDLEtBQWE7UUFDN0QsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQztJQUN2RCxDQUFDOzs7O0lBQ00sMkNBQTJDO1FBQ2hELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxTQUFTLENBQUM7SUFDM0QsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLDJDQUEyQztRQUNwRCxPQUFPLElBQUksQ0FBQyx1Q0FBdUMsQ0FBQztJQUN0RCxDQUFDOzs7O0lBSUQsSUFBVyw0QkFBNEI7UUFDckMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRSxDQUFDOzs7O0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUFhO1FBQ25ELElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQzs7OztJQUNNLGlDQUFpQztRQUN0QyxJQUFJLENBQUMsNkJBQTZCLEdBQUcsU0FBUyxDQUFDO0lBQ2pELENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxpQ0FBaUM7UUFDMUMsT0FBTyxJQUFJLENBQUMsNkJBQTZCLENBQUM7SUFDNUMsQ0FBQzs7QUFuRkgsNEhBb0ZDOzs7QUFVRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDakQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFNBQVMsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2xGLFFBQVEsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2pGLE9BQU8sRUFBRSxvREFBb0QsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO0tBQy9FLENBQUE7QUFDSCxDQUFDO0FBVkQsc0dBVUM7Ozs7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhOzs7Ozs7O0lBRXhGLFlBQW1CLGlCQUEyQyxFQUFFLGtCQUEwQixFQUFFLFlBQXFCO1FBQy9HLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztRQWtDN0QsK0RBQStEO1FBQ3ZELGNBQVMsR0FBRyxJQUFJLHlEQUF5RCxDQUFDLElBQVcsRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFlbEgsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLHlEQUF5RCxDQUFDLElBQVcsRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFlakgsNkRBQTZEO1FBQ3JELGFBQVEsR0FBRyxJQUFJLHdEQUF3RCxDQUFDLElBQVcsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFsRTlHLENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7O1FBQ3RCLElBQUksWUFBWSxHQUFHLEtBQUssQ0FBQztRQUN6QixNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxTQUFTLEVBQUU7WUFDbEIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLFNBQUcsSUFBSSxDQUFDLFNBQVMsMENBQUUsYUFBYSxDQUFDO1NBQzlEO1FBQ0QsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO1lBQ2xCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsUUFBUSxTQUFHLElBQUksQ0FBQyxTQUFTLDBDQUFFLGFBQWEsQ0FBQztTQUM5RDtRQUNELElBQUksSUFBSSxDQUFDLFFBQVEsRUFBRTtZQUNqQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE9BQU8sU0FBRyxJQUFJLENBQUMsUUFBUSwwQ0FBRSxhQUFhLENBQUM7U0FDNUQ7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztZQUN6QyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDekMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO1NBQ3pDO2FBQ0k7WUFDSCxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQzlDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7WUFDOUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztTQUM3QztJQUNILENBQUM7Ozs7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7Ozs7SUFDTSxXQUFXLENBQUMsS0FBaUQ7UUFDbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7Ozs7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0lBQ3RDLENBQUM7Ozs7SUFJRCxJQUFXLFFBQVE7UUFDakIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO0lBQ3hCLENBQUM7Ozs7SUFDTSxXQUFXLENBQUMsS0FBaUQ7UUFDbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3ZDLENBQUM7Ozs7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMzQyxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDO0lBQ3RDLENBQUM7Ozs7SUFJRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7Ozs7SUFDTSxVQUFVLENBQUMsS0FBZ0Q7UUFDaEUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQ3RDLENBQUM7Ozs7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztJQUMxQyxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDO0lBQ3JDLENBQUM7O0FBbkZILDhHQW9GQzs7O0FBVUQsU0FBZ0IsOERBQThELENBQUMsTUFBNEQ7SUFDekksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQ2pELElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsU0FBUyxDQUFDO1FBQ3JELEtBQUssRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLEtBQUssQ0FBQztLQUM5QyxDQUFBO0FBQ0gsQ0FBQztBQVZELHdJQVVDO0FBV0QsU0FBZ0IsNkNBQTZDLENBQUMsTUFBK0Y7SUFDM0osSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQ2pELElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxNQUFPLENBQUMsU0FBUyxDQUFDO1FBQ3hFLFlBQVksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLE1BQU8sQ0FBQyxXQUFXLENBQUM7UUFDNUUsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyw4REFBOEQsQ0FBQyxDQUFDLE1BQU8sQ0FBQyxpQkFBaUIsQ0FBQztLQUNsSSxDQUFBO0FBQ0gsQ0FBQztBQVZELHNHQVVDOzs7O0FBRUQsTUFBYSxpREFBa0QsU0FBUSxLQUFLLENBQUMsYUFBYTs7Ozs7OztJQUV4RixZQUFtQixpQkFBMkMsRUFBRSxrQkFBMEIsRUFBRSxZQUFxQjtRQUMvRyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsWUFBWSxDQUFDLENBQUM7SUFDN0QsQ0FBQzs7OztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxLQUFLLENBQUM7UUFDekIsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ25CLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7U0FDakQ7UUFDRCxJQUFJLElBQUksQ0FBQyxZQUFZLEVBQUU7WUFDckIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztTQUNyRDtRQUNELElBQUksSUFBSSxDQUFDLGtCQUFrQixFQUFFO1lBQzNCLFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1NBQ2pFO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQXFEO1FBQzVFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztZQUM1QixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztZQUM5QixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO1NBQ3JDO2FBQ0k7WUFDSCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7WUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1lBQ3RDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsaUJBQWlCLENBQUM7U0FDbkQ7SUFDSCxDQUFDOzs7O0lBSUQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQzdDLENBQUM7Ozs7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUFlO1FBQ2xDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBQzFCLENBQUM7Ozs7SUFDTSxjQUFjO1FBQ25CLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO0lBQzlCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLFVBQVUsQ0FBQztJQUN6QixDQUFDOzs7O0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQy9DLENBQUM7Ozs7SUFDRCxJQUFXLFdBQVcsQ0FBQyxLQUFlO1FBQ3BDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7Ozs7SUFDTSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxTQUFTLENBQUM7SUFDaEMsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQzs7OztJQUlELElBQVcsaUJBQWlCO1FBQzFCLG9EQUFvRDtRQUNwRCxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxzQkFBc0IsQ0FBUSxDQUFDO0lBQ3ZFLENBQUM7Ozs7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQTREO1FBQ3ZGLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQzs7OztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQzs7QUFwRkgsOEdBcUZDOzs7QUFZRCxTQUFnQixzQ0FBc0MsQ0FBQyxNQUFvQztJQUN6RixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDakQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLE9BQU8sRUFBRSxLQUFLLENBQUMsa0JBQWtCLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUNsRCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsT0FBTyxFQUFFLDZDQUE2QyxDQUFDLE1BQU8sQ0FBQyxPQUFPLENBQUM7UUFDdkUsT0FBTyxFQUFFLDZDQUE2QyxDQUFDLE1BQU8sQ0FBQyxPQUFPLENBQUM7S0FDeEUsQ0FBQTtBQUNILENBQUM7QUFYRCx3RkFXQztBQWFELFNBQWdCLDBDQUEwQyxDQUFDLE1BQXlGO0lBQ2xKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztRQUMvQyxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxJQUFJLENBQUM7UUFDM0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO0tBQ2hELENBQUE7QUFDSCxDQUFDO0FBWEQsZ0dBV0M7Ozs7QUFFRCxNQUFhLDhDQUErQyxTQUFRLEtBQUssQ0FBQyxhQUFhOzs7Ozs7O0lBRXJGLFlBQW1CLGlCQUEyQyxFQUFFLGtCQUEwQixFQUFFLFlBQXFCO1FBQy9HLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztJQUM3RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLEtBQUssQ0FBQztRQUN6QixNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDaEIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ2QsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQWtEO1FBQ3pFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztTQUMxQjthQUNJO1lBQ0gsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztZQUM1QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQzdCO0lBQ0gsQ0FBQzs7OztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7Ozs7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDOzs7O0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7OztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQzs7OztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7Ozs7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7O0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7O0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDOzs7O0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7OztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQzs7OztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBekdILHdHQTBHQzs7Ozs7Ozs7QUFHRCxNQUFhLHVCQUF3QixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPbEUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjOzs7Ozs7OztJQUdkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXFDO1FBQ3BGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsbUNBQW1DO1lBQzFELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsU0FBUzthQUN4QjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUE2Q0wsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLDhDQUE4QyxDQUFDLElBQVcsRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUE3Q3BHLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7SUFDakQsQ0FBQztJQUVELGFBQWE7SUFDYixhQUFhO0lBQ2IsYUFBYTtJQUViLHVEQUF1RDs7OztJQUN2RCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7O0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDOzs7O0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFhO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDOzs7O0lBSUQsSUFBVyxJQUFJO1FBQ2Isb0RBQW9EO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDLE1BQU0sQ0FBUSxDQUFDO0lBQ3ZELENBQUM7Ozs7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFvQztRQUNsRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7O0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDOzs7O0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDOzs7O0lBQ00sV0FBVyxDQUFDLEtBQXNDO1FBQ3ZELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDOzs7O0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZOzs7O0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ25FLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLHNDQUFzQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUMxRSxRQUFRLEVBQUUsMENBQTBDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7U0FDbkYsQ0FBQztJQUNKLENBQUM7O0FBN0ZILDBEQThGQzs7O0FBNUZDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9COzs7O0FBQ0csc0NBQWMsR0FBVyxtQ0FBbUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeS5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3RvcmFnZUFjY291bnRJZDogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcnVsZT86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGltZW91dHM/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzO1xufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2Ige1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JPdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICAgIHRpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW46IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEudGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICAgIHRpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW46IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEudGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklUZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGlzU2luZ2xlSXRlbTogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGlzU2luZ2xlSXRlbSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gZmFsc2U7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gICAgfVxuICAgIGlmICh0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNCYXNlQmxvYiB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWUuZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgICAgIHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWUudGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gICAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2RlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgfVxuXG4gIC8vIHRpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICB9XG5cbiAgLy8gdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCd0aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuJyk7XG4gIH1cbiAgcHVibGljIHNldCB0aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW5JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3RUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3RPdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3QpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICAgIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gICAgZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb25fZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbiksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdE91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSVRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgaXNTaW5nbGVJdGVtOiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgaXNTaW5nbGVJdGVtKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3QgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSBmYWxzZTtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgfVxuICAgIGlmICh0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuID0gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgICByZXR1cm4gaGFzQW55VmFsdWVzID8gaW50ZXJuYWxWYWx1ZVJlc3VsdCA6IHVuZGVmaW5lZDtcbiAgfVxuXG4gIHB1YmxpYyBzZXQgaW50ZXJuYWxWYWx1ZSh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90IHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWUuY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZS5kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW47XG4gICAgfVxuICB9XG5cbiAgLy8gY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2NoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICB9XG5cbiAgLy8gY2hhbmdlX3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ2NoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICB9XG5cbiAgLy8gZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb25fZ3JlYXRlcl90aGFuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb25fZ3JlYXRlcl90aGFuJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW47XG4gIH1cbn1cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb24ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb25Ub1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbk91dHB1dFJlZmVyZW5jZSB8IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKSxcbiAgICBjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICAgIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbk91dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSVRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgaXNTaW5nbGVJdGVtOiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgaXNTaW5nbGVJdGVtKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbiB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IGZhbHNlO1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbiB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlLmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYmFzZUJsb2I/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2I7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzbmFwc2hvdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZlcnNpb24/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9ucyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGJhc2VfYmxvYjogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iVG9UZXJyYWZvcm0oc3RydWN0IS5iYXNlQmxvYiksXG4gICAgc25hcHNob3Q6IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdFRvVGVycmFmb3JtKHN0cnVjdCEuc25hcHNob3QpLFxuICAgIHZlcnNpb246IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uVG9UZXJyYWZvcm0oc3RydWN0IS52ZXJzaW9uKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSVRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgaXNTaW5nbGVJdGVtOiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgaXNTaW5nbGVJdGVtKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gZmFsc2U7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2Jhc2VCbG9iKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5iYXNlQmxvYiA9IHRoaXMuX2Jhc2VCbG9iPy5pbnRlcm5hbFZhbHVlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fc25hcHNob3QpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnNuYXBzaG90ID0gdGhpcy5fc25hcHNob3Q/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIGlmICh0aGlzLl92ZXJzaW9uKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC52ZXJzaW9uID0gdGhpcy5fdmVyc2lvbj8uaW50ZXJuYWxWYWx1ZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl92ZXJzaW9uLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlLmJhc2VCbG9iO1xuICAgICAgdGhpcy5fc25hcHNob3QuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlLnNuYXBzaG90O1xuICAgICAgdGhpcy5fdmVyc2lvbi5pbnRlcm5hbFZhbHVlID0gdmFsdWUudmVyc2lvbjtcbiAgICB9XG4gIH1cblxuICAvLyBiYXNlX2Jsb2IgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYmFzZUJsb2IgPSBuZXcgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iT3V0cHV0UmVmZXJlbmNlKHRoaXMgYXMgYW55LCBcImJhc2VfYmxvYlwiLCB0cnVlKTtcbiAgcHVibGljIGdldCBiYXNlQmxvYigpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFzZUJsb2I7XG4gIH1cbiAgcHVibGljIHB1dEJhc2VCbG9iKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IpIHtcbiAgICB0aGlzLl9iYXNlQmxvYi5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QmFzZUJsb2IoKSB7XG4gICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmFzZUJsb2JJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHNuYXBzaG90IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NuYXBzaG90ID0gbmV3IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdE91dHB1dFJlZmVyZW5jZSh0aGlzIGFzIGFueSwgXCJzbmFwc2hvdFwiLCB0cnVlKTtcbiAgcHVibGljIGdldCBzbmFwc2hvdCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc25hcHNob3Q7XG4gIH1cbiAgcHVibGljIHB1dFNuYXBzaG90KHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3QpIHtcbiAgICB0aGlzLl9zbmFwc2hvdC5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U25hcHNob3QoKSB7XG4gICAgdGhpcy5fc25hcHNob3QuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc25hcHNob3RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc25hcHNob3QuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vIHZlcnNpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdmVyc2lvbiA9IG5ldyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbk91dHB1dFJlZmVyZW5jZSh0aGlzIGFzIGFueSwgXCJ2ZXJzaW9uXCIsIHRydWUpO1xuICBwdWJsaWMgZ2V0IHZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZlcnNpb247XG4gIH1cbiAgcHVibGljIHB1dFZlcnNpb24odmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uKSB7XG4gICAgdGhpcy5fdmVyc2lvbi5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VmVyc2lvbigpIHtcbiAgICB0aGlzLl92ZXJzaW9uLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHZlcnNpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdmVyc2lvbi5pbnRlcm5hbFZhbHVlO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBvcGVyYXRpb24/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5uYW1lKSxcbiAgICBvcGVyYXRpb246IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEub3BlcmF0aW9uKSxcbiAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS52YWx1ZSksXG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBibG9iVHlwZXM/OiBzdHJpbmdbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHJlZml4TWF0Y2g/OiBzdHJpbmdbXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG1hdGNoQmxvYkluZGV4VGFnPzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnW107XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzVG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc091dHB1dFJlZmVyZW5jZSB8IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnMpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBibG9iX3R5cGVzOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLmJsb2JUeXBlcyksXG4gICAgcHJlZml4X21hdGNoOiBjZGt0Zi5saXN0TWFwcGVyKGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKShzdHJ1Y3QhLnByZWZpeE1hdGNoKSxcbiAgICBtYXRjaF9ibG9iX2luZGV4X3RhZzogY2RrdGYubGlzdE1hcHBlcihzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzTWF0Y2hCbG9iSW5kZXhUYWdUb1RlcnJhZm9ybSkoc3RydWN0IS5tYXRjaEJsb2JJbmRleFRhZyksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklUZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGlzU2luZ2xlSXRlbTogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGlzU2luZ2xlSXRlbSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVycyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IGZhbHNlO1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9ibG9iVHlwZXMpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmJsb2JUeXBlcyA9IHRoaXMuX2Jsb2JUeXBlcztcbiAgICB9XG4gICAgaWYgKHRoaXMuX3ByZWZpeE1hdGNoKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5wcmVmaXhNYXRjaCA9IHRoaXMuX3ByZWZpeE1hdGNoO1xuICAgIH1cbiAgICBpZiAodGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0Lm1hdGNoQmxvYkluZGV4VGFnID0gdGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWc7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuX2Jsb2JUeXBlcyA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3ByZWZpeE1hdGNoID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5fYmxvYlR5cGVzID0gdmFsdWUuYmxvYlR5cGVzO1xuICAgICAgdGhpcy5fcHJlZml4TWF0Y2ggPSB2YWx1ZS5wcmVmaXhNYXRjaDtcbiAgICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdmFsdWUubWF0Y2hCbG9iSW5kZXhUYWc7XG4gICAgfVxuICB9XG5cbiAgLy8gYmxvYl90eXBlcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9ibG9iVHlwZXM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgYmxvYlR5cGVzKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ2Jsb2JfdHlwZXMnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJsb2JUeXBlcyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9ibG9iVHlwZXMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRCbG9iVHlwZXMoKSB7XG4gICAgdGhpcy5fYmxvYlR5cGVzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBibG9iVHlwZXNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYmxvYlR5cGVzO1xuICB9XG5cbiAgLy8gcHJlZml4X21hdGNoIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3ByZWZpeE1hdGNoPzogc3RyaW5nW107IFxuICBwdWJsaWMgZ2V0IHByZWZpeE1hdGNoKCkge1xuICAgIHJldHVybiB0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3ByZWZpeF9tYXRjaCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcHJlZml4TWF0Y2godmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fcHJlZml4TWF0Y2ggPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQcmVmaXhNYXRjaCgpIHtcbiAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJlZml4TWF0Y2hJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHJlZml4TWF0Y2g7XG4gIH1cblxuICAvLyBtYXRjaF9ibG9iX2luZGV4X3RhZyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYXRjaEJsb2JJbmRleFRhZz86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1tdOyBcbiAgcHVibGljIGdldCBtYXRjaEJsb2JJbmRleFRhZygpIHtcbiAgICAvLyBHZXR0aW5nIHRoZSBjb21wdXRlZCB2YWx1ZSBpcyBub3QgeWV0IGltcGxlbWVudGVkXG4gICAgcmV0dXJuIHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSgnbWF0Y2hfYmxvYl9pbmRleF90YWcnKSBhcyBhbnk7XG4gIH1cbiAgcHVibGljIHNldCBtYXRjaEJsb2JJbmRleFRhZyh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnW10pIHtcbiAgICB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1hdGNoQmxvYkluZGV4VGFnKCkge1xuICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYXRjaEJsb2JJbmRleFRhZ0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZztcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGVuYWJsZWQ6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhY3Rpb25zOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZmlsdGVycz86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnM7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGUpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBlbmFibGVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0oc3RydWN0IS5lbmFibGVkKSxcbiAgICBuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLm5hbWUpLFxuICAgIGFjdGlvbnM6IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNUb1RlcnJhZm9ybShzdHJ1Y3QhLmFjdGlvbnMpLFxuICAgIGZpbHRlcnM6IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNUb1RlcnJhZm9ybShzdHJ1Y3QhLmZpbHRlcnMpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0cyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNyZWF0ZT86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVsZXRlPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHJlYWQ/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHVwZGF0ZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0cyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGNyZWF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5jcmVhdGUpLFxuICAgIGRlbGV0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGUpLFxuICAgIHJlYWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEucmVhZCksXG4gICAgdXBkYXRlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnVwZGF0ZSksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklUZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGlzU2luZ2xlSXRlbTogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGlzU2luZ2xlSXRlbSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0cyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IGZhbHNlO1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jcmVhdGUpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNyZWF0ZSA9IHRoaXMuX2NyZWF0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZSkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlID0gdGhpcy5fZGVsZXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVhZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVhZCA9IHRoaXMuX3JlYWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl91cGRhdGUpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnVwZGF0ZSA9IHRoaXMuX3VwZGF0ZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsZXRlID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fcmVhZCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZS5jcmVhdGU7XG4gICAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZS5kZWxldGU7XG4gICAgICB0aGlzLl9yZWFkID0gdmFsdWUucmVhZDtcbiAgICAgIHRoaXMuX3VwZGF0ZSA9IHZhbHVlLnVwZGF0ZTtcbiAgICB9XG4gIH1cblxuICAvLyBjcmVhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3JlYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjcmVhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjcmVhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNyZWF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3JlYXRlKCkge1xuICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY3JlYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NyZWF0ZTtcbiAgfVxuXG4gIC8vIGRlbGV0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWxldGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RlbGV0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGUoKSB7XG4gICAgdGhpcy5fZGVsZXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlO1xuICB9XG5cbiAgLy8gcmVhZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZWFkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZWFkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVhZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVhZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVhZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlYWQoKSB7XG4gICAgdGhpcy5fcmVhZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVhZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZWFkO1xuICB9XG5cbiAgLy8gdXBkYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VwZGF0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXBkYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndXBkYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCB1cGRhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFVwZGF0ZSgpIHtcbiAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHVwZGF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl91cGRhdGU7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZTogc3RyaW5nID0gXCJhenVyZXJtX3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3lcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeUNvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnYXp1cmVybV9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F6dXJlcm0nXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9zdG9yYWdlQWNjb3VudElkID0gY29uZmlnLnN0b3JhZ2VBY2NvdW50SWQ7XG4gICAgdGhpcy5fcnVsZSA9IGNvbmZpZy5ydWxlO1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSBjb25maWcudGltZW91dHM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cblxuICAvLyBzdG9yYWdlX2FjY291bnRfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc3RvcmFnZUFjY291bnRJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc3RvcmFnZUFjY291bnRJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3N0b3JhZ2VfYWNjb3VudF9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RvcmFnZUFjY291bnRJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RvcmFnZUFjY291bnRJZCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzdG9yYWdlQWNjb3VudElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N0b3JhZ2VBY2NvdW50SWQ7XG4gIH1cblxuICAvLyBydWxlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3J1bGU/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVbXTsgXG4gIHB1YmxpYyBnZXQgcnVsZSgpIHtcbiAgICAvLyBHZXR0aW5nIHRoZSBjb21wdXRlZCB2YWx1ZSBpcyBub3QgeWV0IGltcGxlbWVudGVkXG4gICAgcmV0dXJuIHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSgncnVsZScpIGFzIGFueTtcbiAgfVxuICBwdWJsaWMgc2V0IHJ1bGUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdKSB7XG4gICAgdGhpcy5fcnVsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJ1bGUoKSB7XG4gICAgdGhpcy5fcnVsZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcnVsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ydWxlO1xuICB9XG5cbiAgLy8gdGltZW91dHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGltZW91dHMgPSBuZXcgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c091dHB1dFJlZmVyZW5jZSh0aGlzIGFzIGFueSwgXCJ0aW1lb3V0c1wiLCB0cnVlKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpbWVvdXRzKCkge1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpbWVvdXRzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0b3JhZ2VfYWNjb3VudF9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fc3RvcmFnZUFjY291bnRJZCksXG4gICAgICBydWxlOiBjZGt0Zi5saXN0TWFwcGVyKHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVRvVGVycmFmb3JtKSh0aGlzLl9ydWxlKSxcbiAgICAgIHRpbWVvdXRzOiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzVG9UZXJyYWZvcm0odGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSksXG4gICAgfTtcbiAgfVxufVxuIl19