import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputSynapseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#database StreamAnalyticsOutputSynapse#database}.
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#name StreamAnalyticsOutputSynapse#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#password StreamAnalyticsOutputSynapse#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#resource_group_name StreamAnalyticsOutputSynapse#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#server StreamAnalyticsOutputSynapse#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#stream_analytics_job_name StreamAnalyticsOutputSynapse#stream_analytics_job_name}.
     *
     * @stability stable
     */
    readonly streamAnalyticsJobName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#table StreamAnalyticsOutputSynapse#table}.
     *
     * @stability stable
     */
    readonly table: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#user StreamAnalyticsOutputSynapse#user}.
     *
     * @stability stable
     */
    readonly user: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#timeouts StreamAnalyticsOutputSynapse#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StreamAnalyticsOutputSynapseTimeouts;
}
/**
 * @stability stable
 */
export interface StreamAnalyticsOutputSynapseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#create StreamAnalyticsOutputSynapse#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#delete StreamAnalyticsOutputSynapse#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#read StreamAnalyticsOutputSynapse#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html#update StreamAnalyticsOutputSynapse#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function streamAnalyticsOutputSynapseTimeoutsToTerraform(struct?: StreamAnalyticsOutputSynapseTimeoutsOutputReference | StreamAnalyticsOutputSynapseTimeouts): any;
/**
 * @stability stable
 */
export declare class StreamAnalyticsOutputSynapseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StreamAnalyticsOutputSynapseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StreamAnalyticsOutputSynapseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html azurerm_stream_analytics_output_synapse}.
 *
 * @stability stable
 */
export declare class StreamAnalyticsOutputSynapse extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/stream_analytics_output_synapse.html azurerm_stream_analytics_output_synapse} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamAnalyticsOutputSynapseConfig);
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _streamAnalyticsJobName?;
    /**
     * @stability stable
     */
    get streamAnalyticsJobName(): string;
    /**
     * @stability stable
     */
    set streamAnalyticsJobName(value: string);
    /**
     * @stability stable
     */
    get streamAnalyticsJobNameInput(): string | undefined;
    private _table?;
    /**
     * @stability stable
     */
    get table(): string;
    /**
     * @stability stable
     */
    set table(value: string);
    /**
     * @stability stable
     */
    get tableInput(): string | undefined;
    private _user?;
    /**
     * @stability stable
     */
    get user(): string;
    /**
     * @stability stable
     */
    set user(value: string);
    /**
     * @stability stable
     */
    get userInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): StreamAnalyticsOutputSynapseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StreamAnalyticsOutputSynapseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StreamAnalyticsOutputSynapseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
