import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#aad_admin SynapseWorkspace#aad_admin}.
     *
     * @stability stable
     */
    readonly aadAdmin?: SynapseWorkspaceAadAdmin[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#compute_subnet_id SynapseWorkspace#compute_subnet_id}.
     *
     * @stability stable
     */
    readonly computeSubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#data_exfiltration_protection_enabled SynapseWorkspace#data_exfiltration_protection_enabled}.
     *
     * @stability stable
     */
    readonly dataExfiltrationProtectionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#linking_allowed_for_aad_tenant_ids SynapseWorkspace#linking_allowed_for_aad_tenant_ids}.
     *
     * @stability stable
     */
    readonly linkingAllowedForAadTenantIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#location SynapseWorkspace#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#managed_resource_group_name SynapseWorkspace#managed_resource_group_name}.
     *
     * @stability stable
     */
    readonly managedResourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#managed_virtual_network_enabled SynapseWorkspace#managed_virtual_network_enabled}.
     *
     * @stability stable
     */
    readonly managedVirtualNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#name SynapseWorkspace#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#public_network_access_enabled SynapseWorkspace#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#purview_id SynapseWorkspace#purview_id}.
     *
     * @stability stable
     */
    readonly purviewId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#resource_group_name SynapseWorkspace#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#sql_aad_admin SynapseWorkspace#sql_aad_admin}.
     *
     * @stability stable
     */
    readonly sqlAadAdmin?: SynapseWorkspaceSqlAadAdmin[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#sql_administrator_login SynapseWorkspace#sql_administrator_login}.
     *
     * @stability stable
     */
    readonly sqlAdministratorLogin: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#sql_administrator_login_password SynapseWorkspace#sql_administrator_login_password}.
     *
     * @stability stable
     */
    readonly sqlAdministratorLoginPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#sql_identity_control_enabled SynapseWorkspace#sql_identity_control_enabled}.
     *
     * @stability stable
     */
    readonly sqlIdentityControlEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#storage_data_lake_gen2_filesystem_id SynapseWorkspace#storage_data_lake_gen2_filesystem_id}.
     *
     * @stability stable
     */
    readonly storageDataLakeGen2FilesystemId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#tags SynapseWorkspace#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * azure_devops_repo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#azure_devops_repo SynapseWorkspace#azure_devops_repo}
     *
     * @stability stable
     */
    readonly azureDevopsRepo?: SynapseWorkspaceAzureDevopsRepo;
    /**
     * customer_managed_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#customer_managed_key SynapseWorkspace#customer_managed_key}
     *
     * @stability stable
     */
    readonly customerManagedKey?: SynapseWorkspaceCustomerManagedKey;
    /**
     * github_repo block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#github_repo SynapseWorkspace#github_repo}
     *
     * @stability stable
     */
    readonly githubRepo?: SynapseWorkspaceGithubRepo;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#timeouts SynapseWorkspace#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseWorkspaceTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceAadAdmin {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#login SynapseWorkspace#login}.
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#object_id SynapseWorkspace#object_id}.
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#tenant_id SynapseWorkspace#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceAadAdminToTerraform(struct?: SynapseWorkspaceAadAdmin): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceSqlAadAdmin {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#login SynapseWorkspace#login}.
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#object_id SynapseWorkspace#object_id}.
     *
     * @stability stable
     */
    readonly objectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#tenant_id SynapseWorkspace#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceSqlAadAdminToTerraform(struct?: SynapseWorkspaceSqlAadAdmin): any;
/**
 * @stability stable
 */
export interface SynapseWorkspaceAzureDevopsRepo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#account_name SynapseWorkspace#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#branch_name SynapseWorkspace#branch_name}.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#last_commit_id SynapseWorkspace#last_commit_id}.
     *
     * @stability stable
     */
    readonly lastCommitId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#project_name SynapseWorkspace#project_name}.
     *
     * @stability stable
     */
    readonly projectName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#repository_name SynapseWorkspace#repository_name}.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#root_folder SynapseWorkspace#root_folder}.
     *
     * @stability stable
     */
    readonly rootFolder: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#tenant_id SynapseWorkspace#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
export declare function synapseWorkspaceAzureDevopsRepoToTerraform(struct?: SynapseWorkspaceAzureDevopsRepoOutputReference | SynapseWorkspaceAzureDevopsRepo): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceAzureDevopsRepoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceAzureDevopsRepo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceAzureDevopsRepo | undefined);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    set branchName(value: string);
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _lastCommitId?;
    /**
     * @stability stable
     */
    get lastCommitId(): string;
    /**
     * @stability stable
     */
    set lastCommitId(value: string);
    /**
     * @stability stable
     */
    resetLastCommitId(): void;
    /**
     * @stability stable
     */
    get lastCommitIdInput(): string | undefined;
    private _projectName?;
    /**
     * @stability stable
     */
    get projectName(): string;
    /**
     * @stability stable
     */
    set projectName(value: string);
    /**
     * @stability stable
     */
    get projectNameInput(): string | undefined;
    private _repositoryName?;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    set repositoryName(value: string);
    /**
     * @stability stable
     */
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    /**
     * @stability stable
     */
    get rootFolder(): string;
    /**
     * @stability stable
     */
    set rootFolder(value: string);
    /**
     * @stability stable
     */
    get rootFolderInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceCustomerManagedKey {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#key_name SynapseWorkspace#key_name}.
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#key_versionless_id SynapseWorkspace#key_versionless_id}.
     *
     * @stability stable
     */
    readonly keyVersionlessId: string;
}
export declare function synapseWorkspaceCustomerManagedKeyToTerraform(struct?: SynapseWorkspaceCustomerManagedKeyOutputReference | SynapseWorkspaceCustomerManagedKey): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceCustomerManagedKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceCustomerManagedKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceCustomerManagedKey | undefined);
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    set keyName(value: string);
    /**
     * @stability stable
     */
    resetKeyName(): void;
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    private _keyVersionlessId?;
    /**
     * @stability stable
     */
    get keyVersionlessId(): string;
    /**
     * @stability stable
     */
    set keyVersionlessId(value: string);
    /**
     * @stability stable
     */
    get keyVersionlessIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceGithubRepo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#account_name SynapseWorkspace#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#branch_name SynapseWorkspace#branch_name}.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#git_url SynapseWorkspace#git_url}.
     *
     * @stability stable
     */
    readonly gitUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#last_commit_id SynapseWorkspace#last_commit_id}.
     *
     * @stability stable
     */
    readonly lastCommitId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#repository_name SynapseWorkspace#repository_name}.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#root_folder SynapseWorkspace#root_folder}.
     *
     * @stability stable
     */
    readonly rootFolder: string;
}
export declare function synapseWorkspaceGithubRepoToTerraform(struct?: SynapseWorkspaceGithubRepoOutputReference | SynapseWorkspaceGithubRepo): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceGithubRepoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceGithubRepo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceGithubRepo | undefined);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    set branchName(value: string);
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _gitUrl?;
    /**
     * @stability stable
     */
    get gitUrl(): string;
    /**
     * @stability stable
     */
    set gitUrl(value: string);
    /**
     * @stability stable
     */
    resetGitUrl(): void;
    /**
     * @stability stable
     */
    get gitUrlInput(): string | undefined;
    private _lastCommitId?;
    /**
     * @stability stable
     */
    get lastCommitId(): string;
    /**
     * @stability stable
     */
    set lastCommitId(value: string);
    /**
     * @stability stable
     */
    resetLastCommitId(): void;
    /**
     * @stability stable
     */
    get lastCommitIdInput(): string | undefined;
    private _repositoryName?;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    set repositoryName(value: string);
    /**
     * @stability stable
     */
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    /**
     * @stability stable
     */
    get rootFolder(): string;
    /**
     * @stability stable
     */
    set rootFolder(value: string);
    /**
     * @stability stable
     */
    get rootFolderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SynapseWorkspaceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#create SynapseWorkspace#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#delete SynapseWorkspace#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#read SynapseWorkspace#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html#update SynapseWorkspace#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseWorkspaceTimeoutsToTerraform(struct?: SynapseWorkspaceTimeoutsOutputReference | SynapseWorkspaceTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseWorkspaceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html azurerm_synapse_workspace}.
 *
 * @stability stable
 */
export declare class SynapseWorkspace extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_workspace.html azurerm_synapse_workspace} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseWorkspaceConfig);
    private _aadAdmin?;
    /**
     * @stability stable
     */
    get aadAdmin(): SynapseWorkspaceAadAdmin[];
    /**
     * @stability stable
     */
    set aadAdmin(value: SynapseWorkspaceAadAdmin[]);
    /**
     * @stability stable
     */
    resetAadAdmin(): void;
    /**
     * @stability stable
     */
    get aadAdminInput(): SynapseWorkspaceAadAdmin[] | undefined;
    private _computeSubnetId?;
    /**
     * @stability stable
     */
    get computeSubnetId(): string;
    /**
     * @stability stable
     */
    set computeSubnetId(value: string);
    /**
     * @stability stable
     */
    resetComputeSubnetId(): void;
    /**
     * @stability stable
     */
    get computeSubnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    connectivityEndpoints(key: string): string;
    private _dataExfiltrationProtectionEnabled?;
    /**
     * @stability stable
     */
    get dataExfiltrationProtectionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataExfiltrationProtectionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataExfiltrationProtectionEnabled(): void;
    /**
     * @stability stable
     */
    get dataExfiltrationProtectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): SynapseWorkspaceIdentity;
    private _linkingAllowedForAadTenantIds?;
    /**
     * @stability stable
     */
    get linkingAllowedForAadTenantIds(): string[];
    /**
     * @stability stable
     */
    set linkingAllowedForAadTenantIds(value: string[]);
    /**
     * @stability stable
     */
    resetLinkingAllowedForAadTenantIds(): void;
    /**
     * @stability stable
     */
    get linkingAllowedForAadTenantIdsInput(): string[] | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managedResourceGroupName?;
    /**
     * @stability stable
     */
    get managedResourceGroupName(): string;
    /**
     * @stability stable
     */
    set managedResourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetManagedResourceGroupName(): void;
    /**
     * @stability stable
     */
    get managedResourceGroupNameInput(): string | undefined;
    private _managedVirtualNetworkEnabled?;
    /**
     * @stability stable
     */
    get managedVirtualNetworkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set managedVirtualNetworkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManagedVirtualNetworkEnabled(): void;
    /**
     * @stability stable
     */
    get managedVirtualNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _purviewId?;
    /**
     * @stability stable
     */
    get purviewId(): string;
    /**
     * @stability stable
     */
    set purviewId(value: string);
    /**
     * @stability stable
     */
    resetPurviewId(): void;
    /**
     * @stability stable
     */
    get purviewIdInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sqlAadAdmin?;
    /**
     * @stability stable
     */
    get sqlAadAdmin(): SynapseWorkspaceSqlAadAdmin[];
    /**
     * @stability stable
     */
    set sqlAadAdmin(value: SynapseWorkspaceSqlAadAdmin[]);
    /**
     * @stability stable
     */
    resetSqlAadAdmin(): void;
    /**
     * @stability stable
     */
    get sqlAadAdminInput(): SynapseWorkspaceSqlAadAdmin[] | undefined;
    private _sqlAdministratorLogin?;
    /**
     * @stability stable
     */
    get sqlAdministratorLogin(): string;
    /**
     * @stability stable
     */
    set sqlAdministratorLogin(value: string);
    /**
     * @stability stable
     */
    get sqlAdministratorLoginInput(): string | undefined;
    private _sqlAdministratorLoginPassword?;
    /**
     * @stability stable
     */
    get sqlAdministratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set sqlAdministratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    get sqlAdministratorLoginPasswordInput(): string | undefined;
    private _sqlIdentityControlEnabled?;
    /**
     * @stability stable
     */
    get sqlIdentityControlEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sqlIdentityControlEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSqlIdentityControlEnabled(): void;
    /**
     * @stability stable
     */
    get sqlIdentityControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _storageDataLakeGen2FilesystemId?;
    /**
     * @stability stable
     */
    get storageDataLakeGen2FilesystemId(): string;
    /**
     * @stability stable
     */
    set storageDataLakeGen2FilesystemId(value: string);
    /**
     * @stability stable
     */
    get storageDataLakeGen2FilesystemIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _azureDevopsRepo;
    /**
     * @stability stable
     */
    get azureDevopsRepo(): SynapseWorkspaceAzureDevopsRepoOutputReference;
    /**
     * @stability stable
     */
    putAzureDevopsRepo(value: SynapseWorkspaceAzureDevopsRepo): void;
    /**
     * @stability stable
     */
    resetAzureDevopsRepo(): void;
    /**
     * @stability stable
     */
    get azureDevopsRepoInput(): SynapseWorkspaceAzureDevopsRepo | undefined;
    private _customerManagedKey;
    /**
     * @stability stable
     */
    get customerManagedKey(): SynapseWorkspaceCustomerManagedKeyOutputReference;
    /**
     * @stability stable
     */
    putCustomerManagedKey(value: SynapseWorkspaceCustomerManagedKey): void;
    /**
     * @stability stable
     */
    resetCustomerManagedKey(): void;
    /**
     * @stability stable
     */
    get customerManagedKeyInput(): SynapseWorkspaceCustomerManagedKey | undefined;
    private _githubRepo;
    /**
     * @stability stable
     */
    get githubRepo(): SynapseWorkspaceGithubRepoOutputReference;
    /**
     * @stability stable
     */
    putGithubRepo(value: SynapseWorkspaceGithubRepo): void;
    /**
     * @stability stable
     */
    resetGithubRepo(): void;
    /**
     * @stability stable
     */
    get githubRepoInput(): SynapseWorkspaceGithubRepo | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseWorkspaceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseWorkspaceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseWorkspaceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
