import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VmwareExpressRouteAuthorizationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#name VmwareExpressRouteAuthorization#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#private_cloud_id VmwareExpressRouteAuthorization#private_cloud_id}.
     *
     * @stability stable
     */
    readonly privateCloudId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#timeouts VmwareExpressRouteAuthorization#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VmwareExpressRouteAuthorizationTimeouts;
}
/**
 * @stability stable
 */
export interface VmwareExpressRouteAuthorizationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#create VmwareExpressRouteAuthorization#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#delete VmwareExpressRouteAuthorization#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html#read VmwareExpressRouteAuthorization#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function vmwareExpressRouteAuthorizationTimeoutsToTerraform(struct?: VmwareExpressRouteAuthorizationTimeoutsOutputReference | VmwareExpressRouteAuthorizationTimeouts): any;
/**
 * @stability stable
 */
export declare class VmwareExpressRouteAuthorizationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VmwareExpressRouteAuthorizationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VmwareExpressRouteAuthorizationTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html azurerm_vmware_express_route_authorization}.
 *
 * @stability stable
 */
export declare class VmwareExpressRouteAuthorization extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/vmware_express_route_authorization.html azurerm_vmware_express_route_authorization} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VmwareExpressRouteAuthorizationConfig);
    /**
     * @stability stable
     */
    get expressRouteAuthorizationId(): string;
    /**
     * @stability stable
     */
    get expressRouteAuthorizationKey(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateCloudId?;
    /**
     * @stability stable
     */
    get privateCloudId(): string;
    /**
     * @stability stable
     */
    set privateCloudId(value: string);
    /**
     * @stability stable
     */
    get privateCloudIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VmwareExpressRouteAuthorizationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VmwareExpressRouteAuthorizationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VmwareExpressRouteAuthorizationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
