# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2024-06-19T05:38:42+00:00

from __future__ import annotations

from enum import Enum
from typing import Annotated, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel


class Version(BaseModel):
    version_identifier: Optional[str] = "23.2"


class Terrain(Enum):
    city = "City"
    country = "Country"
    ocean = "Ocean"
    suburbs = "Suburbs"
    urban = "Urban"


class SolarDistribution(Enum):
    full_exterior = "FullExterior"
    full_exterior_with_reflections = "FullExteriorWithReflections"
    full_interior_and_exterior = "FullInteriorAndExterior"
    full_interior_and_exterior_with_reflections = (
        "FullInteriorAndExteriorWithReflections"
    )
    minimal_shadowing = "MinimalShadowing"


class Building(BaseModel):
    north_axis: Optional[float] = 0.0
    terrain: Optional[Terrain] = Terrain.suburbs
    loads_convergence_tolerance_value: Annotated[
        Optional[float], Field(0.04, gt=0.0, le=0.5)
    ]
    temperature_convergence_tolerance_value: Annotated[
        Optional[float], Field(0.4, gt=0.0, le=0.5)
    ]
    solar_distribution: Optional[SolarDistribution] = SolarDistribution.full_exterior
    maximum_number_of_warmup_days: Annotated[Optional[int], Field(25, gt=0)]
    minimum_number_of_warmup_days: Annotated[Optional[int], Field(1, gt=0)]


class ShadingCalculationMethod(Enum):
    imported = "Imported"
    pixel_counting = "PixelCounting"
    polygon_clipping = "PolygonClipping"
    scheduled = "Scheduled"


class ShadingCalculationUpdateFrequencyMethod(Enum):
    periodic = "Periodic"
    timestep = "Timestep"


class PolygonClippingAlgorithm(Enum):
    convex_weiler_atherton = "ConvexWeilerAtherton"
    slater_barskyand_sutherland_hodgman = "SlaterBarskyandSutherlandHodgman"
    sutherland_hodgman = "SutherlandHodgman"


class SkyDiffuseModelingAlgorithm(Enum):
    detailed_sky_diffuse_modeling = "DetailedSkyDiffuseModeling"
    simple_sky_diffuse_modeling = "SimpleSkyDiffuseModeling"


class ShadingZoneGroup(BaseModel):
    shading_zone_group_zonelist_name: Optional[str] = None


class Algorithm(Enum):
    astmc1340 = "ASTMC1340"
    adaptive_convection_algorithm = "AdaptiveConvectionAlgorithm"
    ceiling_diffuser = "CeilingDiffuser"
    simple = "Simple"
    tarp = "TARP"


class SurfaceConvectionAlgorithmInside(BaseModel):
    algorithm: Optional[Algorithm] = Algorithm.tarp


class Algorithm1(Enum):
    adaptive_convection_algorithm = "AdaptiveConvectionAlgorithm"
    doe_2 = "DOE-2"
    mo_wi_tt = "MoWiTT"
    simple_combined = "SimpleCombined"
    tarp = "TARP"


class SurfaceConvectionAlgorithmOutside(BaseModel):
    algorithm: Optional[Algorithm1] = Algorithm1.doe_2


class Algorithm2(Enum):
    combined_heat_and_moisture_finite_element = "CombinedHeatAndMoistureFiniteElement"
    conduction_finite_difference = "ConductionFiniteDifference"
    conduction_transfer_function = "ConductionTransferFunction"
    moisture_penetration_depth_conduction_transfer_function = (
        "MoisturePenetrationDepthConductionTransferFunction"
    )


class HeatBalanceAlgorithm(BaseModel):
    algorithm: Optional[Algorithm2] = Algorithm2.conduction_transfer_function
    surface_temperature_upper_limit: Annotated[Optional[float], Field(200.0, ge=200.0)]
    minimum_surface_convection_heat_transfer_coefficient_value: Annotated[
        Optional[float], Field(0.1, gt=0.0)
    ]
    maximum_surface_convection_heat_transfer_coefficient_value: Annotated[
        Optional[float], Field(1000.0, ge=1.0)
    ]


class Algorithm3(Enum):
    analytical_solution = "AnalyticalSolution"
    euler_method = "EulerMethod"
    third_order_backward_difference = "ThirdOrderBackwardDifference"


class ZoneCapacitanceMultiplierResearchSpecial(BaseModel):
    zone_or_zonelist_name: Optional[str] = None
    temperature_capacity_multiplier: Annotated[Optional[float], Field(1.0, gt=0.0)]
    humidity_capacity_multiplier: Annotated[Optional[float], Field(1.0, gt=0.0)]
    carbon_dioxide_capacity_multiplier: Annotated[Optional[float], Field(1.0, gt=0.0)]
    generic_contaminant_capacity_multiplier: Annotated[
        Optional[float], Field(1.0, gt=0.0)
    ]


class Timestep(BaseModel):
    number_of_timesteps_per_hour: Annotated[Optional[int], Field(6, ge=1, le=60)]


class ConvergenceLimits(BaseModel):
    minimum_system_timestep: Annotated[Optional[int], Field(None, ge=0, le=60)]
    maximum_hvac_iterations: Annotated[Optional[int], Field(20, ge=1)]
    minimum_plant_iterations: Annotated[Optional[int], Field(2, ge=1)]
    maximum_plant_iterations: Annotated[Optional[int], Field(8, ge=2)]


class SiteLocation(BaseModel):
    latitude: Annotated[Optional[float], Field(0.0, ge=-90.0, le=90.0)]
    longitude: Annotated[Optional[float], Field(0.0, ge=-180.0, le=180.0)]
    time_zone: Annotated[Optional[float], Field(0.0, ge=-12.0, le=14.0)]
    elevation: Annotated[Optional[float], Field(0.0, ge=-300.0, lt=8900.0)]


class DayType(Enum):
    custom_day1 = "CustomDay1"
    custom_day2 = "CustomDay2"
    friday = "Friday"
    holiday = "Holiday"
    monday = "Monday"
    saturday = "Saturday"
    summer_design_day = "SummerDesignDay"
    sunday = "Sunday"
    thursday = "Thursday"
    tuesday = "Tuesday"
    wednesday = "Wednesday"
    winter_design_day = "WinterDesignDay"


class DryBulbTemperatureRangeModifierType(Enum):
    default_multipliers = "DefaultMultipliers"
    difference_schedule = "DifferenceSchedule"
    multiplier_schedule = "MultiplierSchedule"
    temperature_profile_schedule = "TemperatureProfileSchedule"


class HumidityConditionType(Enum):
    dew_point = "DewPoint"
    enthalpy = "Enthalpy"
    humidity_ratio = "HumidityRatio"
    relative_humidity_schedule = "RelativeHumiditySchedule"
    wet_bulb = "WetBulb"
    wet_bulb_profile_default_multipliers = "WetBulbProfileDefaultMultipliers"
    wet_bulb_profile_difference_schedule = "WetBulbProfileDifferenceSchedule"
    wet_bulb_profile_multiplier_schedule = "WetBulbProfileMultiplierSchedule"


class SolarModelIndicator(Enum):
    ashrae_clear_sky = "ASHRAEClearSky"
    ashrae_tau = "ASHRAETau"
    ashrae_tau2017 = "ASHRAETau2017"
    schedule = "Schedule"
    zhang_huang = "ZhangHuang"


class BeginEnvironmentResetMode(Enum):
    full_reset_at_begin_environment = "FullResetAtBeginEnvironment"
    suppress_all_begin_environment_resets = "SuppressAllBeginEnvironmentResets"


class DayOfWeekForStartDay(Enum):
    friday = "Friday"
    monday = "Monday"
    saturday = "Saturday"
    sunday = "Sunday"
    thursday = "Thursday"
    tuesday = "Tuesday"
    wednesday = "Wednesday"


class FirstHourInterpolationStartingValues(Enum):
    hour1 = "Hour1"
    hour24 = "Hour24"


class SpecialDayType(Enum):
    custom_day1 = "CustomDay1"
    custom_day2 = "CustomDay2"
    holiday = "Holiday"
    summer_design_day = "SummerDesignDay"
    winter_design_day = "WinterDesignDay"


class RunPeriodControlSpecialDays(BaseModel):
    start_date: str
    duration: Annotated[Optional[float], Field(1.0, ge=1.0, le=366.0)]
    special_day_type: Optional[SpecialDayType] = SpecialDayType.holiday


class RunPeriodControlDaylightSavingTime(BaseModel):
    start_date: str
    end_date: str


class SiteGroundTemperatureBuildingSurface(BaseModel):
    january_ground_temperature: Optional[float] = 18.0
    february_ground_temperature: Optional[float] = 18.0
    march_ground_temperature: Optional[float] = 18.0
    april_ground_temperature: Optional[float] = 18.0
    may_ground_temperature: Optional[float] = 18.0
    june_ground_temperature: Optional[float] = 18.0
    july_ground_temperature: Optional[float] = 18.0
    august_ground_temperature: Optional[float] = 18.0
    september_ground_temperature: Optional[float] = 18.0
    october_ground_temperature: Optional[float] = 18.0
    november_ground_temperature: Optional[float] = 18.0
    december_ground_temperature: Optional[float] = 18.0


class SiteGroundTemperatureFCfactorMethod(BaseModel):
    january_ground_temperature: Optional[float] = 13.0
    february_ground_temperature: Optional[float] = 13.0
    march_ground_temperature: Optional[float] = 13.0
    april_ground_temperature: Optional[float] = 13.0
    may_ground_temperature: Optional[float] = 13.0
    june_ground_temperature: Optional[float] = 13.0
    july_ground_temperature: Optional[float] = 13.0
    august_ground_temperature: Optional[float] = 13.0
    september_ground_temperature: Optional[float] = 13.0
    october_ground_temperature: Optional[float] = 13.0
    november_ground_temperature: Optional[float] = 13.0
    december_ground_temperature: Optional[float] = 13.0


class CalculationMethod(Enum):
    correlation = "Correlation"
    correlation_from_weather_file = "CorrelationFromWeatherFile"
    schedule = "Schedule"


class SiteWaterMainsTemperature(BaseModel):
    calculation_method: Optional[CalculationMethod] = (
        CalculationMethod.correlation_from_weather_file
    )
    temperature_schedule_name: Optional[str] = None
    annual_average_outdoor_air_temperature: Optional[float] = None
    maximum_difference_in_monthly_average_outdoor_air_temperatures: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]


class NumericType(Enum):
    continuous = "Continuous"
    discrete = "Discrete"


class UnitType(Enum):
    activity_level = "ActivityLevel"
    angle = "Angle"
    availability = "Availability"
    capacity = "Capacity"
    control = "Control"
    convection_coefficient = "ConvectionCoefficient"
    delta_temperature = "DeltaTemperature"
    dimensionless = "Dimensionless"
    mode = "Mode"
    percent = "Percent"
    power = "Power"
    precipitation_rate = "PrecipitationRate"
    temperature = "Temperature"
    velocity = "Velocity"


class ScheduleTypeLimits(BaseModel):
    lower_limit_value: Optional[float] = None
    upper_limit_value: Optional[float] = None
    numeric_type: Optional[NumericType] = None
    unit_type: Optional[UnitType] = UnitType.dimensionless


class ScheduleDayHourly(BaseModel):
    schedule_type_limits_name: Optional[str] = None
    hour_1: Optional[float] = 0.0
    hour_2: Optional[float] = 0.0
    hour_3: Optional[float] = 0.0
    hour_4: Optional[float] = 0.0
    hour_5: Optional[float] = 0.0
    hour_6: Optional[float] = 0.0
    hour_7: Optional[float] = 0.0
    hour_8: Optional[float] = 0.0
    hour_9: Optional[float] = 0.0
    hour_10: Optional[float] = 0.0
    hour_11: Optional[float] = 0.0
    hour_12: Optional[float] = 0.0
    hour_13: Optional[float] = 0.0
    hour_14: Optional[float] = 0.0
    hour_15: Optional[float] = 0.0
    hour_16: Optional[float] = 0.0
    hour_17: Optional[float] = 0.0
    hour_18: Optional[float] = 0.0
    hour_19: Optional[float] = 0.0
    hour_20: Optional[float] = 0.0
    hour_21: Optional[float] = 0.0
    hour_22: Optional[float] = 0.0
    hour_23: Optional[float] = 0.0
    hour_24: Optional[float] = 0.0


class InterpolateToTimestep(Enum):
    average = "Average"
    linear = "Linear"
    no = "No"


class Datum(BaseModel):
    time: Optional[str] = None
    value_until_time: Optional[float] = None


class ScheduleDayInterval(BaseModel):
    schedule_type_limits_name: Optional[str] = None
    interpolate_to_timestep: Optional[InterpolateToTimestep] = InterpolateToTimestep.no
    data: Optional[List[Datum]] = None


class ScheduleWeekDaily(BaseModel):
    sunday_schedule_day_name: str
    monday_schedule_day_name: str
    tuesday_schedule_day_name: str
    wednesday_schedule_day_name: str
    thursday_schedule_day_name: str
    friday_schedule_day_name: str
    saturday_schedule_day_name: str
    holiday_schedule_day_name: str
    summerdesignday_schedule_day_name: str
    winterdesignday_schedule_day_name: str
    customday1_schedule_day_name: str
    customday2_schedule_day_name: str


class ScheduleWeek(BaseModel):
    schedule_week_name: str
    start_month: Annotated[int, Field(ge=1, le=12)]
    start_day: Annotated[int, Field(ge=1, le=31)]
    end_month: Annotated[int, Field(ge=1, le=12)]
    end_day: Annotated[int, Field(ge=1, le=31)]


class ScheduleYear(BaseModel):
    schedule_type_limits_name: Optional[str] = None
    schedule_weeks: Annotated[
        Optional[List[ScheduleWeek]], Field(None, max_length=53, min_length=1)
    ]


class Datum1(BaseModel):
    field: Optional[Union[float, str]] = None


class ScheduleCompact(BaseModel):
    schedule_type_limits_name: Optional[str] = None
    data: Optional[List[Datum1]] = None


class ScheduleConstant(BaseModel):
    schedule_type_limits_name: Optional[str] = None
    hourly_value: Optional[float] = 0.0


class Roughness(Enum):
    medium_rough = "MediumRough"
    medium_smooth = "MediumSmooth"
    rough = "Rough"
    smooth = "Smooth"
    very_rough = "VeryRough"
    very_smooth = "VerySmooth"


class Material(BaseModel):
    roughness: Roughness
    thickness: Annotated[float, Field(gt=0.0)]
    conductivity: Annotated[float, Field(gt=0.0)]
    density: Annotated[float, Field(gt=0.0)]
    specific_heat: Annotated[float, Field(ge=100.0)]
    thermal_absorptance: Annotated[Optional[float], Field(0.9, gt=0.0, le=0.99999)]
    solar_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]
    visible_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]


class MaterialNoMass(BaseModel):
    roughness: Roughness
    thermal_resistance: Annotated[float, Field(ge=0.001)]
    thermal_absorptance: Annotated[Optional[float], Field(0.9, gt=0.0, le=0.99999)]
    solar_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]
    visible_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]


class MaterialAirGap(BaseModel):
    thermal_resistance: Annotated[float, Field(gt=0.0)]


class WindowMaterialSimpleGlazingSystem(BaseModel):
    u_factor: Annotated[float, Field(gt=0.0)]
    solar_heat_gain_coefficient: Annotated[float, Field(gt=0.0, lt=1.0)]
    visible_transmittance: Annotated[Optional[float], Field(None, gt=0.0, lt=1.0)]


class OpticalDataType(Enum):
    bsdf = "BSDF"
    spectral = "Spectral"
    spectral_and_angle = "SpectralAndAngle"
    spectral_average = "SpectralAverage"


class GasType(Enum):
    air = "Air"
    argon = "Argon"
    custom = "Custom"
    krypton = "Krypton"
    xenon = "Xenon"


class WindowMaterialGas(BaseModel):
    gas_type: GasType
    thickness: Annotated[float, Field(gt=0.0)]
    conductivity_coefficient_a: Optional[float] = None
    conductivity_coefficient_b: Optional[float] = None
    conductivity_coefficient_c: Optional[float] = None
    viscosity_coefficient_a: Annotated[Optional[float], Field(None, gt=0.0)]
    viscosity_coefficient_b: Optional[float] = None
    viscosity_coefficient_c: Optional[float] = None
    specific_heat_coefficient_a: Annotated[Optional[float], Field(None, gt=0.0)]
    specific_heat_coefficient_b: Optional[float] = None
    specific_heat_coefficient_c: Optional[float] = None
    molecular_weight: Annotated[Optional[float], Field(None, ge=20.0, le=200.0)]
    specific_heat_ratio: Annotated[Optional[float], Field(None, gt=1.0)]


class WindowGapSupportPillar(BaseModel):
    spacing: Annotated[Optional[float], Field(0.04, gt=0.0)]
    radius: Annotated[Optional[float], Field(0.0004, gt=0.0)]


class WindowGapDeflectionState(BaseModel):
    deflected_thickness: Annotated[Optional[float], Field(0.0, ge=0.0)]
    initial_temperature: Annotated[Optional[float], Field(25.0, ge=0.0)]
    initial_pressure: Annotated[Optional[float], Field(101325.0, ge=0.0)]


class Gas1Type(Enum):
    air = "Air"
    argon = "Argon"
    krypton = "Krypton"
    xenon = "Xenon"


class WindowMaterialGasMixture(BaseModel):
    thickness: Annotated[float, Field(gt=0.0)]
    number_of_gases_in_mixture: Annotated[int, Field(ge=1, le=4)]
    gas_1_type: Gas1Type
    gas_1_fraction: Annotated[float, Field(gt=0.0, le=1.0)]
    gas_2_type: Gas1Type
    gas_2_fraction: Annotated[float, Field(gt=0.0, le=1.0)]
    gas_3_type: Optional[Gas1Type] = None
    gas_3_fraction: Annotated[Optional[float], Field(None, gt=0.0, le=1.0)]
    gas_4_type: Optional[Gas1Type] = None
    gas_4_fraction: Annotated[Optional[float], Field(None, gt=0.0, le=1.0)]


class WindowMaterialGap(BaseModel):
    thickness: Annotated[float, Field(gt=0.0)]
    gas_or_gas_mixture_: str
    pressure: Optional[float] = 101325.0
    deflection_state: Optional[str] = None
    support_pillar: Optional[str] = None


class LayerType(Enum):
    bsdf = "BSDF"
    other_shading_type = "OtherShadingType"
    perforated = "Perforated"
    venetian_horizontal = "VenetianHorizontal"
    venetian_vertical = "VenetianVertical"
    woven = "Woven"


class WindowMaterialComplexShade(BaseModel):
    layer_type: Optional[LayerType] = LayerType.other_shading_type
    thickness: Annotated[Optional[float], Field(0.002, gt=0.0)]
    conductivity: Annotated[Optional[float], Field(1.0, gt=0.0)]
    ir_transmittance: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    front_emissivity: Annotated[Optional[float], Field(0.84, gt=0.0, le=1.0)]
    back_emissivity: Annotated[Optional[float], Field(0.84, gt=0.0, le=1.0)]
    top_opening_multiplier: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    bottom_opening_multiplier: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    left_side_opening_multiplier: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    right_side_opening_multiplier: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    front_opening_multiplier: Annotated[Optional[float], Field(0.05, ge=0.0, le=1.0)]
    slat_width: Annotated[Optional[float], Field(0.016, gt=0.0)]
    slat_spacing: Annotated[Optional[float], Field(0.012, gt=0.0)]
    slat_thickness: Annotated[Optional[float], Field(0.0006, gt=0.0)]
    slat_angle: Annotated[Optional[float], Field(90.0, ge=-90.0, le=90.0)]
    slat_conductivity: Annotated[Optional[float], Field(160.0, gt=0.0)]
    slat_curve: Annotated[Optional[float], Field(0.0, ge=0.0)]


class SlatOrientation(Enum):
    horizontal = "Horizontal"
    vertical = "Vertical"


class WindowMaterialBlind(BaseModel):
    slat_orientation: Optional[SlatOrientation] = SlatOrientation.horizontal
    slat_width: Annotated[float, Field(gt=0.0, le=1.0)]
    slat_separation: Annotated[float, Field(gt=0.0, le=1.0)]
    slat_thickness: Annotated[Optional[float], Field(0.00025, gt=0.0, le=0.1)]
    slat_angle: Annotated[Optional[float], Field(45.0, ge=0.0, le=180.0)]
    slat_conductivity: Annotated[Optional[float], Field(221.0, gt=0.0)]
    slat_beam_solar_transmittance: Annotated[
        Optional[float], Field(0.0, ge=0.0, lt=1.0)
    ]
    front_side_slat_beam_solar_reflectance: Annotated[float, Field(ge=0.0, lt=1.0)]
    back_side_slat_beam_solar_reflectance: Annotated[float, Field(ge=0.0, lt=1.0)]
    slat_diffuse_solar_transmittance: Annotated[
        Optional[float], Field(0.0, ge=0.0, lt=1.0)
    ]
    front_side_slat_diffuse_solar_reflectance: Annotated[float, Field(ge=0.0, lt=1.0)]
    back_side_slat_diffuse_solar_reflectance: Annotated[float, Field(ge=0.0, lt=1.0)]
    slat_beam_visible_transmittance: Annotated[float, Field(ge=0.0, lt=1.0)]
    front_side_slat_beam_visible_reflectance: Annotated[
        Optional[float], Field(None, ge=0.0, lt=1.0)
    ]
    back_side_slat_beam_visible_reflectance: Annotated[
        Optional[float], Field(None, ge=0.0, lt=1.0)
    ]
    slat_diffuse_visible_transmittance: Annotated[
        Optional[float], Field(0.0, ge=0.0, lt=1.0)
    ]
    front_side_slat_diffuse_visible_reflectance: Annotated[
        Optional[float], Field(None, ge=0.0, lt=1.0)
    ]
    back_side_slat_diffuse_visible_reflectance: Annotated[
        Optional[float], Field(None, ge=0.0, lt=1.0)
    ]
    slat_infrared_hemispherical_transmittance: Annotated[
        Optional[float], Field(0.0, ge=0.0, lt=1.0)
    ]
    front_side_slat_infrared_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.9, ge=0.0, lt=1.0)
    ]
    back_side_slat_infrared_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.9, ge=0.0, lt=1.0)
    ]
    blind_to_glass_distance: Annotated[Optional[float], Field(0.05, ge=0.01, le=1.0)]
    blind_top_opening_multiplier: Annotated[Optional[float], Field(0.5, ge=0.0, le=1.0)]
    blind_bottom_opening_multiplier: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    blind_left_side_opening_multiplier: Annotated[
        Optional[float], Field(0.5, ge=0.0, le=1.0)
    ]
    blind_right_side_opening_multiplier: Annotated[
        Optional[float], Field(0.5, ge=0.0, le=1.0)
    ]
    minimum_slat_angle: Annotated[Optional[float], Field(0.0, ge=0.0, le=180.0)]
    maximum_slat_angle: Annotated[Optional[float], Field(180.0, ge=0.0, le=180.0)]


class Construction(BaseModel):
    outside_layer: str
    layer_2: Optional[str] = None
    layer_3: Optional[str] = None
    layer_4: Optional[str] = None
    layer_5: Optional[str] = None
    layer_6: Optional[str] = None
    layer_7: Optional[str] = None
    layer_8: Optional[str] = None
    layer_9: Optional[str] = None
    layer_10: Optional[str] = None


class ConstructionCfactorUndergroundWall(BaseModel):
    c_factor: Annotated[float, Field(gt=0.0)]
    height: Annotated[float, Field(gt=0.0)]


class ConstructionFfactorGroundFloor(BaseModel):
    f_factor: Annotated[float, Field(gt=0.0)]
    area: Annotated[float, Field(gt=0.0)]
    perimeterexposed: Annotated[float, Field(ge=0.0)]


class Standard(Enum):
    en673_declared = "EN673Declared"
    en673_design = "EN673Design"
    iso15099 = "ISO15099"


class ThermalModel(Enum):
    convective_scalar_model_no_sd_thickness = "ConvectiveScalarModel_NoSDThickness"
    convective_scalar_model_with_sd_thickness = "ConvectiveScalarModel_withSDThickness"
    iso15099 = "ISO15099"
    scaled_cavity_width = "ScaledCavityWidth"


class DeflectionModel(Enum):
    measured_deflection = "MeasuredDeflection"
    no_deflection = "NoDeflection"
    temperature_and_pressure_input = "TemperatureAndPressureInput"


class WindowThermalModelParams(BaseModel):
    standard: Optional[Standard] = Standard.iso15099
    thermal_model: Optional[ThermalModel] = ThermalModel.iso15099
    sdscalar: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    deflection_model: Optional[DeflectionModel] = DeflectionModel.no_deflection
    vacuum_pressure_limit: Annotated[Optional[float], Field(13.238, gt=0.0)]
    initial_temperature: Annotated[Optional[float], Field(25.0, gt=0.0)]
    initial_pressure: Annotated[Optional[float], Field(101325.0, gt=0.0)]


class BasisType(Enum):
    lbnlwindow = "LBNLWINDOW"
    user_defined = "UserDefined"


class BasisSymmetryType(Enum):
    axisymmetric = "Axisymmetric"
    none = "None"


class ConstructionComplexFenestrationState(BaseModel):
    basis_type: Optional[BasisType] = BasisType.lbnlwindow
    basis_symmetry_type: Optional[BasisSymmetryType] = BasisSymmetryType.none
    window_thermal_model: str
    basis_matrix_name: str
    solar_optical_complex_front_transmittance_matrix_name: str
    solar_optical_complex_back_reflectance_matrix_name: str
    visible_optical_complex_front_transmittance_matrix_name: str
    visible_optical_complex_back_transmittance_matrix_name: str
    outside_layer_name: str
    outside_layer_directional_front_absorptance_matrix_name: str
    outside_layer_directional_back_absorptance_matrix_name: str
    gap_1_name: Optional[str] = None
    cfs_gap_1_directional_front_absorptance_matrix_name: Optional[str] = None
    cfs_gap_1_directional_back_absorptance_matrix_name: Optional[str] = None
    layer_2_name: Optional[str] = None
    layer_2_directional_front_absorptance_matrix_name: Optional[str] = None
    layer_2_directional_back_absorptance_matrix_name: Optional[str] = None
    gap_2_name: Optional[str] = None
    gap_2_directional_front_absorptance_matrix_name: Optional[str] = None
    gap_2_directional_back_absorptance_matrix_name: Optional[str] = None
    layer_3_name: Optional[str] = None
    layer_3_directional_front_absorptance_matrix_name: Optional[str] = None
    layer_3_directional_back_absorptance_matrix_name: Optional[str] = None
    gap_3_name: Optional[str] = None
    gap_3_directional_front_absorptance_matrix_name: Optional[str] = None
    gap_3_directional_back_absorptance_matrix_name: Optional[str] = None
    layer_4_name: Optional[str] = None
    layer_4_directional_front_absorptance_matrix_name: Optional[str] = None
    layer_4_directional_back_absorptance_matrix_name: Optional[str] = None
    gap_4_name: Optional[str] = None
    gap_4_directional_front_absorptance_matrix_name: Optional[str] = None
    gap_4_directional_back_absorptance_matrix_name: Optional[str] = None
    layer_5_name: Optional[str] = None
    layer_5_directional_front_absorptance_matrix_name: Optional[str] = None
    layer_5_directional_back_absorptance_matrix_name: Optional[str] = None


class StartingVertexPosition(Enum):
    lower_left_corner = "LowerLeftCorner"
    lower_right_corner = "LowerRightCorner"
    upper_left_corner = "UpperLeftCorner"
    upper_right_corner = "UpperRightCorner"


class VertexEntryDirection(Enum):
    clockwise = "Clockwise"
    counterclockwise = "Counterclockwise"


class CoordinateSystem(Enum):
    relative = "Relative"
    world = "World"


class GlobalGeometryRules(BaseModel):
    starting_vertex_position: StartingVertexPosition
    vertex_entry_direction: VertexEntryDirection
    coordinate_system: CoordinateSystem
    daylighting_reference_point_coordinate_system: Optional[CoordinateSystem] = (
        CoordinateSystem.relative
    )
    rectangular_surface_coordinate_system: Optional[CoordinateSystem] = (
        CoordinateSystem.relative
    )


class ZoneInsideConvectionAlgorithm(Enum):
    astmc1340 = "ASTMC1340"
    adaptive_convection_algorithm = "AdaptiveConvectionAlgorithm"
    ceiling_diffuser = "CeilingDiffuser"
    simple = "Simple"
    tarp = "TARP"
    trombe_wall = "TrombeWall"


class Zone1(BaseModel):
    zone_name: str


class ZoneList(BaseModel):
    zones: Optional[List[Zone1]] = None


class ZoneGroup(BaseModel):
    zone_list_name: str
    zone_list_multiplier: Annotated[Optional[int], Field(1, ge=1)]


class SurfaceType(Enum):
    ceiling = "Ceiling"
    floor = "Floor"
    roof = "Roof"
    wall = "Wall"


class OutsideBoundaryCondition(Enum):
    adiabatic = "Adiabatic"
    foundation = "Foundation"
    ground = "Ground"
    ground_basement_preprocessor_average_floor = (
        "GroundBasementPreprocessorAverageFloor"
    )
    ground_basement_preprocessor_average_wall = "GroundBasementPreprocessorAverageWall"
    ground_basement_preprocessor_lower_wall = "GroundBasementPreprocessorLowerWall"
    ground_basement_preprocessor_upper_wall = "GroundBasementPreprocessorUpperWall"
    ground_f_cfactor_method = "GroundFCfactorMethod"
    ground_slab_preprocessor_average = "GroundSlabPreprocessorAverage"
    ground_slab_preprocessor_core = "GroundSlabPreprocessorCore"
    ground_slab_preprocessor_perimeter = "GroundSlabPreprocessorPerimeter"
    other_side_coefficients = "OtherSideCoefficients"
    other_side_conditions_model = "OtherSideConditionsModel"
    outdoors = "Outdoors"
    surface = "Surface"
    zone = "Zone"


class SunExposure(Enum):
    no_sun = "NoSun"
    sun_exposed = "SunExposed"


class WindExposure(Enum):
    no_wind = "NoWind"
    wind_exposed = "WindExposed"


class ViewFactorToGround(RootModel[float]):
    root: Annotated[float, Field(ge=0.0, le=1.0)]


class NumberOfVertices(RootModel[float]):
    root: Annotated[float, Field(ge=3.0)]


class Vertice(BaseModel):
    vertex_x_coordinate: float
    vertex_y_coordinate: float
    vertex_z_coordinate: float


class BuildingSurfaceDetailed(BaseModel):
    surface_type: SurfaceType
    construction_name: str
    zone_name: str
    space_name: Optional[str] = None
    outside_boundary_condition: OutsideBoundaryCondition
    outside_boundary_condition_object: Optional[str] = None
    sun_exposure: Optional[SunExposure] = SunExposure.sun_exposed
    wind_exposure: Optional[WindExposure] = WindExposure.wind_exposed
    view_factor_to_ground: Optional[
        Union[ViewFactorToGround, Literal["Autocalculate"]]
    ] = "Autocalculate"
    number_of_vertices: Optional[Union[NumberOfVertices, Literal["Autocalculate"]]] = (
        "Autocalculate"
    )
    vertices: Optional[List[Vertice]] = None


class SurfaceType1(Enum):
    door = "Door"
    glass_door = "GlassDoor"
    tubular_daylight_diffuser = "TubularDaylightDiffuser"
    tubular_daylight_dome = "TubularDaylightDome"
    window = "Window"


class NumberOfVertices1(RootModel[float]):
    root: Annotated[float, Field(ge=3.0, le=4.0)]


class FenestrationSurfaceDetailed(BaseModel):
    surface_type: SurfaceType1
    construction_name: str
    building_surface_name: str
    outside_boundary_condition_object: Optional[str] = None
    view_factor_to_ground: Optional[
        Union[ViewFactorToGround, Literal["Autocalculate"]]
    ] = "Autocalculate"
    frame_and_divider_name: Optional[str] = None
    multiplier: Annotated[Optional[float], Field(1.0, ge=1.0)]
    number_of_vertices: Optional[Union[NumberOfVertices1, Literal["Autocalculate"]]] = (
        "Autocalculate"
    )
    vertex_1_x_coordinate: float
    vertex_1_y_coordinate: float
    vertex_1_z_coordinate: float
    vertex_2_x_coordinate: float
    vertex_2_y_coordinate: float
    vertex_2_z_coordinate: float
    vertex_3_x_coordinate: float
    vertex_3_y_coordinate: float
    vertex_3_z_coordinate: float
    vertex_4_x_coordinate: Optional[float] = None
    vertex_4_y_coordinate: Optional[float] = None
    vertex_4_z_coordinate: Optional[float] = None


class ShadingType(Enum):
    between_glass_blind = "BetweenGlassBlind"
    between_glass_shade = "BetweenGlassShade"
    exterior_blind = "ExteriorBlind"
    exterior_screen = "ExteriorScreen"
    exterior_shade = "ExteriorShade"
    interior_blind = "InteriorBlind"
    interior_shade = "InteriorShade"
    switchable_glazing = "SwitchableGlazing"


class ShadingControlType(Enum):
    always_off = "AlwaysOff"
    always_on = "AlwaysOn"
    meet_daylight_illuminance_setpoint = "MeetDaylightIlluminanceSetpoint"
    off_night_and_on_day_if_cooling_and_high_solar_on_window = (
        "OffNightAndOnDayIfCoolingAndHighSolarOnWindow"
    )
    on_if_high_glare = "OnIfHighGlare"
    on_if_high_horizontal_solar = "OnIfHighHorizontalSolar"
    on_if_high_outdoor_air_temp_and_high_horizontal_solar = (
        "OnIfHighOutdoorAirTempAndHighHorizontalSolar"
    )
    on_if_high_outdoor_air_temp_and_high_solar_on_window = (
        "OnIfHighOutdoorAirTempAndHighSolarOnWindow"
    )
    on_if_high_outdoor_air_temperature = "OnIfHighOutdoorAirTemperature"
    on_if_high_solar_on_window = "OnIfHighSolarOnWindow"
    on_if_high_solar_or_high_luminance_till_midnight = (
        "OnIfHighSolarOrHighLuminanceTillMidnight"
    )
    on_if_high_solar_or_high_luminance_till_next_morning = (
        "OnIfHighSolarOrHighLuminanceTillNextMorning"
    )
    on_if_high_solar_or_high_luminance_till_sunset = (
        "OnIfHighSolarOrHighLuminanceTillSunset"
    )
    on_if_high_zone_air_temp_and_high_horizontal_solar = (
        "OnIfHighZoneAirTempAndHighHorizontalSolar"
    )
    on_if_high_zone_air_temp_and_high_solar_on_window = (
        "OnIfHighZoneAirTempAndHighSolarOnWindow"
    )
    on_if_high_zone_air_temperature = "OnIfHighZoneAirTemperature"
    on_if_high_zone_cooling = "OnIfHighZoneCooling"
    on_if_schedule_allows = "OnIfScheduleAllows"
    on_night_and_on_day_if_cooling_and_high_solar_on_window = (
        "OnNightAndOnDayIfCoolingAndHighSolarOnWindow"
    )
    on_night_if_heating_and_off_day = "OnNightIfHeatingAndOffDay"
    on_night_if_heating_and_on_day_if_cooling = "OnNightIfHeatingAndOnDayIfCooling"
    on_night_if_low_inside_temp_and_off_day = "OnNightIfLowInsideTempAndOffDay"
    on_night_if_low_outdoor_temp_and_off_day = "OnNightIfLowOutdoorTempAndOffDay"
    on_night_if_low_outdoor_temp_and_on_day_if_cooling = (
        "OnNightIfLowOutdoorTempAndOnDayIfCooling"
    )


class TypeOfSlatAngleControlForBlinds(Enum):
    block_beam_solar = "BlockBeamSolar"
    fixed_slat_angle = "FixedSlatAngle"
    scheduled_slat_angle = "ScheduledSlatAngle"


class MultipleSurfaceControlType(Enum):
    group = "Group"
    sequential = "Sequential"


class FenestrationSurface(BaseModel):
    fenestration_surface_name: str


class DividerType(Enum):
    divided_lite = "DividedLite"
    suspended = "Suspended"


class NfrcProductTypeForAssemblyCalculations(Enum):
    casement_double = "CasementDouble"
    casement_single = "CasementSingle"
    curtain_wall = "CurtainWall"
    door_sidelite = "DoorSidelite"
    door_transom = "DoorTransom"
    dual_action = "DualAction"
    fixed = "Fixed"
    garage = "Garage"
    greenhouse = "Greenhouse"
    hinged_escape = "HingedEscape"
    horizontal_slider = "HorizontalSlider"
    jal = "Jal"
    pivoted = "Pivoted"
    projecting_dual = "ProjectingDual"
    projecting_single = "ProjectingSingle"
    side_hinged_door = "SideHingedDoor"
    skylight = "Skylight"
    sliding_patio_door = "SlidingPatioDoor"
    spandrel_panel = "SpandrelPanel"
    tropical_awning = "TropicalAwning"
    tubular_daylighting_device = "TubularDaylightingDevice"
    vertical_slider = "VerticalSlider"


class WindowPropertyFrameAndDivider(BaseModel):
    frame_width: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    frame_outside_projection: Annotated[Optional[float], Field(0.0, ge=0.0, le=0.5)]
    frame_inside_projection: Annotated[Optional[float], Field(0.0, ge=0.0, le=0.5)]
    frame_conductance: Annotated[Optional[float], Field(None, ge=0.0)]
    ratio_of_frame_edge_glass_conductance_to_center_of_glass_conductance: Annotated[
        Optional[float], Field(1.0, gt=0.0, le=4.0)
    ]
    frame_solar_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]
    frame_visible_absorptance: Annotated[Optional[float], Field(0.7, ge=0.0, le=1.0)]
    frame_thermal_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.9, gt=0.0)
    ]
    divider_type: Optional[DividerType] = DividerType.divided_lite
    divider_width: Annotated[Optional[float], Field(0.0, ge=0.0, le=0.5)]
    number_of_horizontal_dividers: Annotated[Optional[float], Field(0.0, ge=0.0)]
    number_of_vertical_dividers: Annotated[Optional[float], Field(0.0, ge=0.0)]
    divider_outside_projection: Annotated[Optional[float], Field(0.0, ge=0.0, le=0.5)]
    divider_inside_projection: Annotated[Optional[float], Field(0.0, ge=0.0, le=0.5)]
    divider_conductance: Annotated[Optional[float], Field(0.0, ge=0.0)]
    ratio_of_divider_edge_glass_conductance_to_center_of_glass_conductance: Annotated[
        Optional[float], Field(1.0, gt=0.0, le=4.0)
    ]
    divider_solar_absorptance: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    divider_visible_absorptance: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    divider_thermal_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.9, gt=0.0, lt=1.0)
    ]
    outside_reveal_solar_absorptance: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    inside_sill_depth: Annotated[Optional[float], Field(0.0, ge=0.0, le=2.0)]
    inside_sill_solar_absorptance: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    inside_reveal_depth: Annotated[Optional[float], Field(0.0, ge=0.0, le=2.0)]
    inside_reveal_solar_absorptance: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    nfrc_product_type_for_assembly_calculations: Optional[
        NfrcProductTypeForAssemblyCalculations
    ] = NfrcProductTypeForAssemblyCalculations.curtain_wall


class InternalMass(BaseModel):
    construction_name: str
    zone_or_zonelist_name: str
    space_or_spacelist_name: Optional[str] = None
    surface_area: Annotated[float, Field(gt=0.0)]


class NumberOfVertices2(NumberOfVertices):
    pass


class ShadingSiteDetailed(BaseModel):
    transmittance_schedule_name: Optional[str] = None
    number_of_vertices: Optional[Union[NumberOfVertices2, Literal["Autocalculate"]]] = (
        "Autocalculate"
    )
    vertices: Optional[List[Vertice]] = None


class ShadingBuildingDetailed(ShadingSiteDetailed):
    pass


class ShadingZoneDetailed(BaseModel):
    base_surface_name: str
    transmittance_schedule_name: Optional[str] = None
    number_of_vertices: Optional[Union[NumberOfVertices2, Literal["Autocalculate"]]] = (
        "Autocalculate"
    )
    vertices: Optional[List[Vertice]] = None


class ShadingPropertyReflectance(BaseModel):
    shading_surface_name: str
    diffuse_solar_reflectance_of_unglazed_part_of_shading_surface: Annotated[
        Optional[float], Field(0.2, ge=0.0, le=1.0)
    ]
    diffuse_visible_reflectance_of_unglazed_part_of_shading_surface: Annotated[
        Optional[float], Field(0.2, ge=0.0, le=1.0)
    ]
    fraction_of_shading_surface_that_is_glazed: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    glazing_construction_name: Optional[str] = None


class SurfacePropertySolarIncidentInside(BaseModel):
    surface_name: str
    construction_name: str
    inside_surface_incident_sun_solar_radiation_schedule_name: str


class ComplexFenestrationPropertySolarAbsorbedLayers(BaseModel):
    fenestration_surface: str
    construction_name: str
    layer_1_solar_radiation_absorbed_schedule_name: str
    layer_2_solar_radiation_absorbed_schedule_name: Optional[str] = None
    layer_3_solar_radiation_absorbed_schedule_name: Optional[str] = None
    layer_4_solar_radiation_absorbed_schedule_name: Optional[str] = None
    layer_5_solar_radiation_absorbed_schedule_name: Optional[str] = None


class NumberOfPeopleCalculationMethod(Enum):
    area_person = "Area/Person"
    people = "People"
    people_area = "People/Area"


class SensibleHeatFraction(ViewFactorToGround):
    pass


class MeanRadiantTemperatureCalculationType(Enum):
    angle_factor = "AngleFactor"
    surface_weighted = "SurfaceWeighted"
    zone_averaged = "ZoneAveraged"


class ClothingInsulationCalculationMethod(Enum):
    calculation_method_schedule = "CalculationMethodSchedule"
    clothing_insulation_schedule = "ClothingInsulationSchedule"
    dynamic_clothing_model_ashrae55 = "DynamicClothingModelASHRAE55"


class ThermalComfortModel1Type(Enum):
    adaptive_ash55 = "AdaptiveASH55"
    adaptive_cen15251 = "AdaptiveCEN15251"
    ankle_draft_ash55 = "AnkleDraftASH55"
    cooling_effect_ash55 = "CoolingEffectASH55"
    fanger = "Fanger"
    ksu = "KSU"
    pierce = "Pierce"


class DesignLevelCalculationMethod(Enum):
    lighting_level = "LightingLevel"
    watts_area = "Watts/Area"
    watts_person = "Watts/Person"


class DesignLevelCalculationMethod1(Enum):
    equipment_level = "EquipmentLevel"
    watts_area = "Watts/Area"
    watts_person = "Watts/Person"


class ElectricEquipment(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: str
    design_level_calculation_method: Optional[DesignLevelCalculationMethod1] = (
        DesignLevelCalculationMethod1.equipment_level
    )
    design_level: Annotated[Optional[float], Field(None, ge=0.0)]
    watts_per_zone_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    watts_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    fraction_latent: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_radiant: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_lost: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    end_use_subcategory: Optional[str] = "General"


class DesignLevelCalculationMethod2(Enum):
    equipment_level = "EquipmentLevel"
    power_area = "Power/Area"
    power_person = "Power/Person"
    watts_area = "Watts/Area"
    watts_person = "Watts/Person"


class GasEquipment(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: str
    design_level_calculation_method: Optional[DesignLevelCalculationMethod2] = (
        DesignLevelCalculationMethod2.equipment_level
    )
    design_level: Annotated[Optional[float], Field(None, ge=0.0)]
    power_per_zone_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    power_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    fraction_latent: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_radiant: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_lost: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    carbon_dioxide_generation_rate: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=4e-07)
    ]
    end_use_subcategory: Optional[str] = "General"


class FuelType(Enum):
    coal = "Coal"
    diesel = "Diesel"
    district_cooling = "DistrictCooling"
    district_heating_steam = "DistrictHeatingSteam"
    district_heating_water = "DistrictHeatingWater"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    none = "None"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"


class OtherEquipment(BaseModel):
    fuel_type: Optional[FuelType] = FuelType.none
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: str
    design_level_calculation_method: Optional[DesignLevelCalculationMethod2] = (
        DesignLevelCalculationMethod2.equipment_level
    )
    design_level: Optional[float] = None
    power_per_zone_floor_area: Optional[float] = None
    power_per_person: Optional[float] = None
    fraction_latent: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_radiant: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_lost: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    carbon_dioxide_generation_rate: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=4e-07)
    ]
    end_use_subcategory: Optional[str] = "General"


class DaylightingMethod(Enum):
    d_elight = "DElight"
    split_flux = "SplitFlux"


class LightingControlType(Enum):
    continuous = "Continuous"
    continuous_off = "ContinuousOff"
    stepped = "Stepped"


class ControlDatum(BaseModel):
    daylighting_reference_point_name: str
    fraction_of_lights_controlled_by_reference_point: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    illuminance_setpoint_at_reference_point: Annotated[
        Optional[float], Field(500.0, ge=0.0)
    ]


class DaylightingControls(BaseModel):
    zone_or_space_name: str
    daylighting_method: Optional[DaylightingMethod] = DaylightingMethod.split_flux
    availability_schedule_name: Optional[str] = None
    lighting_control_type: Optional[LightingControlType] = (
        LightingControlType.continuous
    )
    minimum_input_power_fraction_for_continuous_or_continuousoff_dimming_control: (
        Annotated[Optional[float], Field(0.3, ge=0.0, le=0.6)]
    )
    minimum_light_output_fraction_for_continuous_or_continuousoff_dimming_control: (
        Annotated[Optional[float], Field(0.2, ge=0.0, le=0.6)]
    )
    number_of_stepped_control_steps: Annotated[Optional[int], Field(1, ge=1)]
    probability_lighting_will_be_reset_when_needed_in_manual_stepped_control: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    glare_calculation_daylighting_reference_point_name: Optional[str] = None
    glare_calculation_azimuth_angle_of_view_direction_clockwise_from_zone_y_axis: (
        Annotated[Optional[float], Field(0.0, ge=0.0, le=360.0)]
    )
    maximum_allowable_discomfort_glare_index: Annotated[
        Optional[float], Field(22.0, ge=1.0)
    ]
    delight_gridding_resolution: Annotated[Optional[float], Field(None, gt=0.0)]
    control_data: Optional[List[ControlDatum]] = None


class DaylightingReferencePoint(BaseModel):
    zone_or_space_name: str
    x_coordinate_of_reference_point: float
    y_coordinate_of_reference_point: float
    z_coordinate_of_reference_point: Optional[float] = 0.8


class DesignFlowRateCalculationMethod(Enum):
    air_changes_hour = "AirChanges/Hour"
    flow_area = "Flow/Area"
    flow_exterior_area = "Flow/ExteriorArea"
    flow_exterior_wall_area = "Flow/ExteriorWallArea"
    flow_zone = "Flow/Zone"


class ZoneInfiltrationDesignFlowRate(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: Optional[str] = None
    design_flow_rate_calculation_method: Optional[DesignFlowRateCalculationMethod] = (
        DesignFlowRateCalculationMethod.flow_zone
    )
    design_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_exterior_surface_area: Annotated[Optional[float], Field(None, ge=0.0)]
    air_changes_per_hour: Annotated[Optional[float], Field(None, ge=0.0)]
    constant_term_coefficient: Optional[float] = 1.0
    temperature_term_coefficient: Optional[float] = 0.0
    velocity_term_coefficient: Optional[float] = 0.0
    velocity_squared_term_coefficient: Optional[float] = 0.0


class DesignFlowRateCalculationMethod1(Enum):
    air_changes_hour = "AirChanges/Hour"
    flow_area = "Flow/Area"
    flow_person = "Flow/Person"
    flow_zone = "Flow/Zone"


class VentilationType(Enum):
    balanced = "Balanced"
    exhaust = "Exhaust"
    intake = "Intake"
    natural = "Natural"


class ZoneVentilationDesignFlowRate(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: Optional[str] = None
    design_flow_rate_calculation_method: Optional[DesignFlowRateCalculationMethod1] = (
        DesignFlowRateCalculationMethod1.flow_zone
    )
    design_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    air_changes_per_hour: Annotated[Optional[float], Field(None, ge=0.0)]
    ventilation_type: Optional[VentilationType] = VentilationType.natural
    fan_pressure_rise: Annotated[Optional[float], Field(0.0, ge=0.0)]
    fan_total_efficiency: Annotated[Optional[float], Field(1.0, gt=0.0)]
    constant_term_coefficient: Optional[float] = 1.0
    temperature_term_coefficient: Optional[float] = 0.0
    velocity_term_coefficient: Optional[float] = 0.0
    velocity_squared_term_coefficient: Optional[float] = 0.0
    minimum_indoor_temperature: Annotated[
        Optional[float], Field(-100.0, ge=-100.0, le=100.0)
    ]
    minimum_indoor_temperature_schedule_name: Optional[str] = None
    maximum_indoor_temperature: Annotated[
        Optional[float], Field(100.0, ge=-100.0, le=100.0)
    ]
    maximum_indoor_temperature_schedule_name: Optional[str] = None
    delta_temperature: Annotated[Optional[float], Field(-100.0, ge=-100.0)]
    delta_temperature_schedule_name: Optional[str] = None
    minimum_outdoor_temperature: Annotated[
        Optional[float], Field(-100.0, ge=-100.0, le=100.0)
    ]
    minimum_outdoor_temperature_schedule_name: Optional[str] = None
    maximum_outdoor_temperature: Annotated[
        Optional[float], Field(100.0, ge=-100.0, le=100.0)
    ]
    maximum_outdoor_temperature_schedule_name: Optional[str] = None
    maximum_wind_speed: Annotated[Optional[float], Field(40.0, ge=0.0, le=40.0)]


class OpeningEffectiveness(ViewFactorToGround):
    pass


class DischargeCoefficientForOpening(ViewFactorToGround):
    pass


class ZoneVentilationWindandStackOpenArea(BaseModel):
    zone_or_space_name: str
    opening_area: Annotated[Optional[float], Field(0.0, ge=0.0)]
    opening_area_fraction_schedule_name: Optional[str] = None
    opening_effectiveness: Optional[
        Union[OpeningEffectiveness, Literal["Autocalculate"]]
    ] = "Autocalculate"
    effective_angle: Annotated[Optional[float], Field(0.0, ge=0.0, lt=360.0)]
    height_difference: Annotated[Optional[float], Field(0.0, ge=0.0)]
    discharge_coefficient_for_opening: Optional[
        Union[DischargeCoefficientForOpening, Literal["Autocalculate"]]
    ] = "Autocalculate"
    minimum_indoor_temperature: Annotated[
        Optional[float], Field(-100.0, ge=-100.0, le=100.0)
    ]
    minimum_indoor_temperature_schedule_name: Optional[str] = None
    maximum_indoor_temperature: Annotated[
        Optional[float], Field(100.0, ge=-100.0, le=100.0)
    ]
    maximum_indoor_temperature_schedule_name: Optional[str] = None
    delta_temperature: Annotated[Optional[float], Field(-100.0, ge=-100.0)]
    delta_temperature_schedule_name: Optional[str] = None
    minimum_outdoor_temperature: Annotated[
        Optional[float], Field(-100.0, ge=-100.0, le=100.0)
    ]
    minimum_outdoor_temperature_schedule_name: Optional[str] = None
    maximum_outdoor_temperature: Annotated[
        Optional[float], Field(100.0, ge=-100.0, le=100.0)
    ]
    maximum_outdoor_temperature_schedule_name: Optional[str] = None
    maximum_wind_speed: Annotated[Optional[float], Field(40.0, ge=0.0, le=40.0)]


class ZoneMixing(BaseModel):
    zone_or_space_name: str
    schedule_name: Optional[str] = None
    design_flow_rate_calculation_method: Optional[DesignFlowRateCalculationMethod1] = (
        DesignFlowRateCalculationMethod1.flow_zone
    )
    design_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    flow_rate_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    air_changes_per_hour: Annotated[Optional[float], Field(None, ge=0.0)]
    source_zone_or_space_name: str
    delta_temperature: Optional[float] = 0.0
    delta_temperature_schedule_name: Optional[str] = None
    minimum_receiving_temperature_schedule_name: Optional[str] = None
    maximum_receiving_temperature_schedule_name: Optional[str] = None
    minimum_source_temperature_schedule_name: Optional[str] = None
    maximum_source_temperature_schedule_name: Optional[str] = None
    minimum_outdoor_temperature_schedule_name: Optional[str] = None
    maximum_outdoor_temperature_schedule_name: Optional[str] = None


class DoorProtectionType(Enum):
    air_curtain = "AirCurtain"
    none = "None"
    strip_curtain = "StripCurtain"


class ZoneRefrigerationDoorMixing(BaseModel):
    zone_1_name: str
    zone_2_name: str
    schedule_name: str
    door_height: Annotated[Optional[float], Field(3.0, ge=0.0, le=50.0)]
    door_area: Annotated[Optional[float], Field(9.0, ge=0.0, le=400.0)]
    door_protection_type: Optional[DoorProtectionType] = DoorProtectionType.none


class AirflowNetworkMultiZoneSurfaceEffectiveLeakageArea(BaseModel):
    effective_leakage_area: Annotated[float, Field(gt=0.0)]
    discharge_coefficient: Annotated[Optional[float], Field(1.0, gt=0.0)]
    reference_pressure_difference: Annotated[Optional[float], Field(4.0, gt=0.0)]
    air_mass_flow_exponent: Annotated[Optional[float], Field(0.65, ge=0.5, le=1.0)]


class ControlOption(Enum):
    astronomical_clock = "AstronomicalClock"
    schedule_name_only = "ScheduleNameOnly"


class ExteriorLights(BaseModel):
    schedule_name: str
    design_level: Annotated[float, Field(ge=0.0)]
    control_option: Optional[ControlOption] = None
    end_use_subcategory: Optional[str] = "General"


class FuelUseType(Enum):
    coal = "Coal"
    diesel = "Diesel"
    district_cooling = "DistrictCooling"
    district_heating_steam = "DistrictHeatingSteam"
    district_heating_water = "DistrictHeatingWater"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"
    water = "Water"


class ExteriorFuelEquipment(BaseModel):
    fuel_use_type: FuelUseType
    schedule_name: str
    design_level: Annotated[float, Field(ge=0.0)]
    end_use_subcategory: Optional[str] = "General"


class OutdoorAirMethod(Enum):
    air_changes_hour = "AirChanges/Hour"
    flow_area = "Flow/Area"
    flow_person = "Flow/Person"
    flow_zone = "Flow/Zone"
    indoor_air_quality_procedure = "IndoorAirQualityProcedure"
    maximum = "Maximum"
    proportional_control_based_on_design_occupancy = (
        "ProportionalControlBasedOnDesignOccupancy"
    )
    proportional_control_based_on_occupancy_schedule = (
        "ProportionalControlBasedOnOccupancySchedule"
    )
    sum = "Sum"


class DesignSpecificationOutdoorAir(BaseModel):
    outdoor_air_method: Optional[OutdoorAirMethod] = OutdoorAirMethod.flow_person
    outdoor_air_flow_per_person: Annotated[Optional[float], Field(0.00944, ge=0.0)]
    outdoor_air_flow_per_zone_floor_area: Annotated[Optional[float], Field(0.0, ge=0.0)]
    outdoor_air_flow_per_zone: Annotated[Optional[float], Field(0.0, ge=0.0)]
    outdoor_air_flow_air_changes_per_hour: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    outdoor_air_schedule_name: Optional[str] = None
    proportional_control_minimum_outdoor_air_flow_rate_schedule_name: Optional[str] = (
        None
    )


class DesignSpecificationZoneAirDistribution(BaseModel):
    zone_air_distribution_effectiveness_in_cooling_mode: Annotated[
        Optional[float], Field(1.0, gt=0.0)
    ]
    zone_air_distribution_effectiveness_in_heating_mode: Annotated[
        Optional[float], Field(1.0, gt=0.0)
    ]
    zone_air_distribution_effectiveness_schedule_name: Optional[str] = None
    zone_secondary_recirculation_fraction: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    minimum_zone_ventilation_efficiency: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]


class SizingParameters(BaseModel):
    heating_sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    cooling_sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    timesteps_in_averaging_window: Annotated[Optional[int], Field(None, ge=1)]


class ZoneCoolingDesignSupplyAirTemperatureInputMethod(Enum):
    supply_air_temperature = "SupplyAirTemperature"
    temperature_difference = "TemperatureDifference"


class CoolingDesignAirFlowMethod(Enum):
    design_day = "DesignDay"
    design_day_with_limit = "DesignDayWithLimit"
    flow_zone = "Flow/Zone"


class DedicatedOutdoorAirSystemControlStrategy(Enum):
    cold_supply_air = "ColdSupplyAir"
    neutral_dehumidified_supply_air = "NeutralDehumidifiedSupplyAir"
    neutral_supply_air = "NeutralSupplyAir"


class ZoneLoadSizingMethod(Enum):
    latent_load = "Latent Load"
    sensible_and_latent_load = "Sensible And Latent Load"
    sensible_load = "Sensible Load"
    sensible_load_only_no_latent_load = "Sensible Load Only No Latent Load"


class ZoneLatentCoolingDesignSupplyAirHumidityRatioInputMethod(Enum):
    humidity_ratio_difference = "HumidityRatioDifference"
    supply_air_humidity_ratio = "SupplyAirHumidityRatio"


class TypeOfLoadToSizeOn(Enum):
    latent = "Latent"
    sensible = "Sensible"
    total = "Total"
    ventilation_requirement = "VentilationRequirement"


class DesignOutdoorAirFlowRate(RootModel[float]):
    root: Annotated[float, Field(ge=0.0)]


class CentralHeatingMaximumSystemAirFlowRatio(ViewFactorToGround):
    pass


class TypeOfZoneSumToUse(Enum):
    coincident = "Coincident"
    non_coincident = "NonCoincident"


class CoolingSupplyAirFlowRateMethod(Enum):
    design_day = "DesignDay"
    flow_system = "Flow/System"
    flow_per_cooling_capacity = "FlowPerCoolingCapacity"
    flow_per_floor_area = "FlowPerFloorArea"
    fraction_of_autosized_cooling_airflow = "FractionOfAutosizedCoolingAirflow"


class HeatingSupplyAirFlowRateMethod(Enum):
    design_day = "DesignDay"
    flow_system = "Flow/System"
    flow_per_floor_area = "FlowPerFloorArea"
    flow_per_heating_capacity = "FlowPerHeatingCapacity"
    fraction_of_autosized_cooling_airflow = "FractionOfAutosizedCoolingAirflow"
    fraction_of_autosized_heating_airflow = "FractionOfAutosizedHeatingAirflow"


class SystemOutdoorAirMethod(Enum):
    standard62_1_simplified_procedure = "Standard62.1SimplifiedProcedure"
    standard62_1_ventilation_rate_procedure = "Standard62.1VentilationRateProcedure"
    zone_sum = "ZoneSum"


class CoolingDesignCapacityMethod(Enum):
    capacity_per_floor_area = "CapacityPerFloorArea"
    cooling_design_capacity = "CoolingDesignCapacity"
    fraction_of_autosized_cooling_capacity = "FractionOfAutosizedCoolingCapacity"
    none = "None"


class CoolingDesignCapacity(DesignOutdoorAirFlowRate):
    pass


class HeatingDesignCapacityMethod(Enum):
    capacity_per_floor_area = "CapacityPerFloorArea"
    fraction_of_autosized_heating_capacity = "FractionOfAutosizedHeatingCapacity"
    heating_design_capacity = "HeatingDesignCapacity"
    none = "None"


class HeatingDesignCapacity(DesignOutdoorAirFlowRate):
    pass


class CentralCoolingCapacityControlMethod(Enum):
    bypass = "Bypass"
    on_off = "OnOff"
    vav = "VAV"
    vt = "VT"


class OccupantDiversity(ViewFactorToGround):
    pass


class LoopType(Enum):
    condenser = "Condenser"
    cooling = "Cooling"
    heating = "Heating"
    steam = "Steam"


class CoincidentSizingFactorMode(Enum):
    global_cooling_sizing_factor = "GlobalCoolingSizingFactor"
    global_heating_sizing_factor = "GlobalHeatingSizingFactor"
    loop_component_sizing_factor = "LoopComponentSizingFactor"
    none = "None"


class SizingPlant(BaseModel):
    plant_or_condenser_loop_name: str
    loop_type: LoopType
    design_loop_exit_temperature: float
    loop_design_temperature_difference: Annotated[float, Field(gt=0.0)]
    sizing_option: Optional[TypeOfZoneSumToUse] = TypeOfZoneSumToUse.non_coincident
    zone_timesteps_in_averaging_window: Annotated[Optional[int], Field(1, ge=1)]
    coincident_sizing_factor_mode: Optional[CoincidentSizingFactorMode] = None


class ZoneControlHumidistat(BaseModel):
    zone_name: str
    humidifying_relative_humidity_setpoint_schedule_name: str
    dehumidifying_relative_humidity_setpoint_schedule_name: Optional[str] = None


class Control1ObjectType(Enum):
    thermostat_setpoint_dual_setpoint = "ThermostatSetpoint:DualSetpoint"
    thermostat_setpoint_single_cooling = "ThermostatSetpoint:SingleCooling"
    thermostat_setpoint_single_heating = "ThermostatSetpoint:SingleHeating"
    thermostat_setpoint_single_heating_or_cooling = (
        "ThermostatSetpoint:SingleHeatingOrCooling"
    )


class ZoneControlThermostat(BaseModel):
    zone_or_zonelist_name: str
    control_type_schedule_name: str
    control_1_object_type: Control1ObjectType
    control_1_name: str
    control_2_object_type: Optional[Control1ObjectType] = None
    control_2_name: Optional[str] = None
    control_3_object_type: Optional[Control1ObjectType] = None
    control_3_name: Optional[str] = None
    control_4_object_type: Optional[Control1ObjectType] = None
    control_4_name: Optional[str] = None
    temperature_difference_between_cutout_and_setpoint: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]


class ThermostatSetpointSingleHeating(BaseModel):
    setpoint_temperature_schedule_name: Optional[str] = None


class ThermostatSetpointSingleCooling(ThermostatSetpointSingleHeating):
    pass


class ThermostatSetpointDualSetpoint(BaseModel):
    heating_setpoint_temperature_schedule_name: Optional[str] = None
    cooling_setpoint_temperature_schedule_name: Optional[str] = None


class HeatingLimit(Enum):
    limit_capacity = "LimitCapacity"
    limit_flow_rate = "LimitFlowRate"
    limit_flow_rate_and_capacity = "LimitFlowRateAndCapacity"
    no_limit = "NoLimit"


class MaximumHeatingAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class MaximumSensibleHeatingCapacity(DesignOutdoorAirFlowRate):
    pass


class MaximumCoolingAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class MaximumTotalCoolingCapacity(DesignOutdoorAirFlowRate):
    pass


class DehumidificationControlType(Enum):
    constant_sensible_heat_ratio = "ConstantSensibleHeatRatio"
    constant_supply_humidity_ratio = "ConstantSupplyHumidityRatio"
    humidistat = "Humidistat"
    none = "None"


class HumidificationControlType(Enum):
    constant_supply_humidity_ratio = "ConstantSupplyHumidityRatio"
    humidistat = "Humidistat"
    none = "None"


class DemandControlledVentilationType(Enum):
    co2_setpoint = "CO2Setpoint"
    none = "None"
    occupancy_schedule = "OccupancySchedule"


class OutdoorAirEconomizerType(Enum):
    differential_dry_bulb = "DifferentialDryBulb"
    differential_enthalpy = "DifferentialEnthalpy"
    no_economizer = "NoEconomizer"


class HeatRecoveryType(Enum):
    enthalpy = "Enthalpy"
    none = "None"
    sensible = "Sensible"


class ZoneHvacIdealLoadsAirSystem(BaseModel):
    availability_schedule_name: Optional[str] = None
    zone_supply_air_node_name: str
    zone_exhaust_air_node_name: Optional[str] = None
    system_inlet_air_node_name: Optional[str] = None
    maximum_heating_supply_air_temperature: Annotated[
        Optional[float], Field(50.0, gt=0.0, lt=100.0)
    ]
    minimum_cooling_supply_air_temperature: Annotated[
        Optional[float], Field(13.0, gt=-100.0, lt=50.0)
    ]
    maximum_heating_supply_air_humidity_ratio: Annotated[
        Optional[float], Field(0.0156, gt=0.0)
    ]
    minimum_cooling_supply_air_humidity_ratio: Annotated[
        Optional[float], Field(0.0077, gt=0.0)
    ]
    heating_limit: Optional[HeatingLimit] = HeatingLimit.no_limit
    maximum_heating_air_flow_rate: Optional[
        Union[MaximumHeatingAirFlowRate, Literal["Autosize"]]
    ] = None
    maximum_sensible_heating_capacity: Optional[
        Union[MaximumSensibleHeatingCapacity, Literal["Autosize"]]
    ] = None
    cooling_limit: Optional[HeatingLimit] = HeatingLimit.no_limit
    maximum_cooling_air_flow_rate: Optional[
        Union[MaximumCoolingAirFlowRate, Literal["Autosize"]]
    ] = None
    maximum_total_cooling_capacity: Optional[
        Union[MaximumTotalCoolingCapacity, Literal["Autosize"]]
    ] = None
    heating_availability_schedule_name: Optional[str] = None
    cooling_availability_schedule_name: Optional[str] = None
    dehumidification_control_type: Optional[DehumidificationControlType] = (
        DehumidificationControlType.constant_sensible_heat_ratio
    )
    cooling_sensible_heat_ratio: Annotated[Optional[float], Field(0.7, gt=0.0, le=1.0)]
    humidification_control_type: Optional[HumidificationControlType] = (
        HumidificationControlType.none
    )
    design_specification_outdoor_air_object_name: Optional[str] = None
    outdoor_air_inlet_node_name: Optional[str] = None
    demand_controlled_ventilation_type: Optional[DemandControlledVentilationType] = (
        DemandControlledVentilationType.none
    )
    outdoor_air_economizer_type: Optional[OutdoorAirEconomizerType] = (
        OutdoorAirEconomizerType.no_economizer
    )
    heat_recovery_type: Optional[HeatRecoveryType] = HeatRecoveryType.none
    sensible_heat_recovery_effectiveness: Annotated[
        Optional[float], Field(0.7, ge=0.0, le=1.0)
    ]
    latent_heat_recovery_effectiveness: Annotated[
        Optional[float], Field(0.65, ge=0.0, le=1.0)
    ]
    design_specification_zonehvac_sizing_object_name: Optional[str] = None


class CapacityControlMethod(Enum):
    ashrae90_variable_fan = "ASHRAE90VariableFan"
    constant_fan_variable_flow = "ConstantFanVariableFlow"
    cycling_fan = "CyclingFan"
    multi_speed_fan = "MultiSpeedFan"
    variable_fan_constant_flow = "VariableFanConstantFlow"
    variable_fan_variable_flow = "VariableFanVariableFlow"


class SupplyAirFanObjectType(Enum):
    fan_constant_volume = "Fan:ConstantVolume"
    fan_on_off = "Fan:OnOff"
    fan_system_model = "Fan:SystemModel"
    fan_variable_volume = "Fan:VariableVolume"


class CoolingCoilObjectType(Enum):
    coil_cooling_water = "Coil:Cooling:Water"
    coil_cooling_water_detailed_geometry = "Coil:Cooling:Water:DetailedGeometry"
    coil_system_cooling_water_heat_exchanger_assisted = (
        "CoilSystem:Cooling:Water:HeatExchangerAssisted"
    )


class HeatingCoilObjectType(Enum):
    coil_heating_electric = "Coil:Heating:Electric"
    coil_heating_water = "Coil:Heating:Water"


class MinimumSupplyAirTemperatureInCoolingMode(DesignOutdoorAirFlowRate):
    pass


class MaximumSupplyAirTemperatureInHeatingMode(DesignOutdoorAirFlowRate):
    pass


class ZoneHvacFourPipeFanCoil(BaseModel):
    availability_schedule_name: Optional[str] = None
    capacity_control_method: CapacityControlMethod
    maximum_supply_air_flow_rate: Union[float, Literal["Autosize"]]
    low_speed_supply_air_flow_ratio: Annotated[Optional[float], Field(0.33, gt=0.0)]
    medium_speed_supply_air_flow_ratio: Annotated[Optional[float], Field(0.66, gt=0.0)]
    maximum_outdoor_air_flow_rate: Union[float, Literal["Autosize"]]
    outdoor_air_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    outdoor_air_mixer_object_type: Optional[Literal["OutdoorAir:Mixer"]] = None
    outdoor_air_mixer_name: Optional[str] = None
    supply_air_fan_object_type: SupplyAirFanObjectType
    supply_air_fan_name: str
    cooling_coil_object_type: CoolingCoilObjectType
    cooling_coil_name: str
    maximum_cold_water_flow_rate: Union[float, Literal["Autosize"]]
    minimum_cold_water_flow_rate: Optional[float] = 0.0
    cooling_convergence_tolerance: Annotated[Optional[float], Field(0.001, gt=0.0)]
    heating_coil_object_type: HeatingCoilObjectType
    heating_coil_name: str
    maximum_hot_water_flow_rate: Union[float, Literal["Autosize"]]
    minimum_hot_water_flow_rate: Optional[float] = 0.0
    heating_convergence_tolerance: Annotated[Optional[float], Field(0.001, gt=0.0)]
    availability_manager_list_name: Optional[str] = None
    design_specification_zonehvac_sizing_object_name: Optional[str] = None
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    minimum_supply_air_temperature_in_cooling_mode: Optional[
        Union[MinimumSupplyAirTemperatureInCoolingMode, Literal["Autosize"]]
    ] = "Autosize"
    maximum_supply_air_temperature_in_heating_mode: Optional[
        Union[MaximumSupplyAirTemperatureInHeatingMode, Literal["Autosize"]]
    ] = "Autosize"


class CoolingSupplyAirFlowRate(RootModel[float]):
    root: Annotated[float, Field(gt=0.0)]


class HeatingSupplyAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class NoLoadSupplyAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class CoolingOutdoorAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class HeatingOutdoorAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class NoLoadOutdoorAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class SupplyAirFanObjectType1(Enum):
    fan_constant_volume = "Fan:ConstantVolume"
    fan_on_off = "Fan:OnOff"
    fan_system_model = "Fan:SystemModel"


class HeatingCoilObjectType1(Enum):
    coil_heating_electric = "Coil:Heating:Electric"
    coil_heating_fuel = "Coil:Heating:Fuel"
    coil_heating_steam = "Coil:Heating:Steam"
    coil_heating_water = "Coil:Heating:Water"


class CoolingCoilObjectType1(Enum):
    coil_cooling_dx = "Coil:Cooling:DX"
    coil_cooling_dx_single_speed = "Coil:Cooling:DX:SingleSpeed"
    coil_cooling_dx_variable_speed = "Coil:Cooling:DX:VariableSpeed"
    coil_system_cooling_dx_heat_exchanger_assisted = (
        "CoilSystem:Cooling:DX:HeatExchangerAssisted"
    )


class FanPlacement(Enum):
    blow_through = "BlowThrough"
    draw_through = "DrawThrough"


class CapacityControlMethod1(Enum):
    none = "None"
    single_zone_vav = "SingleZoneVAV"


class ZoneHvacPackagedTerminalAirConditioner(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    outdoor_air_mixer_object_type: Optional[Literal["OutdoorAir:Mixer"]] = None
    outdoor_air_mixer_name: Optional[str] = None
    cooling_supply_air_flow_rate: Union[CoolingSupplyAirFlowRate, Literal["Autosize"]]
    heating_supply_air_flow_rate: Union[HeatingSupplyAirFlowRate, Literal["Autosize"]]
    no_load_supply_air_flow_rate: Optional[
        Union[NoLoadSupplyAirFlowRate, Literal["Autosize"]]
    ] = None
    cooling_outdoor_air_flow_rate: Union[CoolingOutdoorAirFlowRate, Literal["Autosize"]]
    heating_outdoor_air_flow_rate: Union[HeatingOutdoorAirFlowRate, Literal["Autosize"]]
    no_load_outdoor_air_flow_rate: Optional[
        Union[NoLoadOutdoorAirFlowRate, Literal["Autosize"]]
    ] = None
    supply_air_fan_object_type: SupplyAirFanObjectType1
    supply_air_fan_name: str
    heating_coil_object_type: HeatingCoilObjectType1
    heating_coil_name: str
    cooling_coil_object_type: CoolingCoilObjectType1
    cooling_coil_name: str
    fan_placement: Optional[FanPlacement] = FanPlacement.draw_through
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    availability_manager_list_name: Optional[str] = None
    design_specification_zonehvac_sizing_object_name: Optional[str] = None
    capacity_control_method: Optional[CapacityControlMethod1] = (
        CapacityControlMethod1.none
    )
    minimum_supply_air_temperature_in_cooling_mode: Optional[
        Union[MinimumSupplyAirTemperatureInCoolingMode, Literal["Autosize"]]
    ] = "Autosize"
    maximum_supply_air_temperature_in_heating_mode: Optional[
        Union[MaximumSupplyAirTemperatureInHeatingMode, Literal["Autosize"]]
    ] = "Autosize"


class SupplyAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class ExhaustAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class ZoneHvacEnergyRecoveryVentilator(BaseModel):
    availability_schedule_name: Optional[str] = None
    heat_exchanger_name: str
    supply_air_flow_rate: Union[SupplyAirFlowRate, Literal["Autosize"]]
    exhaust_air_flow_rate: Union[ExhaustAirFlowRate, Literal["Autosize"]]
    supply_air_fan_name: str
    exhaust_air_fan_name: str
    controller_name: Optional[str] = None
    ventilation_rate_per_unit_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    ventilation_rate_per_occupant: Annotated[Optional[float], Field(None, ge=0.0)]
    availability_manager_list_name: Optional[str] = None


class ExhaustAirTemperatureLimit(Enum):
    exhaust_air_temperature_limit = "ExhaustAirTemperatureLimit"
    no_exhaust_air_temperature_limit = "NoExhaustAirTemperatureLimit"


class ExhaustAirEnthalpyLimit(Enum):
    exhaust_air_enthalpy_limit = "ExhaustAirEnthalpyLimit"
    no_exhaust_air_enthalpy_limit = "NoExhaustAirEnthalpyLimit"


class MaximumSupplyAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class MaximumHotWaterOrSteamFlowRate(CoolingSupplyAirFlowRate):
    pass


class HeatingDesignCapacityMethod1(Enum):
    capacity_per_floor_area = "CapacityPerFloorArea"
    fraction_of_autosized_heating_capacity = "FractionOfAutosizedHeatingCapacity"
    heating_design_capacity = "HeatingDesignCapacity"


class FuelType1(Enum):
    electricity = "Electricity"
    natural_gas = "NaturalGas"


class TemperatureControlType(Enum):
    mean_air_temperature = "MeanAirTemperature"
    mean_air_temperature_setpoint = "MeanAirTemperatureSetpoint"
    mean_radiant_temperature = "MeanRadiantTemperature"
    mean_radiant_temperature_setpoint = "MeanRadiantTemperatureSetpoint"
    operative_temperature = "OperativeTemperature"
    operative_temperature_setpoint = "OperativeTemperatureSetpoint"


class SurfaceFraction(BaseModel):
    surface_name: Optional[str] = None
    fraction_of_radiant_energy_to_surface: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]


class ZoneHvacHighTemperatureRadiant(BaseModel):
    availability_schedule_name: Optional[str] = None
    zone_name: str
    heating_design_capacity_method: Optional[HeatingDesignCapacityMethod1] = (
        HeatingDesignCapacityMethod1.heating_design_capacity
    )
    heating_design_capacity: Optional[
        Union[HeatingDesignCapacity, Literal["Autosize"]]
    ] = "Autosize"
    heating_design_capacity_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    fraction_of_autosized_heating_design_capacity: Annotated[
        Optional[float], Field(1.0, ge=0.0)
    ]
    fuel_type: FuelType1
    combustion_efficiency: Annotated[Optional[float], Field(0.9, ge=0.0, le=1.0)]
    fraction_of_input_converted_to_radiant_energy: Annotated[
        Optional[float], Field(0.7, ge=0.0, le=1.0)
    ]
    fraction_of_input_converted_to_latent_energy: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    fraction_of_input_that_is_lost: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    temperature_control_type: Optional[TemperatureControlType] = (
        TemperatureControlType.operative_temperature
    )
    heating_throttling_range: Annotated[Optional[float], Field(2.0, ge=0.0)]
    heating_setpoint_temperature_schedule_name: Optional[str] = None
    fraction_of_radiant_energy_incident_on_people: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    surface_fractions: Optional[List[SurfaceFraction]] = None


class MaximumAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class PerPersonVentilationRateMode(Enum):
    current_occupancy = "CurrentOccupancy"
    design_occupancy = "DesignOccupancy"


class AirTerminalSingleDuctConstantVolumeNoReheat(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    maximum_air_flow_rate: Union[MaximumAirFlowRate, Literal["Autosize"]]
    design_specification_outdoor_air_object_name: Optional[str] = None
    per_person_ventilation_rate_mode: Optional[PerPersonVentilationRateMode] = (
        PerPersonVentilationRateMode.current_occupancy
    )


class ZoneMinimumAirFlowInputMethod(Enum):
    constant = "Constant"
    fixed_flow_rate = "FixedFlowRate"
    scheduled = "Scheduled"


class MaximumHotWaterOrSteamFlowRate1(DesignOutdoorAirFlowRate):
    pass


class DamperHeatingAction(Enum):
    normal = "Normal"
    reverse = "Reverse"
    reverse_with_limits = "ReverseWithLimits"


class AirTerminalSingleDuctVavReheat(BaseModel):
    availability_schedule_name: Optional[str] = None
    damper_air_outlet_node_name: str
    air_inlet_node_name: str
    maximum_air_flow_rate: Union[MaximumAirFlowRate, Literal["Autosize"]]
    zone_minimum_air_flow_input_method: Optional[ZoneMinimumAirFlowInputMethod] = (
        ZoneMinimumAirFlowInputMethod.constant
    )
    constant_minimum_air_flow_fraction: Optional[Union[float, Literal["Autosize"]]] = (
        "Autosize"
    )
    fixed_minimum_air_flow_rate: Optional[Union[float, Literal["Autosize"]]] = (
        "Autosize"
    )
    minimum_air_flow_fraction_schedule_name: Optional[str] = None
    reheat_coil_object_type: HeatingCoilObjectType1
    reheat_coil_name: str
    maximum_hot_water_or_steam_flow_rate: Optional[
        Union[MaximumHotWaterOrSteamFlowRate1, Literal["Autosize"]]
    ] = None
    minimum_hot_water_or_steam_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    air_outlet_node_name: str
    convergence_tolerance: Annotated[Optional[float], Field(0.001, gt=0.0)]
    damper_heating_action: Optional[DamperHeatingAction] = (
        DamperHeatingAction.reverse_with_limits
    )
    maximum_flow_per_zone_floor_area_during_reheat: Optional[
        Union[float, Literal["Autosize"]]
    ] = "Autosize"
    maximum_flow_fraction_during_reheat: Optional[Union[float, Literal["Autosize"]]] = (
        "Autosize"
    )
    maximum_reheat_air_temperature: Annotated[Optional[float], Field(None, gt=0.0)]
    design_specification_outdoor_air_object_name: Optional[str] = None
    minimum_air_flow_turndown_schedule_name: Optional[str] = None


class AirTerminalObjectType(Enum):
    air_terminal_dual_duct_constant_volume = "AirTerminal:DualDuct:ConstantVolume"
    air_terminal_dual_duct_vav = "AirTerminal:DualDuct:VAV"
    air_terminal_dual_duct_vav_outdoor_air = "AirTerminal:DualDuct:VAV:OutdoorAir"
    air_terminal_single_duct_constant_volume_cooled_beam = (
        "AirTerminal:SingleDuct:ConstantVolume:CooledBeam"
    )
    air_terminal_single_duct_constant_volume_four_pipe_beam = (
        "AirTerminal:SingleDuct:ConstantVolume:FourPipeBeam"
    )
    air_terminal_single_duct_constant_volume_four_pipe_induction = (
        "AirTerminal:SingleDuct:ConstantVolume:FourPipeInduction"
    )
    air_terminal_single_duct_constant_volume_no_reheat = (
        "AirTerminal:SingleDuct:ConstantVolume:NoReheat"
    )
    air_terminal_single_duct_constant_volume_reheat = (
        "AirTerminal:SingleDuct:ConstantVolume:Reheat"
    )
    air_terminal_single_duct_mixer = "AirTerminal:SingleDuct:Mixer"
    air_terminal_single_duct_parallel_piu_reheat = (
        "AirTerminal:SingleDuct:ParallelPIU:Reheat"
    )
    air_terminal_single_duct_series_piu_reheat = (
        "AirTerminal:SingleDuct:SeriesPIU:Reheat"
    )
    air_terminal_single_duct_user_defined = "AirTerminal:SingleDuct:UserDefined"
    air_terminal_single_duct_vav_heat_and_cool_no_reheat = (
        "AirTerminal:SingleDuct:VAV:HeatAndCool:NoReheat"
    )
    air_terminal_single_duct_vav_heat_and_cool_reheat = (
        "AirTerminal:SingleDuct:VAV:HeatAndCool:Reheat"
    )
    air_terminal_single_duct_vav_no_reheat = "AirTerminal:SingleDuct:VAV:NoReheat"
    air_terminal_single_duct_vav_reheat = "AirTerminal:SingleDuct:VAV:Reheat"
    air_terminal_single_duct_vav_reheat_variable_speed_fan = (
        "AirTerminal:SingleDuct:VAV:Reheat:VariableSpeedFan"
    )


class ZoneHvacAirDistributionUnit(BaseModel):
    air_distribution_unit_outlet_node_name: str
    air_terminal_object_type: AirTerminalObjectType
    air_terminal_name: str
    nominal_upstream_leakage_fraction: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=0.3)
    ]
    constant_downstream_leakage_fraction: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=0.3)
    ]
    design_specification_air_terminal_sizing_object_name: Optional[str] = None


class LoadDistributionScheme(Enum):
    sequential_load = "SequentialLoad"
    sequential_uniform_plr = "SequentialUniformPLR"
    uniform_load = "UniformLoad"
    uniform_plr = "UniformPLR"


class ZoneEquipmentObjectType(Enum):
    air_loop_hvac_unitary_system = "AirLoopHVAC:UnitarySystem"
    fan_zone_exhaust = "Fan:ZoneExhaust"
    heat_exchanger_air_to_air_flat_plate = "HeatExchanger:AirToAir:FlatPlate"
    water_heater_heat_pump_pumped_condenser = "WaterHeater:HeatPump:PumpedCondenser"
    water_heater_heat_pump_wrapped_condenser = "WaterHeater:HeatPump:WrappedCondenser"
    zone_hvac_air_distribution_unit = "ZoneHVAC:AirDistributionUnit"
    zone_hvac_baseboard_convective_electric = "ZoneHVAC:Baseboard:Convective:Electric"
    zone_hvac_baseboard_convective_water = "ZoneHVAC:Baseboard:Convective:Water"
    zone_hvac_baseboard_radiant_convective_electric = (
        "ZoneHVAC:Baseboard:RadiantConvective:Electric"
    )
    zone_hvac_baseboard_radiant_convective_steam = (
        "ZoneHVAC:Baseboard:RadiantConvective:Steam"
    )
    zone_hvac_baseboard_radiant_convective_water = (
        "ZoneHVAC:Baseboard:RadiantConvective:Water"
    )
    zone_hvac_cooling_panel_radiant_convective_water = (
        "ZoneHVAC:CoolingPanel:RadiantConvective:Water"
    )
    zone_hvac_dehumidifier_dx = "ZoneHVAC:Dehumidifier:DX"
    zone_hvac_energy_recovery_ventilator = "ZoneHVAC:EnergyRecoveryVentilator"
    zone_hvac_evaporative_cooler_unit = "ZoneHVAC:EvaporativeCoolerUnit"
    zone_hvac_forced_air_user_defined = "ZoneHVAC:ForcedAir:UserDefined"
    zone_hvac_four_pipe_fan_coil = "ZoneHVAC:FourPipeFanCoil"
    zone_hvac_high_temperature_radiant = "ZoneHVAC:HighTemperatureRadiant"
    zone_hvac_hybrid_unitary_hvac = "ZoneHVAC:HybridUnitaryHVAC"
    zone_hvac_ideal_loads_air_system = "ZoneHVAC:IdealLoadsAirSystem"
    zone_hvac_low_temperature_radiant_constant_flow = (
        "ZoneHVAC:LowTemperatureRadiant:ConstantFlow"
    )
    zone_hvac_low_temperature_radiant_electric = (
        "ZoneHVAC:LowTemperatureRadiant:Electric"
    )
    zone_hvac_low_temperature_radiant_variable_flow = (
        "ZoneHVAC:LowTemperatureRadiant:VariableFlow"
    )
    zone_hvac_outdoor_air_unit = "ZoneHVAC:OutdoorAirUnit"
    zone_hvac_packaged_terminal_air_conditioner = (
        "ZoneHVAC:PackagedTerminalAirConditioner"
    )
    zone_hvac_packaged_terminal_heat_pump = "ZoneHVAC:PackagedTerminalHeatPump"
    zone_hvac_refrigeration_chiller_set = "ZoneHVAC:RefrigerationChillerSet"
    zone_hvac_terminal_unit_variable_refrigerant_flow = (
        "ZoneHVAC:TerminalUnit:VariableRefrigerantFlow"
    )
    zone_hvac_unit_heater = "ZoneHVAC:UnitHeater"
    zone_hvac_unit_ventilator = "ZoneHVAC:UnitVentilator"
    zone_hvac_ventilated_slab = "ZoneHVAC:VentilatedSlab"
    zone_hvac_water_to_air_heat_pump = "ZoneHVAC:WaterToAirHeatPump"
    zone_hvac_window_air_conditioner = "ZoneHVAC:WindowAirConditioner"


class EquipmentItem(BaseModel):
    zone_equipment_object_type: ZoneEquipmentObjectType
    zone_equipment_name: str
    zone_equipment_cooling_sequence: Annotated[int, Field(ge=0)]
    zone_equipment_heating_or_no_load_sequence: Annotated[int, Field(ge=0)]
    zone_equipment_sequential_cooling_fraction_schedule_name: Optional[str] = None
    zone_equipment_sequential_heating_fraction_schedule_name: Optional[str] = None


class ZoneHvacEquipmentList(BaseModel):
    load_distribution_scheme: Optional[LoadDistributionScheme] = (
        LoadDistributionScheme.sequential_load
    )
    equipment: Optional[List[EquipmentItem]] = None


class ZoneHvacEquipmentConnections(BaseModel):
    zone_name: str
    zone_conditioning_equipment_list_name: str
    zone_air_inlet_node_or_nodelist_name: Optional[str] = None
    zone_air_exhaust_node_or_nodelist_name: Optional[str] = None
    zone_air_node_name: str
    zone_return_air_node_or_nodelist_name: Optional[str] = None
    zone_return_air_node_1_flow_rate_fraction_schedule_name: Optional[str] = None
    zone_return_air_node_1_flow_rate_basis_node_or_nodelist_name: Optional[str] = None


class DesignMaximumAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class DesignPowerSizingMethod(Enum):
    power_per_flow = "PowerPerFlow"
    power_per_flow_per_pressure = "PowerPerFlowPerPressure"
    total_efficiency_and_pressure = "TotalEfficiencyAndPressure"


class SpeedFraction(BaseModel):
    speed_flow_fraction: Annotated[Optional[float], Field(None, ge=0.0, le=1.0)]
    speed_electric_power_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]


class FanSystemModel(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    design_maximum_air_flow_rate: Union[DesignMaximumAirFlowRate, Literal["Autosize"]]
    speed_control_method: Optional[NumericType] = NumericType.discrete
    electric_power_minimum_flow_rate_fraction: Annotated[
        Optional[float], Field(0.2, ge=0.0, le=1.0)
    ]
    design_pressure_rise: Annotated[float, Field(gt=0.0)]
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    motor_in_air_stream_fraction: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    design_electric_power_consumption: Optional[Union[float, Literal["Autosize"]]] = (
        "Autosize"
    )
    design_power_sizing_method: Optional[DesignPowerSizingMethod] = (
        DesignPowerSizingMethod.power_per_flow_per_pressure
    )
    electric_power_per_unit_flow_rate: Optional[float] = None
    electric_power_per_unit_flow_rate_per_unit_pressure: Optional[float] = 1.66667
    fan_total_efficiency: Annotated[Optional[float], Field(0.7, gt=0.0, le=1.0)]
    electric_power_function_of_flow_fraction_curve_name: Optional[str] = None
    night_ventilation_mode_pressure_rise: Optional[float] = None
    night_ventilation_mode_flow_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    motor_loss_zone_name: Optional[str] = None
    motor_loss_radiative_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    end_use_subcategory: Optional[str] = "General"
    number_of_speeds: Optional[int] = 1
    speed_fractions: Optional[List[SpeedFraction]] = None


class MaximumFlowRate(DesignOutdoorAirFlowRate):
    pass


class FanConstantVolume(BaseModel):
    availability_schedule_name: Optional[str] = None
    fan_total_efficiency: Annotated[Optional[float], Field(0.7, gt=0.0, le=1.0)]
    pressure_rise: float
    maximum_flow_rate: Optional[Union[MaximumFlowRate, Literal["Autosize"]]] = None
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    motor_in_airstream_fraction: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    air_inlet_node_name: str
    air_outlet_node_name: str
    end_use_subcategory: Optional[str] = "General"


class FanPowerMinimumFlowRateInputMethod(Enum):
    fixed_flow_rate = "FixedFlowRate"
    fraction = "Fraction"


class FanVariableVolume(BaseModel):
    availability_schedule_name: Optional[str] = None
    fan_total_efficiency: Annotated[Optional[float], Field(0.7, gt=0.0, le=1.0)]
    pressure_rise: float
    maximum_flow_rate: Optional[Union[MaximumFlowRate, Literal["Autosize"]]] = None
    fan_power_minimum_flow_rate_input_method: Optional[
        FanPowerMinimumFlowRateInputMethod
    ] = FanPowerMinimumFlowRateInputMethod.fraction
    fan_power_minimum_flow_fraction: Annotated[
        Optional[float], Field(0.25, ge=0.0, le=1.0)
    ]
    fan_power_minimum_air_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    motor_in_airstream_fraction: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    fan_power_coefficient_1: Optional[float] = None
    fan_power_coefficient_2: Optional[float] = None
    fan_power_coefficient_3: Optional[float] = None
    fan_power_coefficient_4: Optional[float] = None
    fan_power_coefficient_5: Optional[float] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    end_use_subcategory: Optional[str] = "General"


class FanOnOff(BaseModel):
    availability_schedule_name: Optional[str] = None
    fan_total_efficiency: Annotated[Optional[float], Field(0.6, gt=0.0, le=1.0)]
    pressure_rise: float
    maximum_flow_rate: Optional[Union[MaximumFlowRate, Literal["Autosize"]]] = None
    motor_efficiency: Annotated[Optional[float], Field(0.8, gt=0.0, le=1.0)]
    motor_in_airstream_fraction: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    air_inlet_node_name: str
    air_outlet_node_name: str
    fan_power_ratio_function_of_speed_ratio_curve_name: Optional[str] = None
    fan_efficiency_ratio_function_of_speed_ratio_curve_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"


class SystemAvailabilityManagerCouplingMode(Enum):
    coupled = "Coupled"
    decoupled = "Decoupled"


class FanZoneExhaust(BaseModel):
    availability_schedule_name: Optional[str] = None
    fan_total_efficiency: Annotated[Optional[float], Field(0.6, gt=0.0, le=1.0)]
    pressure_rise: float
    maximum_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    air_inlet_node_name: str
    air_outlet_node_name: str
    end_use_subcategory: Optional[str] = "General"
    flow_fraction_schedule_name: Optional[str] = None
    system_availability_manager_coupling_mode: Optional[
        SystemAvailabilityManagerCouplingMode
    ] = SystemAvailabilityManagerCouplingMode.coupled
    minimum_zone_temperature_limit_schedule_name: Optional[str] = None
    balanced_exhaust_fraction_schedule_name: Optional[str] = None


class DesignWaterFlowRate(DesignOutdoorAirFlowRate):
    pass


class DesignAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class DesignInletWaterTemperature(CoolingSupplyAirFlowRate):
    pass


class DesignInletAirTemperature(CoolingSupplyAirFlowRate):
    pass


class DesignOutletAirTemperature(CoolingSupplyAirFlowRate):
    pass


class DesignInletAirHumidityRatio(DesignOutdoorAirFlowRate):
    pass


class DesignOutletAirHumidityRatio(DesignOutdoorAirFlowRate):
    pass


class TypeOfAnalysis(Enum):
    detailed_analysis = "DetailedAnalysis"
    simple_analysis = "SimpleAnalysis"


class HeatExchangerConfiguration(Enum):
    counter_flow = "CounterFlow"
    cross_flow = "CrossFlow"


class CoilCoolingWater(BaseModel):
    availability_schedule_name: Optional[str] = None
    design_water_flow_rate: Optional[
        Union[DesignWaterFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    design_air_flow_rate: Optional[Union[DesignAirFlowRate, Literal["Autosize"]]] = (
        "Autosize"
    )
    design_inlet_water_temperature: Optional[
        Union[DesignInletWaterTemperature, Literal["Autosize"]]
    ] = "Autosize"
    design_inlet_air_temperature: Optional[
        Union[DesignInletAirTemperature, Literal["Autosize"]]
    ] = "Autosize"
    design_outlet_air_temperature: Optional[
        Union[DesignOutletAirTemperature, Literal["Autosize"]]
    ] = "Autosize"
    design_inlet_air_humidity_ratio: Optional[
        Union[DesignInletAirHumidityRatio, Literal["Autosize"]]
    ] = "Autosize"
    design_outlet_air_humidity_ratio: Optional[
        Union[DesignOutletAirHumidityRatio, Literal["Autosize"]]
    ] = "Autosize"
    water_inlet_node_name: str
    water_outlet_node_name: str
    air_inlet_node_name: str
    air_outlet_node_name: str
    type_of_analysis: Optional[TypeOfAnalysis] = TypeOfAnalysis.simple_analysis
    heat_exchanger_configuration: Optional[HeatExchangerConfiguration] = (
        HeatExchangerConfiguration.counter_flow
    )
    condensate_collection_water_storage_tank_name: Optional[str] = None
    design_water_temperature_difference: Annotated[Optional[float], Field(None, gt=0.0)]


class TotalTubeInsideArea(CoolingSupplyAirFlowRate):
    pass


class MinimumAirflowArea(CoolingSupplyAirFlowRate):
    pass


class CoilDepth(CoolingSupplyAirFlowRate):
    pass


class FinDiameter(CoolingSupplyAirFlowRate):
    pass


class NumberOfTubesPerRow(CoolingSupplyAirFlowRate):
    pass


class CoilCoolingWaterDetailedGeometry(BaseModel):
    availability_schedule_name: Optional[str] = None
    maximum_water_flow_rate: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    tube_outside_surface_area: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    total_tube_inside_area: Optional[
        Union[TotalTubeInsideArea, Literal["Autosize"]]
    ] = "Autosize"
    fin_surface_area: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    minimum_airflow_area: Optional[Union[MinimumAirflowArea, Literal["Autosize"]]] = (
        "Autosize"
    )
    coil_depth: Optional[Union[CoilDepth, Literal["Autosize"]]] = "Autosize"
    fin_diameter: Optional[Union[FinDiameter, Literal["Autosize"]]] = "Autosize"
    fin_thickness: Annotated[Optional[float], Field(0.0015, gt=0.0)]
    tube_inside_diameter: Annotated[Optional[float], Field(0.01445, gt=0.0)]
    tube_outside_diameter: Annotated[Optional[float], Field(0.0159, gt=0.0)]
    tube_thermal_conductivity: Annotated[Optional[float], Field(386.0, ge=1.0)]
    fin_thermal_conductivity: Annotated[Optional[float], Field(204.0, ge=1.0)]
    fin_spacing: Annotated[Optional[float], Field(0.0018, gt=0.0)]
    tube_depth_spacing: Annotated[Optional[float], Field(0.026, gt=0.0)]
    number_of_tube_rows: Annotated[Optional[float], Field(4.0, gt=0.0)]
    number_of_tubes_per_row: Optional[
        Union[NumberOfTubesPerRow, Literal["Autosize"]]
    ] = "Autosize"
    water_inlet_node_name: str
    water_outlet_node_name: str
    air_inlet_node_name: str
    air_outlet_node_name: str
    condensate_collection_water_storage_tank_name: Optional[str] = None
    design_water_temperature_difference: Annotated[Optional[float], Field(None, gt=0.0)]
    design_inlet_water_temperature: Optional[
        Union[DesignInletWaterTemperature, Literal["Autosize"]]
    ] = "Autosize"


class GrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class GrossRatedSensibleHeatRatio(RootModel[float]):
    root: Annotated[float, Field(ge=0.5, le=1.0)]


class RatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class CondenserType(Enum):
    air_cooled = "AirCooled"
    evaporatively_cooled = "EvaporativelyCooled"


class EvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class EvaporativeCondenserPumpRatedPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class HighSpeedGrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class HighSpeedRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class HighSpeedRatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class LowSpeedGrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class LowSpeedGrossRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class LowSpeedRatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class HighSpeedEvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class HighSpeedEvaporativeCondenserPumpRatedPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class LowSpeedEvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class LowSpeedEvaporativeCondenserPumpRatedPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class CoilCoolingDxTwoSpeed(BaseModel):
    availability_schedule_name: Optional[str] = None
    high_speed_gross_rated_total_cooling_capacity: Union[
        HighSpeedGrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    high_speed_rated_sensible_heat_ratio: Union[
        HighSpeedRatedSensibleHeatRatio, Literal["Autosize"]
    ]
    high_speed_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    high_speed_rated_air_flow_rate: Union[
        HighSpeedRatedAirFlowRate, Literal["Autosize"]
    ]
    high_speed_2017_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float], Field(773.3, ge=0.0, le=1250.0)
    ]
    high_speed_2023_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float], Field(934.4, ge=0.0, le=1505.0)
    ]
    unit_internal_static_air_pressure: Annotated[Optional[float], Field(None, gt=0.0)]
    air_inlet_node_name: str
    air_outlet_node_name: str
    total_cooling_capacity_function_of_temperature_curve_name: str
    total_cooling_capacity_function_of_flow_fraction_curve_name: str
    energy_input_ratio_function_of_temperature_curve_name: str
    energy_input_ratio_function_of_flow_fraction_curve_name: str
    part_load_fraction_correlation_curve_name: str
    low_speed_gross_rated_total_cooling_capacity: Union[
        LowSpeedGrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    low_speed_gross_rated_sensible_heat_ratio: Union[
        LowSpeedGrossRatedSensibleHeatRatio, Literal["Autosize"]
    ]
    low_speed_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    low_speed_rated_air_flow_rate: Union[LowSpeedRatedAirFlowRate, Literal["Autosize"]]
    low_speed_2017_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float], Field(773.3, ge=0.0, le=1250.0)
    ]
    low_speed_2023_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float], Field(934.4, ge=0.0, le=1505.0)
    ]
    low_speed_total_cooling_capacity_function_of_temperature_curve_name: str
    low_speed_energy_input_ratio_function_of_temperature_curve_name: str
    condenser_air_inlet_node_name: Optional[str] = None
    condenser_type: Optional[CondenserType] = CondenserType.air_cooled
    minimum_outdoor_dry_bulb_temperature_for_compressor_operation: Optional[float] = (
        -25.0
    )
    high_speed_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    high_speed_evaporative_condenser_air_flow_rate: Optional[
        Union[HighSpeedEvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    high_speed_evaporative_condenser_pump_rated_power_consumption: Optional[
        Union[
            HighSpeedEvaporativeCondenserPumpRatedPowerConsumption, Literal["Autosize"]
        ]
    ] = None
    low_speed_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    low_speed_evaporative_condenser_air_flow_rate: Optional[
        Union[LowSpeedEvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    low_speed_evaporative_condenser_pump_rated_power_consumption: Optional[
        Union[
            LowSpeedEvaporativeCondenserPumpRatedPowerConsumption, Literal["Autosize"]
        ]
    ] = None
    supply_water_storage_tank_name: Optional[str] = None
    condensate_collection_water_storage_tank_name: Optional[str] = None
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    sensible_heat_ratio_function_of_temperature_curve_name: Optional[str] = None
    sensible_heat_ratio_function_of_flow_fraction_curve_name: Optional[str] = None
    low_speed_sensible_heat_ratio_function_of_temperature_curve_name: Optional[str] = (
        None
    )
    low_speed_sensible_heat_ratio_function_of_flow_fraction_curve_name: Optional[
        str
    ] = None
    zone_name_for_condenser_placement: Optional[str] = None


class FuelType2(Enum):
    diesel = "Diesel"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"


class Speed1GrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class Speed1GrossRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class Speed1RatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed1EvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed1RatedEvaporativeCondenserPumpPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class Speed2GrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class Speed2GrossRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class Speed2RatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed2EvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed2RatedEvaporativeCondenserPumpPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class Speed3GrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class Speed3GrossRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class Speed3RatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed3EvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed3RatedEvaporativeCondenserPumpPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class Speed4GrossRatedTotalCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class Speed4GrossRatedSensibleHeatRatio(GrossRatedSensibleHeatRatio):
    pass


class Speed4RatedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed4EvaporativeCondenserAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class Speed4RatedEvaporativeCondenserPumpPowerConsumption(DesignOutdoorAirFlowRate):
    pass


class PerformanceInputMethod(Enum):
    nominal_capacity = "NominalCapacity"
    u_factor_times_area_and_design_water_flow_rate = (
        "UFactorTimesAreaAndDesignWaterFlowRate"
    )


class RatedCapacity(DesignOutdoorAirFlowRate):
    pass


class CoilHeatingWater(BaseModel):
    availability_schedule_name: Optional[str] = None
    u_factor_times_area_value: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    maximum_water_flow_rate: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    water_inlet_node_name: str
    water_outlet_node_name: str
    air_inlet_node_name: str
    air_outlet_node_name: str
    performance_input_method: Optional[PerformanceInputMethod] = (
        PerformanceInputMethod.u_factor_times_area_and_design_water_flow_rate
    )
    rated_capacity: Optional[Union[RatedCapacity, Literal["Autosize"]]] = "Autosize"
    rated_inlet_water_temperature: Optional[float] = 82.2
    rated_inlet_air_temperature: Optional[float] = 16.6
    rated_outlet_water_temperature: Optional[float] = 71.1
    rated_outlet_air_temperature: Optional[float] = 32.2
    rated_ratio_for_air_and_water_convection: Annotated[
        Optional[float], Field(0.5, gt=0.0)
    ]
    design_water_temperature_difference: Annotated[Optional[float], Field(None, gt=0.0)]


class CoilHeatingElectric(BaseModel):
    availability_schedule_name: Optional[str] = None
    efficiency: Annotated[Optional[float], Field(1.0, gt=0.0, le=1.0)]
    nominal_capacity: Optional[Union[float, Literal["Autosize"]]] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    temperature_setpoint_node_name: Optional[str] = None


class FuelType3(Enum):
    coal = "Coal"
    diesel = "Diesel"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"


class CoilHeatingFuel(BaseModel):
    availability_schedule_name: Optional[str] = None
    fuel_type: Optional[FuelType3] = FuelType3.natural_gas
    burner_efficiency: Annotated[Optional[float], Field(0.8, ge=0.0, le=1.0)]
    nominal_capacity: Optional[Union[float, Literal["Autosize"]]] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    temperature_setpoint_node_name: Optional[str] = None
    on_cycle_parasitic_electric_load: Optional[float] = None
    part_load_fraction_correlation_curve_name: Optional[str] = None
    off_cycle_parasitic_fuel_load: Optional[float] = None


class GrossRatedHeatingCapacity(CoolingSupplyAirFlowRate):
    pass


class DefrostStrategy(Enum):
    resistive = "Resistive"
    reverse_cycle = "ReverseCycle"


class DefrostControl(Enum):
    on_demand = "OnDemand"
    timed = "Timed"


class ResistiveDefrostHeaterCapacity(DesignOutdoorAirFlowRate):
    pass


class SecondaryCoilAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class CoilHeatingDxSingleSpeed(BaseModel):
    availability_schedule_name: Optional[str] = None
    gross_rated_heating_capacity: Union[GrossRatedHeatingCapacity, Literal["Autosize"]]
    gross_rated_heating_cop: Annotated[float, Field(gt=0.0)]
    rated_air_flow_rate: Union[RatedAirFlowRate, Literal["Autosize"]]
    field_2017_rated_supply_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_rated_supply_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_rated_supply_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_rated_supply_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    air_inlet_node_name: str
    air_outlet_node_name: str
    heating_capacity_function_of_temperature_curve_name: str
    heating_capacity_function_of_flow_fraction_curve_name: str
    energy_input_ratio_function_of_temperature_curve_name: str
    energy_input_ratio_function_of_flow_fraction_curve_name: str
    part_load_fraction_correlation_curve_name: str
    defrost_energy_input_ratio_function_of_temperature_curve_name: Optional[str] = None
    minimum_outdoor_dry_bulb_temperature_for_compressor_operation: Optional[float] = (
        -8.0
    )
    outdoor_dry_bulb_temperature_to_turn_on_compressor: Optional[float] = None
    maximum_outdoor_dry_bulb_temperature_for_defrost_operation: Annotated[
        Optional[float], Field(5.0, ge=0.0, le=7.22)
    ]
    crankcase_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    crankcase_heater_capacity_function_of_temperature_curve_name: Optional[str] = None
    maximum_outdoor_dry_bulb_temperature_for_crankcase_heater_operation: Annotated[
        Optional[float], Field(10.0, ge=0.0)
    ]
    defrost_strategy: Optional[DefrostStrategy] = DefrostStrategy.reverse_cycle
    defrost_control: Optional[DefrostControl] = DefrostControl.timed
    defrost_time_period_fraction: Annotated[Optional[float], Field(0.058333, ge=0.0)]
    resistive_defrost_heater_capacity: Optional[
        Union[ResistiveDefrostHeaterCapacity, Literal["Autosize"]]
    ] = 0.0
    region_number_for_calculating_hspf: Annotated[Optional[int], Field(4, ge=1, le=6)]
    evaporator_air_inlet_node_name: Optional[str] = None
    zone_name_for_evaporator_placement: Optional[str] = None
    secondary_coil_air_flow_rate: Optional[
        Union[SecondaryCoilAirFlowRate, Literal["Autosize"]]
    ] = None
    secondary_coil_fan_flow_scaling_factor: Annotated[
        Optional[float], Field(1.25, gt=0.0)
    ]
    nominal_sensible_heat_ratio_of_secondary_coil: Annotated[
        Optional[float], Field(None, gt=0.0, le=1.0)
    ]
    sensible_heat_ratio_modifier_function_of_temperature_curve_name: Optional[str] = (
        None
    )
    sensible_heat_ratio_modifier_function_of_flow_fraction_curve_name: Optional[str] = (
        None
    )


class RatedWaterFlowRate(CoolingSupplyAirFlowRate):
    pass


class GrossRatedSensibleCoolingCapacity(CoolingSupplyAirFlowRate):
    pass


class CoilCoolingWaterToAirHeatPumpEquationFit(BaseModel):
    water_inlet_node_name: str
    water_outlet_node_name: str
    air_inlet_node_name: str
    air_outlet_node_name: str
    rated_air_flow_rate: Union[RatedAirFlowRate, Literal["Autosize"]]
    rated_water_flow_rate: Union[RatedWaterFlowRate, Literal["Autosize"]]
    gross_rated_total_cooling_capacity: Union[
        GrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    gross_rated_sensible_cooling_capacity: Union[
        GrossRatedSensibleCoolingCapacity, Literal["Autosize"]
    ]
    gross_rated_cooling_cop: Annotated[float, Field(gt=0.0)]
    rated_entering_water_temperature: Annotated[Optional[float], Field(30.0, gt=0.0)]
    rated_entering_air_dry_bulb_temperature: Annotated[
        Optional[float], Field(27.0, gt=0.0)
    ]
    rated_entering_air_wet_bulb_temperature: Annotated[
        Optional[float], Field(19.0, gt=0.0)
    ]
    total_cooling_capacity_curve_name: str
    sensible_cooling_capacity_curve_name: str
    cooling_power_consumption_curve_name: str
    part_load_fraction_correlation_curve_name: str
    nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: (
        Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    )
    maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    fan_delay_time: Annotated[Optional[float], Field(60.0, ge=0.0)]


class CoilHeatingWaterToAirHeatPumpEquationFit(BaseModel):
    water_inlet_node_name: str
    water_outlet_node_name: str
    air_inlet_node_name: str
    air_outlet_node_name: str
    rated_air_flow_rate: Union[RatedAirFlowRate, Literal["Autosize"]]
    rated_water_flow_rate: Union[RatedWaterFlowRate, Literal["Autosize"]]
    gross_rated_heating_capacity: Union[GrossRatedHeatingCapacity, Literal["Autosize"]]
    gross_rated_heating_cop: Annotated[float, Field(gt=0.0)]
    rated_entering_water_temperature: Optional[float] = 20.0
    rated_entering_air_dry_bulb_temperature: Annotated[
        Optional[float], Field(20.0, gt=0.0)
    ]
    ratio_of_rated_heating_capacity_to_rated_cooling_capacity: Annotated[
        Optional[float], Field(1.0, gt=0.0)
    ]
    heating_capacity_curve_name: str
    heating_power_consumption_curve_name: str
    part_load_fraction_correlation_curve_name: str


class CoolingCoilObjectType2(Enum):
    coil_cooling_dx = "Coil:Cooling:DX"
    coil_cooling_dx_single_speed = "Coil:Cooling:DX:SingleSpeed"
    coil_cooling_dx_single_speed_thermal_storage = (
        "Coil:Cooling:DX:SingleSpeed:ThermalStorage"
    )
    coil_cooling_dx_two_speed = "Coil:Cooling:DX:TwoSpeed"
    coil_cooling_dx_two_stage_with_humidity_control_mode = (
        "Coil:Cooling:DX:TwoStageWithHumidityControlMode"
    )
    coil_cooling_dx_variable_speed = "Coil:Cooling:DX:VariableSpeed"
    coil_system_cooling_dx_heat_exchanger_assisted = (
        "CoilSystem:Cooling:DX:HeatExchangerAssisted"
    )


class DehumidificationControlType1(Enum):
    cool_reheat = "CoolReheat"
    multimode = "Multimode"
    none = "None"


class RatedPower(DesignOutdoorAirFlowRate):
    pass


class HumidifierSteamElectric(BaseModel):
    availability_schedule_name: Optional[str] = None
    rated_capacity: Optional[Union[RatedCapacity, Literal["Autosize"]]] = None
    rated_power: Optional[Union[RatedPower, Literal["Autosize"]]] = None
    rated_fan_power: Annotated[Optional[float], Field(None, ge=0.0)]
    standby_power: Annotated[Optional[float], Field(None, ge=0.0)]
    air_inlet_node_name: Optional[str] = None
    air_outlet_node_name: Optional[str] = None
    water_storage_tank_name: Optional[str] = None


class NominalSupplyAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class HeatExchangerType(Enum):
    plate = "Plate"
    rotary = "Rotary"


class FrostControlType(Enum):
    exhaust_air_recirculation = "ExhaustAirRecirculation"
    exhaust_only = "ExhaustOnly"
    minimum_exhaust_temperature = "MinimumExhaustTemperature"
    none = "None"


class ControlType(Enum):
    load = "Load"
    set_point = "SetPoint"
    single_zone_vav = "SingleZoneVAV"


class SupplyFanObjectType(Enum):
    fan_component_model = "Fan:ComponentModel"
    fan_constant_volume = "Fan:ConstantVolume"
    fan_on_off = "Fan:OnOff"
    fan_system_model = "Fan:SystemModel"
    fan_variable_volume = "Fan:VariableVolume"


class HeatingCoilObjectType3(Enum):
    coil_heating_dx_multi_speed = "Coil:Heating:DX:MultiSpeed"
    coil_heating_dx_single_speed = "Coil:Heating:DX:SingleSpeed"
    coil_heating_dx_variable_speed = "Coil:Heating:DX:VariableSpeed"
    coil_heating_desuperheater = "Coil:Heating:Desuperheater"
    coil_heating_electric = "Coil:Heating:Electric"
    coil_heating_electric_multi_stage = "Coil:Heating:Electric:MultiStage"
    coil_heating_fuel = "Coil:Heating:Fuel"
    coil_heating_gas_multi_stage = "Coil:Heating:Gas:MultiStage"
    coil_heating_steam = "Coil:Heating:Steam"
    coil_heating_water = "Coil:Heating:Water"
    coil_heating_water_to_air_heat_pump_equation_fit = (
        "Coil:Heating:WaterToAirHeatPump:EquationFit"
    )
    coil_heating_water_to_air_heat_pump_parameter_estimation = (
        "Coil:Heating:WaterToAirHeatPump:ParameterEstimation"
    )
    coil_heating_water_to_air_heat_pump_variable_speed_equation_fit = (
        "Coil:Heating:WaterToAirHeatPump:VariableSpeedEquationFit"
    )
    coil_user_defined = "Coil:UserDefined"


class CoolingCoilObjectType3(Enum):
    coil_cooling_dx = "Coil:Cooling:DX"
    coil_cooling_dx_multi_speed = "Coil:Cooling:DX:MultiSpeed"
    coil_cooling_dx_single_speed = "Coil:Cooling:DX:SingleSpeed"
    coil_cooling_dx_single_speed_thermal_storage = (
        "Coil:Cooling:DX:SingleSpeed:ThermalStorage"
    )
    coil_cooling_dx_two_speed = "Coil:Cooling:DX:TwoSpeed"
    coil_cooling_dx_two_stage_with_humidity_control_mode = (
        "Coil:Cooling:DX:TwoStageWithHumidityControlMode"
    )
    coil_cooling_dx_variable_speed = "Coil:Cooling:DX:VariableSpeed"
    coil_cooling_water = "Coil:Cooling:Water"
    coil_cooling_water_detailed_geometry = "Coil:Cooling:Water:DetailedGeometry"
    coil_cooling_water_to_air_heat_pump_equation_fit = (
        "Coil:Cooling:WaterToAirHeatPump:EquationFit"
    )
    coil_cooling_water_to_air_heat_pump_parameter_estimation = (
        "Coil:Cooling:WaterToAirHeatPump:ParameterEstimation"
    )
    coil_cooling_water_to_air_heat_pump_variable_speed_equation_fit = (
        "Coil:Cooling:WaterToAirHeatPump:VariableSpeedEquationFit"
    )
    coil_user_defined = "Coil:UserDefined"
    coil_system_cooling_dx_heat_exchanger_assisted = (
        "CoilSystem:Cooling:DX:HeatExchangerAssisted"
    )
    coil_system_cooling_water_heat_exchanger_assisted = (
        "CoilSystem:Cooling:Water:HeatExchangerAssisted"
    )


class MinimumSupplyAirTemperature(RootModel[float]):
    root: Annotated[float, Field(ge=0.0, le=20.0)]


class LatentLoadControl(Enum):
    latent_only_load_control = "LatentOnlyLoadControl"
    latent_or_sensible_load_control = "LatentOrSensibleLoadControl"
    latent_with_sensible_load_control = "LatentWithSensibleLoadControl"
    sensible_only_load_control = "SensibleOnlyLoadControl"


class SupplementalHeatingCoilObjectType(Enum):
    coil_heating_desuperheater = "Coil:Heating:Desuperheater"
    coil_heating_electric = "Coil:Heating:Electric"
    coil_heating_electric_multistage = "Coil:Heating:Electric:Multistage"
    coil_heating_fuel = "Coil:Heating:Fuel"
    coil_heating_steam = "Coil:Heating:Steam"
    coil_heating_water = "Coil:Heating:Water"
    coil_user_defined = "Coil:UserDefined"


class CoolingSupplyAirFlowRateMethod1(Enum):
    flow_per_cooling_capacity = "FlowPerCoolingCapacity"
    flow_per_floor_area = "FlowPerFloorArea"
    fraction_of_autosized_cooling_value = "FractionOfAutosizedCoolingValue"
    none = "None"
    supply_air_flow_rate = "SupplyAirFlowRate"


class CoolingSupplyAirFlowRate1(DesignOutdoorAirFlowRate):
    pass


class HeatingSupplyAirFlowRateMethod1(Enum):
    flow_per_floor_area = "FlowPerFloorArea"
    flow_per_heating_capacity = "FlowPerHeatingCapacity"
    fraction_of_autosized_heating_value = "FractionOfAutosizedHeatingValue"
    none = "None"
    supply_air_flow_rate = "SupplyAirFlowRate"


class HeatingSupplyAirFlowRate1(DesignOutdoorAirFlowRate):
    pass


class NoLoadSupplyAirFlowRateMethod(Enum):
    flow_per_cooling_capacity = "FlowPerCoolingCapacity"
    flow_per_floor_area = "FlowPerFloorArea"
    flow_per_heating_capacity = "FlowPerHeatingCapacity"
    fraction_of_autosized_cooling_value = "FractionOfAutosizedCoolingValue"
    fraction_of_autosized_heating_value = "FractionOfAutosizedHeatingValue"
    none = "None"
    supply_air_flow_rate = "SupplyAirFlowRate"


class HeatingSpeedSupplyAirFlowRatio(CoolingSupplyAirFlowRate):
    pass


class CoolingSpeedSupplyAirFlowRatio(CoolingSupplyAirFlowRate):
    pass


class FlowRatio(BaseModel):
    heating_speed_supply_air_flow_ratio: Union[
        HeatingSpeedSupplyAirFlowRatio, Literal["Autosize"]
    ]
    cooling_speed_supply_air_flow_ratio: Union[
        CoolingSpeedSupplyAirFlowRatio, Literal["Autosize"]
    ]


class CoolingSupplyAirFlowRate2(CoolingSupplyAirFlowRate):
    pass


class HeatingSupplyAirFlowRate2(CoolingSupplyAirFlowRate):
    pass


class SupplyFanObjectType1(Enum):
    fan_constant_volume = "Fan:ConstantVolume"
    fan_on_off = "Fan:OnOff"


class CoolingCoilObjectType4(Enum):
    coil_cooling_dx_single_speed = "Coil:Cooling:DX:SingleSpeed"
    coil_cooling_dx_variable_speed = "Coil:Cooling:DX:VariableSpeed"
    coil_system_cooling_dx_heat_exchanger_assisted = (
        "CoilSystem:Cooling:DX:HeatExchangerAssisted"
    )


class ReheatCoilObjectType1(Enum):
    coil_heating_desuperheater = "Coil:Heating:Desuperheater"
    coil_heating_electric = "Coil:Heating:Electric"
    coil_heating_fuel = "Coil:Heating:Fuel"
    coil_heating_steam = "Coil:Heating:Steam"
    coil_heating_water = "Coil:Heating:Water"


class AirLoopHvacUnitaryFurnaceHeatCool(BaseModel):
    availability_schedule_name: Optional[str] = None
    furnace_air_inlet_node_name: str
    furnace_air_outlet_node_name: str
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    maximum_supply_air_temperature: Optional[Union[float, Literal["Autosize"]]] = 80.0
    cooling_supply_air_flow_rate: Union[CoolingSupplyAirFlowRate2, Literal["Autosize"]]
    heating_supply_air_flow_rate: Union[HeatingSupplyAirFlowRate2, Literal["Autosize"]]
    no_load_supply_air_flow_rate: Optional[
        Union[NoLoadSupplyAirFlowRate, Literal["Autosize"]]
    ] = None
    controlling_zone_or_thermostat_location: str
    supply_fan_object_type: SupplyFanObjectType1
    supply_fan_name: str
    fan_placement: Optional[FanPlacement] = FanPlacement.blow_through
    heating_coil_object_type: HeatingCoilObjectType1
    heating_coil_name: str
    cooling_coil_object_type: CoolingCoilObjectType4
    cooling_coil_name: str
    dehumidification_control_type: Optional[DehumidificationControlType1] = (
        DehumidificationControlType1.none
    )
    reheat_coil_object_type: Optional[ReheatCoilObjectType1] = None
    reheat_coil_name: Optional[str] = None


class AirLoopHvacUnitaryHeatCool(BaseModel):
    availability_schedule_name: Optional[str] = None
    unitary_system_air_inlet_node_name: str
    unitary_system_air_outlet_node_name: str
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    maximum_supply_air_temperature: Optional[Union[float, Literal["Autosize"]]] = 80.0
    cooling_supply_air_flow_rate: Union[CoolingSupplyAirFlowRate2, Literal["Autosize"]]
    heating_supply_air_flow_rate: Union[HeatingSupplyAirFlowRate2, Literal["Autosize"]]
    no_load_supply_air_flow_rate: Optional[
        Union[NoLoadSupplyAirFlowRate, Literal["Autosize"]]
    ] = None
    controlling_zone_or_thermostat_location: str
    supply_fan_object_type: SupplyFanObjectType1
    supply_fan_name: str
    fan_placement: Optional[FanPlacement] = FanPlacement.blow_through
    heating_coil_object_type: HeatingCoilObjectType1
    heating_coil_name: str
    cooling_coil_object_type: CoolingCoilObjectType4
    cooling_coil_name: str
    dehumidification_control_type: Optional[DehumidificationControlType1] = (
        DehumidificationControlType1.none
    )
    reheat_coil_object_type: Optional[ReheatCoilObjectType1] = None
    reheat_coil_name: Optional[str] = None


class HeatingCoilObjectType6(Enum):
    coil_heating_dx_single_speed = "Coil:Heating:DX:SingleSpeed"
    coil_heating_dx_variable_speed = "Coil:Heating:DX:VariableSpeed"
    coil_system_integrated_heat_pump_air_source = (
        "CoilSystem:IntegratedHeatPump:AirSource"
    )


class CoolingCoilObjectType6(Enum):
    coil_cooling_dx_single_speed = "Coil:Cooling:DX:SingleSpeed"
    coil_cooling_dx_variable_speed = "Coil:Cooling:DX:VariableSpeed"
    coil_system_cooling_dx_heat_exchanger_assisted = (
        "CoilSystem:Cooling:DX:HeatExchangerAssisted"
    )
    coil_system_integrated_heat_pump_air_source = (
        "CoilSystem:IntegratedHeatPump:AirSource"
    )


class AirLoopHvacUnitaryHeatPumpAirToAir(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    cooling_supply_air_flow_rate: Union[CoolingSupplyAirFlowRate2, Literal["Autosize"]]
    heating_supply_air_flow_rate: Union[HeatingSupplyAirFlowRate2, Literal["Autosize"]]
    no_load_supply_air_flow_rate: Optional[
        Union[NoLoadSupplyAirFlowRate, Literal["Autosize"]]
    ] = None
    controlling_zone_or_thermostat_location: str
    supply_air_fan_object_type: SupplyFanObjectType1
    supply_air_fan_name: str
    heating_coil_object_type: HeatingCoilObjectType6
    heating_coil_name: str
    cooling_coil_object_type: CoolingCoilObjectType6
    cooling_coil_name: str
    supplemental_heating_coil_object_type: HeatingCoilObjectType1
    supplemental_heating_coil_name: str
    maximum_supply_air_temperature_from_supplemental_heater: Union[
        float, Literal["Autosize"]
    ]
    maximum_outdoor_dry_bulb_temperature_for_supplemental_heater_operation: Annotated[
        Optional[float], Field(21.0, le=21.0)
    ]
    fan_placement: Optional[FanPlacement] = FanPlacement.blow_through
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    dehumidification_control_type: Optional[DehumidificationControlType1] = (
        DehumidificationControlType1.none
    )


class HeatingCoilObjectType7(Enum):
    coil_heating_water_to_air_heat_pump_equation_fit = (
        "Coil:Heating:WaterToAirHeatPump:EquationFit"
    )
    coil_heating_water_to_air_heat_pump_parameter_estimation = (
        "Coil:Heating:WaterToAirHeatPump:ParameterEstimation"
    )
    coil_heating_water_to_air_heat_pump_variable_speed_equation_fit = (
        "Coil:Heating:WaterToAirHeatPump:VariableSpeedEquationFit"
    )


class CoolingCoilObjectType7(Enum):
    coil_cooling_water_to_air_heat_pump_equation_fit = (
        "Coil:Cooling:WaterToAirHeatPump:EquationFit"
    )
    coil_cooling_water_to_air_heat_pump_parameter_estimation = (
        "Coil:Cooling:WaterToAirHeatPump:ParameterEstimation"
    )
    coil_cooling_water_to_air_heat_pump_variable_speed_equation_fit = (
        "Coil:Cooling:WaterToAirHeatPump:VariableSpeedEquationFit"
    )


class DehumidificationControlType6(Enum):
    cool_reheat = "CoolReheat"
    none = "None"


class HeatPumpCoilWaterFlowMode(Enum):
    constant = "Constant"
    constant_on_demand = "ConstantOnDemand"
    cycling = "Cycling"


class AirLoopHvacUnitaryHeatPumpWaterToAir(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    supply_air_flow_rate: Union[SupplyAirFlowRate, Literal["Autosize"]]
    controlling_zone_or_thermostat_location: str
    supply_air_fan_object_type: Literal["Fan:OnOff"]
    supply_air_fan_name: str
    heating_coil_object_type: HeatingCoilObjectType7
    heating_coil_name: str
    heating_convergence: Annotated[Optional[float], Field(0.001, gt=0.0)]
    cooling_coil_object_type: CoolingCoilObjectType7
    cooling_coil_name: str
    cooling_convergence: Annotated[Optional[float], Field(0.001, gt=0.0)]
    supplemental_heating_coil_object_type: HeatingCoilObjectType1
    supplemental_heating_coil_name: str
    maximum_supply_air_temperature_from_supplemental_heater: Union[
        float, Literal["Autosize"]
    ]
    maximum_outdoor_dry_bulb_temperature_for_supplemental_heater_operation: Annotated[
        Optional[float], Field(21.0, le=21.0)
    ]
    outdoor_dry_bulb_temperature_sensor_node_name: Optional[str] = None
    fan_placement: Optional[FanPlacement] = FanPlacement.blow_through
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    dehumidification_control_type: Optional[DehumidificationControlType6] = (
        DehumidificationControlType6.none
    )
    heat_pump_coil_water_flow_mode: Optional[HeatPumpCoilWaterFlowMode] = (
        HeatPumpCoilWaterFlowMode.cycling
    )


class ControlVariable(Enum):
    humidity_ratio = "HumidityRatio"
    temperature = "Temperature"
    temperature_and_humidity_ratio = "TemperatureAndHumidityRatio"


class Action(Enum):
    normal = "Normal"
    reverse = "Reverse"


class MaximumActuatedFlow(DesignOutdoorAirFlowRate):
    pass


class ControllerWaterCoil(BaseModel):
    control_variable: ControlVariable
    action: Optional[Action] = None
    actuator_variable: Literal["Flow"]
    sensor_node_name: str
    actuator_node_name: str
    controller_convergence_tolerance: Optional[Union[float, Literal["Autosize"]]] = (
        "Autosize"
    )
    maximum_actuated_flow: Optional[Union[MaximumActuatedFlow, Literal["Autosize"]]] = (
        "Autosize"
    )
    minimum_actuated_flow: Annotated[Optional[float], Field(0.0, ge=0.0)]


class EconomizerControlType(Enum):
    differential_dry_bulb = "DifferentialDryBulb"
    differential_dry_bulb_and_enthalpy = "DifferentialDryBulbAndEnthalpy"
    differential_enthalpy = "DifferentialEnthalpy"
    electronic_enthalpy = "ElectronicEnthalpy"
    fixed_dew_point_and_dry_bulb = "FixedDewPointAndDryBulb"
    fixed_dry_bulb = "FixedDryBulb"
    fixed_enthalpy = "FixedEnthalpy"
    no_economizer = "NoEconomizer"


class EconomizerControlActionType(Enum):
    minimum_flow_with_bypass = "MinimumFlowWithBypass"
    modulate_flow = "ModulateFlow"


class LockoutType(Enum):
    lockout_with_compressor = "LockoutWithCompressor"
    lockout_with_heating = "LockoutWithHeating"
    no_lockout = "NoLockout"


class MinimumLimitType(Enum):
    fixed_minimum = "FixedMinimum"
    proportional_minimum = "ProportionalMinimum"


class HeatRecoveryBypassControlType(Enum):
    bypass_when_oa_flow_greater_than_minimum = "BypassWhenOAFlowGreaterThanMinimum"
    bypass_when_within_economizer_limits = "BypassWhenWithinEconomizerLimits"


class EconomizerOperationStaging(Enum):
    economizer_first = "EconomizerFirst"
    interlocked_with_mechanical_cooling = "InterlockedWithMechanicalCooling"


class SystemOutdoorAirMethod1(Enum):
    indoor_air_quality_procedure = "IndoorAirQualityProcedure"
    indoor_air_quality_procedure_combined = "IndoorAirQualityProcedureCombined"
    indoor_air_quality_procedure_generic_contaminant = (
        "IndoorAirQualityProcedureGenericContaminant"
    )
    proportional_control_based_on_design_oa_rate = (
        "ProportionalControlBasedOnDesignOARate"
    )
    proportional_control_based_on_design_occupancy = (
        "ProportionalControlBasedOnDesignOccupancy"
    )
    proportional_control_based_on_occupancy_schedule = (
        "ProportionalControlBasedOnOccupancySchedule"
    )
    standard62_1_ventilation_rate_procedure = "Standard62.1VentilationRateProcedure"
    standard62_1_ventilation_rate_procedure_with_limit = (
        "Standard62.1VentilationRateProcedureWithLimit"
    )
    zone_sum = "ZoneSum"


class ZoneSpecification(BaseModel):
    zone_or_zonelist_name: str
    design_specification_outdoor_air_object_name: Optional[str] = None
    design_specification_zone_air_distribution_object_name: Optional[str] = None


class Controller1ObjectType(Enum):
    controller_outdoor_air = "Controller:OutdoorAir"
    controller_water_coil = "Controller:WaterCoil"


class AirLoopHvacControllerList(BaseModel):
    controller_1_object_type: Controller1ObjectType
    controller_1_name: str
    controller_2_object_type: Optional[Controller1ObjectType] = None
    controller_2_name: Optional[str] = None
    controller_3_object_type: Optional[Controller1ObjectType] = None
    controller_3_name: Optional[str] = None
    controller_4_object_type: Optional[Controller1ObjectType] = None
    controller_4_name: Optional[str] = None
    controller_5_object_type: Optional[Controller1ObjectType] = None
    controller_5_name: Optional[str] = None
    controller_6_object_type: Optional[Controller1ObjectType] = None
    controller_6_name: Optional[str] = None
    controller_7_object_type: Optional[Controller1ObjectType] = None
    controller_7_name: Optional[str] = None
    controller_8_object_type: Optional[Controller1ObjectType] = None
    controller_8_name: Optional[str] = None


class AirLoopHvac(BaseModel):
    controller_list_name: Optional[str] = None
    availability_manager_list_name: Optional[str] = None
    design_supply_air_flow_rate: Optional[Union[float, Literal["Autosize"]]] = 0.0
    branch_list_name: str
    connector_list_name: Optional[str] = None
    supply_side_inlet_node_name: str
    demand_side_outlet_node_name: Optional[str] = None
    demand_side_inlet_node_names: str
    supply_side_outlet_node_names: str
    design_return_air_flow_fraction_of_supply_air_flow: Annotated[
        Optional[float], Field(1.0, ge=0.0)
    ]


class AirLoopHvacOutdoorAirSystemEquipmentList(BaseModel):
    component_1_object_type: str
    component_1_name: str
    component_2_object_type: Optional[str] = None
    component_2_name: Optional[str] = None
    component_3_object_type: Optional[str] = None
    component_3_name: Optional[str] = None
    component_4_object_type: Optional[str] = None
    component_4_name: Optional[str] = None
    component_5_object_type: Optional[str] = None
    component_5_name: Optional[str] = None
    component_6_object_type: Optional[str] = None
    component_6_name: Optional[str] = None
    component_7_object_type: Optional[str] = None
    component_7_name: Optional[str] = None
    component_8_object_type: Optional[str] = None
    component_8_name: Optional[str] = None
    component_9_object_type: Optional[str] = None
    component_9_name: Optional[str] = None


class AirLoopHvacOutdoorAirSystem(BaseModel):
    controller_list_name: Optional[str] = None
    outdoor_air_equipment_list_name: str


class OutdoorAirMixer(BaseModel):
    mixed_air_node_name: str
    outdoor_air_stream_node_name: str
    relief_air_stream_node_name: str
    return_air_stream_node_name: str


class Node(BaseModel):
    outlet_node_name: str


class AirLoopHvacZoneSplitter(BaseModel):
    inlet_node_name: str
    nodes: Optional[List[Node]] = None


class ComponentObjectType(Enum):
    air_loop_hvac_supply_plenum = "AirLoopHVAC:SupplyPlenum"
    air_loop_hvac_zone_splitter = "AirLoopHVAC:ZoneSplitter"


class Component(BaseModel):
    component_object_type: ComponentObjectType
    component_name: str


class AirLoopHvacSupplyPath(BaseModel):
    supply_air_path_inlet_node_name: str
    components: Optional[List[Component]] = None


class Node1(BaseModel):
    inlet_node_name: str


class AirLoopHvacZoneMixer(BaseModel):
    outlet_node_name: str
    nodes: Optional[List[Node1]] = None


class AirLoopHvacReturnPlenum(BaseModel):
    zone_name: str
    zone_node_name: str
    outlet_node_name: str
    induced_air_outlet_node_or_nodelist_name: Optional[str] = None
    nodes: Optional[List[Node1]] = None


class ComponentObjectType1(Enum):
    air_loop_hvac_return_plenum = "AirLoopHVAC:ReturnPlenum"
    air_loop_hvac_zone_mixer = "AirLoopHVAC:ZoneMixer"


class Component1(BaseModel):
    component_object_type: ComponentObjectType1
    component_name: str


class AirLoopHvacReturnPath(BaseModel):
    return_air_path_outlet_node_name: str
    components: Optional[List[Component1]] = None


class Component2(BaseModel):
    component_object_type: str
    component_name: str
    component_inlet_node_name: str
    component_outlet_node_name: str


class Branch(BaseModel):
    pressure_drop_curve_name: Optional[str] = None
    components: Optional[List[Component2]] = None


class Branch1(BaseModel):
    branch_name: str


class BranchList(BaseModel):
    branches: Optional[List[Branch1]] = None


class Branch2(BaseModel):
    outlet_branch_name: str


class ConnectorSplitter(BaseModel):
    inlet_branch_name: str
    branches: Optional[List[Branch2]] = None


class Branch3(BaseModel):
    inlet_branch_name: str


class ConnectorMixer(BaseModel):
    outlet_branch_name: str
    branches: Optional[List[Branch3]] = None


class Connector1ObjectType(Enum):
    connector_mixer = "Connector:Mixer"
    connector_splitter = "Connector:Splitter"


class ConnectorList(BaseModel):
    connector_1_object_type: Connector1ObjectType
    connector_1_name: str
    connector_2_object_type: Optional[Connector1ObjectType] = None
    connector_2_name: Optional[str] = None


class Node3(BaseModel):
    node_name: str


class NodeList(BaseModel):
    nodes: Optional[List[Node3]] = None


class WindAngleType(Enum):
    absolute = "Absolute"
    relative = "Relative"


class Node4(BaseModel):
    node_or_nodelist_name: str


class OutdoorAirNodeList(BaseModel):
    nodes: Optional[List[Node4]] = None


class PipeAdiabatic(BaseModel):
    inlet_node_name: str
    outlet_node_name: str


class DesignMaximumFlowRate(CoolingSupplyAirFlowRate):
    pass


class PumpControlType(Enum):
    continuous = "Continuous"
    intermittent = "Intermittent"


class VfdControlType(Enum):
    manual_control = "ManualControl"
    pressure_setpoint_control = "PressureSetpointControl"


class DesignPowerSizingMethod1(Enum):
    power_per_flow = "PowerPerFlow"
    power_per_flow_per_pressure = "PowerPerFlowPerPressure"


class PumpVariableSpeed(BaseModel):
    inlet_node_name: str
    outlet_node_name: str
    design_maximum_flow_rate: Optional[
        Union[DesignMaximumFlowRate, Literal["Autosize"]]
    ] = None
    design_pump_head: Optional[float] = 179352.0
    design_power_consumption: Optional[Union[float, Literal["Autosize"]]] = None
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    fraction_of_motor_inefficiencies_to_fluid_stream: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    coefficient_1_of_the_part_load_performance_curve: Optional[float] = 0.0
    coefficient_2_of_the_part_load_performance_curve: Optional[float] = 1.0
    coefficient_3_of_the_part_load_performance_curve: Optional[float] = 0.0
    coefficient_4_of_the_part_load_performance_curve: Optional[float] = 0.0
    design_minimum_flow_rate: Optional[Union[float, Literal["Autosize"]]] = "Autosize"
    pump_control_type: Optional[PumpControlType] = PumpControlType.continuous
    pump_flow_rate_schedule_name: Optional[str] = None
    pump_curve_name: Optional[str] = None
    impeller_diameter: Optional[float] = None
    vfd_control_type: Optional[VfdControlType] = None
    pump_rpm_schedule_name: Optional[str] = None
    minimum_pressure_schedule: Optional[str] = None
    maximum_pressure_schedule: Optional[str] = None
    minimum_rpm_schedule: Optional[str] = None
    maximum_rpm_schedule: Optional[str] = None
    zone_name: Optional[str] = None
    skin_loss_radiative_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    design_power_sizing_method: Optional[DesignPowerSizingMethod1] = (
        DesignPowerSizingMethod1.power_per_flow_per_pressure
    )
    design_electric_power_per_unit_flow_rate: Annotated[
        Optional[float], Field(348701.1, gt=0.0)
    ]
    design_shaft_power_per_unit_flow_rate_per_unit_head: Annotated[
        Optional[float], Field(1.282051282, gt=0.0)
    ]
    design_minimum_flow_rate_fraction: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    end_use_subcategory: Optional[str] = "General"


class DesignFlowRate(CoolingSupplyAirFlowRate):
    pass


class PumpConstantSpeed(BaseModel):
    inlet_node_name: str
    outlet_node_name: str
    design_flow_rate: Optional[Union[DesignFlowRate, Literal["Autosize"]]] = None
    design_pump_head: Optional[float] = 179352.0
    design_power_consumption: Optional[Union[float, Literal["Autosize"]]] = None
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    fraction_of_motor_inefficiencies_to_fluid_stream: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    pump_control_type: Optional[PumpControlType] = PumpControlType.continuous
    pump_flow_rate_schedule_name: Optional[str] = None
    pump_curve_name: Optional[str] = None
    impeller_diameter: Optional[float] = None
    rotational_speed: Optional[float] = None
    zone_name: Optional[str] = None
    skin_loss_radiative_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    design_power_sizing_method: Optional[DesignPowerSizingMethod1] = (
        DesignPowerSizingMethod1.power_per_flow_per_pressure
    )
    design_electric_power_per_unit_flow_rate: Annotated[
        Optional[float], Field(348701.1, gt=0.0)
    ]
    design_shaft_power_per_unit_flow_rate_per_unit_head: Annotated[
        Optional[float], Field(1.282051282, gt=0.0)
    ]
    end_use_subcategory: Optional[str] = "General"


class TotalDesignFlowRate(CoolingSupplyAirFlowRate):
    pass


class HeaderedPumpsVariableSpeed(BaseModel):
    inlet_node_name: str
    outlet_node_name: str
    total_design_flow_rate: Optional[
        Union[TotalDesignFlowRate, Literal["Autosize"]]
    ] = None
    number_of_pumps_in_bank: Optional[int] = None
    flow_sequencing_control_scheme: Optional[Literal["Sequential"]] = "Sequential"
    design_pump_head: Optional[float] = 179352.0
    design_power_consumption: Optional[Union[float, Literal["Autosize"]]] = None
    motor_efficiency: Annotated[Optional[float], Field(0.9, gt=0.0, le=1.0)]
    fraction_of_motor_inefficiencies_to_fluid_stream: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    coefficient_1_of_the_part_load_performance_curve: Optional[float] = 0.0
    coefficient_2_of_the_part_load_performance_curve: Optional[float] = 1.0
    coefficient_3_of_the_part_load_performance_curve: Optional[float] = 0.0
    coefficient_4_of_the_part_load_performance_curve: Optional[float] = 0.0
    minimum_flow_rate_fraction: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    pump_control_type: Optional[PumpControlType] = PumpControlType.continuous
    pump_flow_rate_schedule_name: Optional[str] = None
    zone_name: Optional[str] = None
    skin_loss_radiative_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    design_power_sizing_method: Optional[DesignPowerSizingMethod1] = (
        DesignPowerSizingMethod1.power_per_flow_per_pressure
    )
    design_electric_power_per_unit_flow_rate: Annotated[
        Optional[float], Field(348701.1, gt=0.0)
    ]
    design_shaft_power_per_unit_flow_rate_per_unit_head: Annotated[
        Optional[float], Field(1.282051282, gt=0.0)
    ]
    end_use_subcategory: Optional[str] = "General"


class FuelType4(Enum):
    coal = "Coal"
    diesel = "Diesel"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"


class NominalCapacity(DesignOutdoorAirFlowRate):
    pass


class EfficiencyCurveTemperatureEvaluationVariable(Enum):
    entering_boiler = "EnteringBoiler"
    leaving_boiler = "LeavingBoiler"


class BoilerFlowMode(Enum):
    constant_flow = "ConstantFlow"
    leaving_setpoint_modulated = "LeavingSetpointModulated"
    not_modulated = "NotModulated"


class BoilerHotWater(BaseModel):
    fuel_type: FuelType4
    nominal_capacity: Optional[Union[NominalCapacity, Literal["Autosize"]]] = None
    nominal_thermal_efficiency: Annotated[float, Field(gt=0.0, le=1.0)]
    efficiency_curve_temperature_evaluation_variable: Optional[
        EfficiencyCurveTemperatureEvaluationVariable
    ] = None
    normalized_boiler_efficiency_curve_name: Optional[str] = None
    design_water_flow_rate: Optional[
        Union[DesignWaterFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    minimum_part_load_ratio: Annotated[Optional[float], Field(0.0, ge=0.0)]
    maximum_part_load_ratio: Annotated[Optional[float], Field(1.0, ge=0.0)]
    optimum_part_load_ratio: Annotated[Optional[float], Field(1.0, ge=0.0)]
    boiler_water_inlet_node_name: str
    boiler_water_outlet_node_name: str
    water_outlet_upper_temperature_limit: Optional[float] = 99.9
    boiler_flow_mode: Optional[BoilerFlowMode] = BoilerFlowMode.not_modulated
    on_cycle_parasitic_electric_load: Annotated[Optional[float], Field(0.0, ge=0.0)]
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    end_use_subcategory: Optional[str] = "General"
    off_cycle_parasitic_fuel_load: Optional[float] = None


class PerformanceInterpolationMethod(Enum):
    cubic = "Cubic"
    linear = "Linear"


class RatedCapacity2(CoolingSupplyAirFlowRate):
    pass


class AmbientTemperatureIndicator(Enum):
    outdoors = "Outdoors"
    schedule = "Schedule"
    zone = "Zone"


class ChilledWaterMaximumRequestedFlowRate(CoolingSupplyAirFlowRate):
    pass


class CondenserMaximumRequestedFlowRate(CoolingSupplyAirFlowRate):
    pass


class ChillerElectricAshrae205(BaseModel):
    representation_file_name: str
    performance_interpolation_method: Optional[PerformanceInterpolationMethod] = (
        PerformanceInterpolationMethod.linear
    )
    rated_capacity: Optional[Union[RatedCapacity2, Literal["Autosize"]]] = "Autosize"
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    ambient_temperature_indicator: AmbientTemperatureIndicator
    ambient_temperature_schedule_name: Optional[str] = None
    ambient_temperature_zone_name: Optional[str] = None
    ambient_temperature_outdoor_air_node_name: Optional[str] = None
    chilled_water_inlet_node_name: str
    chilled_water_outlet_node_name: str
    chilled_water_maximum_requested_flow_rate: Optional[
        Union[ChilledWaterMaximumRequestedFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    condenser_inlet_node_name: Optional[str] = None
    condenser_outlet_node_name: Optional[str] = None
    condenser_maximum_requested_flow_rate: Optional[
        Union[CondenserMaximumRequestedFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    chiller_flow_mode: Optional[BoilerFlowMode] = BoilerFlowMode.not_modulated
    oil_cooler_inlet_node_name: Optional[str] = None
    oil_cooler_outlet_node_name: Optional[str] = None
    oil_cooler_design_flow_rate: Annotated[Optional[float], Field(None, gt=0.0)]
    auxiliary_inlet_node_name: Optional[str] = None
    auxiliary_outlet_node_name: Optional[str] = None
    auxiliary_cooling_design_flow_rate: Annotated[Optional[float], Field(None, gt=0.0)]
    heat_recovery_inlet_node_name: Optional[str] = None
    heat_recovery_outlet_node_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"


class ReferenceCapacity(CoolingSupplyAirFlowRate):
    pass


class ReferenceChilledWaterFlowRate(CoolingSupplyAirFlowRate):
    pass


class ReferenceCondenserFluidFlowRate(DesignOutdoorAirFlowRate):
    pass


class CondenserType3(Enum):
    air_cooled = "AirCooled"
    evaporatively_cooled = "EvaporativelyCooled"
    water_cooled = "WaterCooled"


class DesignHeatRecoveryWaterFlowRate(DesignOutdoorAirFlowRate):
    pass


class ChillerElectricEir(BaseModel):
    reference_capacity: Union[ReferenceCapacity, Literal["Autosize"]]
    reference_cop: Annotated[float, Field(gt=0.0)]
    reference_leaving_chilled_water_temperature: Optional[float] = 6.67
    reference_entering_condenser_fluid_temperature: Optional[float] = 29.4
    reference_chilled_water_flow_rate: Optional[
        Union[ReferenceChilledWaterFlowRate, Literal["Autosize"]]
    ] = None
    reference_condenser_fluid_flow_rate: Optional[
        Union[ReferenceCondenserFluidFlowRate, Literal["Autosize"]]
    ] = None
    cooling_capacity_function_of_temperature_curve_name: str
    electric_input_to_cooling_output_ratio_function_of_temperature_curve_name: str
    electric_input_to_cooling_output_ratio_function_of_part_load_ratio_curve_name: str
    minimum_part_load_ratio: Annotated[Optional[float], Field(0.1, ge=0.0)]
    maximum_part_load_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    optimum_part_load_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    minimum_unloading_ratio: Annotated[Optional[float], Field(0.2, ge=0.0)]
    chilled_water_inlet_node_name: str
    chilled_water_outlet_node_name: str
    condenser_inlet_node_name: Optional[str] = None
    condenser_outlet_node_name: Optional[str] = None
    condenser_type: Optional[CondenserType3] = CondenserType3.water_cooled
    condenser_fan_power_ratio: Annotated[Optional[float], Field(0.0, ge=0.0)]
    fraction_of_compressor_electric_consumption_rejected_by_condenser: Annotated[
        Optional[float], Field(1.0, gt=0.0, le=1.0)
    ]
    leaving_chilled_water_lower_temperature_limit: Optional[float] = 2.0
    chiller_flow_mode: Optional[BoilerFlowMode] = BoilerFlowMode.not_modulated
    design_heat_recovery_water_flow_rate: Optional[
        Union[DesignHeatRecoveryWaterFlowRate, Literal["Autosize"]]
    ] = 0.0
    heat_recovery_inlet_node_name: Optional[str] = None
    heat_recovery_outlet_node_name: Optional[str] = None
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    condenser_heat_recovery_relative_capacity_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    heat_recovery_inlet_high_temperature_limit_schedule_name: Optional[str] = None
    heat_recovery_leaving_temperature_setpoint_node_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"


class ReferenceCondenserWaterFlowRate(CoolingSupplyAirFlowRate):
    pass


class ElectricInputToCoolingOutputRatioFunctionOfPartLoadRatioCurveType(Enum):
    leaving_condenser_water_temperature = "LeavingCondenserWaterTemperature"
    lift = "Lift"


class ChillerElectricReformulatedEir(BaseModel):
    reference_capacity: Union[ReferenceCapacity, Literal["Autosize"]]
    reference_cop: Annotated[float, Field(gt=0.0)]
    reference_leaving_chilled_water_temperature: Optional[float] = 6.67
    reference_leaving_condenser_water_temperature: Optional[float] = 35.0
    reference_chilled_water_flow_rate: Optional[
        Union[ReferenceChilledWaterFlowRate, Literal["Autosize"]]
    ] = None
    reference_condenser_water_flow_rate: Optional[
        Union[ReferenceCondenserWaterFlowRate, Literal["Autosize"]]
    ] = None
    cooling_capacity_function_of_temperature_curve_name: str
    electric_input_to_cooling_output_ratio_function_of_temperature_curve_name: str
    electric_input_to_cooling_output_ratio_function_of_part_load_ratio_curve_type: Optional[
        ElectricInputToCoolingOutputRatioFunctionOfPartLoadRatioCurveType
    ] = (
        ElectricInputToCoolingOutputRatioFunctionOfPartLoadRatioCurveType.leaving_condenser_water_temperature
    )
    electric_input_to_cooling_output_ratio_function_of_part_load_ratio_curve_name: str
    minimum_part_load_ratio: Annotated[Optional[float], Field(0.1, ge=0.0)]
    maximum_part_load_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    optimum_part_load_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    minimum_unloading_ratio: Annotated[Optional[float], Field(0.2, ge=0.0)]
    chilled_water_inlet_node_name: str
    chilled_water_outlet_node_name: str
    condenser_inlet_node_name: str
    condenser_outlet_node_name: str
    fraction_of_compressor_electric_consumption_rejected_by_condenser: Annotated[
        Optional[float], Field(1.0, gt=0.0, le=1.0)
    ]
    leaving_chilled_water_lower_temperature_limit: Optional[float] = 2.0
    chiller_flow_mode_type: Optional[BoilerFlowMode] = BoilerFlowMode.not_modulated
    design_heat_recovery_water_flow_rate: Optional[
        Union[DesignHeatRecoveryWaterFlowRate, Literal["Autosize"]]
    ] = 0.0
    heat_recovery_inlet_node_name: Optional[str] = None
    heat_recovery_outlet_node_name: Optional[str] = None
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    condenser_heat_recovery_relative_capacity_fraction: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    heat_recovery_inlet_high_temperature_limit_schedule_name: Optional[str] = None
    heat_recovery_leaving_temperature_setpoint_node_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"


class DesignWaterFlowRate2(CoolingSupplyAirFlowRate):
    pass


class DesignAirFlowRate1(CoolingSupplyAirFlowRate):
    pass


class DesignFanPower(CoolingSupplyAirFlowRate):
    pass


class DesignUFactorTimesAreaValue(RootModel[float]):
    root: Annotated[float, Field(gt=0.0, le=2100000.0)]


class FreeConvectionRegimeAirFlowRate(DesignOutdoorAirFlowRate):
    pass


class FreeConvectionRegimeUFactorTimesAreaValue(RootModel[float]):
    root: Annotated[float, Field(ge=0.0, le=300000.0)]


class FreeConvectionCapacity(DesignOutdoorAirFlowRate):
    pass


class DesignApproachTemperature(CoolingSupplyAirFlowRate):
    pass


class DesignRangeTemperature(CoolingSupplyAirFlowRate):
    pass


class EvaporationLossMode(Enum):
    loss_factor = "LossFactor"
    saturated_exit = "SaturatedExit"


class BlowdownCalculationMode(Enum):
    concentration_ratio = "ConcentrationRatio"
    scheduled_rate = "ScheduledRate"


class CapacityControl(Enum):
    fan_cycling = "FanCycling"
    fluid_bypass = "FluidBypass"


class CellControl(Enum):
    maximal_cell = "MaximalCell"
    minimal_cell = "MinimalCell"


class CoolingTowerSingleSpeed(BaseModel):
    water_inlet_node_name: str
    water_outlet_node_name: str
    design_water_flow_rate: Optional[
        Union[DesignWaterFlowRate2, Literal["Autosize"]]
    ] = None
    design_air_flow_rate: Union[DesignAirFlowRate1, Literal["Autosize"]]
    design_fan_power: Union[DesignFanPower, Literal["Autosize"]]
    design_u_factor_times_area_value: Optional[
        Union[DesignUFactorTimesAreaValue, Literal["Autosize"]]
    ] = None
    free_convection_regime_air_flow_rate: Optional[
        Union[FreeConvectionRegimeAirFlowRate, Literal["Autocalculate"]]
    ] = 0.0
    free_convection_regime_air_flow_rate_sizing_factor: Annotated[
        Optional[float], Field(0.1, gt=0.0, lt=1.0)
    ]
    free_convection_regime_u_factor_times_area_value: Optional[
        Union[FreeConvectionRegimeUFactorTimesAreaValue, Literal["Autocalculate"]]
    ] = 0.0
    free_convection_u_factor_times_area_value_sizing_factor: Annotated[
        Optional[float], Field(0.1, gt=0.0, lt=1.0)
    ]
    performance_input_method: Optional[PerformanceInputMethod] = (
        PerformanceInputMethod.u_factor_times_area_and_design_water_flow_rate
    )
    heat_rejection_capacity_and_nominal_capacity_sizing_ratio: Optional[float] = 1.25
    nominal_capacity: Annotated[Optional[float], Field(None, gt=0.0)]
    free_convection_capacity: Optional[
        Union[FreeConvectionCapacity, Literal["Autocalculate"]]
    ] = None
    free_convection_nominal_capacity_sizing_factor: Annotated[
        Optional[float], Field(0.1, gt=0.0, lt=1.0)
    ]
    design_inlet_air_dry_bulb_temperature: Annotated[
        Optional[float], Field(35.0, ge=20.0)
    ]
    design_inlet_air_wet_bulb_temperature: Annotated[
        Optional[float], Field(25.6, ge=20.0)
    ]
    design_approach_temperature: Optional[
        Union[DesignApproachTemperature, Literal["Autosize"]]
    ] = "Autosize"
    design_range_temperature: Optional[
        Union[DesignRangeTemperature, Literal["Autosize"]]
    ] = "Autosize"
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    evaporation_loss_mode: Optional[EvaporationLossMode] = (
        EvaporationLossMode.saturated_exit
    )
    evaporation_loss_factor: Optional[float] = 0.2
    drift_loss_percent: Optional[float] = 0.008
    blowdown_calculation_mode: Optional[BlowdownCalculationMode] = (
        BlowdownCalculationMode.concentration_ratio
    )
    blowdown_concentration_ratio: Annotated[Optional[float], Field(3.0, ge=2.0)]
    blowdown_makeup_water_usage_schedule_name: Optional[str] = None
    supply_water_storage_tank_name: Optional[str] = None
    outdoor_air_inlet_node_name: Optional[str] = None
    capacity_control: Optional[CapacityControl] = CapacityControl.fan_cycling
    number_of_cells: Annotated[Optional[int], Field(1, ge=1)]
    cell_control: Optional[CellControl] = CellControl.maximal_cell
    cell_minimum_water_flow_rate_fraction: Annotated[
        Optional[float], Field(0.33, gt=0.0, le=1.0)
    ]
    cell_maximum_water_flow_rate_fraction: Annotated[
        Optional[float], Field(2.5, ge=1.0)
    ]
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    end_use_subcategory: Optional[str] = "General"


class ModelType(Enum):
    cool_tools_cross_flow = "CoolToolsCrossFlow"
    cool_tools_user_defined = "CoolToolsUserDefined"
    york_calc = "YorkCalc"
    york_calc_user_defined = "YorkCalcUserDefined"


class CoolingTowerVariableSpeed(BaseModel):
    model_config = ConfigDict(protected_namespaces=())

    water_inlet_node_name: str
    water_outlet_node_name: str
    model_type: Optional[ModelType] = ModelType.york_calc
    model_coefficient_name: Optional[str] = None
    design_inlet_air_wet_bulb_temperature: Annotated[
        Optional[float], Field(25.6, ge=20.0)
    ]
    design_approach_temperature: Annotated[Optional[float], Field(3.9, gt=0.0)]
    design_range_temperature: Annotated[Optional[float], Field(5.6, gt=0.0)]
    design_water_flow_rate: Union[DesignWaterFlowRate2, Literal["Autosize"]]
    design_air_flow_rate: Union[DesignAirFlowRate1, Literal["Autosize"]]
    design_fan_power: Union[DesignFanPower, Literal["Autosize"]]
    fan_power_ratio_function_of_air_flow_rate_ratio_curve_name: Optional[str] = None
    minimum_air_flow_rate_ratio: Annotated[Optional[float], Field(0.2, ge=0.2, le=0.5)]
    fraction_of_tower_capacity_in_free_convection_regime: Annotated[
        Optional[float], Field(0.125, ge=0.0, le=0.2)
    ]
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    evaporation_loss_mode: Optional[EvaporationLossMode] = (
        EvaporationLossMode.saturated_exit
    )
    evaporation_loss_factor: Optional[float] = 0.2
    drift_loss_percent: Optional[float] = 0.008
    blowdown_calculation_mode: Optional[BlowdownCalculationMode] = (
        BlowdownCalculationMode.concentration_ratio
    )
    blowdown_concentration_ratio: Annotated[Optional[float], Field(3.0, ge=2.0)]
    blowdown_makeup_water_usage_schedule_name: Optional[str] = None
    supply_water_storage_tank_name: Optional[str] = None
    outdoor_air_inlet_node_name: Optional[str] = None
    number_of_cells: Annotated[Optional[int], Field(1, ge=1)]
    cell_control: Optional[CellControl] = CellControl.maximal_cell
    cell_minimum_water_flow_rate_fraction: Annotated[
        Optional[float], Field(0.33, gt=0.0, le=1.0)
    ]
    cell_maximum_water_flow_rate_fraction: Annotated[
        Optional[float], Field(2.5, ge=1.0)
    ]
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    end_use_subcategory: Optional[str] = "General"


class HighFanSpeedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class HighFanSpeedFanPower(CoolingSupplyAirFlowRate):
    pass


class LowFanSpeedAirFlowRate(CoolingSupplyAirFlowRate):
    pass


class LowFanSpeedFanPower(CoolingSupplyAirFlowRate):
    pass


class PerformanceInputMethod2(Enum):
    standard_design_capacity = "StandardDesignCapacity"
    u_factor_times_area_and_design_water_flow_rate = (
        "UFactorTimesAreaAndDesignWaterFlowRate"
    )
    user_specified_design_capacity = "UserSpecifiedDesignCapacity"


class LowSpeedStandardDesignCapacity(CoolingSupplyAirFlowRate):
    pass


class HighFanSpeedUFactorTimesAreaValue(DesignUFactorTimesAreaValue):
    pass


class LowFanSpeedUFactorTimesAreaValue(RootModel[float]):
    root: Annotated[float, Field(gt=0.0, le=300000.0)]


class LowSpeedUserSpecifiedDesignCapacity(CoolingSupplyAirFlowRate):
    pass


class EvaporativeFluidCoolerTwoSpeed(BaseModel):
    water_inlet_node_name: str
    water_outlet_node_name: str
    high_fan_speed_air_flow_rate: Union[HighFanSpeedAirFlowRate, Literal["Autosize"]]
    high_fan_speed_fan_power: Union[HighFanSpeedFanPower, Literal["Autosize"]]
    low_fan_speed_air_flow_rate: Union[LowFanSpeedAirFlowRate, Literal["Autocalculate"]]
    low_fan_speed_air_flow_rate_sizing_factor: Optional[float] = 0.5
    low_fan_speed_fan_power: Union[LowFanSpeedFanPower, Literal["Autocalculate"]]
    low_fan_speed_fan_power_sizing_factor: Optional[float] = 0.16
    design_spray_water_flow_rate: Annotated[float, Field(gt=0.0)]
    performance_input_method: PerformanceInputMethod2
    outdoor_air_inlet_node_name: Optional[str] = None
    heat_rejection_capacity_and_nominal_capacity_sizing_ratio: Optional[float] = 1.25
    high_speed_standard_design_capacity: Annotated[Optional[float], Field(None, gt=0.0)]
    low_speed_standard_design_capacity: Optional[
        Union[LowSpeedStandardDesignCapacity, Literal["Autocalculate"]]
    ] = None
    low_speed_standard_capacity_sizing_factor: Optional[float] = 0.5
    high_fan_speed_u_factor_times_area_value: Optional[
        Union[HighFanSpeedUFactorTimesAreaValue, Literal["Autosize"]]
    ] = None
    low_fan_speed_u_factor_times_area_value: Optional[
        Union[LowFanSpeedUFactorTimesAreaValue, Literal["Autocalculate"]]
    ] = None
    low_fan_speed_u_factor_times_area_sizing_factor: Optional[float] = 0.6
    design_water_flow_rate: Optional[
        Union[DesignWaterFlowRate2, Literal["Autosize"]]
    ] = None
    high_speed_user_specified_design_capacity: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    low_speed_user_specified_design_capacity: Optional[
        Union[LowSpeedUserSpecifiedDesignCapacity, Literal["Autocalculate"]]
    ] = None
    low_speed_user_specified_design_capacity_sizing_factor: Optional[float] = 0.5
    design_entering_water_temperature: Annotated[Optional[float], Field(None, gt=0.0)]
    design_entering_air_temperature: Annotated[Optional[float], Field(None, gt=0.0)]
    design_entering_air_wet_bulb_temperature: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    high_speed_sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    evaporation_loss_mode: Optional[EvaporationLossMode] = (
        EvaporationLossMode.saturated_exit
    )
    evaporation_loss_factor: Optional[float] = None
    drift_loss_percent: Optional[float] = 0.008
    blowdown_calculation_mode: Optional[BlowdownCalculationMode] = (
        BlowdownCalculationMode.concentration_ratio
    )
    blowdown_concentration_ratio: Annotated[Optional[float], Field(3.0, ge=2.0)]
    blowdown_makeup_water_usage_schedule_name: Optional[str] = None
    supply_water_storage_tank_name: Optional[str] = None


class LowSpeedNominalCapacity(CoolingSupplyAirFlowRate):
    pass


class FluidCoolerTwoSpeed(BaseModel):
    water_inlet_node_name: str
    water_outlet_node_name: str
    performance_input_method: Optional[PerformanceInputMethod] = (
        PerformanceInputMethod.nominal_capacity
    )
    high_fan_speed_u_factor_times_area_value: Optional[
        Union[HighFanSpeedUFactorTimesAreaValue, Literal["Autosize"]]
    ] = None
    low_fan_speed_u_factor_times_area_value: Optional[
        Union[LowFanSpeedUFactorTimesAreaValue, Literal["Autocalculate"]]
    ] = None
    low_fan_speed_u_factor_times_area_sizing_factor: Optional[float] = 0.6
    high_speed_nominal_capacity: Annotated[Optional[float], Field(None, gt=0.0)]
    low_speed_nominal_capacity: Optional[
        Union[LowSpeedNominalCapacity, Literal["Autocalculate"]]
    ] = None
    low_speed_nominal_capacity_sizing_factor: Optional[float] = 0.5
    design_entering_water_temperature: Annotated[float, Field(gt=0.0)]
    design_entering_air_temperature: Annotated[float, Field(gt=0.0)]
    design_entering_air_wet_bulb_temperature: Annotated[float, Field(gt=0.0)]
    design_water_flow_rate: Union[DesignWaterFlowRate2, Literal["Autosize"]]
    high_fan_speed_air_flow_rate: Union[HighFanSpeedAirFlowRate, Literal["Autosize"]]
    high_fan_speed_fan_power: Union[HighFanSpeedFanPower, Literal["Autosize"]]
    low_fan_speed_air_flow_rate: Union[LowFanSpeedAirFlowRate, Literal["Autocalculate"]]
    low_fan_speed_air_flow_rate_sizing_factor: Optional[float] = 0.5
    low_fan_speed_fan_power: Union[LowFanSpeedFanPower, Literal["Autocalculate"]]
    low_fan_speed_fan_power_sizing_factor: Optional[float] = 0.16
    outdoor_air_inlet_node_name: Optional[str] = None


class LoopDemandSideDesignFlowRate(CoolingSupplyAirFlowRate):
    pass


class LoopSupplySideDesignFlowRate(CoolingSupplyAirFlowRate):
    pass


class HeatExchangeModelType(Enum):
    counter_flow = "CounterFlow"
    cross_flow_both_mixed = "CrossFlowBothMixed"
    cross_flow_both_un_mixed = "CrossFlowBothUnMixed"
    cross_flow_supply_mixed_demand_un_mixed = "CrossFlowSupplyMixedDemandUnMixed"
    cross_flow_supply_un_mixed_demand_mixed = "CrossFlowSupplyUnMixedDemandMixed"
    ideal = "Ideal"
    parallel_flow = "ParallelFlow"


class HeatExchangerUFactorTimesAreaValue(CoolingSupplyAirFlowRate):
    pass


class ControlType1(Enum):
    cooling_differential_on_off = "CoolingDifferentialOnOff"
    cooling_setpoint_modulated = "CoolingSetpointModulated"
    cooling_setpoint_on_off = "CoolingSetpointOnOff"
    cooling_setpoint_on_off_with_component_override = (
        "CoolingSetpointOnOffWithComponentOverride"
    )
    dual_deadband_setpoint_modulated = "DualDeadbandSetpointModulated"
    dual_deadband_setpoint_on_off = "DualDeadbandSetpointOnOff"
    heating_setpoint_modulated = "HeatingSetpointModulated"
    heating_setpoint_on_off = "HeatingSetpointOnOff"
    operation_scheme_modulated = "OperationSchemeModulated"
    operation_scheme_on_off = "OperationSchemeOnOff"
    uncontrolled_on = "UncontrolledOn"


class HeatTransferMeteringEndUseType(Enum):
    free_cooling = "FreeCooling"
    heat_recovery = "HeatRecovery"
    heat_recovery_for_cooling = "HeatRecoveryForCooling"
    heat_recovery_for_heating = "HeatRecoveryForHeating"
    heat_rejection = "HeatRejection"
    loop_to_loop = "LoopToLoop"


class ComponentOverrideCoolingControlTemperatureMode(Enum):
    dry_bulb_temperature = "DryBulbTemperature"
    loop = "Loop"
    wet_bulb_temperature = "WetBulbTemperature"


class HeatExchangerFluidToFluid(BaseModel):
    availability_schedule_name: Optional[str] = None
    loop_demand_side_inlet_node_name: str
    loop_demand_side_outlet_node_name: str
    loop_demand_side_design_flow_rate: Union[
        LoopDemandSideDesignFlowRate, Literal["Autosize"]
    ]
    loop_supply_side_inlet_node_name: str
    loop_supply_side_outlet_node_name: str
    loop_supply_side_design_flow_rate: Union[
        LoopSupplySideDesignFlowRate, Literal["Autosize"]
    ]
    heat_exchange_model_type: Optional[HeatExchangeModelType] = (
        HeatExchangeModelType.ideal
    )
    heat_exchanger_u_factor_times_area_value: Union[
        HeatExchangerUFactorTimesAreaValue, Literal["Autosize"]
    ]
    control_type: Optional[ControlType1] = ControlType1.uncontrolled_on
    heat_exchanger_setpoint_node_name: Optional[str] = None
    minimum_temperature_difference_to_activate_heat_exchanger: Annotated[
        Optional[float], Field(0.01, ge=0.0, le=50.0)
    ]
    heat_transfer_metering_end_use_type: Optional[HeatTransferMeteringEndUseType] = (
        HeatTransferMeteringEndUseType.loop_to_loop
    )
    component_override_loop_supply_side_inlet_node_name: Optional[str] = None
    component_override_loop_demand_side_inlet_node_name: Optional[str] = None
    component_override_cooling_control_temperature_mode: Optional[
        ComponentOverrideCoolingControlTemperatureMode
    ] = ComponentOverrideCoolingControlTemperatureMode.loop
    sizing_factor: Annotated[Optional[float], Field(1.0, gt=0.0)]
    operation_minimum_temperature_limit: Optional[float] = None
    operation_maximum_temperature_limit: Optional[float] = None


class TankVolume(DesignOutdoorAirFlowRate):
    pass


class HeaterControlType(Enum):
    cycle = "Cycle"
    modulate = "Modulate"


class HeaterMaximumCapacity(DesignOutdoorAirFlowRate):
    pass


class HeaterFuelType(Enum):
    coal = "Coal"
    diesel = "Diesel"
    district_heating_steam = "DistrictHeatingSteam"
    district_heating_water = "DistrictHeatingWater"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"


class UseSideDesignFlowRate(DesignOutdoorAirFlowRate):
    pass


class SourceSideDesignFlowRate(DesignOutdoorAirFlowRate):
    pass


class SourceSideFlowControlMode(Enum):
    indirect_heat_alternate_setpoint = "IndirectHeatAlternateSetpoint"
    indirect_heat_primary_setpoint = "IndirectHeatPrimarySetpoint"
    storage_tank = "StorageTank"


class WaterHeaterMixed(BaseModel):
    tank_volume: Optional[Union[TankVolume, Literal["Autosize"]]] = 0.0
    setpoint_temperature_schedule_name: str
    deadband_temperature_difference: Annotated[Optional[float], Field(0.0, ge=0.0)]
    maximum_temperature_limit: Optional[float] = None
    heater_control_type: Optional[HeaterControlType] = HeaterControlType.cycle
    heater_maximum_capacity: Optional[
        Union[HeaterMaximumCapacity, Literal["Autosize"]]
    ] = None
    heater_minimum_capacity: Annotated[Optional[float], Field(None, ge=0.0)]
    heater_ignition_minimum_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    heater_ignition_delay: Annotated[Optional[float], Field(0.0, ge=0.0)]
    heater_fuel_type: HeaterFuelType
    heater_thermal_efficiency: Annotated[float, Field(gt=0.0, le=1.0)]
    part_load_factor_curve_name: Optional[str] = None
    off_cycle_parasitic_fuel_consumption_rate: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    off_cycle_parasitic_fuel_type: Optional[HeaterFuelType] = None
    off_cycle_parasitic_heat_fraction_to_tank: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    on_cycle_parasitic_fuel_consumption_rate: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    on_cycle_parasitic_fuel_type: Optional[HeaterFuelType] = None
    on_cycle_parasitic_heat_fraction_to_tank: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    ambient_temperature_indicator: AmbientTemperatureIndicator
    ambient_temperature_schedule_name: Optional[str] = None
    ambient_temperature_zone_name: Optional[str] = None
    ambient_temperature_outdoor_air_node_name: Optional[str] = None
    off_cycle_loss_coefficient_to_ambient_temperature: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    off_cycle_loss_fraction_to_zone: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    on_cycle_loss_coefficient_to_ambient_temperature: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    on_cycle_loss_fraction_to_zone: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    peak_use_flow_rate: Annotated[Optional[float], Field(None, ge=0.0)]
    use_flow_rate_fraction_schedule_name: Optional[str] = None
    cold_water_supply_temperature_schedule_name: Optional[str] = None
    use_side_inlet_node_name: Optional[str] = None
    use_side_outlet_node_name: Optional[str] = None
    use_side_effectiveness: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    source_side_inlet_node_name: Optional[str] = None
    source_side_outlet_node_name: Optional[str] = None
    source_side_effectiveness: Annotated[Optional[float], Field(1.0, gt=0.0, le=1.0)]
    use_side_design_flow_rate: Optional[
        Union[UseSideDesignFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    source_side_design_flow_rate: Optional[
        Union[SourceSideDesignFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    indirect_water_heating_recovery_time: Annotated[Optional[float], Field(1.5, gt=0.0)]
    source_side_flow_control_mode: Optional[SourceSideFlowControlMode] = (
        SourceSideFlowControlMode.indirect_heat_primary_setpoint
    )
    indirect_alternate_setpoint_temperature_schedule_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"


class FluidType(Enum):
    steam = "Steam"
    user_defined_fluid_type = "UserDefinedFluidType"
    water = "Water"


class MaximumLoopFlowRate(DesignOutdoorAirFlowRate):
    pass


class PlantLoopVolume(DesignOutdoorAirFlowRate):
    pass


class LoadDistributionScheme1(Enum):
    optimal = "Optimal"
    sequential_load = "SequentialLoad"
    sequential_uniform_plr = "SequentialUniformPLR"
    uniform_load = "UniformLoad"
    uniform_plr = "UniformPLR"


class PlantLoopDemandCalculationScheme(Enum):
    dual_setpoint_deadband = "DualSetpointDeadband"
    single_setpoint = "SingleSetpoint"


class CommonPipeSimulation(Enum):
    common_pipe = "CommonPipe"
    none = "None"
    two_way_common_pipe = "TwoWayCommonPipe"


class PressureSimulationType(Enum):
    loop_flow_correction = "LoopFlowCorrection"
    none = "None"
    pump_power_correction = "PumpPowerCorrection"


class PlantLoop(BaseModel):
    fluid_type: Optional[FluidType] = FluidType.water
    user_defined_fluid_type: Optional[str] = None
    plant_equipment_operation_scheme_name: str
    loop_temperature_setpoint_node_name: str
    maximum_loop_temperature: float
    minimum_loop_temperature: float
    maximum_loop_flow_rate: Union[MaximumLoopFlowRate, Literal["Autosize"]]
    minimum_loop_flow_rate: Optional[float] = 0.0
    plant_loop_volume: Optional[Union[PlantLoopVolume, Literal["Autocalculate"]]] = (
        "Autocalculate"
    )
    plant_side_inlet_node_name: str
    plant_side_outlet_node_name: str
    plant_side_branch_list_name: str
    plant_side_connector_list_name: Optional[str] = None
    demand_side_inlet_node_name: str
    demand_side_outlet_node_name: str
    demand_side_branch_list_name: str
    demand_side_connector_list_name: Optional[str] = None
    load_distribution_scheme: Optional[LoadDistributionScheme1] = (
        LoadDistributionScheme1.sequential_load
    )
    availability_manager_list_name: Optional[str] = None
    plant_loop_demand_calculation_scheme: Optional[PlantLoopDemandCalculationScheme] = (
        PlantLoopDemandCalculationScheme.single_setpoint
    )
    common_pipe_simulation: Optional[CommonPipeSimulation] = CommonPipeSimulation.none
    pressure_simulation_type: Optional[PressureSimulationType] = (
        PressureSimulationType.none
    )
    loop_circulation_time: Annotated[Optional[float], Field(2.0, ge=0.0)]


class FluidType1(Enum):
    user_defined_fluid_type = "UserDefinedFluidType"
    water = "Water"


class MaximumLoopFlowRate1(CoolingSupplyAirFlowRate):
    pass


class CondenserLoopVolume(DesignOutdoorAirFlowRate):
    pass


class CondenserLoop(BaseModel):
    fluid_type: Optional[FluidType1] = FluidType1.water
    user_defined_fluid_type: Optional[str] = None
    condenser_equipment_operation_scheme_name: str
    condenser_loop_temperature_setpoint_node_name: str
    maximum_loop_temperature: float
    minimum_loop_temperature: float
    maximum_loop_flow_rate: Union[MaximumLoopFlowRate1, Literal["Autosize"]]
    minimum_loop_flow_rate: Optional[float] = 0.0
    condenser_loop_volume: Optional[
        Union[CondenserLoopVolume, Literal["Autocalculate"]]
    ] = "Autocalculate"
    condenser_side_inlet_node_name: str
    condenser_side_outlet_node_name: str
    condenser_side_branch_list_name: str
    condenser_side_connector_list_name: str
    demand_side_inlet_node_name: str
    demand_side_outlet_node_name: str
    condenser_demand_side_branch_list_name: str
    condenser_demand_side_connector_list_name: str
    load_distribution_scheme: Optional[LoadDistributionScheme1] = (
        LoadDistributionScheme1.sequential_load
    )
    pressure_simulation_type: Optional[PressureSimulationType] = (
        PressureSimulationType.none
    )
    loop_circulation_time: Annotated[Optional[float], Field(2.0, ge=0.0)]


class EquipmentItem1(BaseModel):
    equipment_object_type: Optional[str] = None
    equipment_name: Optional[str] = None


class PlantEquipmentList(BaseModel):
    equipment: Optional[List[EquipmentItem1]] = None


class CondenserEquipmentList(PlantEquipmentList):
    pass


class PlantEquipmentOperationCoolingLoad(BaseModel):
    load_range_1_lower_limit: Annotated[float, Field(ge=0.0)]
    load_range_1_upper_limit: Annotated[float, Field(ge=0.0)]
    range_1_equipment_list_name: Optional[str] = None
    load_range_2_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_2_upper_limit: Optional[float] = None
    range_2_equipment_list_name: Optional[str] = None
    load_range_3_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_3_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_3_equipment_list_name: Optional[str] = None
    load_range_4_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_4_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_4_equipment_list_name: Optional[str] = None
    load_range_5_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_5_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_5_equipment_list_name: Optional[str] = None
    load_range_6_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_6_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_6_equipment_list_name: Optional[str] = None
    load_range_7_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_7_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_7_equipment_list_name: Optional[str] = None
    load_range_8_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_8_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_8_equipment_list_name: Optional[str] = None
    load_range_9_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_9_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_9_equipment_list_name: Optional[str] = None
    load_range_10_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_10_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_10_equipment_list_name: Optional[str] = None


class PlantEquipmentOperationHeatingLoad(BaseModel):
    load_range_1_lower_limit: Annotated[float, Field(ge=0.0)]
    load_range_1_upper_limit: Annotated[float, Field(ge=0.0)]
    range_1_equipment_list_name: str
    load_range_2_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_2_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_2_equipment_list_name: Optional[str] = None
    load_range_3_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_3_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_3_equipment_list_name: Optional[str] = None
    load_range_4_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_4_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_4_equipment_list_name: Optional[str] = None
    load_range_5_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_5_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_5_equipment_list_name: Optional[str] = None
    load_range_6_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_6_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_6_equipment_list_name: Optional[str] = None
    load_range_7_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_7_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_7_equipment_list_name: Optional[str] = None
    load_range_8_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_8_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_8_equipment_list_name: Optional[str] = None
    load_range_9_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_9_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_9_equipment_list_name: Optional[str] = None
    load_range_10_lower_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    load_range_10_upper_limit: Annotated[Optional[float], Field(None, ge=0.0)]
    range_10_equipment_list_name: Optional[str] = None


class Operation1Type(Enum):
    cooling = "Cooling"
    dual = "Dual"
    heating = "Heating"


class PlantEquipmentOperationComponentSetpoint(BaseModel):
    equipment_1_object_type: str
    equipment_1_name: str
    demand_calculation_1_node_name: str
    setpoint_1_node_name: str
    component_1_flow_rate: Union[float, Literal["Autosize"]]
    operation_1_type: Operation1Type
    equipment_2_object_type: Optional[str] = None
    equipment_2_name: Optional[str] = None
    demand_calculation_2_node_name: Optional[str] = None
    setpoint_2_node_name: Optional[str] = None
    component_2_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_2_type: Optional[Operation1Type] = None
    equipment_3_object_type: Optional[str] = None
    equipment_3_name: Optional[str] = None
    demand_calculation_3_node_name: Optional[str] = None
    setpoint_3_node_name: Optional[str] = None
    component_3_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_3_type: Optional[Operation1Type] = None
    equipment_4_object_type: Optional[str] = None
    equipment_4_name: Optional[str] = None
    demand_calculation_4_node_name: Optional[str] = None
    setpoint_4_node_name: Optional[str] = None
    component_4_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_4_type: Optional[Operation1Type] = None
    equipment_5_object_type: Optional[str] = None
    equipment_5_name: Optional[str] = None
    demand_calculation_5_node_name: Optional[str] = None
    setpoint_5_node_name: Optional[str] = None
    component_5_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_5_type: Optional[Operation1Type] = None
    equipment_6_object_type: Optional[str] = None
    equipment_6_name: Optional[str] = None
    demand_calculation_6_node_name: Optional[str] = None
    setpoint_6_node_name: Optional[str] = None
    component_6_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_6_type: Optional[Operation1Type] = None
    equipment_7_object_type: Optional[str] = None
    equipment_7_name: Optional[str] = None
    demand_calculation_7_node_name: Optional[str] = None
    setpoint_7_node_name: Optional[str] = None
    component_7_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_7_type: Optional[Operation1Type] = None
    equipment_8_object_type: Optional[str] = None
    equipment_8_name: Optional[str] = None
    demand_calculation_8_node_name: Optional[str] = None
    setpoint_8_node_name: Optional[str] = None
    component_8_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_8_type: Optional[Operation1Type] = None
    equipment_9_object_type: Optional[str] = None
    equipment_9_name: Optional[str] = None
    demand_calculation_9_node_name: Optional[str] = None
    setpoint_9_node_name: Optional[str] = None
    component_9_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_9_type: Optional[Operation1Type] = None
    equipment_10_object_type: Optional[str] = None
    equipment_10_name: Optional[str] = None
    demand_calculation_10_node_name: Optional[str] = None
    setpoint_10_node_name: Optional[str] = None
    component_10_flow_rate: Optional[Union[float, Literal["Autosize"]]] = None
    operation_10_type: Optional[Operation1Type] = None


class ControlScheme1ObjectType(Enum):
    plant_equipment_operation_chiller_heater_changeover = (
        "PlantEquipmentOperation:ChillerHeaterChangeover"
    )
    plant_equipment_operation_component_setpoint = (
        "PlantEquipmentOperation:ComponentSetpoint"
    )
    plant_equipment_operation_cooling_load = "PlantEquipmentOperation:CoolingLoad"
    plant_equipment_operation_heating_load = "PlantEquipmentOperation:HeatingLoad"
    plant_equipment_operation_outdoor_dewpoint = (
        "PlantEquipmentOperation:OutdoorDewpoint"
    )
    plant_equipment_operation_outdoor_dewpoint_difference = (
        "PlantEquipmentOperation:OutdoorDewpointDifference"
    )
    plant_equipment_operation_outdoor_dry_bulb = (
        "PlantEquipmentOperation:OutdoorDryBulb"
    )
    plant_equipment_operation_outdoor_dry_bulb_difference = (
        "PlantEquipmentOperation:OutdoorDryBulbDifference"
    )
    plant_equipment_operation_outdoor_relative_humidity = (
        "PlantEquipmentOperation:OutdoorRelativeHumidity"
    )
    plant_equipment_operation_outdoor_wet_bulb = (
        "PlantEquipmentOperation:OutdoorWetBulb"
    )
    plant_equipment_operation_outdoor_wet_bulb_difference = (
        "PlantEquipmentOperation:OutdoorWetBulbDifference"
    )
    plant_equipment_operation_thermal_energy_storage = (
        "PlantEquipmentOperation:ThermalEnergyStorage"
    )
    plant_equipment_operation_uncontrolled = "PlantEquipmentOperation:Uncontrolled"
    plant_equipment_operation_user_defined = "PlantEquipmentOperation:UserDefined"


class PlantEquipmentOperationSchemes(BaseModel):
    control_scheme_1_object_type: ControlScheme1ObjectType
    control_scheme_1_name: str
    control_scheme_1_schedule_name: str
    control_scheme_2_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_2_name: Optional[str] = None
    control_scheme_2_schedule_name: Optional[str] = None
    control_scheme_3_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_3_name: Optional[str] = None
    control_scheme_3_schedule_name: Optional[str] = None
    control_scheme_4_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_4_name: Optional[str] = None
    control_scheme_4_schedule_name: Optional[str] = None
    control_scheme_5_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_5_name: Optional[str] = None
    control_scheme_5_schedule_name: Optional[str] = None
    control_scheme_6_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_6_name: Optional[str] = None
    control_scheme_6_schedule_name: Optional[str] = None
    control_scheme_7_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_7_name: Optional[str] = None
    control_scheme_7_schedule_name: Optional[str] = None
    control_scheme_8_object_type: Optional[ControlScheme1ObjectType] = None
    control_scheme_8_name: Optional[str] = None
    control_scheme_8_schedule_name: Optional[str] = None


class ControlScheme1ObjectType1(Enum):
    plant_equipment_operation_cooling_load = "PlantEquipmentOperation:CoolingLoad"
    plant_equipment_operation_heating_load = "PlantEquipmentOperation:HeatingLoad"
    plant_equipment_operation_outdoor_dewpoint = (
        "PlantEquipmentOperation:OutdoorDewpoint"
    )
    plant_equipment_operation_outdoor_dewpoint_difference = (
        "PlantEquipmentOperation:OutdoorDewpointDifference"
    )
    plant_equipment_operation_outdoor_dry_bulb = (
        "PlantEquipmentOperation:OutdoorDryBulb"
    )
    plant_equipment_operation_outdoor_dry_bulb_difference = (
        "PlantEquipmentOperation:OutdoorDryBulbDifference"
    )
    plant_equipment_operation_outdoor_relative_humidity = (
        "PlantEquipmentOperation:OutdoorRelativeHumidity"
    )
    plant_equipment_operation_outdoor_wet_bulb = (
        "PlantEquipmentOperation:OutdoorWetBulb"
    )
    plant_equipment_operation_outdoor_wet_bulb_difference = (
        "PlantEquipmentOperation:OutdoorWetBulbDifference"
    )
    plant_equipment_operation_uncontrolled = "PlantEquipmentOperation:Uncontrolled"
    plant_equipment_operation_user_defined = "PlantEquipmentOperation:UserDefined"


class CondenserEquipmentOperationSchemes(BaseModel):
    control_scheme_1_object_type: ControlScheme1ObjectType1
    control_scheme_1_name: str
    control_scheme_1_schedule_name: str
    control_scheme_2_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_2_name: Optional[str] = None
    control_scheme_2_schedule_name: Optional[str] = None
    control_scheme_3_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_3_name: Optional[str] = None
    control_scheme_3_schedule_name: Optional[str] = None
    control_scheme_4_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_4_name: Optional[str] = None
    control_scheme_4_schedule_name: Optional[str] = None
    control_scheme_5_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_5_name: Optional[str] = None
    control_scheme_5_schedule_name: Optional[str] = None
    control_scheme_6_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_6_name: Optional[str] = None
    control_scheme_6_schedule_name: Optional[str] = None
    control_scheme_7_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_7_name: Optional[str] = None
    control_scheme_7_schedule_name: Optional[str] = None
    control_scheme_8_object_type: Optional[ControlScheme1ObjectType1] = None
    control_scheme_8_name: Optional[str] = None
    control_scheme_8_schedule_name: Optional[str] = None


class EnergyManagementSystemSensor(BaseModel):
    output_variable_or_output_meter_index_key_name: Optional[str] = None
    output_variable_or_output_meter_name: str


class EnergyManagementSystemActuator(BaseModel):
    actuated_component_unique_name: str
    actuated_component_type: str
    actuated_component_control_type: str


class EnergyplusModelCallingPoint(Enum):
    after_component_input_read_in = "AfterComponentInputReadIn"
    after_new_environment_warm_up_is_complete = "AfterNewEnvironmentWarmUpIsComplete"
    after_predictor_after_hvac_managers = "AfterPredictorAfterHVACManagers"
    after_predictor_before_hvac_managers = "AfterPredictorBeforeHVACManagers"
    begin_new_environment = "BeginNewEnvironment"
    begin_timestep_before_predictor = "BeginTimestepBeforePredictor"
    begin_zone_timestep_after_init_heat_balance = (
        "BeginZoneTimestepAfterInitHeatBalance"
    )
    begin_zone_timestep_before_init_heat_balance = (
        "BeginZoneTimestepBeforeInitHeatBalance"
    )
    begin_zone_timestep_before_set_current_weather = (
        "BeginZoneTimestepBeforeSetCurrentWeather"
    )
    end_of_system_sizing = "EndOfSystemSizing"
    end_of_system_timestep_after_hvac_reporting = (
        "EndOfSystemTimestepAfterHVACReporting"
    )
    end_of_system_timestep_before_hvac_reporting = (
        "EndOfSystemTimestepBeforeHVACReporting"
    )
    end_of_zone_sizing = "EndOfZoneSizing"
    end_of_zone_timestep_after_zone_reporting = "EndOfZoneTimestepAfterZoneReporting"
    end_of_zone_timestep_before_zone_reporting = "EndOfZoneTimestepBeforeZoneReporting"
    inside_hvac_system_iteration_loop = "InsideHVACSystemIterationLoop"
    unitary_system_sizing = "UnitarySystemSizing"
    user_defined_component_model = "UserDefinedComponentModel"


class Program(BaseModel):
    program_name: str


class EnergyManagementSystemProgramCallingManager(BaseModel):
    energyplus_model_calling_point: Optional[EnergyplusModelCallingPoint] = None
    programs: Optional[List[Program]] = None


class Line(BaseModel):
    program_line: Optional[str] = None


class EnergyManagementSystemProgram(BaseModel):
    lines: Annotated[List[Line], Field(min_length=1)]


class Variable(BaseModel):
    erl_variable_name: str


class EnergyManagementSystemGlobalVariable(BaseModel):
    variables: Optional[List[Variable]] = None


class TypeOfDataInVariable(Enum):
    averaged = "Averaged"
    summed = "Summed"


class UpdateFrequency(Enum):
    system_timestep = "SystemTimestep"
    zone_timestep = "ZoneTimestep"


class EnergyManagementSystemOutputVariable(BaseModel):
    ems_variable_name: str
    type_of_data_in_variable: TypeOfDataInVariable
    update_frequency: UpdateFrequency
    ems_program_or_subroutine_name: Optional[str] = None
    units: Optional[str] = None


class EnergyManagementSystemInternalVariable(BaseModel):
    internal_data_index_key_name: Optional[str] = None
    internal_data_type: str


class AvailabilityManagerScheduled(BaseModel):
    schedule_name: str


class ControlType2(Enum):
    cycle_on_any = "CycleOnAny"
    cycle_on_any_cooling_or_heating_zone = "CycleOnAnyCoolingOrHeatingZone"
    cycle_on_any_cooling_zone = "CycleOnAnyCoolingZone"
    cycle_on_any_heating_zone = "CycleOnAnyHeatingZone"
    cycle_on_any_heating_zone_fans_only = "CycleOnAnyHeatingZoneFansOnly"
    cycle_on_any_zone_fans_only = "CycleOnAnyZoneFansOnly"
    cycle_on_control_zone = "CycleOnControlZone"
    stay_off = "StayOff"


class CyclingRunTimeControlType(Enum):
    fixed_run_time = "FixedRunTime"
    thermostat = "Thermostat"
    thermostat_with_minimum_run_time = "ThermostatWithMinimumRunTime"


class AvailabilityManagerNightCycle(BaseModel):
    applicability_schedule_name: str
    fan_schedule_name: str
    control_type: Optional[ControlType2] = ControlType2.stay_off
    thermostat_tolerance: Optional[float] = 1.0
    cycling_run_time_control_type: Optional[CyclingRunTimeControlType] = (
        CyclingRunTimeControlType.fixed_run_time
    )
    cycling_run_time: Optional[float] = 3600.0
    control_zone_or_zone_list_name: Optional[str] = None
    cooling_control_zone_or_zone_list_name: Optional[str] = None
    heating_control_zone_or_zone_list_name: Optional[str] = None
    heating_zone_fans_only_zone_or_zone_list_name: Optional[str] = None


class AvailabilityManagerObjectType(Enum):
    availability_manager_differential_thermostat = (
        "AvailabilityManager:DifferentialThermostat"
    )
    availability_manager_high_temperature_turn_off = (
        "AvailabilityManager:HighTemperatureTurnOff"
    )
    availability_manager_high_temperature_turn_on = (
        "AvailabilityManager:HighTemperatureTurnOn"
    )
    availability_manager_low_temperature_turn_off = (
        "AvailabilityManager:LowTemperatureTurnOff"
    )
    availability_manager_low_temperature_turn_on = (
        "AvailabilityManager:LowTemperatureTurnOn"
    )
    availability_manager_night_cycle = "AvailabilityManager:NightCycle"
    availability_manager_night_ventilation = "AvailabilityManager:NightVentilation"
    availability_manager_optimum_start = "AvailabilityManager:OptimumStart"
    availability_manager_scheduled = "AvailabilityManager:Scheduled"
    availability_manager_scheduled_off = "AvailabilityManager:ScheduledOff"
    availability_manager_scheduled_on = "AvailabilityManager:ScheduledOn"


class Manager(BaseModel):
    availability_manager_object_type: AvailabilityManagerObjectType
    availability_manager_name: str


class AvailabilityManagerAssignmentList(BaseModel):
    managers: Optional[List[Manager]] = None


class ControlVariable1(Enum):
    humidity_ratio = "HumidityRatio"
    mass_flow_rate = "MassFlowRate"
    maximum_humidity_ratio = "MaximumHumidityRatio"
    maximum_mass_flow_rate = "MaximumMassFlowRate"
    maximum_temperature = "MaximumTemperature"
    minimum_humidity_ratio = "MinimumHumidityRatio"
    minimum_mass_flow_rate = "MinimumMassFlowRate"
    minimum_temperature = "MinimumTemperature"
    temperature = "Temperature"


class SetpointManagerScheduled(BaseModel):
    control_variable: ControlVariable1
    schedule_name: str
    setpoint_node_or_nodelist_name: str


class SetpointManagerScheduledDualSetpoint(BaseModel):
    control_variable: Optional[Literal["Temperature"]] = "Temperature"
    high_setpoint_schedule_name: str
    low_setpoint_schedule_name: str
    setpoint_node_or_nodelist_name: str


class ControlVariable2(Enum):
    maximum_temperature = "MaximumTemperature"
    minimum_temperature = "MinimumTemperature"
    temperature = "Temperature"


class SetpointManagerOutdoorAirReset(BaseModel):
    control_variable: Optional[ControlVariable2] = ControlVariable2.temperature
    setpoint_at_outdoor_low_temperature: float
    outdoor_low_temperature: float
    setpoint_at_outdoor_high_temperature: float
    outdoor_high_temperature: float
    setpoint_node_or_nodelist_name: str
    schedule_name: Optional[str] = None
    setpoint_at_outdoor_low_temperature_2: Optional[float] = None
    outdoor_low_temperature_2: Optional[float] = None
    setpoint_at_outdoor_high_temperature_2: Optional[float] = None
    outdoor_high_temperature_2: Optional[float] = None


class SetpointManagerSingleZoneReheat(BaseModel):
    control_variable: Optional[Literal["Temperature"]] = "Temperature"
    minimum_supply_air_temperature: Optional[float] = -99.0
    maximum_supply_air_temperature: Optional[float] = 99.0
    control_zone_name: str
    zone_node_name: str
    zone_inlet_node_name: str
    setpoint_node_or_nodelist_name: str


class SetpointManagerSingleZoneHeating(SetpointManagerSingleZoneReheat):
    pass


class SetpointManagerSingleZoneCooling(SetpointManagerSingleZoneReheat):
    pass


class SetpointManagerSingleZoneHumidityMinimum(BaseModel):
    setpoint_node_or_nodelist_name: str
    control_zone_air_node_name: str


class SetpointManagerSingleZoneHumidityMaximum(
    SetpointManagerSingleZoneHumidityMinimum
):
    pass


class SetpointManagerMixedAir(BaseModel):
    control_variable: Optional[Literal["Temperature"]] = "Temperature"
    reference_setpoint_node_name: str
    fan_inlet_node_name: str
    fan_outlet_node_name: str
    setpoint_node_or_nodelist_name: str
    cooling_coil_inlet_node_name: Optional[str] = None
    cooling_coil_outlet_node_name: Optional[str] = None
    minimum_temperature_at_cooling_coil_outlet_node: Annotated[
        Optional[float], Field(7.2, gt=0.0)
    ]


class ControlVariable3(Enum):
    humidity_ratio = "HumidityRatio"
    maximum_humidity_ratio = "MaximumHumidityRatio"
    minimum_humidity_ratio = "MinimumHumidityRatio"
    temperature = "Temperature"


class SetpointManagerOutdoorAirPretreat(BaseModel):
    control_variable: Optional[ControlVariable3] = None
    minimum_setpoint_temperature: Optional[float] = -99.0
    maximum_setpoint_temperature: Optional[float] = 99.0
    minimum_setpoint_humidity_ratio: Annotated[Optional[float], Field("1e-05", le=1.0)]
    maximum_setpoint_humidity_ratio: Annotated[Optional[float], Field(1.0, le=1.0)]
    reference_setpoint_node_name: Optional[str] = None
    mixed_air_stream_node_name: str
    outdoor_air_stream_node_name: str
    return_air_stream_node_name: str
    setpoint_node_or_nodelist_name: str


class SetpointManagerMultiZoneHumidityMinimum(BaseModel):
    hvac_air_loop_name: str
    minimum_setpoint_humidity_ratio: Annotated[Optional[float], Field(0.005, gt=0.0)]
    maximum_setpoint_humidity_ratio: Annotated[Optional[float], Field(0.012, gt=0.0)]
    setpoint_node_or_nodelist_name: str


class SetpointManagerMultiZoneHumidityMaximum(BaseModel):
    hvac_air_loop_name: str
    minimum_setpoint_humidity_ratio: Annotated[Optional[float], Field(0.008, gt=0.0)]
    maximum_setpoint_humidity_ratio: Annotated[Optional[float], Field(0.015, gt=0.0)]
    setpoint_node_or_nodelist_name: str


class ReferenceTemperatureType(Enum):
    outdoor_air_dry_bulb = "OutdoorAirDryBulb"
    outdoor_air_wet_bulb = "OutdoorAirWetBulb"


class SetpointManagerFollowOutdoorAirTemperature(BaseModel):
    control_variable: Optional[ControlVariable2] = ControlVariable2.temperature
    reference_temperature_type: Optional[ReferenceTemperatureType] = (
        ReferenceTemperatureType.outdoor_air_wet_bulb
    )
    offset_temperature_difference: Optional[float] = None
    maximum_setpoint_temperature: Optional[float] = None
    minimum_setpoint_temperature: Optional[float] = None
    setpoint_node_or_nodelist_name: str


class ReturnTemperatureSetpointInputType(Enum):
    constant = "Constant"
    return_temperature_setpoint = "ReturnTemperatureSetpoint"
    scheduled = "Scheduled"


class SetpointManagerReturnTemperatureChilledWater(BaseModel):
    plant_loop_supply_outlet_node: str
    plant_loop_supply_inlet_node: str
    minimum_supply_temperature_setpoint: Optional[float] = 5.0
    maximum_supply_temperature_setpoint: Optional[float] = 10.0
    return_temperature_setpoint_input_type: ReturnTemperatureSetpointInputType
    return_temperature_setpoint_constant_value: Optional[float] = 13.0
    return_temperature_setpoint_schedule_name: Optional[str] = None


class SetpointManagerReturnTemperatureHotWater(BaseModel):
    plant_loop_supply_outlet_node: str
    plant_loop_supply_inlet_node: str
    minimum_supply_temperature_setpoint: Optional[float] = 77.0
    maximum_supply_temperature_setpoint: Optional[float] = 82.0
    return_temperature_setpoint_input_type: ReturnTemperatureSetpointInputType
    return_temperature_setpoint_constant_value: Optional[float] = 71.0
    return_temperature_setpoint_schedule_name: Optional[str] = None


class LatentCaseCreditCurveType(Enum):
    case_temperature_method = "CaseTemperatureMethod"
    dewpoint_method = "DewpointMethod"
    relative_humidity_method = "RelativeHumidityMethod"


class AntiSweatHeaterControlType(Enum):
    constant = "Constant"
    dewpoint_method = "DewpointMethod"
    heat_balance_method = "HeatBalanceMethod"
    linear = "Linear"
    none = "None"


class CaseDefrostType(Enum):
    electric = "Electric"
    electric_with_temperature_termination = "ElectricWithTemperatureTermination"
    hot_fluid = "HotFluid"
    hot_fluid_with_temperature_termination = "HotFluidWithTemperatureTermination"
    hot_gas = "HotGas"
    hot_gas_with_temperature_termination = "HotGasWithTemperatureTermination"
    none = "None"
    off_cycle = "OffCycle"


class DefrostEnergyCorrectionCurveType(Enum):
    case_temperature_method = "CaseTemperatureMethod"
    dewpoint_method = "DewpointMethod"
    none = "None"
    relative_humidity_method = "RelativeHumidityMethod"


class RefrigerationCase(BaseModel):
    availability_schedule_name: Optional[str] = None
    zone_name: str
    rated_ambient_temperature: Annotated[Optional[float], Field(23.9, gt=0.0)]
    rated_ambient_relative_humidity: Annotated[
        Optional[float], Field(55.0, gt=0.0, lt=100.0)
    ]
    rated_total_cooling_capacity_per_unit_length: Annotated[
        Optional[float], Field(1900.0, gt=0.0)
    ]
    rated_latent_heat_ratio: Annotated[Optional[float], Field(0.3, ge=0.0, le=1.0)]
    rated_runtime_fraction: Annotated[Optional[float], Field(0.85, gt=0.0, le=1.0)]
    case_length: Annotated[Optional[float], Field(3.0, gt=0.0)]
    case_operating_temperature: Annotated[Optional[float], Field(1.1, lt=20.0)]
    latent_case_credit_curve_type: Optional[LatentCaseCreditCurveType] = (
        LatentCaseCreditCurveType.case_temperature_method
    )
    latent_case_credit_curve_name: str
    standard_case_fan_power_per_unit_length: Annotated[
        Optional[float], Field(75.0, ge=0.0)
    ]
    operating_case_fan_power_per_unit_length: Annotated[
        Optional[float], Field(75.0, ge=0.0)
    ]
    standard_case_lighting_power_per_unit_length: Optional[float] = 90.0
    installed_case_lighting_power_per_unit_length: Optional[float] = None
    case_lighting_schedule_name: Optional[str] = None
    fraction_of_lighting_energy_to_case: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    case_anti_sweat_heater_power_per_unit_length: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    minimum_anti_sweat_heater_power_per_unit_length: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    anti_sweat_heater_control_type: Optional[AntiSweatHeaterControlType] = (
        AntiSweatHeaterControlType.none
    )
    humidity_at_zero_anti_sweat_heater_energy: Optional[float] = -10.0
    case_height: Annotated[Optional[float], Field(1.5, ge=0.0)]
    fraction_of_anti_sweat_heater_energy_to_case: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    case_defrost_power_per_unit_length: Annotated[Optional[float], Field(0.0, ge=0.0)]
    case_defrost_type: Optional[CaseDefrostType] = CaseDefrostType.off_cycle
    case_defrost_schedule_name: Optional[str] = None
    case_defrost_drip_down_schedule_name: Optional[str] = None
    defrost_energy_correction_curve_type: Optional[DefrostEnergyCorrectionCurveType] = (
        DefrostEnergyCorrectionCurveType.none
    )
    defrost_energy_correction_curve_name: Optional[str] = None
    under_case_hvac_return_air_fraction: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    refrigerated_case_restocking_schedule_name: Optional[str] = None
    case_credit_fraction_schedule_name: Optional[str] = None
    design_evaporator_temperature_or_brine_inlet_temperature: Annotated[
        Optional[float], Field(None, ge=-70.0, le=40.0)
    ]
    average_refrigerant_charge_inventory: Optional[float] = 0.0
    under_case_hvac_return_air_node_name: Optional[str] = None


class HeatRejectionLocation(Enum):
    outdoors = "Outdoors"
    zone = "Zone"


class WaterCooledLoopFlowType(Enum):
    constant_flow = "ConstantFlow"
    variable_flow = "VariableFlow"


class DesignEvaporativeCondenserWaterPumpPower(DesignOutdoorAirFlowRate):
    pass


class RefrigerationCompressorRack(BaseModel):
    heat_rejection_location: Optional[HeatRejectionLocation] = (
        HeatRejectionLocation.outdoors
    )
    design_compressor_rack_cop: Annotated[Optional[float], Field(2.0, gt=0.0)]
    compressor_rack_cop_function_of_temperature_curve_name: str
    design_condenser_fan_power: Annotated[Optional[float], Field(250.0, ge=0.0)]
    condenser_fan_power_function_of_temperature_curve_name: Optional[str] = None
    condenser_type: Optional[CondenserType3] = CondenserType3.air_cooled
    water_cooled_condenser_inlet_node_name: Optional[str] = None
    water_cooled_condenser_outlet_node_name: Optional[str] = None
    water_cooled_loop_flow_type: Optional[WaterCooledLoopFlowType] = (
        WaterCooledLoopFlowType.variable_flow
    )
    water_cooled_condenser_outlet_temperature_schedule_name: Optional[str] = None
    water_cooled_condenser_design_flow_rate: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    water_cooled_condenser_maximum_flow_rate: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    water_cooled_condenser_maximum_water_outlet_temperature: Annotated[
        Optional[float], Field(55.0, ge=10.0, le=60.0)
    ]
    water_cooled_condenser_minimum_water_inlet_temperature: Annotated[
        Optional[float], Field(10.0, ge=10.0, le=30.0)
    ]
    evaporative_condenser_availability_schedule_name: Optional[str] = None
    evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    evaporative_condenser_air_flow_rate: Optional[
        Union[EvaporativeCondenserAirFlowRate, Literal["Autocalculate"]]
    ] = "Autocalculate"
    basin_heater_capacity: Annotated[Optional[float], Field(200.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    design_evaporative_condenser_water_pump_power: Optional[
        Union[DesignEvaporativeCondenserWaterPumpPower, Literal["Autocalculate"]]
    ] = 1000.0
    evaporative_water_supply_tank_name: Optional[str] = None
    condenser_air_inlet_node_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"
    refrigeration_case_name_or_walkin_name_or_caseandwalkinlist_name: Optional[str] = (
        None
    )
    heat_rejection_zone_name: Optional[str] = None


class CasesAndWalkin(BaseModel):
    case_or_walkin_name: Optional[str] = None


class RefrigerationCaseAndWalkInList(BaseModel):
    cases_and_walkins: Optional[List[CasesAndWalkin]] = None


class CondenserFanSpeedControlType(Enum):
    fixed = "Fixed"
    fixed_linear = "FixedLinear"
    two_speed = "TwoSpeed"
    variable_speed = "VariableSpeed"


class RefrigerationCondenserAirCooled(BaseModel):
    rated_effective_total_heat_rejection_rate_curve_name: Optional[str] = None
    rated_subcooling_temperature_difference: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    condenser_fan_speed_control_type: Optional[CondenserFanSpeedControlType] = (
        CondenserFanSpeedControlType.fixed
    )
    rated_fan_power: Annotated[Optional[float], Field(250.0, ge=0.0)]
    minimum_fan_air_flow_ratio: Annotated[Optional[float], Field(0.2, ge=0.0)]
    air_inlet_node_name_or_zone_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"
    condenser_refrigerant_operating_charge_inventory: Optional[float] = 0.0
    condensate_receiver_refrigerant_inventory: Optional[float] = 0.0
    condensate_piping_refrigerant_inventory: Optional[float] = 0.0


class ModeOfOperation(Enum):
    subcritical = "Subcritical"
    transcritical = "Transcritical"


class RefrigerationCompressor(BaseModel):
    refrigeration_compressor_power_curve_name: str
    refrigeration_compressor_capacity_curve_name: str
    rated_superheat: Optional[float] = None
    rated_return_gas_temperature: Optional[float] = None
    rated_liquid_temperature: Optional[float] = None
    rated_subcooling: Optional[float] = None
    end_use_subcategory: Optional[str] = "General"
    mode_of_operation: Optional[ModeOfOperation] = ModeOfOperation.subcritical
    transcritical_compressor_power_curve_name: Optional[str] = None
    transcritical_compressor_capacity_curve_name: Optional[str] = None


class Compressor(BaseModel):
    refrigeration_compressor_name: str


class RefrigerationCompressorList(BaseModel):
    compressors: Optional[List[Compressor]] = None


class SuctionTemperatureControlType(Enum):
    constant_suction_temperature = "ConstantSuctionTemperature"
    float_suction_temperature = "FloatSuctionTemperature"


class NumberOfCompressorStages(Enum):
    number_1 = 1
    number_2 = 2


class IntercoolerType(Enum):
    flash_intercooler = "Flash Intercooler"
    none = "None"
    shell_and_coil_intercooler = "Shell-and-Coil Intercooler"


class RefrigerationSystem(BaseModel):
    refrigerated_case_or_walkin_or_caseandwalkinlist_name: Optional[str] = None
    refrigeration_transfer_load_or_transferload_list_name: Optional[str] = None
    refrigeration_condenser_name: str
    compressor_or_compressorlist_name: str
    minimum_condensing_temperature: float
    refrigeration_system_working_fluid_type: str
    suction_temperature_control_type: Optional[SuctionTemperatureControlType] = (
        SuctionTemperatureControlType.constant_suction_temperature
    )
    mechanical_subcooler_name: Optional[str] = None
    liquid_suction_heat_exchanger_subcooler_name: Optional[str] = None
    sum_ua_suction_piping: Optional[float] = 0.0
    suction_piping_zone_name: Optional[str] = None
    end_use_subcategory: Optional[str] = "General"
    number_of_compressor_stages: Optional[Union[NumberOfCompressorStages, str]] = 1.0
    intercooler_type: Optional[IntercoolerType] = IntercoolerType.none
    shell_and_coil_intercooler_effectiveness: Optional[float] = 0.8
    high_stage_compressor_or_compressorlist_name: Optional[str] = None


class CapacityRatingType(Enum):
    capacity_total_specific_conditions = "CapacityTotalSpecificConditions"
    european_sc1_nominal_wet = "EuropeanSC1NominalWet"
    european_sc1_standard = "EuropeanSC1Standard"
    european_sc2_nominal_wet = "EuropeanSC2NominalWet"
    european_sc2_standard = "EuropeanSC2Standard"
    european_sc3_nominal_wet = "EuropeanSC3NominalWet"
    european_sc3_standard = "EuropeanSC3Standard"
    european_sc4_nominal_wet = "EuropeanSC4NominalWet"
    european_sc4_standard = "EuropeanSC4Standard"
    european_sc5_nominal_wet = "EuropeanSC5NominalWet"
    european_sc5_standard = "EuropeanSC5Standard"
    fixed_linear = "FixedLinear"
    unit_load_factor_sensible_only = "UnitLoadFactorSensibleOnly"


class CapacityCorrectionCurveType(Enum):
    european = "European"
    linear_shr60 = "LinearSHR60"
    quadratic_shr = "QuadraticSHR"
    tabular_r_hx_dt1x_t_room = "TabularRHxDT1xTRoom"


class DefrostType(Enum):
    electric = "Electric"
    hot_fluid = "HotFluid"
    none = "None"
    off_cycle = "OffCycle"


class DefrostControlType(Enum):
    temperature_termination = "TemperatureTermination"
    time_schedule = "TimeSchedule"


class VerticalLocation(Enum):
    ceiling = "Ceiling"
    floor = "Floor"
    middle = "Middle"


class RefrigerationAirChiller(BaseModel):
    availability_schedule_name: Optional[str] = None
    capacity_rating_type: CapacityRatingType
    rated_unit_load_factor: Optional[float] = None
    rated_capacity: Optional[float] = None
    rated_relative_humidity: Annotated[Optional[float], Field(85.0, le=100.0)]
    rated_cooling_source_temperature: Annotated[float, Field(ge=-70.0, le=40.0)]
    rated_temperature_difference_dt1: Annotated[float, Field(ge=0.0, le=20.0)]
    maximum_temperature_difference_between_inlet_air_and_evaporating_temperature: (
        Annotated[Optional[float], Field(None, ge=0.0, le=25.0)]
    )
    coil_material_correction_factor: Optional[float] = 1.0
    refrigerant_correction_factor: Optional[float] = 1.0
    capacity_correction_curve_type: Optional[CapacityCorrectionCurveType] = None
    capacity_correction_curve_name: Optional[str] = None
    shr60_correction_factor: Annotated[Optional[float], Field(1.48, le=1.67)]
    rated_total_heating_power: float
    heating_power_schedule_name: Optional[str] = None
    fan_speed_control_type: Optional[CondenserFanSpeedControlType] = (
        CondenserFanSpeedControlType.fixed
    )
    rated_fan_power: Annotated[Optional[float], Field(375.0, ge=0.0)]
    rated_air_flow: float
    minimum_fan_air_flow_ratio: Annotated[Optional[float], Field(0.2, ge=0.0)]
    defrost_type: Optional[DefrostType] = DefrostType.electric
    defrost_control_type: Optional[DefrostControlType] = (
        DefrostControlType.time_schedule
    )
    defrost_schedule_name: str
    defrost_drip_down_schedule_name: Optional[str] = None
    defrost_power: Annotated[Optional[float], Field(None, ge=0.0)]
    temperature_termination_defrost_fraction_to_ice: Annotated[
        Optional[float], Field(None, gt=0.0, le=1.0)
    ]
    vertical_location: Optional[VerticalLocation] = VerticalLocation.middle
    average_refrigerant_charge_inventory: Optional[float] = 0.0


class Chiller(BaseModel):
    air_chiller_name: Optional[str] = None


class ZoneHvacRefrigerationChillerSet(BaseModel):
    availability_schedule_name: Optional[str] = None
    zone_name: Optional[str] = None
    air_inlet_node_name: Optional[str] = None
    air_outlet_node_name: Optional[str] = None
    chillers: Optional[List[Chiller]] = None


class TransformerUsage(Enum):
    load_center_power_conditioning = "LoadCenterPowerConditioning"
    power_in_from_grid = "PowerInFromGrid"
    power_out_to_grid = "PowerOutToGrid"


class Phase(Enum):
    number_1 = 1
    number_3 = 3


class ConductorMaterial(Enum):
    aluminum = "Aluminum"
    copper = "Copper"


class PerformanceInputMethod4(Enum):
    nominal_efficiency = "NominalEfficiency"
    rated_losses = "RatedLosses"


class Meter(BaseModel):
    meter_name: Optional[str] = None


class WaterUseEquipment(BaseModel):
    end_use_subcategory: Optional[str] = "General"
    peak_flow_rate: Annotated[float, Field(ge=0.0)]
    flow_rate_fraction_schedule_name: Optional[str] = None
    target_temperature_schedule_name: Optional[str] = None
    hot_water_supply_temperature_schedule_name: Optional[str] = None
    cold_water_supply_temperature_schedule_name: Optional[str] = None
    zone_name: Optional[str] = None
    sensible_fraction_schedule_name: Optional[str] = None
    latent_fraction_schedule_name: Optional[str] = None


class DrainWaterHeatExchangerType(Enum):
    counter_flow = "CounterFlow"
    cross_flow = "CrossFlow"
    ideal = "Ideal"
    none = "None"


class DrainWaterHeatExchangerDestination(Enum):
    equipment = "Equipment"
    plant = "Plant"
    plant_and_equipment = "PlantAndEquipment"


class Connection(BaseModel):
    water_use_equipment_name: str


class WaterUseConnections(BaseModel):
    inlet_node_name: Optional[str] = None
    outlet_node_name: Optional[str] = None
    supply_water_storage_tank_name: Optional[str] = None
    reclamation_water_storage_tank_name: Optional[str] = None
    hot_water_supply_temperature_schedule_name: Optional[str] = None
    cold_water_supply_temperature_schedule_name: Optional[str] = None
    drain_water_heat_exchanger_type: Optional[DrainWaterHeatExchangerType] = (
        DrainWaterHeatExchangerType.none
    )
    drain_water_heat_exchanger_destination: Optional[
        DrainWaterHeatExchangerDestination
    ] = DrainWaterHeatExchangerDestination.plant
    drain_water_heat_exchanger_u_factor_times_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    connections: Optional[List[Connection]] = None


class Value(BaseModel):
    value: Optional[float] = None


class MatrixTwoDimension(BaseModel):
    number_of_rows: int
    number_of_columns: int
    values: Optional[List[Value]] = None


class InputUnitTypeForX(Enum):
    dimensionless = "Dimensionless"
    distance = "Distance"
    mass_flow = "MassFlow"
    power = "Power"
    pressure = "Pressure"
    temperature = "Temperature"
    volumetric_flow = "VolumetricFlow"


class OutputUnitType(Enum):
    capacity = "Capacity"
    dimensionless = "Dimensionless"
    power = "Power"
    pressure = "Pressure"
    temperature = "Temperature"


class CurveLinear(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX] = InputUnitTypeForX.dimensionless
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class InputUnitTypeForW(Enum):
    dimensionless = "Dimensionless"
    distance = "Distance"
    mass_flow = "MassFlow"
    power = "Power"
    temperature = "Temperature"
    volumetric_flow = "VolumetricFlow"
    volumetric_flow_per_power = "VolumetricFlowPerPower"


class CurveQuadLinear(BaseModel):
    coefficient1_constant: float
    coefficient2_w: float
    coefficient3_x: float
    coefficient4_y: float
    coefficient5_z: float
    minimum_value_of_w: float
    maximum_value_of_w: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_value_of_y: float
    maximum_value_of_y: float
    minimum_value_of_z: float
    maximum_value_of_z: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_w: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_x: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_y: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_z: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless


class CurveQuintLinear(BaseModel):
    coefficient1_constant: float
    coefficient2_v: float
    coefficient3_w: float
    coefficient4_x: float
    coefficient5_y: float
    coefficient6_z: float
    minimum_value_of_v: float
    maximum_value_of_v: float
    minimum_value_of_w: float
    maximum_value_of_w: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_value_of_y: float
    maximum_value_of_y: float
    minimum_value_of_z: float
    maximum_value_of_z: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_v: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_w: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_x: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_y: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless
    input_unit_type_for_z: Optional[InputUnitTypeForW] = InputUnitTypeForW.dimensionless


class InputUnitTypeForX3(Enum):
    dimensionless = "Dimensionless"
    distance = "Distance"
    mass_flow = "MassFlow"
    power = "Power"
    temperature = "Temperature"
    volumetric_flow = "VolumetricFlow"


class CurveQuadratic(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    coefficient3_x_2: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class CurveCubic(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    coefficient3_x_2: float
    coefficient4_x_3: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class CurveQuartic(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    coefficient3_x_2: float
    coefficient4_x_3: float
    coefficient5_x_4: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class CurveBicubic(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    coefficient3_x_2: float
    coefficient4_y: float
    coefficient5_y_2: float
    coefficient6_x_y: float
    coefficient7_x_3: float
    coefficient8_y_3: float
    coefficient9_x_2_y: float
    coefficient10_x_y_2: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_value_of_y: float
    maximum_value_of_y: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    input_unit_type_for_y: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class CurveBiquadratic(BaseModel):
    coefficient1_constant: float
    coefficient2_x: float
    coefficient3_x_2: float
    coefficient4_y: float
    coefficient5_y_2: float
    coefficient6_x_y: float
    minimum_value_of_x: float
    maximum_value_of_x: float
    minimum_value_of_y: float
    maximum_value_of_y: float
    minimum_curve_output: Optional[float] = None
    maximum_curve_output: Optional[float] = None
    input_unit_type_for_x: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    input_unit_type_for_y: Optional[InputUnitTypeForX3] = (
        InputUnitTypeForX3.dimensionless
    )
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless


class ExtrapolationMethod(Enum):
    constant = "Constant"
    linear = "Linear"


class UnitType1(Enum):
    angle = "Angle"
    dimensionless = "Dimensionless"
    distance = "Distance"
    mass_flow = "MassFlow"
    power = "Power"
    temperature = "Temperature"
    volumetric_flow = "VolumetricFlow"


class TableIndependentVariable(BaseModel):
    interpolation_method: Optional[PerformanceInterpolationMethod] = (
        PerformanceInterpolationMethod.linear
    )
    extrapolation_method: Optional[ExtrapolationMethod] = ExtrapolationMethod.constant
    minimum_value: Optional[float] = None
    maximum_value: Optional[float] = None
    normalization_reference_value: Optional[float] = None
    unit_type: Optional[UnitType1] = UnitType1.dimensionless
    external_file_name: Optional[str] = None
    external_file_column_number: Annotated[Optional[int], Field(None, ge=1)]
    external_file_starting_row_number: Annotated[Optional[int], Field(None, ge=1)]
    values: Optional[List[Value]] = None


class IndependentVariable(BaseModel):
    independent_variable_name: str


class TableIndependentVariableList(BaseModel):
    independent_variables: Optional[List[IndependentVariable]] = None


class NormalizationMethod(Enum):
    automatic_with_divisor = "AutomaticWithDivisor"
    divisor_only = "DivisorOnly"
    none = "None"


class Value2(BaseModel):
    output_value: Optional[float] = None


class TableLookup(BaseModel):
    independent_variable_list_name: str
    normalization_method: Optional[NormalizationMethod] = NormalizationMethod.none
    normalization_divisor: Optional[float] = 1.0
    minimum_output: Optional[float] = None
    maximum_output: Optional[float] = None
    output_unit_type: Optional[OutputUnitType] = OutputUnitType.dimensionless
    external_file_name: Optional[str] = None
    external_file_column_number: Annotated[Optional[int], Field(None, ge=1)]
    external_file_starting_row_number: Annotated[Optional[int], Field(None, ge=1)]
    values: Optional[List[Value2]] = None


class FluidType2(Enum):
    glycol = "Glycol"
    refrigerant = "Refrigerant"


class FluidPropertiesName(BaseModel):
    fluid_name: str
    fluid_type: FluidType2


class GlycolType(Enum):
    ethylene_glycol = "EthyleneGlycol"
    propylene_glycol = "PropyleneGlycol"
    user_defined_glycol_type = "UserDefinedGlycolType"


class FluidPropertiesGlycolConcentration(BaseModel):
    glycol_type: GlycolType
    user_defined_glycol_name: Optional[str] = None
    glycol_concentration: Annotated[Optional[float], Field(None, ge=0.0, le=1.0)]


class FluidPropertiesTemperatures(BaseModel):
    temperature_1: Optional[float] = None
    temperature_2: Optional[float] = None
    temperature_3: Optional[float] = None
    temperature_4: Optional[float] = None
    temperature_5: Optional[float] = None
    temperature_6: Optional[float] = None
    temperature_7: Optional[float] = None
    temperature_8: Optional[float] = None
    temperature_9: Optional[float] = None
    temperature_10: Optional[float] = None
    temperature_11: Optional[float] = None
    temperature_12: Optional[float] = None
    temperature_13: Optional[float] = None
    temperature_14: Optional[float] = None
    temperature_15: Optional[float] = None
    temperature_16: Optional[float] = None
    temperature_17: Optional[float] = None
    temperature_18: Optional[float] = None
    temperature_19: Optional[float] = None
    temperature_20: Optional[float] = None
    temperature_21: Optional[float] = None
    temperature_22: Optional[float] = None
    temperature_23: Optional[float] = None
    temperature_24: Optional[float] = None
    temperature_25: Optional[float] = None
    temperature_26: Optional[float] = None
    temperature_27: Optional[float] = None
    temperature_28: Optional[float] = None
    temperature_29: Optional[float] = None
    temperature_30: Optional[float] = None
    temperature_31: Optional[float] = None
    temperature_32: Optional[float] = None
    temperature_33: Optional[float] = None
    temperature_34: Optional[float] = None
    temperature_35: Optional[float] = None
    temperature_36: Optional[float] = None
    temperature_37: Optional[float] = None
    temperature_38: Optional[float] = None
    temperature_39: Optional[float] = None
    temperature_40: Optional[float] = None
    temperature_41: Optional[float] = None
    temperature_42: Optional[float] = None
    temperature_43: Optional[float] = None
    temperature_44: Optional[float] = None
    temperature_45: Optional[float] = None
    temperature_46: Optional[float] = None
    temperature_47: Optional[float] = None
    temperature_48: Optional[float] = None
    temperature_49: Optional[float] = None
    temperature_50: Optional[float] = None
    temperature_51: Optional[float] = None
    temperature_52: Optional[float] = None
    temperature_53: Optional[float] = None
    temperature_54: Optional[float] = None
    temperature_55: Optional[float] = None
    temperature_56: Optional[float] = None
    temperature_57: Optional[float] = None
    temperature_58: Optional[float] = None
    temperature_59: Optional[float] = None
    temperature_60: Optional[float] = None
    temperature_61: Optional[float] = None
    temperature_62: Optional[float] = None
    temperature_63: Optional[float] = None
    temperature_64: Optional[float] = None
    temperature_65: Optional[float] = None
    temperature_66: Optional[float] = None
    temperature_67: Optional[float] = None
    temperature_68: Optional[float] = None
    temperature_69: Optional[float] = None
    temperature_70: Optional[float] = None
    temperature_71: Optional[float] = None
    temperature_72: Optional[float] = None
    temperature_73: Optional[float] = None
    temperature_74: Optional[float] = None
    temperature_75: Optional[float] = None
    temperature_76: Optional[float] = None
    temperature_77: Optional[float] = None
    temperature_78: Optional[float] = None
    temperature_79: Optional[float] = None
    temperature_80: Optional[float] = None
    temperature_81: Optional[float] = None
    temperature_82: Optional[float] = None
    temperature_83: Optional[float] = None
    temperature_84: Optional[float] = None
    temperature_85: Optional[float] = None
    temperature_86: Optional[float] = None
    temperature_87: Optional[float] = None
    temperature_88: Optional[float] = None
    temperature_89: Optional[float] = None
    temperature_90: Optional[float] = None
    temperature_91: Optional[float] = None
    temperature_92: Optional[float] = None
    temperature_93: Optional[float] = None
    temperature_94: Optional[float] = None
    temperature_95: Optional[float] = None
    temperature_96: Optional[float] = None
    temperature_97: Optional[float] = None
    temperature_98: Optional[float] = None
    temperature_99: Optional[float] = None
    temperature_100: Optional[float] = None
    temperature_101: Optional[float] = None
    temperature_102: Optional[float] = None
    temperature_103: Optional[float] = None
    temperature_104: Optional[float] = None
    temperature_105: Optional[float] = None
    temperature_106: Optional[float] = None
    temperature_107: Optional[float] = None
    temperature_108: Optional[float] = None
    temperature_109: Optional[float] = None
    temperature_110: Optional[float] = None
    temperature_111: Optional[float] = None
    temperature_112: Optional[float] = None
    temperature_113: Optional[float] = None
    temperature_114: Optional[float] = None
    temperature_115: Optional[float] = None
    temperature_116: Optional[float] = None
    temperature_117: Optional[float] = None
    temperature_118: Optional[float] = None
    temperature_119: Optional[float] = None
    temperature_120: Optional[float] = None
    temperature_121: Optional[float] = None
    temperature_122: Optional[float] = None
    temperature_123: Optional[float] = None
    temperature_124: Optional[float] = None
    temperature_125: Optional[float] = None
    temperature_126: Optional[float] = None
    temperature_127: Optional[float] = None
    temperature_128: Optional[float] = None
    temperature_129: Optional[float] = None
    temperature_130: Optional[float] = None
    temperature_131: Optional[float] = None
    temperature_132: Optional[float] = None
    temperature_133: Optional[float] = None
    temperature_134: Optional[float] = None
    temperature_135: Optional[float] = None
    temperature_136: Optional[float] = None
    temperature_137: Optional[float] = None
    temperature_138: Optional[float] = None
    temperature_139: Optional[float] = None
    temperature_140: Optional[float] = None
    temperature_141: Optional[float] = None
    temperature_142: Optional[float] = None
    temperature_143: Optional[float] = None
    temperature_144: Optional[float] = None
    temperature_145: Optional[float] = None
    temperature_146: Optional[float] = None
    temperature_147: Optional[float] = None
    temperature_148: Optional[float] = None
    temperature_149: Optional[float] = None
    temperature_150: Optional[float] = None
    temperature_151: Optional[float] = None
    temperature_152: Optional[float] = None
    temperature_153: Optional[float] = None
    temperature_154: Optional[float] = None
    temperature_155: Optional[float] = None
    temperature_156: Optional[float] = None
    temperature_157: Optional[float] = None
    temperature_158: Optional[float] = None
    temperature_159: Optional[float] = None
    temperature_160: Optional[float] = None
    temperature_161: Optional[float] = None
    temperature_162: Optional[float] = None
    temperature_163: Optional[float] = None
    temperature_164: Optional[float] = None
    temperature_165: Optional[float] = None
    temperature_166: Optional[float] = None
    temperature_167: Optional[float] = None
    temperature_168: Optional[float] = None
    temperature_169: Optional[float] = None
    temperature_170: Optional[float] = None
    temperature_171: Optional[float] = None
    temperature_172: Optional[float] = None
    temperature_173: Optional[float] = None
    temperature_174: Optional[float] = None
    temperature_175: Optional[float] = None
    temperature_176: Optional[float] = None
    temperature_177: Optional[float] = None
    temperature_178: Optional[float] = None
    temperature_179: Optional[float] = None
    temperature_180: Optional[float] = None
    temperature_181: Optional[float] = None
    temperature_182: Optional[float] = None
    temperature_183: Optional[float] = None
    temperature_184: Optional[float] = None
    temperature_185: Optional[float] = None
    temperature_186: Optional[float] = None
    temperature_187: Optional[float] = None
    temperature_188: Optional[float] = None
    temperature_189: Optional[float] = None
    temperature_190: Optional[float] = None
    temperature_191: Optional[float] = None
    temperature_192: Optional[float] = None
    temperature_193: Optional[float] = None
    temperature_194: Optional[float] = None
    temperature_195: Optional[float] = None
    temperature_196: Optional[float] = None
    temperature_197: Optional[float] = None
    temperature_198: Optional[float] = None
    temperature_199: Optional[float] = None
    temperature_200: Optional[float] = None
    temperature_201: Optional[float] = None
    temperature_202: Optional[float] = None
    temperature_203: Optional[float] = None
    temperature_204: Optional[float] = None
    temperature_205: Optional[float] = None
    temperature_206: Optional[float] = None
    temperature_207: Optional[float] = None
    temperature_208: Optional[float] = None
    temperature_209: Optional[float] = None
    temperature_210: Optional[float] = None
    temperature_211: Optional[float] = None
    temperature_212: Optional[float] = None
    temperature_213: Optional[float] = None
    temperature_214: Optional[float] = None
    temperature_215: Optional[float] = None
    temperature_216: Optional[float] = None
    temperature_217: Optional[float] = None
    temperature_218: Optional[float] = None
    temperature_219: Optional[float] = None
    temperature_220: Optional[float] = None
    temperature_221: Optional[float] = None
    temperature_222: Optional[float] = None
    temperature_223: Optional[float] = None
    temperature_224: Optional[float] = None
    temperature_225: Optional[float] = None
    temperature_226: Optional[float] = None
    temperature_227: Optional[float] = None
    temperature_228: Optional[float] = None
    temperature_229: Optional[float] = None
    temperature_230: Optional[float] = None
    temperature_231: Optional[float] = None
    temperature_232: Optional[float] = None
    temperature_233: Optional[float] = None
    temperature_234: Optional[float] = None
    temperature_235: Optional[float] = None
    temperature_236: Optional[float] = None
    temperature_237: Optional[float] = None
    temperature_238: Optional[float] = None
    temperature_239: Optional[float] = None
    temperature_240: Optional[float] = None
    temperature_241: Optional[float] = None
    temperature_242: Optional[float] = None
    temperature_243: Optional[float] = None
    temperature_244: Optional[float] = None
    temperature_245: Optional[float] = None
    temperature_246: Optional[float] = None
    temperature_247: Optional[float] = None
    temperature_248: Optional[float] = None
    temperature_249: Optional[float] = None
    temperature_250: Optional[float] = None


class FluidPropertyType(Enum):
    density = "Density"
    enthalpy = "Enthalpy"
    pressure = "Pressure"
    specific_heat = "SpecificHeat"


class FluidPhase(Enum):
    fluid = "Fluid"
    fluid_gas = "FluidGas"


class FluidPropertiesSaturated(BaseModel):
    fluid_name: Optional[str] = None
    fluid_property_type: Optional[FluidPropertyType] = None
    fluid_phase: Optional[FluidPhase] = None
    temperature_values_name: Optional[str] = None
    property_value_1: Optional[float] = None
    property_value_2: Optional[float] = None
    property_value_3: Optional[float] = None
    property_value_4: Optional[float] = None
    property_value_5: Optional[float] = None
    property_value_6: Optional[float] = None
    property_value_7: Optional[float] = None
    property_value_8: Optional[float] = None
    property_value_9: Optional[float] = None
    property_value_10: Optional[float] = None
    property_value_11: Optional[float] = None
    property_value_12: Optional[float] = None
    property_value_13: Optional[float] = None
    property_value_14: Optional[float] = None
    property_value_15: Optional[float] = None
    property_value_16: Optional[float] = None
    property_value_17: Optional[float] = None
    property_value_18: Optional[float] = None
    property_value_19: Optional[float] = None
    property_value_20: Optional[float] = None
    property_value_21: Optional[float] = None
    property_value_22: Optional[float] = None
    property_value_23: Optional[float] = None
    property_value_24: Optional[float] = None
    property_value_25: Optional[float] = None
    property_value_26: Optional[float] = None
    property_value_27: Optional[float] = None
    property_value_28: Optional[float] = None
    property_value_29: Optional[float] = None
    property_value_30: Optional[float] = None
    property_value_31: Optional[float] = None
    property_value_32: Optional[float] = None
    property_value_33: Optional[float] = None
    property_value_34: Optional[float] = None
    property_value_35: Optional[float] = None
    property_value_36: Optional[float] = None
    property_value_37: Optional[float] = None
    property_value_38: Optional[float] = None
    property_value_39: Optional[float] = None
    property_value_40: Optional[float] = None
    property_value_41: Optional[float] = None
    property_value_42: Optional[float] = None
    property_value_43: Optional[float] = None
    property_value_44: Optional[float] = None
    property_value_45: Optional[float] = None
    property_value_46: Optional[float] = None
    property_value_47: Optional[float] = None
    property_value_48: Optional[float] = None
    property_value_49: Optional[float] = None
    property_value_50: Optional[float] = None
    property_value_51: Optional[float] = None
    property_value_52: Optional[float] = None
    property_value_53: Optional[float] = None
    property_value_54: Optional[float] = None
    property_value_55: Optional[float] = None
    property_value_56: Optional[float] = None
    property_value_57: Optional[float] = None
    property_value_58: Optional[float] = None
    property_value_59: Optional[float] = None
    property_value_60: Optional[float] = None
    property_value_61: Optional[float] = None
    property_value_62: Optional[float] = None
    property_value_63: Optional[float] = None
    property_value_64: Optional[float] = None
    property_value_65: Optional[float] = None
    property_value_66: Optional[float] = None
    property_value_67: Optional[float] = None
    property_value_68: Optional[float] = None
    property_value_69: Optional[float] = None
    property_value_70: Optional[float] = None
    property_value_71: Optional[float] = None
    property_value_72: Optional[float] = None
    property_value_73: Optional[float] = None
    property_value_74: Optional[float] = None
    property_value_75: Optional[float] = None
    property_value_76: Optional[float] = None
    property_value_77: Optional[float] = None
    property_value_78: Optional[float] = None
    property_value_79: Optional[float] = None
    property_value_80: Optional[float] = None
    property_value_81: Optional[float] = None
    property_value_82: Optional[float] = None
    property_value_83: Optional[float] = None
    property_value_84: Optional[float] = None
    property_value_85: Optional[float] = None
    property_value_86: Optional[float] = None
    property_value_87: Optional[float] = None
    property_value_88: Optional[float] = None
    property_value_89: Optional[float] = None
    property_value_90: Optional[float] = None
    property_value_91: Optional[float] = None
    property_value_92: Optional[float] = None
    property_value_93: Optional[float] = None
    property_value_94: Optional[float] = None
    property_value_95: Optional[float] = None
    property_value_96: Optional[float] = None
    property_value_97: Optional[float] = None
    property_value_98: Optional[float] = None
    property_value_99: Optional[float] = None
    property_value_100: Optional[float] = None
    property_value_101: Optional[float] = None
    property_value_102: Optional[float] = None
    property_value_103: Optional[float] = None
    property_value_104: Optional[float] = None
    property_value_105: Optional[float] = None
    property_value_106: Optional[float] = None
    property_value_107: Optional[float] = None
    property_value_108: Optional[float] = None
    property_value_109: Optional[float] = None
    property_value_110: Optional[float] = None
    property_value_111: Optional[float] = None
    property_value_112: Optional[float] = None
    property_value_113: Optional[float] = None
    property_value_114: Optional[float] = None
    property_value_115: Optional[float] = None
    property_value_116: Optional[float] = None
    property_value_117: Optional[float] = None
    property_value_118: Optional[float] = None
    property_value_119: Optional[float] = None
    property_value_120: Optional[float] = None
    property_value_121: Optional[float] = None
    property_value_122: Optional[float] = None
    property_value_123: Optional[float] = None
    property_value_124: Optional[float] = None
    property_value_125: Optional[float] = None
    property_value_126: Optional[float] = None
    property_value_127: Optional[float] = None
    property_value_128: Optional[float] = None
    property_value_129: Optional[float] = None
    property_value_130: Optional[float] = None
    property_value_131: Optional[float] = None
    property_value_132: Optional[float] = None
    property_value_133: Optional[float] = None
    property_value_134: Optional[float] = None
    property_value_135: Optional[float] = None
    property_value_136: Optional[float] = None
    property_value_137: Optional[float] = None
    property_value_138: Optional[float] = None
    property_value_139: Optional[float] = None
    property_value_140: Optional[float] = None
    property_value_141: Optional[float] = None
    property_value_142: Optional[float] = None
    property_value_143: Optional[float] = None
    property_value_144: Optional[float] = None
    property_value_145: Optional[float] = None
    property_value_146: Optional[float] = None
    property_value_147: Optional[float] = None
    property_value_148: Optional[float] = None
    property_value_149: Optional[float] = None
    property_value_150: Optional[float] = None
    property_value_151: Optional[float] = None
    property_value_152: Optional[float] = None
    property_value_153: Optional[float] = None
    property_value_154: Optional[float] = None
    property_value_155: Optional[float] = None
    property_value_156: Optional[float] = None
    property_value_157: Optional[float] = None
    property_value_158: Optional[float] = None
    property_value_159: Optional[float] = None
    property_value_160: Optional[float] = None
    property_value_161: Optional[float] = None
    property_value_162: Optional[float] = None
    property_value_163: Optional[float] = None
    property_value_164: Optional[float] = None
    property_value_165: Optional[float] = None
    property_value_166: Optional[float] = None
    property_value_167: Optional[float] = None
    property_value_168: Optional[float] = None
    property_value_169: Optional[float] = None
    property_value_170: Optional[float] = None
    property_value_171: Optional[float] = None
    property_value_172: Optional[float] = None
    property_value_173: Optional[float] = None
    property_value_174: Optional[float] = None
    property_value_175: Optional[float] = None
    property_value_176: Optional[float] = None
    property_value_177: Optional[float] = None
    property_value_178: Optional[float] = None
    property_value_179: Optional[float] = None
    property_value_180: Optional[float] = None
    property_value_181: Optional[float] = None
    property_value_182: Optional[float] = None
    property_value_183: Optional[float] = None
    property_value_184: Optional[float] = None
    property_value_185: Optional[float] = None
    property_value_186: Optional[float] = None
    property_value_187: Optional[float] = None
    property_value_188: Optional[float] = None
    property_value_189: Optional[float] = None
    property_value_190: Optional[float] = None
    property_value_191: Optional[float] = None
    property_value_192: Optional[float] = None
    property_value_193: Optional[float] = None
    property_value_194: Optional[float] = None
    property_value_195: Optional[float] = None
    property_value_196: Optional[float] = None
    property_value_197: Optional[float] = None
    property_value_198: Optional[float] = None
    property_value_199: Optional[float] = None
    property_value_200: Optional[float] = None
    property_value_201: Optional[float] = None
    property_value_202: Optional[float] = None
    property_value_203: Optional[float] = None
    property_value_204: Optional[float] = None
    property_value_205: Optional[float] = None
    property_value_206: Optional[float] = None
    property_value_207: Optional[float] = None
    property_value_208: Optional[float] = None
    property_value_209: Optional[float] = None
    property_value_210: Optional[float] = None
    property_value_211: Optional[float] = None
    property_value_212: Optional[float] = None
    property_value_213: Optional[float] = None
    property_value_214: Optional[float] = None
    property_value_215: Optional[float] = None
    property_value_216: Optional[float] = None
    property_value_217: Optional[float] = None
    property_value_218: Optional[float] = None
    property_value_219: Optional[float] = None
    property_value_220: Optional[float] = None
    property_value_221: Optional[float] = None
    property_value_222: Optional[float] = None
    property_value_223: Optional[float] = None
    property_value_224: Optional[float] = None
    property_value_225: Optional[float] = None
    property_value_226: Optional[float] = None
    property_value_227: Optional[float] = None
    property_value_228: Optional[float] = None
    property_value_229: Optional[float] = None
    property_value_230: Optional[float] = None
    property_value_231: Optional[float] = None
    property_value_232: Optional[float] = None
    property_value_233: Optional[float] = None
    property_value_234: Optional[float] = None
    property_value_235: Optional[float] = None
    property_value_236: Optional[float] = None
    property_value_237: Optional[float] = None
    property_value_238: Optional[float] = None
    property_value_239: Optional[float] = None
    property_value_240: Optional[float] = None
    property_value_241: Optional[float] = None
    property_value_242: Optional[float] = None
    property_value_243: Optional[float] = None
    property_value_244: Optional[float] = None
    property_value_245: Optional[float] = None
    property_value_246: Optional[float] = None
    property_value_247: Optional[float] = None
    property_value_248: Optional[float] = None
    property_value_249: Optional[float] = None
    property_value_250: Optional[float] = None


class FluidPropertyType1(Enum):
    density = "Density"
    enthalpy = "Enthalpy"


class FluidPropertiesSuperheated(BaseModel):
    fluid_name: Optional[str] = None
    fluid_property_type: Optional[FluidPropertyType1] = None
    temperature_values_name: Optional[str] = None
    pressure: Annotated[Optional[float], Field(None, gt=0.0)]
    property_value_1: Optional[float] = None
    property_value_2: Optional[float] = None
    property_value_3: Optional[float] = None
    property_value_4: Optional[float] = None
    property_value_5: Optional[float] = None
    property_value_6: Optional[float] = None
    property_value_7: Optional[float] = None
    property_value_8: Optional[float] = None
    property_value_9: Optional[float] = None
    property_value_10: Optional[float] = None
    property_value_11: Optional[float] = None
    property_value_12: Optional[float] = None
    property_value_13: Optional[float] = None
    property_value_14: Optional[float] = None
    property_value_15: Optional[float] = None
    property_value_16: Optional[float] = None
    property_value_17: Optional[float] = None
    property_value_18: Optional[float] = None
    property_value_19: Optional[float] = None
    property_value_20: Optional[float] = None
    property_value_21: Optional[float] = None
    property_value_22: Optional[float] = None
    property_value_23: Optional[float] = None
    property_value_24: Optional[float] = None
    property_value_25: Optional[float] = None
    property_value_26: Optional[float] = None
    property_value_27: Optional[float] = None
    property_value_28: Optional[float] = None
    property_value_29: Optional[float] = None
    property_value_30: Optional[float] = None
    property_value_31: Optional[float] = None
    property_value_32: Optional[float] = None
    property_value_33: Optional[float] = None
    property_value_34: Optional[float] = None
    property_value_35: Optional[float] = None
    property_value_36: Optional[float] = None
    property_value_37: Optional[float] = None
    property_value_38: Optional[float] = None
    property_value_39: Optional[float] = None
    property_value_40: Optional[float] = None
    property_value_41: Optional[float] = None
    property_value_42: Optional[float] = None
    property_value_43: Optional[float] = None
    property_value_44: Optional[float] = None
    property_value_45: Optional[float] = None
    property_value_46: Optional[float] = None
    property_value_47: Optional[float] = None
    property_value_48: Optional[float] = None
    property_value_49: Optional[float] = None
    property_value_50: Optional[float] = None
    property_value_51: Optional[float] = None
    property_value_52: Optional[float] = None
    property_value_53: Optional[float] = None
    property_value_54: Optional[float] = None
    property_value_55: Optional[float] = None
    property_value_56: Optional[float] = None
    property_value_57: Optional[float] = None
    property_value_58: Optional[float] = None
    property_value_59: Optional[float] = None
    property_value_60: Optional[float] = None
    property_value_61: Optional[float] = None
    property_value_62: Optional[float] = None
    property_value_63: Optional[float] = None
    property_value_64: Optional[float] = None
    property_value_65: Optional[float] = None
    property_value_66: Optional[float] = None
    property_value_67: Optional[float] = None
    property_value_68: Optional[float] = None
    property_value_69: Optional[float] = None
    property_value_70: Optional[float] = None
    property_value_71: Optional[float] = None
    property_value_72: Optional[float] = None
    property_value_73: Optional[float] = None
    property_value_74: Optional[float] = None
    property_value_75: Optional[float] = None
    property_value_76: Optional[float] = None
    property_value_77: Optional[float] = None
    property_value_78: Optional[float] = None
    property_value_79: Optional[float] = None
    property_value_80: Optional[float] = None
    property_value_81: Optional[float] = None
    property_value_82: Optional[float] = None
    property_value_83: Optional[float] = None
    property_value_84: Optional[float] = None
    property_value_85: Optional[float] = None
    property_value_86: Optional[float] = None
    property_value_87: Optional[float] = None
    property_value_88: Optional[float] = None
    property_value_89: Optional[float] = None
    property_value_90: Optional[float] = None
    property_value_91: Optional[float] = None
    property_value_92: Optional[float] = None
    property_value_93: Optional[float] = None
    property_value_94: Optional[float] = None
    property_value_95: Optional[float] = None
    property_value_96: Optional[float] = None
    property_value_97: Optional[float] = None
    property_value_98: Optional[float] = None
    property_value_99: Optional[float] = None
    property_value_100: Optional[float] = None
    property_value_101: Optional[float] = None
    property_value_102: Optional[float] = None
    property_value_103: Optional[float] = None
    property_value_104: Optional[float] = None
    property_value_105: Optional[float] = None
    property_value_106: Optional[float] = None
    property_value_107: Optional[float] = None
    property_value_108: Optional[float] = None
    property_value_109: Optional[float] = None
    property_value_110: Optional[float] = None
    property_value_111: Optional[float] = None
    property_value_112: Optional[float] = None
    property_value_113: Optional[float] = None
    property_value_114: Optional[float] = None
    property_value_115: Optional[float] = None
    property_value_116: Optional[float] = None
    property_value_117: Optional[float] = None
    property_value_118: Optional[float] = None
    property_value_119: Optional[float] = None
    property_value_120: Optional[float] = None
    property_value_121: Optional[float] = None
    property_value_122: Optional[float] = None
    property_value_123: Optional[float] = None
    property_value_124: Optional[float] = None
    property_value_125: Optional[float] = None
    property_value_126: Optional[float] = None
    property_value_127: Optional[float] = None
    property_value_128: Optional[float] = None
    property_value_129: Optional[float] = None
    property_value_130: Optional[float] = None
    property_value_131: Optional[float] = None
    property_value_132: Optional[float] = None
    property_value_133: Optional[float] = None
    property_value_134: Optional[float] = None
    property_value_135: Optional[float] = None
    property_value_136: Optional[float] = None
    property_value_137: Optional[float] = None
    property_value_138: Optional[float] = None
    property_value_139: Optional[float] = None
    property_value_140: Optional[float] = None
    property_value_141: Optional[float] = None
    property_value_142: Optional[float] = None
    property_value_143: Optional[float] = None
    property_value_144: Optional[float] = None
    property_value_145: Optional[float] = None
    property_value_146: Optional[float] = None
    property_value_147: Optional[float] = None
    property_value_148: Optional[float] = None
    property_value_149: Optional[float] = None
    property_value_150: Optional[float] = None
    property_value_151: Optional[float] = None
    property_value_152: Optional[float] = None
    property_value_153: Optional[float] = None
    property_value_154: Optional[float] = None
    property_value_155: Optional[float] = None
    property_value_156: Optional[float] = None
    property_value_157: Optional[float] = None
    property_value_158: Optional[float] = None
    property_value_159: Optional[float] = None
    property_value_160: Optional[float] = None
    property_value_161: Optional[float] = None
    property_value_162: Optional[float] = None
    property_value_163: Optional[float] = None
    property_value_164: Optional[float] = None
    property_value_165: Optional[float] = None
    property_value_166: Optional[float] = None
    property_value_167: Optional[float] = None
    property_value_168: Optional[float] = None
    property_value_169: Optional[float] = None
    property_value_170: Optional[float] = None
    property_value_171: Optional[float] = None
    property_value_172: Optional[float] = None
    property_value_173: Optional[float] = None
    property_value_174: Optional[float] = None
    property_value_175: Optional[float] = None
    property_value_176: Optional[float] = None
    property_value_177: Optional[float] = None
    property_value_178: Optional[float] = None
    property_value_179: Optional[float] = None
    property_value_180: Optional[float] = None
    property_value_181: Optional[float] = None
    property_value_182: Optional[float] = None
    property_value_183: Optional[float] = None
    property_value_184: Optional[float] = None
    property_value_185: Optional[float] = None
    property_value_186: Optional[float] = None
    property_value_187: Optional[float] = None
    property_value_188: Optional[float] = None
    property_value_189: Optional[float] = None
    property_value_190: Optional[float] = None
    property_value_191: Optional[float] = None
    property_value_192: Optional[float] = None
    property_value_193: Optional[float] = None
    property_value_194: Optional[float] = None
    property_value_195: Optional[float] = None
    property_value_196: Optional[float] = None
    property_value_197: Optional[float] = None
    property_value_198: Optional[float] = None
    property_value_199: Optional[float] = None
    property_value_200: Optional[float] = None
    property_value_201: Optional[float] = None
    property_value_202: Optional[float] = None
    property_value_203: Optional[float] = None
    property_value_204: Optional[float] = None
    property_value_205: Optional[float] = None
    property_value_206: Optional[float] = None
    property_value_207: Optional[float] = None
    property_value_208: Optional[float] = None
    property_value_209: Optional[float] = None
    property_value_210: Optional[float] = None
    property_value_211: Optional[float] = None
    property_value_212: Optional[float] = None
    property_value_213: Optional[float] = None
    property_value_214: Optional[float] = None
    property_value_215: Optional[float] = None
    property_value_216: Optional[float] = None
    property_value_217: Optional[float] = None
    property_value_218: Optional[float] = None
    property_value_219: Optional[float] = None
    property_value_220: Optional[float] = None
    property_value_221: Optional[float] = None
    property_value_222: Optional[float] = None
    property_value_223: Optional[float] = None
    property_value_224: Optional[float] = None
    property_value_225: Optional[float] = None
    property_value_226: Optional[float] = None
    property_value_227: Optional[float] = None
    property_value_228: Optional[float] = None
    property_value_229: Optional[float] = None
    property_value_230: Optional[float] = None
    property_value_231: Optional[float] = None
    property_value_232: Optional[float] = None
    property_value_233: Optional[float] = None
    property_value_234: Optional[float] = None
    property_value_235: Optional[float] = None
    property_value_236: Optional[float] = None
    property_value_237: Optional[float] = None
    property_value_238: Optional[float] = None
    property_value_239: Optional[float] = None
    property_value_240: Optional[float] = None
    property_value_241: Optional[float] = None
    property_value_242: Optional[float] = None
    property_value_243: Optional[float] = None
    property_value_244: Optional[float] = None
    property_value_245: Optional[float] = None
    property_value_246: Optional[float] = None
    property_value_247: Optional[float] = None
    property_value_248: Optional[float] = None
    property_value_249: Optional[float] = None
    property_value_250: Optional[float] = None


class ConversionFactorChoice(Enum):
    ccf = "CCF"
    mcf = "MCF"
    mj = "MJ"
    mm_btu = "MMBtu"
    therm = "Therm"
    user_defined = "UserDefined"
    gal = "gal"
    k_btu = "kBtu"
    k_wh = "kWh"
    kgal = "kgal"
    m3 = "m3"


class DemandWindowLength(Enum):
    day = "Day"
    full_hour = "FullHour"
    half_hour = "HalfHour"
    quarter_hour = "QuarterHour"
    week = "Week"


class BuyOrSell(Enum):
    buy_from_utility = "BuyFromUtility"
    net_metering = "NetMetering"
    sell_to_utility = "SellToUtility"


class UtilityCostTariff(BaseModel):
    output_meter_name: str
    conversion_factor_choice: Optional[ConversionFactorChoice] = None
    energy_conversion_factor: Optional[float] = None
    demand_conversion_factor: Optional[float] = None
    time_of_use_period_schedule_name: Optional[str] = None
    season_schedule_name: Optional[str] = None
    month_schedule_name: Optional[str] = None
    demand_window_length: Optional[DemandWindowLength] = None
    monthly_charge_or_variable_name: Optional[Union[float, str]] = None
    minimum_monthly_charge_or_variable_name: Optional[Union[float, str]] = None
    real_time_pricing_charge_schedule_name: Optional[str] = None
    customer_baseline_load_schedule_name: Optional[str] = None
    group_name: Optional[str] = None
    buy_or_sell: Optional[BuyOrSell] = BuyOrSell.buy_from_utility


class QualifyType(Enum):
    maximum = "Maximum"
    minimum = "Minimum"


class Season(Enum):
    annual = "Annual"
    fall = "Fall"
    spring = "Spring"
    summer = "Summer"
    winter = "Winter"


class ThresholdTest(Enum):
    consecutive = "Consecutive"
    count = "Count"


class UtilityCostQualify(BaseModel):
    utility_cost_qualify_name: str
    tariff_name: str
    variable_name: str
    qualify_type: Optional[QualifyType] = QualifyType.maximum
    threshold_value_or_variable_name: Union[float, str]
    season: Optional[Season] = None
    threshold_test: Optional[ThresholdTest] = ThresholdTest.consecutive
    number_of_months: Annotated[Optional[float], Field(None, ge=1.0, le=12.0)]


class CategoryVariableName(Enum):
    adjustment = "Adjustment"
    basis = "Basis"
    demand_charges = "DemandCharges"
    energy_charges = "EnergyCharges"
    not_included = "NotIncluded"
    service_charges = "ServiceCharges"
    subtotal = "Subtotal"
    surcharge = "Surcharge"
    taxes = "Taxes"
    total = "Total"


class UtilityCostChargeSimple(BaseModel):
    utility_cost_charge_simple_name: str
    tariff_name: str
    source_variable: str
    season: Optional[Season] = None
    category_variable_name: CategoryVariableName
    cost_per_unit_value_or_variable_name: Union[float, str]


class UtilityCostChargeBlock(BaseModel):
    utility_cost_charge_block_name: str
    tariff_name: str
    source_variable: str
    season: Optional[Season] = Season.annual
    category_variable_name: CategoryVariableName
    remaining_into_variable: Optional[str] = None
    block_size_multiplier_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_1_value_or_variable_name: Optional[Union[float, str]] = None
    block_1_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_2_value_or_variable_name: Optional[Union[float, str]] = None
    block_2_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_3_value_or_variable_name: Optional[Union[float, str]] = None
    block_3_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_4_value_or_variable_name: Optional[Union[float, str]] = None
    block_4_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_5_value_or_variable_name: Optional[Union[float, str]] = None
    block_5_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_6_value_or_variable_name: Optional[Union[float, str]] = None
    block_6_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_7_value_or_variable_name: Optional[Union[float, str]] = None
    block_7_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_8_value_or_variable_name: Optional[Union[float, str]] = None
    block_8_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_9_value_or_variable_name: Optional[Union[float, str]] = None
    block_9_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_10_value_or_variable_name: Optional[Union[float, str]] = None
    block_10_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_11_value_or_variable_name: Optional[Union[float, str]] = None
    block_11_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_12_value_or_variable_name: Optional[Union[float, str]] = None
    block_12_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_13_value_or_variable_name: Optional[Union[float, str]] = None
    block_13_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_14_value_or_variable_name: Optional[Union[float, str]] = None
    block_14_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None
    block_size_15_value_or_variable_name: Optional[Union[float, str]] = None
    block_15_cost_per_unit_value_or_variable_name: Optional[Union[float, str]] = None


class VariableType(Enum):
    currency = "Currency"
    demand = "Demand"
    dimensionless = "Dimensionless"
    energy = "Energy"


class UtilityCostVariable(BaseModel):
    tariff_name: str
    variable_type: Optional[VariableType] = VariableType.dimensionless
    january_value: Optional[float] = None
    february_value: Optional[float] = None
    march_value: Optional[float] = None
    april_value: Optional[float] = None
    may_value: Optional[float] = None
    june_value: Optional[float] = None
    july_value: Optional[float] = None
    august_value: Optional[float] = None
    september_value: Optional[float] = None
    october_value: Optional[float] = None
    november_value: Optional[float] = None
    december_value: Optional[float] = None


class KeyField(Enum):
    idf = "IDF"
    regular = "regular"


class SortOption(Enum):
    name = "Name"
    unsorted = "Unsorted"


class OutputVariableDictionary(BaseModel):
    key_field: Optional[KeyField] = KeyField.regular
    sort_option: Optional[SortOption] = None


class ReportType(Enum):
    cost_info = "CostInfo"
    decay_curves_from_component_loads_summary = "DecayCurvesFromComponentLoadsSummary"
    details = "Details"
    details_with_vertices = "DetailsWithVertices"
    lines = "Lines"
    vertices = "Vertices"
    view_factor_info = "ViewFactorInfo"


class OutputSurfacesList(BaseModel):
    report_type: ReportType
    report_specifications: Optional[Literal["IDF"]] = None


class ReportType1(Enum):
    dxf = "DXF"
    dxf_wire_frame = "DXF:WireFrame"
    vrml = "VRML"


class ReportSpecifications1(Enum):
    regular_polyline = "RegularPolyline"
    thick_polyline = "ThickPolyline"
    triangulate3_d_face = "Triangulate3DFace"


class OutputSurfacesDrawing(BaseModel):
    report_type: ReportType1
    report_specifications_1: Optional[ReportSpecifications1] = (
        ReportSpecifications1.triangulate3_d_face
    )
    report_specifications_2: Optional[str] = None


class DetailsType1(Enum):
    constructions = "Constructions"
    materials = "Materials"


class OutputConstructions(BaseModel):
    details_type_1: Optional[DetailsType1] = None
    details_type_2: Optional[DetailsType1] = None


class ActuatorAvailabilityDictionaryReporting(Enum):
    none = "None"
    not_by_unique_key_names = "NotByUniqueKeyNames"
    verbose = "Verbose"


class EmsRuntimeLanguageDebugOutputLevel(Enum):
    errors_only = "ErrorsOnly"
    none = "None"
    verbose = "Verbose"


class OutputEnergyManagementSystem(BaseModel):
    actuator_availability_dictionary_reporting: Optional[
        ActuatorAvailabilityDictionaryReporting
    ] = ActuatorAvailabilityDictionaryReporting.none
    internal_variable_availability_dictionary_reporting: Optional[
        ActuatorAvailabilityDictionaryReporting
    ] = ActuatorAvailabilityDictionaryReporting.none
    ems_runtime_language_debug_output_level: Optional[
        EmsRuntimeLanguageDebugOutputLevel
    ] = EmsRuntimeLanguageDebugOutputLevel.none


class ReportName(Enum):
    adaptive_comfort_summary = "AdaptiveComfortSummary"
    air_loop_component_load_summary = "AirLoopComponentLoadSummary"
    air_loop_system_component_energy_use_monthly = (
        "AirLoopSystemComponentEnergyUseMonthly"
    )
    air_loop_system_component_loads_monthly = "AirLoopSystemComponentLoadsMonthly"
    air_loop_system_energy_and_water_use_monthly = (
        "AirLoopSystemEnergyAndWaterUseMonthly"
    )
    all_monthly = "AllMonthly"
    all_summary = "AllSummary"
    all_summary_and_monthly = "AllSummaryAndMonthly"
    all_summary_and_sizing_period = "AllSummaryAndSizingPeriod"
    all_summary_monthly_and_sizing_period = "AllSummaryMonthlyAndSizingPeriod"
    annual_building_utility_performance_summary = (
        "AnnualBuildingUtilityPerformanceSummary"
    )
    average_outdoor_conditions_monthly = "AverageOutdoorConditionsMonthly"
    boiler_report_monthly = "BoilerReportMonthly"
    co2_resilience_summary = "CO2ResilienceSummary"
    chiller_report_monthly = "ChillerReportMonthly"
    climatic_data_summary = "ClimaticDataSummary"
    coil_report_monthly = "CoilReportMonthly"
    coil_sizing_details = "CoilSizingDetails"
    comfort_report_simple55_monthly = "ComfortReportSimple55Monthly"
    component_cost_economics_summary = "ComponentCostEconomicsSummary"
    component_sizing_summary = "ComponentSizingSummary"
    cond_loop_demand_report_monthly = "CondLoopDemandReportMonthly"
    dx_report_monthly = "DXReportMonthly"
    daylighting_report_monthly = "DaylightingReportMonthly"
    demand_end_use_components_summary = "DemandEndUseComponentsSummary"
    economic_result_summary = "EconomicResultSummary"
    electric_components_of_peak_demand_monthly = "ElectricComponentsOfPeakDemandMonthly"
    end_use_energy_consumption_coal_monthly = "EndUseEnergyConsumptionCoalMonthly"
    end_use_energy_consumption_diesel_monthly = "EndUseEnergyConsumptionDieselMonthly"
    end_use_energy_consumption_electricity_monthly = (
        "EndUseEnergyConsumptionElectricityMonthly"
    )
    end_use_energy_consumption_fuel_oil_monthly = (
        "EndUseEnergyConsumptionFuelOilMonthly"
    )
    end_use_energy_consumption_gasoline_monthly = (
        "EndUseEnergyConsumptionGasolineMonthly"
    )
    end_use_energy_consumption_natural_gas_monthly = (
        "EndUseEnergyConsumptionNaturalGasMonthly"
    )
    end_use_energy_consumption_other_fuels_monthly = (
        "EndUseEnergyConsumptionOtherFuelsMonthly"
    )
    end_use_energy_consumption_propane_monthly = "EndUseEnergyConsumptionPropaneMonthly"
    energy_consumption_coal_gasoline_monthly = "EnergyConsumptionCoalGasolineMonthly"
    energy_consumption_diesel_fuel_oil_monthly = "EnergyConsumptionDieselFuelOilMonthly"
    energy_consumption_district_heating_cooling_monthly = (
        "EnergyConsumptionDistrictHeatingCoolingMonthly"
    )
    energy_consumption_electricity_generated_propane_monthly = (
        "EnergyConsumptionElectricityGeneratedPropaneMonthly"
    )
    energy_consumption_electricity_natural_gas_monthly = (
        "EnergyConsumptionElectricityNaturalGasMonthly"
    )
    energy_consumption_other_fuels_monthly = "EnergyConsumptionOtherFuelsMonthly"
    energy_meters = "EnergyMeters"
    envelope_summary = "EnvelopeSummary"
    equipment_summary = "EquipmentSummary"
    facility_component_load_summary = "FacilityComponentLoadSummary"
    fan_report_monthly = "FanReportMonthly"
    generator_report_monthly = "GeneratorReportMonthly"
    hvac_sizing_summary = "HVACSizingSummary"
    heat_emissions_report_monthly = "HeatEmissionsReportMonthly"
    heat_emissions_summary = "HeatEmissionsSummary"
    initialization_summary = "InitializationSummary"
    input_verificationand_results_summary = "InputVerificationandResultsSummary"
    leed_summary = "LEEDSummary"
    life_cycle_cost_report = "LifeCycleCostReport"
    lighting_summary = "LightingSummary"
    mechanical_ventilation_loads_monthly = "MechanicalVentilationLoadsMonthly"
    object_count_summary = "ObjectCountSummary"
    occupant_comfort_data_summary_monthly = "OccupantComfortDataSummaryMonthly"
    outdoor_air_details = "OutdoorAirDetails"
    outdoor_air_summary = "OutdoorAirSummary"
    outdoor_conditions_maximum_dew_point_monthly = (
        "OutdoorConditionsMaximumDewPointMonthly"
    )
    outdoor_conditions_maximum_dry_bulb_monthly = (
        "OutdoorConditionsMaximumDryBulbMonthly"
    )
    outdoor_conditions_maximum_wet_bulb_monthly = (
        "OutdoorConditionsMaximumWetBulbMonthly"
    )
    outdoor_conditions_minimum_dry_bulb_monthly = (
        "OutdoorConditionsMinimumDryBulbMonthly"
    )
    outdoor_ground_conditions_monthly = "OutdoorGroundConditionsMonthly"
    peak_energy_end_use_coal_monthly = "PeakEnergyEndUseCoalMonthly"
    peak_energy_end_use_diesel_monthly = "PeakEnergyEndUseDieselMonthly"
    peak_energy_end_use_electricity_part1_monthly = (
        "PeakEnergyEndUseElectricityPart1Monthly"
    )
    peak_energy_end_use_electricity_part2_monthly = (
        "PeakEnergyEndUseElectricityPart2Monthly"
    )
    peak_energy_end_use_fuel_oil_monthly = "PeakEnergyEndUseFuelOilMonthly"
    peak_energy_end_use_gasoline_monthly = "PeakEnergyEndUseGasolineMonthly"
    peak_energy_end_use_natural_gas_monthly = "PeakEnergyEndUseNaturalGasMonthly"
    peak_energy_end_use_other_fuels_monthly = "PeakEnergyEndUseOtherFuelsMonthly"
    peak_energy_end_use_propane_monthly = "PeakEnergyEndUsePropaneMonthly"
    peak_space_gains_monthly = "PeakSpaceGainsMonthly"
    plant_loop_demand_report_monthly = "PlantLoopDemandReportMonthly"
    pump_report_monthly = "PumpReportMonthly"
    sensible_heat_gain_summary = "SensibleHeatGainSummary"
    setpoints_not_met_with_temperatures_monthly = (
        "SetpointsNotMetWithTemperaturesMonthly"
    )
    shading_summary = "ShadingSummary"
    source_energy_end_use_components_summary = "SourceEnergyEndUseComponentsSummary"
    space_gain_components_at_cooling_peak_monthly = (
        "SpaceGainComponentsAtCoolingPeakMonthly"
    )
    space_gains_monthly = "SpaceGainsMonthly"
    standard62_1_summary = "Standard62.1Summary"
    surface_shadowing_summary = "SurfaceShadowingSummary"
    system_summary = "SystemSummary"
    tariff_report = "TariffReport"
    thermal_resilience_summary = "ThermalResilienceSummary"
    tower_report_monthly = "TowerReportMonthly"
    unglazed_transpired_solar_collector_summary_monthly = (
        "UnglazedTranspiredSolarCollectorSummaryMonthly"
    )
    visual_resilience_summary = "VisualResilienceSummary"
    water_heater_report_monthly = "WaterHeaterReportMonthly"
    window_ac_report_monthly = "WindowACReportMonthly"
    window_energy_report_monthly = "WindowEnergyReportMonthly"
    window_energy_zone_summary_monthly = "WindowEnergyZoneSummaryMonthly"
    window_report_monthly = "WindowReportMonthly"
    window_zone_summary_monthly = "WindowZoneSummaryMonthly"
    zone_component_load_summary = "ZoneComponentLoadSummary"
    zone_cooling_summary_monthly = "ZoneCoolingSummaryMonthly"
    zone_electric_summary_monthly = "ZoneElectricSummaryMonthly"
    zone_heating_summary_monthly = "ZoneHeatingSummaryMonthly"
    zone_temperature_oscillation_report_monthly = (
        "ZoneTemperatureOscillationReportMonthly"
    )


class Report(BaseModel):
    report_name: Optional[ReportName] = None


class OutputTableSummaryReports(BaseModel):
    reports: Optional[List[Report]] = None


class VariableType1(Enum):
    energy = "Energy"
    power = "Power"
    temperature = "Temperature"
    volumetric_flow = "VolumetricFlow"


class OutputTableTimeBins(BaseModel):
    key_value: Optional[str] = "*"
    variable_name: str
    interval_start: Optional[float] = None
    interval_size: Optional[float] = None
    interval_count: Annotated[Optional[int], Field(None, ge=1, le=20)]
    schedule_name: Optional[str] = None
    variable_type: Optional[VariableType1] = None


class AggregationTypeForVariableOrMeter(Enum):
    hours_negative = "HoursNegative"
    hours_non_negative = "HoursNonNegative"
    hours_non_positive = "HoursNonPositive"
    hours_non_zero = "HoursNonZero"
    hours_positive = "HoursPositive"
    hours_zero = "HoursZero"
    maximum = "Maximum"
    maximum_during_hours_shown = "MaximumDuringHoursShown"
    minimum = "Minimum"
    minimum_during_hours_shown = "MinimumDuringHoursShown"
    sum_or_average = "SumOrAverage"
    sum_or_average_during_hours_shown = "SumOrAverageDuringHoursShown"
    value_when_maximum_or_minimum = "ValueWhenMaximumOrMinimum"


class VariableDetail(BaseModel):
    variable_or_meter_name: Optional[str] = None
    aggregation_type_for_variable_or_meter: Optional[
        AggregationTypeForVariableOrMeter
    ] = None


class OutputTableMonthly(BaseModel):
    digits_after_decimal: Annotated[Optional[int], Field(2, ge=0, le=10)]
    variable_details: Optional[List[VariableDetail]] = None


class ColumnSeparator(Enum):
    all = "All"
    comma = "Comma"
    comma_and_html = "CommaAndHTML"
    comma_and_xml = "CommaAndXML"
    fixed = "Fixed"
    html = "HTML"
    tab = "Tab"
    tab_and_html = "TabAndHTML"
    xml = "XML"
    xm_land_html = "XMLandHTML"


class UnitConversion(Enum):
    inch_pound = "InchPound"
    jto_gj = "JtoGJ"
    jto_kwh = "JtoKWH"
    jto_mj = "JtoMJ"
    none = "None"


class OutputControlTableStyle(BaseModel):
    column_separator: Optional[ColumnSeparator] = ColumnSeparator.comma
    unit_conversion: Optional[UnitConversion] = UnitConversion.none


class OutputControlReportingTolerances(BaseModel):
    tolerance_for_time_heating_setpoint_not_met: Annotated[
        Optional[float], Field(0.2, ge=0.0, le=10.0)
    ]
    tolerance_for_time_cooling_setpoint_not_met: Annotated[
        Optional[float], Field(0.2, ge=0.0, le=10.0)
    ]


class ReportingFrequency(Enum):
    annual = "Annual"
    daily = "Daily"
    detailed = "Detailed"
    environment = "Environment"
    hourly = "Hourly"
    monthly = "Monthly"
    run_period = "RunPeriod"
    timestep = "Timestep"


class OutputVariable(BaseModel):
    key_value: Optional[str] = "*"
    variable_name: str
    reporting_frequency: Optional[ReportingFrequency] = ReportingFrequency.hourly
    schedule_name: Optional[str] = None


class OutputMeter(BaseModel):
    key_name: str
    reporting_frequency: Optional[ReportingFrequency] = ReportingFrequency.hourly


class OutputMeterMeterFileOnly(OutputMeter):
    pass


class ResourceType(Enum):
    coal = "Coal"
    diesel = "Diesel"
    district_cooling = "DistrictCooling"
    district_heating_steam = "DistrictHeatingSteam"
    district_heating_water = "DistrictHeatingWater"
    electricity = "Electricity"
    fuel_oil_no1 = "FuelOilNo1"
    fuel_oil_no2 = "FuelOilNo2"
    gasoline = "Gasoline"
    generic = "Generic"
    natural_gas = "NaturalGas"
    other_fuel1 = "OtherFuel1"
    other_fuel2 = "OtherFuel2"
    propane = "Propane"
    water = "Water"


class VariableDetail1(BaseModel):
    key_name: Optional[str] = None
    output_variable_or_meter_name: Optional[str] = None


class MeterCustom(BaseModel):
    resource_type: Optional[ResourceType] = None
    variable_details: Optional[List[VariableDetail1]] = None


class MeterCustomDecrement(BaseModel):
    resource_type: Optional[ResourceType] = None
    source_meter_name: str
    variable_details: Optional[List[VariableDetail1]] = None


class OptionType(Enum):
    time_series = "TimeSeries"
    time_series_and_tabular = "TimeSeriesAndTabular"


class OptionType1(Enum):
    simple = "Simple"
    simple_and_tabular = "SimpleAndTabular"


class UnitConversionForTabularData(Enum):
    inch_pound = "InchPound"
    jto_gj = "JtoGJ"
    jto_kwh = "JtoKWH"
    jto_mj = "JtoMJ"
    none = "None"
    use_output_control_table_style = "UseOutputControlTableStyle"


class OutputSqLite(BaseModel):
    option_type: Optional[OptionType1] = None
    unit_conversion_for_tabular_data: Optional[UnitConversionForTabularData] = (
        UnitConversionForTabularData.use_output_control_table_style
    )


class ReportingFrequency3(Enum):
    annual = "Annual"
    daily = "Daily"
    environment = "Environment"
    hourly = "Hourly"
    monthly = "Monthly"
    run_period = "RunPeriod"
    timestep = "Timestep"


class OutputEnvironmentalImpactFactors(BaseModel):
    reporting_frequency: Optional[ReportingFrequency3] = None


class EnvironmentalImpactFactors(BaseModel):
    district_heating_water_efficiency: Annotated[Optional[float], Field(0.3, gt=0.0)]
    district_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    district_heating_steam_conversion_efficiency: Annotated[
        Optional[float], Field(0.25, gt=0.0)
    ]
    total_carbon_equivalent_emission_factor_from_n2o: Optional[float] = 80.7272
    total_carbon_equivalent_emission_factor_from_ch4: Optional[float] = 6.2727
    total_carbon_equivalent_emission_factor_from_co2: Optional[float] = 0.2727


class FuelFactors(BaseModel):
    existing_fuel_resource_name: Optional[FuelType4] = None
    source_energy_factor: Optional[float] = None
    source_energy_schedule_name: Optional[str] = None
    co2_emission_factor: Optional[float] = None
    co2_emission_factor_schedule_name: Optional[str] = None
    co_emission_factor: Optional[float] = None
    co_emission_factor_schedule_name: Optional[str] = None
    ch4_emission_factor: Optional[float] = None
    ch4_emission_factor_schedule_name: Optional[str] = None
    nox_emission_factor: Optional[float] = None
    nox_emission_factor_schedule_name: Optional[str] = None
    n2o_emission_factor: Optional[float] = None
    n2o_emission_factor_schedule_name: Optional[str] = None
    so2_emission_factor: Optional[float] = None
    so2_emission_factor_schedule_name: Optional[str] = None
    pm_emission_factor: Optional[float] = None
    pm_emission_factor_schedule_name: Optional[str] = None
    pm10_emission_factor: Optional[float] = None
    pm10_emission_factor_schedule_name: Optional[str] = None
    pm2_5_emission_factor: Optional[float] = None
    pm2_5_emission_factor_schedule_name: Optional[str] = None
    nh3_emission_factor: Optional[float] = None
    nh3_emission_factor_schedule_name: Optional[str] = None
    nmvoc_emission_factor: Optional[float] = None
    nmvoc_emission_factor_schedule_name: Optional[str] = None
    hg_emission_factor: Optional[float] = None
    hg_emission_factor_schedule_name: Optional[str] = None
    pb_emission_factor: Optional[float] = None
    pb_emission_factor_schedule_name: Optional[str] = None
    water_emission_factor: Optional[float] = None
    water_emission_factor_schedule_name: Optional[str] = None
    nuclear_high_level_emission_factor: Optional[float] = None
    nuclear_high_level_emission_factor_schedule_name: Optional[str] = None
    nuclear_low_level_emission_factor: Optional[float] = None
    nuclear_low_level_emission_factor_schedule_name: Optional[str] = None


class Key(Enum):
    display_advanced_report_variables = "DisplayAdvancedReportVariables"
    display_all_warnings = "DisplayAllWarnings"
    display_extra_warnings = "DisplayExtraWarnings"
    display_unused_objects = "DisplayUnusedObjects"
    display_unused_schedules = "DisplayUnusedSchedules"
    display_weather_missing_data_warnings = "DisplayWeatherMissingDataWarnings"
    display_zone_air_heat_balance_off_balance = "DisplayZoneAirHeatBalanceOffBalance"
    do_not_mirror_attached_shading = "DoNotMirrorAttachedShading"
    do_not_mirror_detached_shading = "DoNotMirrorDetachedShading"
    report_detailed_warmup_convergence = "ReportDetailedWarmupConvergence"
    report_during_hvac_sizing_simulation = "ReportDuringHVACSizingSimulation"
    report_during_warmup = "ReportDuringWarmup"


class Diagnostic(BaseModel):
    key: Optional[Key] = None


class OutputDiagnostics(BaseModel):
    diagnostics: Optional[List[Diagnostic]] = None


class EPBoolean(Enum):
    no = "No"
    yes = "Yes"


class SimulationControl(BaseModel):
    do_zone_sizing_calculation: Optional[EPBoolean] = EPBoolean.no
    do_system_sizing_calculation: Optional[EPBoolean] = EPBoolean.no
    do_plant_sizing_calculation: Optional[EPBoolean] = EPBoolean.no
    run_simulation_for_sizing_periods: Optional[EPBoolean] = EPBoolean.no
    run_simulation_for_weather_file_run_periods: Optional[EPBoolean] = EPBoolean.no
    do_hvac_sizing_simulation_for_sizing_periods: Optional[EPBoolean] = EPBoolean.no
    maximum_number_of_hvac_sizing_simulation_passes: Annotated[
        Optional[int], Field(1, ge=1)
    ]


class ShadowCalculation(BaseModel):
    shading_calculation_method: Optional[ShadingCalculationMethod] = (
        ShadingCalculationMethod.polygon_clipping
    )
    shading_calculation_update_frequency_method: Optional[
        ShadingCalculationUpdateFrequencyMethod
    ] = ShadingCalculationUpdateFrequencyMethod.periodic
    shading_calculation_update_frequency: Annotated[Optional[int], Field(20, ge=1)]
    maximum_figures_in_shadow_overlap_calculations: Annotated[
        Optional[int], Field(15000, ge=200)
    ]
    polygon_clipping_algorithm: Optional[PolygonClippingAlgorithm] = (
        PolygonClippingAlgorithm.sutherland_hodgman
    )
    pixel_counting_resolution: Optional[int] = 512
    sky_diffuse_modeling_algorithm: Optional[SkyDiffuseModelingAlgorithm] = (
        SkyDiffuseModelingAlgorithm.simple_sky_diffuse_modeling
    )
    output_external_shading_calculation_results: Optional[EPBoolean] = EPBoolean.no
    disable_self_shading_within_shading_zone_groups: Optional[EPBoolean] = EPBoolean.no
    disable_self_shading_from_shading_zone_groups_to_other_zones: Optional[
        EPBoolean
    ] = EPBoolean.no
    shading_zone_groups: Optional[List[ShadingZoneGroup]] = None


class ZoneAirHeatBalanceAlgorithm(BaseModel):
    algorithm: Optional[Algorithm3] = Algorithm3.third_order_backward_difference
    do_space_heat_balance_for_sizing: Optional[EPBoolean] = EPBoolean.no
    do_space_heat_balance_for_simulation: Optional[EPBoolean] = EPBoolean.no


class ZoneAirContaminantBalance(BaseModel):
    carbon_dioxide_concentration: Optional[EPBoolean] = EPBoolean.no
    outdoor_carbon_dioxide_schedule_name: Optional[str] = None
    generic_contaminant_concentration: Optional[EPBoolean] = EPBoolean.no
    outdoor_generic_contaminant_schedule_name: Optional[str] = None


class SizingPeriodDesignDay(BaseModel):
    month: Annotated[int, Field(ge=1, le=12)]
    day_of_month: Annotated[int, Field(ge=1, le=31)]
    day_type: DayType
    maximum_dry_bulb_temperature: Annotated[
        Optional[float], Field(None, ge=-90.0, le=70.0)
    ]
    daily_dry_bulb_temperature_range: Annotated[Optional[float], Field(0.0, ge=0.0)]
    dry_bulb_temperature_range_modifier_type: Optional[
        DryBulbTemperatureRangeModifierType
    ] = DryBulbTemperatureRangeModifierType.default_multipliers
    dry_bulb_temperature_range_modifier_day_schedule_name: Optional[str] = None
    humidity_condition_type: Optional[HumidityConditionType] = (
        HumidityConditionType.wet_bulb
    )
    wetbulb_or_dewpoint_at_maximum_dry_bulb: Optional[float] = None
    humidity_condition_day_schedule_name: Optional[str] = None
    humidity_ratio_at_maximum_dry_bulb: Optional[float] = None
    enthalpy_at_maximum_dry_bulb: Optional[float] = None
    daily_wet_bulb_temperature_range: Optional[float] = None
    barometric_pressure: Annotated[
        Optional[float], Field(None, ge=31000.0, le=120000.0)
    ]
    wind_speed: Annotated[float, Field(ge=0.0, le=40.0)]
    wind_direction: Annotated[float, Field(ge=0.0, le=360.0)]
    rain_indicator: Optional[EPBoolean] = EPBoolean.no
    snow_indicator: Optional[EPBoolean] = EPBoolean.no
    daylight_saving_time_indicator: Optional[EPBoolean] = EPBoolean.no
    solar_model_indicator: Optional[SolarModelIndicator] = (
        SolarModelIndicator.ashrae_clear_sky
    )
    beam_solar_day_schedule_name: Optional[str] = None
    diffuse_solar_day_schedule_name: Optional[str] = None
    ashrae_clear_sky_optical_depth_for_beam_irradiance_taub_: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.2)
    ]
    ashrae_clear_sky_optical_depth_for_diffuse_irradiance_taud_: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3.0)
    ]
    sky_clearness: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.2)]
    maximum_number_warmup_days: Optional[int] = None
    begin_environment_reset_mode: Optional[BeginEnvironmentResetMode] = (
        BeginEnvironmentResetMode.full_reset_at_begin_environment
    )


class RunPeriod(BaseModel):
    begin_month: Annotated[int, Field(ge=1, le=12)]
    begin_day_of_month: Annotated[int, Field(ge=1, le=31)]
    begin_year: Optional[float] = None
    end_month: Annotated[int, Field(ge=1, le=12)]
    end_day_of_month: Annotated[int, Field(ge=1, le=31)]
    end_year: Optional[float] = None
    day_of_week_for_start_day: Optional[DayOfWeekForStartDay] = None
    use_weather_file_holidays_and_special_days: Optional[EPBoolean] = EPBoolean.no
    use_weather_file_daylight_saving_period: Optional[EPBoolean] = EPBoolean.no
    apply_weekend_holiday_rule: Optional[EPBoolean] = EPBoolean.no
    use_weather_file_rain_indicators: Optional[EPBoolean] = EPBoolean.no
    use_weather_file_snow_indicators: Optional[EPBoolean] = EPBoolean.no
    treat_weather_as_actual: Optional[EPBoolean] = EPBoolean.no
    first_hour_interpolation_starting_values: Optional[
        FirstHourInterpolationStartingValues
    ] = FirstHourInterpolationStartingValues.hour24


class WindowMaterialGlazing(BaseModel):
    optical_data_type: OpticalDataType
    window_glass_spectral_data_set_name: Optional[str] = None
    thickness: Annotated[float, Field(gt=0.0)]
    solar_transmittance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    front_side_solar_reflectance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    back_side_solar_reflectance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    visible_transmittance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    front_side_visible_reflectance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    back_side_visible_reflectance_at_normal_incidence: Annotated[
        Optional[float], Field(None, ge=0.0, le=1.0)
    ]
    infrared_transmittance_at_normal_incidence: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    front_side_infrared_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.84, gt=0.0, lt=1.0)
    ]
    back_side_infrared_hemispherical_emissivity: Annotated[
        Optional[float], Field(0.84, gt=0.0, lt=1.0)
    ]
    conductivity: Annotated[Optional[float], Field(0.9, gt=0.0)]
    dirt_correction_factor_for_solar_and_visible_transmittance: Annotated[
        Optional[float], Field(1.0, gt=0.0, le=1.0)
    ]
    solar_diffusing: Optional[EPBoolean] = EPBoolean.no
    young_s_modulus: Annotated[Optional[float], Field(72000000000.0, gt=0.0)]
    poisson_s_ratio: Annotated[Optional[float], Field(0.22, gt=0.0, lt=1.0)]
    window_glass_spectral_and_incident_angle_transmittance_data_set_table_name: (
        Optional[str]
    ) = (None)
    window_glass_spectral_and_incident_angle_front_reflectance_data_set_table_name: (
        Optional[str]
    ) = (None)
    window_glass_spectral_and_incident_angle_back_reflectance_data_set_table_name: (
        Optional[str]
    ) = (None)


class Zone(BaseModel):
    direction_of_relative_north: Optional[float] = 0.0
    x_origin: Optional[float] = 0.0
    y_origin: Optional[float] = 0.0
    z_origin: Optional[float] = 0.0
    type: Annotated[Optional[int], Field(1, ge=1, le=1)]
    multiplier: Annotated[Optional[int], Field(1, ge=1)]
    ceiling_height: Optional[Union[float, Literal["Autocalculate"]]] = "Autocalculate"
    volume: Optional[Union[float, Literal["Autocalculate"]]] = "Autocalculate"
    floor_area: Optional[Union[float, Literal["Autocalculate"]]] = "Autocalculate"
    zone_inside_convection_algorithm: Optional[ZoneInsideConvectionAlgorithm] = None
    zone_outside_convection_algorithm: Optional[Algorithm1] = None
    part_of_total_floor_area: Optional[EPBoolean] = EPBoolean.no


class WindowShadingControl(BaseModel):
    zone_name: str
    shading_control_sequence_number: Annotated[Optional[int], Field(1, ge=1)]
    shading_type: ShadingType
    construction_with_shading_name: Optional[str] = None
    shading_control_type: ShadingControlType
    schedule_name: Optional[str] = None
    setpoint: Optional[float] = None
    shading_control_is_scheduled: Optional[EPBoolean] = EPBoolean.no
    glare_control_is_active: Optional[EPBoolean] = EPBoolean.no
    shading_device_material_name: Optional[str] = None
    type_of_slat_angle_control_for_blinds: Optional[TypeOfSlatAngleControlForBlinds] = (
        TypeOfSlatAngleControlForBlinds.fixed_slat_angle
    )
    slat_angle_schedule_name: Optional[str] = None
    setpoint_2: Optional[float] = None
    daylighting_control_object_name: Optional[str] = None
    multiple_surface_control_type: Optional[MultipleSurfaceControlType] = (
        MultipleSurfaceControlType.sequential
    )
    fenestration_surfaces: Optional[List[FenestrationSurface]] = None


class People(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    number_of_people_schedule_name: str
    number_of_people_calculation_method: Optional[NumberOfPeopleCalculationMethod] = (
        NumberOfPeopleCalculationMethod.people
    )
    number_of_people: Annotated[Optional[float], Field(None, ge=0.0)]
    people_per_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    floor_area_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    fraction_radiant: Annotated[Optional[float], Field(0.3, ge=0.0, le=1.0)]
    sensible_heat_fraction: Optional[
        Union[SensibleHeatFraction, Literal["Autocalculate"]]
    ] = "Autocalculate"
    activity_level_schedule_name: str
    carbon_dioxide_generation_rate: Annotated[
        Optional[float], Field(3.82e-08, ge=0.0, le=3.82e-07)
    ]
    enable_ashrae_55_comfort_warnings: Optional[EPBoolean] = EPBoolean.no
    mean_radiant_temperature_calculation_type: Optional[
        MeanRadiantTemperatureCalculationType
    ] = MeanRadiantTemperatureCalculationType.zone_averaged
    surface_name_angle_factor_list_name: Optional[str] = None
    work_efficiency_schedule_name: Optional[str] = None
    clothing_insulation_calculation_method: Optional[
        ClothingInsulationCalculationMethod
    ] = ClothingInsulationCalculationMethod.clothing_insulation_schedule
    clothing_insulation_calculation_method_schedule_name: Optional[str] = None
    clothing_insulation_schedule_name: Optional[str] = None
    air_velocity_schedule_name: Optional[str] = None
    thermal_comfort_model_1_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_2_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_3_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_4_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_5_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_6_type: Optional[ThermalComfortModel1Type] = None
    thermal_comfort_model_7_type: Optional[ThermalComfortModel1Type] = None
    ankle_level_air_velocity_schedule_name: Optional[str] = None
    cold_stress_temperature_threshold: Optional[float] = 15.56
    heat_stress_temperature_threshold: Optional[float] = 30.0


class Lights(BaseModel):
    zone_or_zonelist_or_space_or_spacelist_name: str
    schedule_name: str
    design_level_calculation_method: Optional[DesignLevelCalculationMethod] = (
        DesignLevelCalculationMethod.lighting_level
    )
    lighting_level: Annotated[Optional[float], Field(None, ge=0.0)]
    watts_per_zone_floor_area: Annotated[Optional[float], Field(None, ge=0.0)]
    watts_per_person: Annotated[Optional[float], Field(None, ge=0.0)]
    return_air_fraction: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_radiant: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_visible: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    fraction_replaceable: Annotated[Optional[float], Field(1.0, ge=0.0, le=1.0)]
    end_use_subcategory: Optional[str] = "General"
    return_air_fraction_calculated_from_plenum_temperature: Optional[EPBoolean] = (
        EPBoolean.no
    )
    return_air_fraction_function_of_plenum_temperature_coefficient_1: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    return_air_fraction_function_of_plenum_temperature_coefficient_2: Annotated[
        Optional[float], Field(0.0, ge=0.0)
    ]
    return_air_heat_gain_node_name: Optional[str] = None
    exhaust_air_heat_gain_node_name: Optional[str] = None


class SizingZone(BaseModel):
    zone_or_zonelist_name: str
    zone_cooling_design_supply_air_temperature_input_method: Optional[
        ZoneCoolingDesignSupplyAirTemperatureInputMethod
    ] = ZoneCoolingDesignSupplyAirTemperatureInputMethod.supply_air_temperature
    zone_cooling_design_supply_air_temperature: Optional[float] = None
    zone_cooling_design_supply_air_temperature_difference: Optional[float] = None
    zone_heating_design_supply_air_temperature_input_method: Optional[
        ZoneCoolingDesignSupplyAirTemperatureInputMethod
    ] = ZoneCoolingDesignSupplyAirTemperatureInputMethod.supply_air_temperature
    zone_heating_design_supply_air_temperature: Optional[float] = None
    zone_heating_design_supply_air_temperature_difference: Optional[float] = None
    zone_cooling_design_supply_air_humidity_ratio: Annotated[float, Field(ge=0.0)]
    zone_heating_design_supply_air_humidity_ratio: Annotated[float, Field(ge=0.0)]
    design_specification_outdoor_air_object_name: Optional[str] = None
    zone_heating_sizing_factor: Annotated[Optional[float], Field(None, ge=0.0)]
    zone_cooling_sizing_factor: Annotated[Optional[float], Field(None, ge=0.0)]
    cooling_design_air_flow_method: Optional[CoolingDesignAirFlowMethod] = (
        CoolingDesignAirFlowMethod.design_day
    )
    cooling_design_air_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    cooling_minimum_air_flow_per_zone_floor_area: Annotated[
        Optional[float], Field(0.000762, ge=0.0)
    ]
    cooling_minimum_air_flow: Annotated[Optional[float], Field(0.0, ge=0.0)]
    cooling_minimum_air_flow_fraction: Annotated[Optional[float], Field(0.2, ge=0.0)]
    heating_design_air_flow_method: Optional[CoolingDesignAirFlowMethod] = (
        CoolingDesignAirFlowMethod.design_day
    )
    heating_design_air_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    heating_maximum_air_flow_per_zone_floor_area: Annotated[
        Optional[float], Field(0.002032, ge=0.0)
    ]
    heating_maximum_air_flow: Annotated[Optional[float], Field(0.1415762, ge=0.0)]
    heating_maximum_air_flow_fraction: Annotated[Optional[float], Field(0.3, ge=0.0)]
    design_specification_zone_air_distribution_object_name: Optional[str] = None
    account_for_dedicated_outdoor_air_system: Optional[EPBoolean] = EPBoolean.no
    dedicated_outdoor_air_system_control_strategy: Optional[
        DedicatedOutdoorAirSystemControlStrategy
    ] = DedicatedOutdoorAirSystemControlStrategy.neutral_supply_air
    dedicated_outdoor_air_low_setpoint_temperature_for_design: Optional[
        Union[float, Literal["Autosize"]]
    ] = "Autosize"
    dedicated_outdoor_air_high_setpoint_temperature_for_design: Optional[
        Union[float, Literal["Autosize"]]
    ] = "Autosize"
    zone_load_sizing_method: Optional[ZoneLoadSizingMethod] = (
        ZoneLoadSizingMethod.sensible_load_only_no_latent_load
    )
    zone_latent_cooling_design_supply_air_humidity_ratio_input_method: Optional[
        ZoneLatentCoolingDesignSupplyAirHumidityRatioInputMethod
    ] = (
        ZoneLatentCoolingDesignSupplyAirHumidityRatioInputMethod.humidity_ratio_difference
    )
    zone_dehumidification_design_supply_air_humidity_ratio: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    zone_cooling_design_supply_air_humidity_ratio_difference: Annotated[
        Optional[float], Field(0.005, gt=0.0)
    ]
    zone_latent_heating_design_supply_air_humidity_ratio_input_method: Optional[
        ZoneLatentCoolingDesignSupplyAirHumidityRatioInputMethod
    ] = (
        ZoneLatentCoolingDesignSupplyAirHumidityRatioInputMethod.humidity_ratio_difference
    )
    zone_humidification_design_supply_air_humidity_ratio: Annotated[
        Optional[float], Field(None, gt=0.0)
    ]
    zone_humidification_design_supply_air_humidity_ratio_difference: Annotated[
        Optional[float], Field(0.005, ge=0.0)
    ]
    zone_humidistat_dehumidification_set_point_schedule_name: Optional[str] = None
    zone_humidistat_humidification_set_point_schedule_name: Optional[str] = None


class SizingSystem(BaseModel):
    airloop_name: str
    type_of_load_to_size_on: Optional[TypeOfLoadToSizeOn] = TypeOfLoadToSizeOn.sensible
    design_outdoor_air_flow_rate: Optional[
        Union[DesignOutdoorAirFlowRate, Literal["Autosize"]]
    ] = "Autosize"
    central_heating_maximum_system_air_flow_ratio: Optional[
        Union[CentralHeatingMaximumSystemAirFlowRatio, Literal["Autosize"]]
    ] = "Autosize"
    preheat_design_temperature: float
    preheat_design_humidity_ratio: float
    precool_design_temperature: float
    precool_design_humidity_ratio: float
    central_cooling_design_supply_air_temperature: float
    central_heating_design_supply_air_temperature: float
    type_of_zone_sum_to_use: Optional[TypeOfZoneSumToUse] = (
        TypeOfZoneSumToUse.non_coincident
    )
    field_100_outdoor_air_in_cooling: Annotated[
        Optional[EPBoolean], Field(EPBoolean.no, alias="100_outdoor_air_in_cooling")
    ]
    field_100_outdoor_air_in_heating: Annotated[
        Optional[EPBoolean], Field(EPBoolean.no, alias="100_outdoor_air_in_heating")
    ]
    central_cooling_design_supply_air_humidity_ratio: Optional[float] = 0.008
    central_heating_design_supply_air_humidity_ratio: Optional[float] = 0.008
    cooling_supply_air_flow_rate_method: Optional[CoolingSupplyAirFlowRateMethod] = (
        CoolingSupplyAirFlowRateMethod.design_day
    )
    cooling_supply_air_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    cooling_supply_air_flow_rate_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    cooling_fraction_of_autosized_cooling_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    cooling_supply_air_flow_rate_per_unit_cooling_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_supply_air_flow_rate_method: Optional[HeatingSupplyAirFlowRateMethod] = (
        HeatingSupplyAirFlowRateMethod.design_day
    )
    heating_supply_air_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    heating_supply_air_flow_rate_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_fraction_of_autosized_heating_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_fraction_of_autosized_cooling_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_supply_air_flow_rate_per_unit_heating_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    system_outdoor_air_method: Optional[SystemOutdoorAirMethod] = (
        SystemOutdoorAirMethod.zone_sum
    )
    zone_maximum_outdoor_air_fraction: Annotated[Optional[float], Field(1.0, gt=0.0)]
    cooling_design_capacity_method: Optional[CoolingDesignCapacityMethod] = (
        CoolingDesignCapacityMethod.cooling_design_capacity
    )
    cooling_design_capacity: Optional[
        Union[CoolingDesignCapacity, Literal["Autosize"]]
    ] = "Autosize"
    cooling_design_capacity_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    fraction_of_autosized_cooling_design_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_design_capacity_method: Optional[HeatingDesignCapacityMethod] = (
        HeatingDesignCapacityMethod.heating_design_capacity
    )
    heating_design_capacity: Optional[
        Union[HeatingDesignCapacity, Literal["Autosize"]]
    ] = "Autosize"
    heating_design_capacity_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    fraction_of_autosized_heating_design_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    central_cooling_capacity_control_method: Optional[
        CentralCoolingCapacityControlMethod
    ] = CentralCoolingCapacityControlMethod.on_off
    occupant_diversity: Optional[Union[OccupantDiversity, Literal["Autosize"]]] = (
        "Autosize"
    )


class ZoneHvacEnergyRecoveryVentilatorController(BaseModel):
    temperature_high_limit: Optional[float] = None
    temperature_low_limit: Optional[float] = None
    enthalpy_high_limit: Optional[float] = None
    dewpoint_temperature_limit: Optional[float] = None
    electronic_enthalpy_limit_curve_name: Optional[str] = None
    exhaust_air_temperature_limit: Optional[ExhaustAirTemperatureLimit] = (
        ExhaustAirTemperatureLimit.no_exhaust_air_temperature_limit
    )
    exhaust_air_enthalpy_limit: Optional[ExhaustAirEnthalpyLimit] = (
        ExhaustAirEnthalpyLimit.no_exhaust_air_enthalpy_limit
    )
    time_of_day_economizer_flow_control_schedule_name: Optional[str] = None
    high_humidity_control_flag: Optional[EPBoolean] = EPBoolean.no
    humidistat_control_zone_name: Optional[str] = None
    high_humidity_outdoor_air_flow_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    control_high_indoor_humidity_based_on_outdoor_humidity_ratio: Optional[
        EPBoolean
    ] = EPBoolean.no


class ZoneHvacUnitHeater(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: Optional[str] = None
    air_outlet_node_name: Optional[str] = None
    supply_air_fan_object_type: SupplyAirFanObjectType
    supply_air_fan_name: str
    maximum_supply_air_flow_rate: Union[MaximumSupplyAirFlowRate, Literal["Autosize"]]
    heating_coil_object_type: HeatingCoilObjectType1
    heating_coil_name: str
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    supply_air_fan_operation_during_no_heating: EPBoolean
    maximum_hot_water_or_steam_flow_rate: Optional[
        Union[MaximumHotWaterOrSteamFlowRate, Literal["Autosize"]]
    ] = None
    minimum_hot_water_or_steam_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    heating_convergence_tolerance: Annotated[Optional[float], Field(0.001, gt=0.0)]
    availability_manager_list_name: Optional[str] = None
    design_specification_zonehvac_sizing_object_name: Optional[str] = None


class CoilCoolingDxSingleSpeed(BaseModel):
    availability_schedule_name: Optional[str] = None
    gross_rated_total_cooling_capacity: Union[
        GrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    gross_rated_sensible_heat_ratio: Union[
        GrossRatedSensibleHeatRatio, Literal["Autosize"]
    ]
    gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    rated_air_flow_rate: Union[RatedAirFlowRate, Literal["Autosize"]]
    field_2017_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    air_inlet_node_name: str
    air_outlet_node_name: str
    total_cooling_capacity_function_of_temperature_curve_name: str
    total_cooling_capacity_function_of_flow_fraction_curve_name: str
    energy_input_ratio_function_of_temperature_curve_name: str
    energy_input_ratio_function_of_flow_fraction_curve_name: str
    part_load_fraction_correlation_curve_name: str
    minimum_outdoor_dry_bulb_temperature_for_compressor_operation: Optional[float] = (
        -25.0
    )
    nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: (
        Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    )
    maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    condenser_air_inlet_node_name: Optional[str] = None
    condenser_type: Optional[CondenserType] = CondenserType.air_cooled
    evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    evaporative_condenser_air_flow_rate: Optional[
        Union[EvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    evaporative_condenser_pump_rated_power_consumption: Optional[
        Union[EvaporativeCondenserPumpRatedPowerConsumption, Literal["Autosize"]]
    ] = 0.0
    crankcase_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    crankcase_heater_capacity_function_of_temperature_curve_name: Optional[str] = None
    maximum_outdoor_dry_bulb_temperature_for_crankcase_heater_operation: Annotated[
        Optional[float], Field(10.0, ge=0.0)
    ]
    supply_water_storage_tank_name: Optional[str] = None
    condensate_collection_water_storage_tank_name: Optional[str] = None
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    sensible_heat_ratio_function_of_temperature_curve_name: Optional[str] = None
    sensible_heat_ratio_function_of_flow_fraction_curve_name: Optional[str] = None
    report_ashrae_standard_127_performance_ratings: Optional[EPBoolean] = EPBoolean.no
    zone_name_for_condenser_placement: Optional[str] = None


class CoilCoolingDxMultiSpeed(BaseModel):
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    condenser_air_inlet_node_name: Optional[str] = None
    condenser_type: Optional[CondenserType] = CondenserType.air_cooled
    minimum_outdoor_dry_bulb_temperature_for_compressor_operation: Optional[float] = (
        -25.0
    )
    supply_water_storage_tank_name: Optional[str] = None
    condensate_collection_water_storage_tank_name: Optional[str] = None
    apply_part_load_fraction_to_speeds_greater_than_1: Optional[EPBoolean] = (
        EPBoolean.no
    )
    apply_latent_degradation_to_speeds_greater_than_1: Optional[EPBoolean] = (
        EPBoolean.no
    )
    crankcase_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    crankcase_heater_capacity_function_of_temperature_curve_name: Optional[str] = None
    maximum_outdoor_dry_bulb_temperature_for_crankcase_heater_operation: Annotated[
        Optional[float], Field(10.0, ge=0.0)
    ]
    basin_heater_capacity: Annotated[Optional[float], Field(0.0, ge=0.0)]
    basin_heater_setpoint_temperature: Annotated[Optional[float], Field(2.0, ge=2.0)]
    basin_heater_operating_schedule_name: Optional[str] = None
    fuel_type: FuelType2
    number_of_speeds: Annotated[int, Field(ge=2, le=4)]
    speed_1_gross_rated_total_cooling_capacity: Union[
        Speed1GrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    speed_1_gross_rated_sensible_heat_ratio: Union[
        Speed1GrossRatedSensibleHeatRatio, Literal["Autosize"]
    ]
    speed_1_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    speed_1_rated_air_flow_rate: Union[Speed1RatedAirFlowRate, Literal["Autosize"]]
    field_2017_speed_1_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_speed_1_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_speed_1_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_speed_1_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    speed_1_total_cooling_capacity_function_of_temperature_curve_name: str
    speed_1_total_cooling_capacity_function_of_flow_fraction_curve_name: str
    speed_1_energy_input_ratio_function_of_temperature_curve_name: str
    speed_1_energy_input_ratio_function_of_flow_fraction_curve_name: str
    speed_1_part_load_fraction_correlation_curve_name: str
    speed_1_nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    speed_1_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=5.0)
    ]
    speed_1_maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    speed_1_latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    speed_1_rated_waste_heat_fraction_of_power_input: Annotated[
        Optional[float], Field(0.2, gt=0.0, le=1.0)
    ]
    speed_1_waste_heat_function_of_temperature_curve_name: Optional[str] = None
    speed_1_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    speed_1_evaporative_condenser_air_flow_rate: Optional[
        Union[Speed1EvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    speed_1_rated_evaporative_condenser_pump_power_consumption: Optional[
        Union[Speed1RatedEvaporativeCondenserPumpPowerConsumption, Literal["Autosize"]]
    ] = None
    speed_2_gross_rated_total_cooling_capacity: Union[
        Speed2GrossRatedTotalCoolingCapacity, Literal["Autosize"]
    ]
    speed_2_gross_rated_sensible_heat_ratio: Union[
        Speed2GrossRatedSensibleHeatRatio, Literal["Autosize"]
    ]
    speed_2_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    speed_2_rated_air_flow_rate: Union[Speed2RatedAirFlowRate, Literal["Autosize"]]
    field_2017_speed_2_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_speed_2_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_speed_2_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_speed_2_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    speed_2_total_cooling_capacity_function_of_temperature_curve_name: str
    speed_2_total_cooling_capacity_function_of_flow_fraction_curve_name: str
    speed_2_energy_input_ratio_function_of_temperature_curve_name: str
    speed_2_energy_input_ratio_function_of_flow_fraction_curve_name: str
    speed_2_part_load_fraction_correlation_curve_name: str
    speed_2_nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    speed_2_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=5.0)
    ]
    speed_2_maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    speed_2_latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    speed_2_rated_waste_heat_fraction_of_power_input: Annotated[
        Optional[float], Field(0.2, gt=0.0, le=1.0)
    ]
    speed_2_waste_heat_function_of_temperature_curve_name: Optional[str] = None
    speed_2_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    speed_2_evaporative_condenser_air_flow_rate: Optional[
        Union[Speed2EvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    speed_2_rated_evaporative_condenser_pump_power_consumption: Optional[
        Union[Speed2RatedEvaporativeCondenserPumpPowerConsumption, Literal["Autosize"]]
    ] = None
    speed_3_gross_rated_total_cooling_capacity: Optional[
        Union[Speed3GrossRatedTotalCoolingCapacity, Literal["Autosize"]]
    ] = None
    speed_3_gross_rated_sensible_heat_ratio: Optional[
        Union[Speed3GrossRatedSensibleHeatRatio, Literal["Autosize"]]
    ] = None
    speed_3_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    speed_3_rated_air_flow_rate: Optional[
        Union[Speed3RatedAirFlowRate, Literal["Autosize"]]
    ] = None
    field_2017_speed_3_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_speed_3_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_speed_3_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_speed_3_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    speed_3_total_cooling_capacity_function_of_temperature_curve_name: Optional[str] = (
        None
    )
    speed_3_total_cooling_capacity_function_of_flow_fraction_curve_name: Optional[
        str
    ] = None
    speed_3_energy_input_ratio_function_of_temperature_curve_name: Optional[str] = None
    speed_3_energy_input_ratio_function_of_flow_fraction_curve_name: Optional[str] = (
        None
    )
    speed_3_part_load_fraction_correlation_curve_name: Optional[str] = None
    speed_3_nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    speed_3_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=5.0)
    ]
    speed_3_maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    speed_3_latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    speed_3_rated_waste_heat_fraction_of_power_input: Annotated[
        Optional[float], Field(0.2, gt=0.0, le=1.0)
    ]
    speed_3_waste_heat_function_of_temperature_curve_name: Optional[str] = None
    speed_3_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    speed_3_evaporative_condenser_air_flow_rate: Optional[
        Union[Speed3EvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    speed_3_rated_evaporative_condenser_pump_power_consumption: Optional[
        Union[Speed3RatedEvaporativeCondenserPumpPowerConsumption, Literal["Autosize"]]
    ] = None
    speed_4_gross_rated_total_cooling_capacity: Optional[
        Union[Speed4GrossRatedTotalCoolingCapacity, Literal["Autosize"]]
    ] = None
    speed_4_gross_rated_sensible_heat_ratio: Optional[
        Union[Speed4GrossRatedSensibleHeatRatio, Literal["Autosize"]]
    ] = None
    speed_4_gross_rated_cooling_cop: Annotated[Optional[float], Field(3.0, gt=0.0)]
    speed_4_rated_air_flow_rate: Optional[
        Union[Speed4RatedAirFlowRate, Literal["Autosize"]]
    ] = None
    field_2017_speed_4_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            773.3,
            alias="2017_speed_4_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1250.0,
        ),
    ]
    field_2023_speed_4_rated_evaporator_fan_power_per_volume_flow_rate: Annotated[
        Optional[float],
        Field(
            934.4,
            alias="2023_speed_4_rated_evaporator_fan_power_per_volume_flow_rate",
            ge=0.0,
            le=1505.0,
        ),
    ]
    speed_4_total_cooling_capacity_function_of_temperature_curve_name: Optional[str] = (
        None
    )
    speed_4_total_cooling_capacity_function_of_flow_fraction_curve_name: Optional[
        str
    ] = None
    speed_4_energy_input_ratio_function_of_temperature_curve_name: Optional[str] = None
    speed_4_energy_input_ratio_function_of_flow_fraction_curve_name: Optional[str] = (
        None
    )
    speed_4_part_load_fraction_correlation_curve_name: Optional[str] = None
    speed_4_nominal_time_for_condensate_removal_to_begin: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=3000.0)
    ]
    speed_4_ratio_of_initial_moisture_evaporation_rate_and_steady_state_latent_capacity: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=5.0)
    ]
    speed_4_maximum_cycling_rate: Annotated[Optional[float], Field(0.0, ge=0.0, le=5.0)]
    speed_4_latent_capacity_time_constant: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=500.0)
    ]
    speed_4_rated_waste_heat_fraction_of_power_input: Annotated[
        Optional[float], Field(0.2, gt=0.0, le=1.0)
    ]
    speed_4_waste_heat_function_of_temperature_curve_name: Optional[str] = None
    speed_4_evaporative_condenser_effectiveness: Annotated[
        Optional[float], Field(0.9, ge=0.0, le=1.0)
    ]
    speed_4_evaporative_condenser_air_flow_rate: Optional[
        Union[Speed4EvaporativeCondenserAirFlowRate, Literal["Autosize"]]
    ] = None
    speed_4_rated_evaporative_condenser_pump_power_consumption: Optional[
        Union[Speed4RatedEvaporativeCondenserPumpPowerConsumption, Literal["Autosize"]]
    ] = None
    zone_name_for_condenser_placement: Optional[str] = None


class CoilSystemCoolingDx(BaseModel):
    availability_schedule_name: Optional[str] = None
    dx_cooling_coil_system_inlet_node_name: str
    dx_cooling_coil_system_outlet_node_name: str
    dx_cooling_coil_system_sensor_node_name: str
    cooling_coil_object_type: CoolingCoilObjectType2
    cooling_coil_name: str
    dehumidification_control_type: Optional[DehumidificationControlType1] = (
        DehumidificationControlType1.none
    )
    run_on_sensible_load: Optional[EPBoolean] = EPBoolean.no
    run_on_latent_load: Optional[EPBoolean] = EPBoolean.no
    use_outdoor_air_dx_cooling_coil: Optional[EPBoolean] = EPBoolean.no
    outdoor_air_dx_cooling_coil_leaving_minimum_air_temperature: Annotated[
        Optional[float], Field(2.0, ge=0.0, le=7.2)
    ]


class HeatExchangerAirToAirSensibleAndLatent(BaseModel):
    availability_schedule_name: Optional[str] = None
    nominal_supply_air_flow_rate: Union[NominalSupplyAirFlowRate, Literal["Autosize"]]
    sensible_effectiveness_at_100_heating_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    latent_effectiveness_at_100_heating_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    sensible_effectiveness_at_75_heating_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    latent_effectiveness_at_75_heating_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    sensible_effectiveness_at_100_cooling_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    latent_effectiveness_at_100_cooling_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    sensible_effectiveness_at_75_cooling_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    latent_effectiveness_at_75_cooling_air_flow: Annotated[
        Optional[float], Field(0.0, ge=0.0, le=1.0)
    ]
    supply_air_inlet_node_name: str
    supply_air_outlet_node_name: str
    exhaust_air_inlet_node_name: str
    exhaust_air_outlet_node_name: str
    nominal_electric_power: Annotated[Optional[float], Field(0.0, ge=0.0)]
    supply_air_outlet_temperature_control: Optional[EPBoolean] = EPBoolean.no
    heat_exchanger_type: Optional[HeatExchangerType] = HeatExchangerType.plate
    frost_control_type: Optional[FrostControlType] = FrostControlType.none
    threshold_temperature: Optional[float] = 1.7
    initial_defrost_time_fraction: Annotated[
        Optional[float], Field(0.083, ge=0.0, le=1.0)
    ]
    rate_of_defrost_time_fraction_increase: Annotated[
        Optional[float], Field(0.012, ge=0.0)
    ]
    economizer_lockout: Optional[EPBoolean] = EPBoolean.no


class AirLoopHvacUnitarySystem(BaseModel):
    control_type: Optional[ControlType] = ControlType.load
    controlling_zone_or_thermostat_location: Optional[str] = None
    dehumidification_control_type: Optional[DehumidificationControlType1] = (
        DehumidificationControlType1.none
    )
    availability_schedule_name: Optional[str] = None
    air_inlet_node_name: str
    air_outlet_node_name: str
    supply_fan_object_type: Optional[SupplyFanObjectType] = None
    supply_fan_name: Optional[str] = None
    fan_placement: Optional[FanPlacement] = FanPlacement.draw_through
    supply_air_fan_operating_mode_schedule_name: Optional[str] = None
    heating_coil_object_type: Optional[HeatingCoilObjectType3] = None
    heating_coil_name: Optional[str] = None
    dx_heating_coil_sizing_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    cooling_coil_object_type: Optional[CoolingCoilObjectType3] = None
    cooling_coil_name: Optional[str] = None
    use_doas_dx_cooling_coil: Optional[EPBoolean] = EPBoolean.no
    minimum_supply_air_temperature: Optional[
        Union[MinimumSupplyAirTemperature, Literal["Autosize"]]
    ] = 2.0
    latent_load_control: Optional[LatentLoadControl] = (
        LatentLoadControl.sensible_only_load_control
    )
    supplemental_heating_coil_object_type: Optional[
        SupplementalHeatingCoilObjectType
    ] = None
    supplemental_heating_coil_name: Optional[str] = None
    cooling_supply_air_flow_rate_method: Optional[CoolingSupplyAirFlowRateMethod1] = (
        None
    )
    cooling_supply_air_flow_rate: Optional[
        Union[CoolingSupplyAirFlowRate1, Literal["Autosize"]]
    ] = None
    cooling_supply_air_flow_rate_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    cooling_fraction_of_autosized_cooling_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    cooling_supply_air_flow_rate_per_unit_of_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_supply_air_flow_rate_method: Optional[HeatingSupplyAirFlowRateMethod1] = (
        None
    )
    heating_supply_air_flow_rate: Optional[
        Union[HeatingSupplyAirFlowRate1, Literal["Autosize"]]
    ] = None
    heating_supply_air_flow_rate_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_fraction_of_autosized_heating_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    heating_supply_air_flow_rate_per_unit_of_capacity: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    no_load_supply_air_flow_rate_method: Optional[NoLoadSupplyAirFlowRateMethod] = None
    no_load_supply_air_flow_rate: Optional[
        Union[NoLoadSupplyAirFlowRate, Literal["Autosize"]]
    ] = None
    no_load_supply_air_flow_rate_per_floor_area: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    no_load_fraction_of_autosized_cooling_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    no_load_fraction_of_autosized_heating_supply_air_flow_rate: Annotated[
        Optional[float], Field(None, ge=0.0)
    ]
    no_load_supply_air_flow_rate_per_unit_of_capacity_during_cooling_operation: (
        Annotated[Optional[float], Field(None, ge=0.0)]
    )
    no_load_supply_air_flow_rate_per_unit_of_capacity_during_heating_operation: (
        Annotated[Optional[float], Field(None, ge=0.0)]
    )
    maximum_supply_air_temperature: Optional[Union[float, Literal["Autosize"]]] = 80.0
    maximum_outdoor_dry_bulb_temperature_for_supplemental_heater_operation: Optional[
        float
    ] = 21.0
    outdoor_dry_bulb_temperature_sensor_node_name: Optional[str] = None
    ancillary_on_cycle_electric_power: Annotated[Optional[float], Field(0.0, ge=0.0)]
    ancillary_off_cycle_electric_power: Annotated[Optional[float], Field(0.0, ge=0.0)]
    design_heat_recovery_water_flow_rate: Annotated[Optional[float], Field(0.0, ge=0.0)]
    maximum_temperature_for_heat_recovery: Annotated[
        Optional[float], Field(80.0, ge=0.0, le=100.0)
    ]
    heat_recovery_water_inlet_node_name: Optional[str] = None
    heat_recovery_water_outlet_node_name: Optional[str] = None
    design_specification_multispeed_object_type: Optional[
        Literal["UnitarySystemPerformance:Multispeed"]
    ] = None
    design_specification_multispeed_object_name: Optional[str] = None


class UnitarySystemPerformanceMultispeed(BaseModel):
    number_of_speeds_for_heating: Annotated[int, Field(ge=0, le=10)]
    number_of_speeds_for_cooling: Annotated[int, Field(ge=0, le=10)]
    single_mode_operation: Optional[EPBoolean] = EPBoolean.no
    no_load_supply_air_flow_rate_ratio: Annotated[
        Optional[float], Field(1.0, ge=0.0, le=1.0)
    ]
    flow_ratios: Optional[List[FlowRatio]] = None


class ControllerOutdoorAir(BaseModel):
    relief_air_outlet_node_name: str
    return_air_node_name: str
    mixed_air_node_name: str
    actuator_node_name: str
    minimum_outdoor_air_flow_rate: Union[float, Literal["Autosize"]]
    maximum_outdoor_air_flow_rate: Union[float, Literal["Autosize"]]
    economizer_control_type: Optional[EconomizerControlType] = (
        EconomizerControlType.no_economizer
    )
    economizer_control_action_type: Optional[EconomizerControlActionType] = (
        EconomizerControlActionType.modulate_flow
    )
    economizer_maximum_limit_dry_bulb_temperature: Optional[float] = None
    economizer_maximum_limit_enthalpy: Optional[float] = None
    economizer_maximum_limit_dewpoint_temperature: Optional[float] = None
    electronic_enthalpy_limit_curve_name: Optional[str] = None
    economizer_minimum_limit_dry_bulb_temperature: Optional[float] = None
    lockout_type: Optional[LockoutType] = LockoutType.no_lockout
    minimum_limit_type: Optional[MinimumLimitType] = (
        MinimumLimitType.proportional_minimum
    )
    minimum_outdoor_air_schedule_name: Optional[str] = None
    minimum_fraction_of_outdoor_air_schedule_name: Optional[str] = None
    maximum_fraction_of_outdoor_air_schedule_name: Optional[str] = None
    mechanical_ventilation_controller_name: Optional[str] = None
    time_of_day_economizer_control_schedule_name: Optional[str] = None
    high_humidity_control: Optional[EPBoolean] = EPBoolean.no
    humidistat_control_zone_name: Optional[str] = None
    high_humidity_outdoor_air_flow_ratio: Annotated[Optional[float], Field(1.0, gt=0.0)]
    control_high_indoor_humidity_based_on_outdoor_humidity_ratio: Optional[
        EPBoolean
    ] = EPBoolean.no
    heat_recovery_bypass_control_type: Optional[HeatRecoveryBypassControlType] = (
        HeatRecoveryBypassControlType.bypass_when_within_economizer_limits
    )
    economizer_operation_staging: Optional[EconomizerOperationStaging] = (
        EconomizerOperationStaging.interlocked_with_mechanical_cooling
    )


class ControllerMechanicalVentilation(BaseModel):
    availability_schedule_name: Optional[str] = None
    demand_controlled_ventilation: Optional[EPBoolean] = EPBoolean.no
    system_outdoor_air_method: Optional[SystemOutdoorAirMethod1] = (
        SystemOutdoorAirMethod1.standard62_1_ventilation_rate_procedure
    )
    zone_maximum_outdoor_air_fraction: Annotated[Optional[float], Field(1.0, gt=0.0)]
    zone_specifications: Optional[List[ZoneSpecification]] = None


class OutdoorAirNode(BaseModel):
    height_above_ground: Optional[float] = -1.0
    drybulb_temperature_schedule_name: Optional[str] = None
    wetbulb_temperature_schedule_name: Optional[str] = None
    wind_speed_schedule_name: Optional[str] = None
    wind_direction_schedule_name: Optional[str] = None
    wind_pressure_coefficient_curve_name: Optional[str] = None
    symmetric_wind_pressure_coefficient_curve: Optional[EPBoolean] = EPBoolean.no
    wind_angle_type: Optional[WindAngleType] = WindAngleType.absolute


class ElectricLoadCenterTransformer(BaseModel):
    availability_schedule_name: Optional[str] = None
    transformer_usage: Optional[TransformerUsage] = TransformerUsage.power_in_from_grid
    zone_name: Optional[str] = None
    radiative_fraction: Annotated[Optional[float], Field(0.0, ge=0.0, le=1.0)]
    rated_capacity: Annotated[Optional[float], Field(None, ge=0.0)]
    phase: Optional[Union[Phase, str]] = 3.0
    conductor_material: Optional[ConductorMaterial] = ConductorMaterial.aluminum
    full_load_temperature_rise: Annotated[
        Optional[float], Field(150.0, ge=50.0, le=180.0)
    ]
    fraction_of_eddy_current_losses: Annotated[
        Optional[float], Field(0.1, ge=0.0, le=1.0)
    ]
    performance_input_method: Optional[PerformanceInputMethod4] = (
        PerformanceInputMethod4.rated_losses
    )
    rated_no_load_loss: Annotated[Optional[float], Field(None, gt=0.0)]
    rated_load_loss: Annotated[Optional[float], Field(None, ge=0.0)]
    nameplate_efficiency: Annotated[Optional[float], Field(0.98, gt=0.0, le=1.0)]
    per_unit_load_for_nameplate_efficiency: Annotated[
        Optional[float], Field(0.35, gt=0.0, le=1.0)
    ]
    reference_temperature_for_nameplate_efficiency: Annotated[
        Optional[float], Field(75.0, ge=20.0, le=150.0)
    ]
    per_unit_load_for_maximum_efficiency: Annotated[
        Optional[float], Field(None, gt=0.0, le=1.0)
    ]
    consider_transformer_loss_for_utility_cost: Optional[EPBoolean] = EPBoolean.no
    meters: Optional[List[Meter]] = None


class OutputControlFiles(BaseModel):
    output_csv: Optional[EPBoolean] = EPBoolean.no
    output_mtr: Optional[EPBoolean] = EPBoolean.no
    output_eso: Optional[EPBoolean] = EPBoolean.no
    output_eio: Optional[EPBoolean] = EPBoolean.no
    output_tabular: Optional[EPBoolean] = EPBoolean.no
    output_sqlite: Optional[EPBoolean] = EPBoolean.no
    output_json: Optional[EPBoolean] = EPBoolean.no
    output_audit: Optional[EPBoolean] = EPBoolean.no
    output_zone_sizing: Optional[EPBoolean] = EPBoolean.no
    output_system_sizing: Optional[EPBoolean] = EPBoolean.no
    output_dxf: Optional[EPBoolean] = EPBoolean.no
    output_bnd: Optional[EPBoolean] = EPBoolean.no
    output_rdd: Optional[EPBoolean] = EPBoolean.no
    output_mdd: Optional[EPBoolean] = EPBoolean.no
    output_mtd: Optional[EPBoolean] = EPBoolean.no
    output_end: Optional[EPBoolean] = EPBoolean.no
    output_shd: Optional[EPBoolean] = EPBoolean.no
    output_dfs: Optional[EPBoolean] = EPBoolean.no
    output_glhe: Optional[EPBoolean] = EPBoolean.no
    output_delightin: Optional[EPBoolean] = EPBoolean.no
    output_delighteldmp: Optional[EPBoolean] = EPBoolean.no
    output_delightdfdmp: Optional[EPBoolean] = EPBoolean.no
    output_edd: Optional[EPBoolean] = EPBoolean.no
    output_dbg: Optional[EPBoolean] = EPBoolean.no
    output_perflog: Optional[EPBoolean] = EPBoolean.no
    output_sln: Optional[EPBoolean] = EPBoolean.no
    output_sci: Optional[EPBoolean] = EPBoolean.no
    output_wrl: Optional[EPBoolean] = EPBoolean.no
    output_screen: Optional[EPBoolean] = EPBoolean.no
    output_extshd: Optional[EPBoolean] = EPBoolean.no
    output_tarcog: Optional[EPBoolean] = EPBoolean.no


class OutputControlTimestamp(BaseModel):
    iso_8601_format: Optional[EPBoolean] = EPBoolean.no
    timestamp_at_beginning_of_interval: Optional[EPBoolean] = EPBoolean.no


class OutputJson(BaseModel):
    option_type: OptionType
    output_json: Optional[EPBoolean] = EPBoolean.no
    output_cbor: Optional[EPBoolean] = EPBoolean.no
    output_messagepack: Optional[EPBoolean] = EPBoolean.no


class EnergyPlusModel(BaseModel):
    version: Annotated[Optional[Dict[str, Version]], Field(None, alias="Version")]
    simulation_control: Annotated[
        Optional[Dict[str, SimulationControl]], Field(None, alias="SimulationControl")
    ]
    building: Annotated[Dict[str, Building], Field(alias="Building")]
    shadow_calculation: Annotated[
        Optional[Dict[str, ShadowCalculation]], Field(None, alias="ShadowCalculation")
    ]
    surface_convection_algorithm_inside: Annotated[
        Optional[Dict[str, SurfaceConvectionAlgorithmInside]],
        Field(None, alias="SurfaceConvectionAlgorithm:Inside"),
    ]
    surface_convection_algorithm_outside: Annotated[
        Optional[Dict[str, SurfaceConvectionAlgorithmOutside]],
        Field(None, alias="SurfaceConvectionAlgorithm:Outside"),
    ]
    heat_balance_algorithm: Annotated[
        Optional[Dict[str, HeatBalanceAlgorithm]],
        Field(None, alias="HeatBalanceAlgorithm"),
    ]
    zone_air_heat_balance_algorithm: Annotated[
        Optional[Dict[str, ZoneAirHeatBalanceAlgorithm]],
        Field(None, alias="ZoneAirHeatBalanceAlgorithm"),
    ]
    zone_air_contaminant_balance: Annotated[
        Optional[Dict[str, ZoneAirContaminantBalance]],
        Field(None, alias="ZoneAirContaminantBalance"),
    ]
    zone_capacitance_multiplier_research_special: Annotated[
        Optional[Dict[str, ZoneCapacitanceMultiplierResearchSpecial]],
        Field(None, alias="ZoneCapacitanceMultiplier:ResearchSpecial"),
    ]
    timestep: Annotated[Optional[Dict[str, Timestep]], Field(None, alias="Timestep")]
    convergence_limits: Annotated[
        Optional[Dict[str, ConvergenceLimits]], Field(None, alias="ConvergenceLimits")
    ]
    site_location: Annotated[
        Optional[Dict[str, SiteLocation]], Field(None, alias="Site:Location")
    ]
    sizing_period_design_day: Annotated[
        Optional[Dict[str, SizingPeriodDesignDay]],
        Field(None, alias="SizingPeriod:DesignDay"),
    ]
    run_period: Annotated[
        Optional[Dict[str, RunPeriod]], Field(None, alias="RunPeriod")
    ]
    run_period_control_special_days: Annotated[
        Optional[Dict[str, RunPeriodControlSpecialDays]],
        Field(None, alias="RunPeriodControl:SpecialDays"),
    ]
    run_period_control_daylight_saving_time: Annotated[
        Optional[Dict[str, RunPeriodControlDaylightSavingTime]],
        Field(None, alias="RunPeriodControl:DaylightSavingTime"),
    ]
    site_ground_temperature_building_surface: Annotated[
        Optional[Dict[str, SiteGroundTemperatureBuildingSurface]],
        Field(None, alias="Site:GroundTemperature:BuildingSurface"),
    ]
    site_ground_temperature_f_cfactor_method: Annotated[
        Optional[Dict[str, SiteGroundTemperatureFCfactorMethod]],
        Field(None, alias="Site:GroundTemperature:FCfactorMethod"),
    ]
    site_water_mains_temperature: Annotated[
        Optional[Dict[str, SiteWaterMainsTemperature]],
        Field(None, alias="Site:WaterMainsTemperature"),
    ]
    schedule_type_limits: Annotated[
        Optional[Dict[str, ScheduleTypeLimits]], Field(None, alias="ScheduleTypeLimits")
    ]
    schedule_day_hourly: Annotated[
        Optional[Dict[str, ScheduleDayHourly]], Field(None, alias="Schedule:Day:Hourly")
    ]
    schedule_day_interval: Annotated[
        Optional[Dict[str, ScheduleDayInterval]],
        Field(None, alias="Schedule:Day:Interval"),
    ]
    schedule_week_daily: Annotated[
        Optional[Dict[str, ScheduleWeekDaily]], Field(None, alias="Schedule:Week:Daily")
    ]
    schedule_year: Annotated[
        Optional[Dict[str, ScheduleYear]], Field(None, alias="Schedule:Year")
    ]
    schedule_compact: Annotated[
        Optional[Dict[str, ScheduleCompact]], Field(None, alias="Schedule:Compact")
    ]
    schedule_constant: Annotated[
        Optional[Dict[str, ScheduleConstant]], Field(None, alias="Schedule:Constant")
    ]
    material: Annotated[Optional[Dict[str, Material]], Field(None, alias="Material")]
    material_no_mass: Annotated[
        Optional[Dict[str, MaterialNoMass]], Field(None, alias="Material:NoMass")
    ]
    material_air_gap: Annotated[
        Optional[Dict[str, MaterialAirGap]], Field(None, alias="Material:AirGap")
    ]
    window_material_simple_glazing_system: Annotated[
        Optional[Dict[str, WindowMaterialSimpleGlazingSystem]],
        Field(None, alias="WindowMaterial:SimpleGlazingSystem"),
    ]
    window_material_glazing: Annotated[
        Optional[Dict[str, WindowMaterialGlazing]],
        Field(None, alias="WindowMaterial:Glazing"),
    ]
    window_material_gas: Annotated[
        Optional[Dict[str, WindowMaterialGas]], Field(None, alias="WindowMaterial:Gas")
    ]
    window_gap_support_pillar: Annotated[
        Optional[Dict[str, WindowGapSupportPillar]],
        Field(None, alias="WindowGap:SupportPillar"),
    ]
    window_gap_deflection_state: Annotated[
        Optional[Dict[str, WindowGapDeflectionState]],
        Field(None, alias="WindowGap:DeflectionState"),
    ]
    window_material_gas_mixture: Annotated[
        Optional[Dict[str, WindowMaterialGasMixture]],
        Field(None, alias="WindowMaterial:GasMixture"),
    ]
    window_material_gap: Annotated[
        Optional[Dict[str, WindowMaterialGap]], Field(None, alias="WindowMaterial:Gap")
    ]
    window_material_complex_shade: Annotated[
        Optional[Dict[str, WindowMaterialComplexShade]],
        Field(None, alias="WindowMaterial:ComplexShade"),
    ]
    window_material_blind: Annotated[
        Optional[Dict[str, WindowMaterialBlind]],
        Field(None, alias="WindowMaterial:Blind"),
    ]
    construction: Annotated[
        Optional[Dict[str, Construction]], Field(None, alias="Construction")
    ]
    construction_cfactor_underground_wall: Annotated[
        Optional[Dict[str, ConstructionCfactorUndergroundWall]],
        Field(None, alias="Construction:CfactorUndergroundWall"),
    ]
    construction_ffactor_ground_floor: Annotated[
        Optional[Dict[str, ConstructionFfactorGroundFloor]],
        Field(None, alias="Construction:FfactorGroundFloor"),
    ]
    window_thermal_model_params: Annotated[
        Optional[Dict[str, WindowThermalModelParams]],
        Field(None, alias="WindowThermalModel:Params"),
    ]
    construction_complex_fenestration_state: Annotated[
        Optional[Dict[str, ConstructionComplexFenestrationState]],
        Field(None, alias="Construction:ComplexFenestrationState"),
    ]
    global_geometry_rules: Annotated[
        Dict[str, GlobalGeometryRules], Field(alias="GlobalGeometryRules")
    ]
    zone: Annotated[Optional[Dict[str, Zone]], Field(None, alias="Zone")]
    zone_list: Annotated[Optional[Dict[str, ZoneList]], Field(None, alias="ZoneList")]
    zone_group: Annotated[
        Optional[Dict[str, ZoneGroup]], Field(None, alias="ZoneGroup")
    ]
    building_surface_detailed: Annotated[
        Optional[Dict[str, BuildingSurfaceDetailed]],
        Field(None, alias="BuildingSurface:Detailed"),
    ]
    fenestration_surface_detailed: Annotated[
        Optional[Dict[str, FenestrationSurfaceDetailed]],
        Field(None, alias="FenestrationSurface:Detailed"),
    ]
    window_shading_control: Annotated[
        Optional[Dict[str, WindowShadingControl]],
        Field(None, alias="WindowShadingControl"),
    ]
    window_property_frame_and_divider: Annotated[
        Optional[Dict[str, WindowPropertyFrameAndDivider]],
        Field(None, alias="WindowProperty:FrameAndDivider"),
    ]
    internal_mass: Annotated[
        Optional[Dict[str, InternalMass]], Field(None, alias="InternalMass")
    ]
    shading_site_detailed: Annotated[
        Optional[Dict[str, ShadingSiteDetailed]],
        Field(None, alias="Shading:Site:Detailed"),
    ]
    shading_building_detailed: Annotated[
        Optional[Dict[str, ShadingBuildingDetailed]],
        Field(None, alias="Shading:Building:Detailed"),
    ]
    shading_zone_detailed: Annotated[
        Optional[Dict[str, ShadingZoneDetailed]],
        Field(None, alias="Shading:Zone:Detailed"),
    ]
    shading_property_reflectance: Annotated[
        Optional[Dict[str, ShadingPropertyReflectance]],
        Field(None, alias="ShadingProperty:Reflectance"),
    ]
    surface_property_solar_incident_inside: Annotated[
        Optional[Dict[str, SurfacePropertySolarIncidentInside]],
        Field(None, alias="SurfaceProperty:SolarIncidentInside"),
    ]
    complex_fenestration_property_solar_absorbed_layers: Annotated[
        Optional[Dict[str, ComplexFenestrationPropertySolarAbsorbedLayers]],
        Field(None, alias="ComplexFenestrationProperty:SolarAbsorbedLayers"),
    ]
    people: Annotated[Optional[Dict[str, People]], Field(None, alias="People")]
    lights: Annotated[Optional[Dict[str, Lights]], Field(None, alias="Lights")]
    electric_equipment: Annotated[
        Optional[Dict[str, ElectricEquipment]], Field(None, alias="ElectricEquipment")
    ]
    gas_equipment: Annotated[
        Optional[Dict[str, GasEquipment]], Field(None, alias="GasEquipment")
    ]
    other_equipment: Annotated[
        Optional[Dict[str, OtherEquipment]], Field(None, alias="OtherEquipment")
    ]
    daylighting_controls: Annotated[
        Optional[Dict[str, DaylightingControls]],
        Field(None, alias="Daylighting:Controls"),
    ]
    daylighting_reference_point: Annotated[
        Optional[Dict[str, DaylightingReferencePoint]],
        Field(None, alias="Daylighting:ReferencePoint"),
    ]
    zone_infiltration_design_flow_rate: Annotated[
        Optional[Dict[str, ZoneInfiltrationDesignFlowRate]],
        Field(None, alias="ZoneInfiltration:DesignFlowRate"),
    ]
    zone_ventilation_design_flow_rate: Annotated[
        Optional[Dict[str, ZoneVentilationDesignFlowRate]],
        Field(None, alias="ZoneVentilation:DesignFlowRate"),
    ]
    zone_ventilation_windand_stack_open_area: Annotated[
        Optional[Dict[str, ZoneVentilationWindandStackOpenArea]],
        Field(None, alias="ZoneVentilation:WindandStackOpenArea"),
    ]
    zone_mixing: Annotated[
        Optional[Dict[str, ZoneMixing]], Field(None, alias="ZoneMixing")
    ]
    zone_refrigeration_door_mixing: Annotated[
        Optional[Dict[str, ZoneRefrigerationDoorMixing]],
        Field(None, alias="ZoneRefrigerationDoorMixing"),
    ]
    airflow_network_multi_zone_surface_effective_leakage_area: Annotated[
        Optional[Dict[str, AirflowNetworkMultiZoneSurfaceEffectiveLeakageArea]],
        Field(None, alias="AirflowNetwork:MultiZone:Surface:EffectiveLeakageArea"),
    ]
    exterior_lights: Annotated[
        Optional[Dict[str, ExteriorLights]], Field(None, alias="Exterior:Lights")
    ]
    exterior_fuel_equipment: Annotated[
        Optional[Dict[str, ExteriorFuelEquipment]],
        Field(None, alias="Exterior:FuelEquipment"),
    ]
    design_specification_outdoor_air: Annotated[
        Optional[Dict[str, DesignSpecificationOutdoorAir]],
        Field(None, alias="DesignSpecification:OutdoorAir"),
    ]
    design_specification_zone_air_distribution: Annotated[
        Optional[Dict[str, DesignSpecificationZoneAirDistribution]],
        Field(None, alias="DesignSpecification:ZoneAirDistribution"),
    ]
    sizing_parameters: Annotated[
        Optional[Dict[str, SizingParameters]], Field(None, alias="Sizing:Parameters")
    ]
    sizing_zone: Annotated[
        Optional[Dict[str, SizingZone]], Field(None, alias="Sizing:Zone")
    ]
    sizing_system: Annotated[
        Optional[Dict[str, SizingSystem]], Field(None, alias="Sizing:System")
    ]
    sizing_plant: Annotated[
        Optional[Dict[str, SizingPlant]], Field(None, alias="Sizing:Plant")
    ]
    zone_control_humidistat: Annotated[
        Optional[Dict[str, ZoneControlHumidistat]],
        Field(None, alias="ZoneControl:Humidistat"),
    ]
    zone_control_thermostat: Annotated[
        Optional[Dict[str, ZoneControlThermostat]],
        Field(None, alias="ZoneControl:Thermostat"),
    ]
    thermostat_setpoint_single_heating: Annotated[
        Optional[Dict[str, ThermostatSetpointSingleHeating]],
        Field(None, alias="ThermostatSetpoint:SingleHeating"),
    ]
    thermostat_setpoint_single_cooling: Annotated[
        Optional[Dict[str, ThermostatSetpointSingleCooling]],
        Field(None, alias="ThermostatSetpoint:SingleCooling"),
    ]
    thermostat_setpoint_dual_setpoint: Annotated[
        Optional[Dict[str, ThermostatSetpointDualSetpoint]],
        Field(None, alias="ThermostatSetpoint:DualSetpoint"),
    ]
    zone_hvac_ideal_loads_air_system: Annotated[
        Optional[Dict[str, ZoneHvacIdealLoadsAirSystem]],
        Field(None, alias="ZoneHVAC:IdealLoadsAirSystem"),
    ]
    zone_hvac_four_pipe_fan_coil: Annotated[
        Optional[Dict[str, ZoneHvacFourPipeFanCoil]],
        Field(None, alias="ZoneHVAC:FourPipeFanCoil"),
    ]
    zone_hvac_packaged_terminal_air_conditioner: Annotated[
        Optional[Dict[str, ZoneHvacPackagedTerminalAirConditioner]],
        Field(None, alias="ZoneHVAC:PackagedTerminalAirConditioner"),
    ]
    zone_hvac_energy_recovery_ventilator: Annotated[
        Optional[Dict[str, ZoneHvacEnergyRecoveryVentilator]],
        Field(None, alias="ZoneHVAC:EnergyRecoveryVentilator"),
    ]
    zone_hvac_energy_recovery_ventilator_controller: Annotated[
        Optional[Dict[str, ZoneHvacEnergyRecoveryVentilatorController]],
        Field(None, alias="ZoneHVAC:EnergyRecoveryVentilator:Controller"),
    ]
    zone_hvac_unit_heater: Annotated[
        Optional[Dict[str, ZoneHvacUnitHeater]],
        Field(None, alias="ZoneHVAC:UnitHeater"),
    ]
    zone_hvac_high_temperature_radiant: Annotated[
        Optional[Dict[str, ZoneHvacHighTemperatureRadiant]],
        Field(None, alias="ZoneHVAC:HighTemperatureRadiant"),
    ]
    air_terminal_single_duct_constant_volume_no_reheat: Annotated[
        Optional[Dict[str, AirTerminalSingleDuctConstantVolumeNoReheat]],
        Field(None, alias="AirTerminal:SingleDuct:ConstantVolume:NoReheat"),
    ]
    air_terminal_single_duct_vav_reheat: Annotated[
        Optional[Dict[str, AirTerminalSingleDuctVavReheat]],
        Field(None, alias="AirTerminal:SingleDuct:VAV:Reheat"),
    ]
    zone_hvac_air_distribution_unit: Annotated[
        Optional[Dict[str, ZoneHvacAirDistributionUnit]],
        Field(None, alias="ZoneHVAC:AirDistributionUnit"),
    ]
    zone_hvac_equipment_list: Annotated[
        Optional[Dict[str, ZoneHvacEquipmentList]],
        Field(None, alias="ZoneHVAC:EquipmentList"),
    ]
    zone_hvac_equipment_connections: Annotated[
        Optional[Dict[str, ZoneHvacEquipmentConnections]],
        Field(None, alias="ZoneHVAC:EquipmentConnections"),
    ]
    fan_system_model: Annotated[
        Optional[Dict[str, FanSystemModel]], Field(None, alias="Fan:SystemModel")
    ]
    fan_constant_volume: Annotated[
        Optional[Dict[str, FanConstantVolume]], Field(None, alias="Fan:ConstantVolume")
    ]
    fan_variable_volume: Annotated[
        Optional[Dict[str, FanVariableVolume]], Field(None, alias="Fan:VariableVolume")
    ]
    fan_on_off: Annotated[Optional[Dict[str, FanOnOff]], Field(None, alias="Fan:OnOff")]
    fan_zone_exhaust: Annotated[
        Optional[Dict[str, FanZoneExhaust]], Field(None, alias="Fan:ZoneExhaust")
    ]
    coil_cooling_water: Annotated[
        Optional[Dict[str, CoilCoolingWater]], Field(None, alias="Coil:Cooling:Water")
    ]
    coil_cooling_water_detailed_geometry: Annotated[
        Optional[Dict[str, CoilCoolingWaterDetailedGeometry]],
        Field(None, alias="Coil:Cooling:Water:DetailedGeometry"),
    ]
    coil_cooling_dx_single_speed: Annotated[
        Optional[Dict[str, CoilCoolingDxSingleSpeed]],
        Field(None, alias="Coil:Cooling:DX:SingleSpeed"),
    ]
    coil_cooling_dx_two_speed: Annotated[
        Optional[Dict[str, CoilCoolingDxTwoSpeed]],
        Field(None, alias="Coil:Cooling:DX:TwoSpeed"),
    ]
    coil_cooling_dx_multi_speed: Annotated[
        Optional[Dict[str, CoilCoolingDxMultiSpeed]],
        Field(None, alias="Coil:Cooling:DX:MultiSpeed"),
    ]
    coil_heating_water: Annotated[
        Optional[Dict[str, CoilHeatingWater]], Field(None, alias="Coil:Heating:Water")
    ]
    coil_heating_electric: Annotated[
        Optional[Dict[str, CoilHeatingElectric]],
        Field(None, alias="Coil:Heating:Electric"),
    ]
    coil_heating_fuel: Annotated[
        Optional[Dict[str, CoilHeatingFuel]], Field(None, alias="Coil:Heating:Fuel")
    ]
    coil_heating_dx_single_speed: Annotated[
        Optional[Dict[str, CoilHeatingDxSingleSpeed]],
        Field(None, alias="Coil:Heating:DX:SingleSpeed"),
    ]
    coil_cooling_water_to_air_heat_pump_equation_fit: Annotated[
        Optional[Dict[str, CoilCoolingWaterToAirHeatPumpEquationFit]],
        Field(None, alias="Coil:Cooling:WaterToAirHeatPump:EquationFit"),
    ]
    coil_heating_water_to_air_heat_pump_equation_fit: Annotated[
        Optional[Dict[str, CoilHeatingWaterToAirHeatPumpEquationFit]],
        Field(None, alias="Coil:Heating:WaterToAirHeatPump:EquationFit"),
    ]
    coil_system_cooling_dx: Annotated[
        Optional[Dict[str, CoilSystemCoolingDx]],
        Field(None, alias="CoilSystem:Cooling:DX"),
    ]
    humidifier_steam_electric: Annotated[
        Optional[Dict[str, HumidifierSteamElectric]],
        Field(None, alias="Humidifier:Steam:Electric"),
    ]
    heat_exchanger_air_to_air_sensible_and_latent: Annotated[
        Optional[Dict[str, HeatExchangerAirToAirSensibleAndLatent]],
        Field(None, alias="HeatExchanger:AirToAir:SensibleAndLatent"),
    ]
    air_loop_hvac_unitary_system: Annotated[
        Optional[Dict[str, AirLoopHvacUnitarySystem]],
        Field(None, alias="AirLoopHVAC:UnitarySystem"),
    ]
    unitary_system_performance_multispeed: Annotated[
        Optional[Dict[str, UnitarySystemPerformanceMultispeed]],
        Field(None, alias="UnitarySystemPerformance:Multispeed"),
    ]
    air_loop_hvac_unitary_furnace_heat_cool: Annotated[
        Optional[Dict[str, AirLoopHvacUnitaryFurnaceHeatCool]],
        Field(None, alias="AirLoopHVAC:Unitary:Furnace:HeatCool"),
    ]
    air_loop_hvac_unitary_heat_cool: Annotated[
        Optional[Dict[str, AirLoopHvacUnitaryHeatCool]],
        Field(None, alias="AirLoopHVAC:UnitaryHeatCool"),
    ]
    air_loop_hvac_unitary_heat_pump_air_to_air: Annotated[
        Optional[Dict[str, AirLoopHvacUnitaryHeatPumpAirToAir]],
        Field(None, alias="AirLoopHVAC:UnitaryHeatPump:AirToAir"),
    ]
    air_loop_hvac_unitary_heat_pump_water_to_air: Annotated[
        Optional[Dict[str, AirLoopHvacUnitaryHeatPumpWaterToAir]],
        Field(None, alias="AirLoopHVAC:UnitaryHeatPump:WaterToAir"),
    ]
    controller_water_coil: Annotated[
        Optional[Dict[str, ControllerWaterCoil]],
        Field(None, alias="Controller:WaterCoil"),
    ]
    controller_outdoor_air: Annotated[
        Optional[Dict[str, ControllerOutdoorAir]],
        Field(None, alias="Controller:OutdoorAir"),
    ]
    controller_mechanical_ventilation: Annotated[
        Optional[Dict[str, ControllerMechanicalVentilation]],
        Field(None, alias="Controller:MechanicalVentilation"),
    ]
    air_loop_hvac_controller_list: Annotated[
        Optional[Dict[str, AirLoopHvacControllerList]],
        Field(None, alias="AirLoopHVAC:ControllerList"),
    ]
    air_loop_hvac: Annotated[
        Optional[Dict[str, AirLoopHvac]], Field(None, alias="AirLoopHVAC")
    ]
    air_loop_hvac_outdoor_air_system_equipment_list: Annotated[
        Optional[Dict[str, AirLoopHvacOutdoorAirSystemEquipmentList]],
        Field(None, alias="AirLoopHVAC:OutdoorAirSystem:EquipmentList"),
    ]
    air_loop_hvac_outdoor_air_system: Annotated[
        Optional[Dict[str, AirLoopHvacOutdoorAirSystem]],
        Field(None, alias="AirLoopHVAC:OutdoorAirSystem"),
    ]
    outdoor_air_mixer: Annotated[
        Optional[Dict[str, OutdoorAirMixer]], Field(None, alias="OutdoorAir:Mixer")
    ]
    air_loop_hvac_zone_splitter: Annotated[
        Optional[Dict[str, AirLoopHvacZoneSplitter]],
        Field(None, alias="AirLoopHVAC:ZoneSplitter"),
    ]
    air_loop_hvac_supply_path: Annotated[
        Optional[Dict[str, AirLoopHvacSupplyPath]],
        Field(None, alias="AirLoopHVAC:SupplyPath"),
    ]
    air_loop_hvac_zone_mixer: Annotated[
        Optional[Dict[str, AirLoopHvacZoneMixer]],
        Field(None, alias="AirLoopHVAC:ZoneMixer"),
    ]
    air_loop_hvac_return_plenum: Annotated[
        Optional[Dict[str, AirLoopHvacReturnPlenum]],
        Field(None, alias="AirLoopHVAC:ReturnPlenum"),
    ]
    air_loop_hvac_return_path: Annotated[
        Optional[Dict[str, AirLoopHvacReturnPath]],
        Field(None, alias="AirLoopHVAC:ReturnPath"),
    ]
    branch: Annotated[Optional[Dict[str, Branch]], Field(None, alias="Branch")]
    branch_list: Annotated[
        Optional[Dict[str, BranchList]], Field(None, alias="BranchList")
    ]
    connector_splitter: Annotated[
        Optional[Dict[str, ConnectorSplitter]], Field(None, alias="Connector:Splitter")
    ]
    connector_mixer: Annotated[
        Optional[Dict[str, ConnectorMixer]], Field(None, alias="Connector:Mixer")
    ]
    connector_list: Annotated[
        Optional[Dict[str, ConnectorList]], Field(None, alias="ConnectorList")
    ]
    node_list: Annotated[Optional[Dict[str, NodeList]], Field(None, alias="NodeList")]
    outdoor_air_node: Annotated[
        Optional[Dict[str, OutdoorAirNode]], Field(None, alias="OutdoorAir:Node")
    ]
    outdoor_air_node_list: Annotated[
        Optional[Dict[str, OutdoorAirNodeList]],
        Field(None, alias="OutdoorAir:NodeList"),
    ]
    pipe_adiabatic: Annotated[
        Optional[Dict[str, PipeAdiabatic]], Field(None, alias="Pipe:Adiabatic")
    ]
    pump_variable_speed: Annotated[
        Optional[Dict[str, PumpVariableSpeed]], Field(None, alias="Pump:VariableSpeed")
    ]
    pump_constant_speed: Annotated[
        Optional[Dict[str, PumpConstantSpeed]], Field(None, alias="Pump:ConstantSpeed")
    ]
    headered_pumps_variable_speed: Annotated[
        Optional[Dict[str, HeaderedPumpsVariableSpeed]],
        Field(None, alias="HeaderedPumps:VariableSpeed"),
    ]
    boiler_hot_water: Annotated[
        Optional[Dict[str, BoilerHotWater]], Field(None, alias="Boiler:HotWater")
    ]
    chiller_electric_ashrae205: Annotated[
        Optional[Dict[str, ChillerElectricAshrae205]],
        Field(None, alias="Chiller:Electric:ASHRAE205"),
    ]
    chiller_electric_eir: Annotated[
        Optional[Dict[str, ChillerElectricEir]],
        Field(None, alias="Chiller:Electric:EIR"),
    ]
    chiller_electric_reformulated_eir: Annotated[
        Optional[Dict[str, ChillerElectricReformulatedEir]],
        Field(None, alias="Chiller:Electric:ReformulatedEIR"),
    ]
    cooling_tower_single_speed: Annotated[
        Optional[Dict[str, CoolingTowerSingleSpeed]],
        Field(None, alias="CoolingTower:SingleSpeed"),
    ]
    cooling_tower_variable_speed: Annotated[
        Optional[Dict[str, CoolingTowerVariableSpeed]],
        Field(None, alias="CoolingTower:VariableSpeed"),
    ]
    evaporative_fluid_cooler_two_speed: Annotated[
        Optional[Dict[str, EvaporativeFluidCoolerTwoSpeed]],
        Field(None, alias="EvaporativeFluidCooler:TwoSpeed"),
    ]
    fluid_cooler_two_speed: Annotated[
        Optional[Dict[str, FluidCoolerTwoSpeed]],
        Field(None, alias="FluidCooler:TwoSpeed"),
    ]
    heat_exchanger_fluid_to_fluid: Annotated[
        Optional[Dict[str, HeatExchangerFluidToFluid]],
        Field(None, alias="HeatExchanger:FluidToFluid"),
    ]
    water_heater_mixed: Annotated[
        Optional[Dict[str, WaterHeaterMixed]], Field(None, alias="WaterHeater:Mixed")
    ]
    plant_loop: Annotated[
        Optional[Dict[str, PlantLoop]], Field(None, alias="PlantLoop")
    ]
    condenser_loop: Annotated[
        Optional[Dict[str, CondenserLoop]], Field(None, alias="CondenserLoop")
    ]
    plant_equipment_list: Annotated[
        Optional[Dict[str, PlantEquipmentList]], Field(None, alias="PlantEquipmentList")
    ]
    condenser_equipment_list: Annotated[
        Optional[Dict[str, CondenserEquipmentList]],
        Field(None, alias="CondenserEquipmentList"),
    ]
    plant_equipment_operation_cooling_load: Annotated[
        Optional[Dict[str, PlantEquipmentOperationCoolingLoad]],
        Field(None, alias="PlantEquipmentOperation:CoolingLoad"),
    ]
    plant_equipment_operation_heating_load: Annotated[
        Optional[Dict[str, PlantEquipmentOperationHeatingLoad]],
        Field(None, alias="PlantEquipmentOperation:HeatingLoad"),
    ]
    plant_equipment_operation_component_setpoint: Annotated[
        Optional[Dict[str, PlantEquipmentOperationComponentSetpoint]],
        Field(None, alias="PlantEquipmentOperation:ComponentSetpoint"),
    ]
    plant_equipment_operation_schemes: Annotated[
        Optional[Dict[str, PlantEquipmentOperationSchemes]],
        Field(None, alias="PlantEquipmentOperationSchemes"),
    ]
    condenser_equipment_operation_schemes: Annotated[
        Optional[Dict[str, CondenserEquipmentOperationSchemes]],
        Field(None, alias="CondenserEquipmentOperationSchemes"),
    ]
    energy_management_system_sensor: Annotated[
        Optional[Dict[str, EnergyManagementSystemSensor]],
        Field(None, alias="EnergyManagementSystem:Sensor"),
    ]
    energy_management_system_actuator: Annotated[
        Optional[Dict[str, EnergyManagementSystemActuator]],
        Field(None, alias="EnergyManagementSystem:Actuator"),
    ]
    energy_management_system_program_calling_manager: Annotated[
        Optional[Dict[str, EnergyManagementSystemProgramCallingManager]],
        Field(None, alias="EnergyManagementSystem:ProgramCallingManager"),
    ]
    energy_management_system_program: Annotated[
        Optional[Dict[str, EnergyManagementSystemProgram]],
        Field(None, alias="EnergyManagementSystem:Program"),
    ]
    energy_management_system_global_variable: Annotated[
        Optional[Dict[str, EnergyManagementSystemGlobalVariable]],
        Field(None, alias="EnergyManagementSystem:GlobalVariable"),
    ]
    energy_management_system_output_variable: Annotated[
        Optional[Dict[str, EnergyManagementSystemOutputVariable]],
        Field(None, alias="EnergyManagementSystem:OutputVariable"),
    ]
    energy_management_system_internal_variable: Annotated[
        Optional[Dict[str, EnergyManagementSystemInternalVariable]],
        Field(None, alias="EnergyManagementSystem:InternalVariable"),
    ]
    availability_manager_scheduled: Annotated[
        Optional[Dict[str, AvailabilityManagerScheduled]],
        Field(None, alias="AvailabilityManager:Scheduled"),
    ]
    availability_manager_night_cycle: Annotated[
        Optional[Dict[str, AvailabilityManagerNightCycle]],
        Field(None, alias="AvailabilityManager:NightCycle"),
    ]
    availability_manager_assignment_list: Annotated[
        Optional[Dict[str, AvailabilityManagerAssignmentList]],
        Field(None, alias="AvailabilityManagerAssignmentList"),
    ]
    setpoint_manager_scheduled: Annotated[
        Optional[Dict[str, SetpointManagerScheduled]],
        Field(None, alias="SetpointManager:Scheduled"),
    ]
    setpoint_manager_scheduled_dual_setpoint: Annotated[
        Optional[Dict[str, SetpointManagerScheduledDualSetpoint]],
        Field(None, alias="SetpointManager:Scheduled:DualSetpoint"),
    ]
    setpoint_manager_outdoor_air_reset: Annotated[
        Optional[Dict[str, SetpointManagerOutdoorAirReset]],
        Field(None, alias="SetpointManager:OutdoorAirReset"),
    ]
    setpoint_manager_single_zone_reheat: Annotated[
        Optional[Dict[str, SetpointManagerSingleZoneReheat]],
        Field(None, alias="SetpointManager:SingleZone:Reheat"),
    ]
    setpoint_manager_single_zone_heating: Annotated[
        Optional[Dict[str, SetpointManagerSingleZoneHeating]],
        Field(None, alias="SetpointManager:SingleZone:Heating"),
    ]
    setpoint_manager_single_zone_cooling: Annotated[
        Optional[Dict[str, SetpointManagerSingleZoneCooling]],
        Field(None, alias="SetpointManager:SingleZone:Cooling"),
    ]
    setpoint_manager_single_zone_humidity_minimum: Annotated[
        Optional[Dict[str, SetpointManagerSingleZoneHumidityMinimum]],
        Field(None, alias="SetpointManager:SingleZone:Humidity:Minimum"),
    ]
    setpoint_manager_single_zone_humidity_maximum: Annotated[
        Optional[Dict[str, SetpointManagerSingleZoneHumidityMaximum]],
        Field(None, alias="SetpointManager:SingleZone:Humidity:Maximum"),
    ]
    setpoint_manager_mixed_air: Annotated[
        Optional[Dict[str, SetpointManagerMixedAir]],
        Field(None, alias="SetpointManager:MixedAir"),
    ]
    setpoint_manager_outdoor_air_pretreat: Annotated[
        Optional[Dict[str, SetpointManagerOutdoorAirPretreat]],
        Field(None, alias="SetpointManager:OutdoorAirPretreat"),
    ]
    setpoint_manager_multi_zone_humidity_minimum: Annotated[
        Optional[Dict[str, SetpointManagerMultiZoneHumidityMinimum]],
        Field(None, alias="SetpointManager:MultiZone:Humidity:Minimum"),
    ]
    setpoint_manager_multi_zone_humidity_maximum: Annotated[
        Optional[Dict[str, SetpointManagerMultiZoneHumidityMaximum]],
        Field(None, alias="SetpointManager:MultiZone:Humidity:Maximum"),
    ]
    setpoint_manager_follow_outdoor_air_temperature: Annotated[
        Optional[Dict[str, SetpointManagerFollowOutdoorAirTemperature]],
        Field(None, alias="SetpointManager:FollowOutdoorAirTemperature"),
    ]
    setpoint_manager_return_temperature_chilled_water: Annotated[
        Optional[Dict[str, SetpointManagerReturnTemperatureChilledWater]],
        Field(None, alias="SetpointManager:ReturnTemperature:ChilledWater"),
    ]
    setpoint_manager_return_temperature_hot_water: Annotated[
        Optional[Dict[str, SetpointManagerReturnTemperatureHotWater]],
        Field(None, alias="SetpointManager:ReturnTemperature:HotWater"),
    ]
    refrigeration_case: Annotated[
        Optional[Dict[str, RefrigerationCase]], Field(None, alias="Refrigeration:Case")
    ]
    refrigeration_compressor_rack: Annotated[
        Optional[Dict[str, RefrigerationCompressorRack]],
        Field(None, alias="Refrigeration:CompressorRack"),
    ]
    refrigeration_case_and_walk_in_list: Annotated[
        Optional[Dict[str, RefrigerationCaseAndWalkInList]],
        Field(None, alias="Refrigeration:CaseAndWalkInList"),
    ]
    refrigeration_condenser_air_cooled: Annotated[
        Optional[Dict[str, RefrigerationCondenserAirCooled]],
        Field(None, alias="Refrigeration:Condenser:AirCooled"),
    ]
    refrigeration_compressor: Annotated[
        Optional[Dict[str, RefrigerationCompressor]],
        Field(None, alias="Refrigeration:Compressor"),
    ]
    refrigeration_compressor_list: Annotated[
        Optional[Dict[str, RefrigerationCompressorList]],
        Field(None, alias="Refrigeration:CompressorList"),
    ]
    refrigeration_system: Annotated[
        Optional[Dict[str, RefrigerationSystem]],
        Field(None, alias="Refrigeration:System"),
    ]
    refrigeration_air_chiller: Annotated[
        Optional[Dict[str, RefrigerationAirChiller]],
        Field(None, alias="Refrigeration:AirChiller"),
    ]
    zone_hvac_refrigeration_chiller_set: Annotated[
        Optional[Dict[str, ZoneHvacRefrigerationChillerSet]],
        Field(None, alias="ZoneHVAC:RefrigerationChillerSet"),
    ]
    electric_load_center_transformer: Annotated[
        Optional[Dict[str, ElectricLoadCenterTransformer]],
        Field(None, alias="ElectricLoadCenter:Transformer"),
    ]
    water_use_equipment: Annotated[
        Optional[Dict[str, WaterUseEquipment]], Field(None, alias="WaterUse:Equipment")
    ]
    water_use_connections: Annotated[
        Optional[Dict[str, WaterUseConnections]],
        Field(None, alias="WaterUse:Connections"),
    ]
    matrix_two_dimension: Annotated[
        Optional[Dict[str, MatrixTwoDimension]],
        Field(None, alias="Matrix:TwoDimension"),
    ]
    curve_linear: Annotated[
        Optional[Dict[str, CurveLinear]], Field(None, alias="Curve:Linear")
    ]
    curve_quad_linear: Annotated[
        Optional[Dict[str, CurveQuadLinear]], Field(None, alias="Curve:QuadLinear")
    ]
    curve_quint_linear: Annotated[
        Optional[Dict[str, CurveQuintLinear]], Field(None, alias="Curve:QuintLinear")
    ]
    curve_quadratic: Annotated[
        Optional[Dict[str, CurveQuadratic]], Field(None, alias="Curve:Quadratic")
    ]
    curve_cubic: Annotated[
        Optional[Dict[str, CurveCubic]], Field(None, alias="Curve:Cubic")
    ]
    curve_quartic: Annotated[
        Optional[Dict[str, CurveQuartic]], Field(None, alias="Curve:Quartic")
    ]
    curve_bicubic: Annotated[
        Optional[Dict[str, CurveBicubic]], Field(None, alias="Curve:Bicubic")
    ]
    curve_biquadratic: Annotated[
        Optional[Dict[str, CurveBiquadratic]], Field(None, alias="Curve:Biquadratic")
    ]
    table_independent_variable: Annotated[
        Optional[Dict[str, TableIndependentVariable]],
        Field(None, alias="Table:IndependentVariable"),
    ]
    table_independent_variable_list: Annotated[
        Optional[Dict[str, TableIndependentVariableList]],
        Field(None, alias="Table:IndependentVariableList"),
    ]
    table_lookup: Annotated[
        Optional[Dict[str, TableLookup]], Field(None, alias="Table:Lookup")
    ]
    fluid_properties_name: Annotated[
        Optional[Dict[str, FluidPropertiesName]],
        Field(None, alias="FluidProperties:Name"),
    ]
    fluid_properties_glycol_concentration: Annotated[
        Optional[Dict[str, FluidPropertiesGlycolConcentration]],
        Field(None, alias="FluidProperties:GlycolConcentration"),
    ]
    fluid_properties_temperatures: Annotated[
        Optional[Dict[str, FluidPropertiesTemperatures]],
        Field(None, alias="FluidProperties:Temperatures"),
    ]
    fluid_properties_saturated: Annotated[
        Optional[Dict[str, FluidPropertiesSaturated]],
        Field(None, alias="FluidProperties:Saturated"),
    ]
    fluid_properties_superheated: Annotated[
        Optional[Dict[str, FluidPropertiesSuperheated]],
        Field(None, alias="FluidProperties:Superheated"),
    ]
    utility_cost_tariff: Annotated[
        Optional[Dict[str, UtilityCostTariff]], Field(None, alias="UtilityCost:Tariff")
    ]
    utility_cost_qualify: Annotated[
        Optional[Dict[str, UtilityCostQualify]],
        Field(None, alias="UtilityCost:Qualify"),
    ]
    utility_cost_charge_simple: Annotated[
        Optional[Dict[str, UtilityCostChargeSimple]],
        Field(None, alias="UtilityCost:Charge:Simple"),
    ]
    utility_cost_charge_block: Annotated[
        Optional[Dict[str, UtilityCostChargeBlock]],
        Field(None, alias="UtilityCost:Charge:Block"),
    ]
    utility_cost_variable: Annotated[
        Optional[Dict[str, UtilityCostVariable]],
        Field(None, alias="UtilityCost:Variable"),
    ]
    output_variable_dictionary: Annotated[
        Optional[Dict[str, OutputVariableDictionary]],
        Field(None, alias="Output:VariableDictionary"),
    ]
    output_surfaces_list: Annotated[
        Optional[Dict[str, OutputSurfacesList]],
        Field(None, alias="Output:Surfaces:List"),
    ]
    output_surfaces_drawing: Annotated[
        Optional[Dict[str, OutputSurfacesDrawing]],
        Field(None, alias="Output:Surfaces:Drawing"),
    ]
    output_constructions: Annotated[
        Optional[Dict[str, OutputConstructions]],
        Field(None, alias="Output:Constructions"),
    ]
    output_energy_management_system: Annotated[
        Optional[Dict[str, OutputEnergyManagementSystem]],
        Field(None, alias="Output:EnergyManagementSystem"),
    ]
    output_table_summary_reports: Annotated[
        Optional[Dict[str, OutputTableSummaryReports]],
        Field(None, alias="Output:Table:SummaryReports"),
    ]
    output_table_time_bins: Annotated[
        Optional[Dict[str, OutputTableTimeBins]],
        Field(None, alias="Output:Table:TimeBins"),
    ]
    output_table_monthly: Annotated[
        Optional[Dict[str, OutputTableMonthly]],
        Field(None, alias="Output:Table:Monthly"),
    ]
    output_control_table_style: Annotated[
        Optional[Dict[str, OutputControlTableStyle]],
        Field(None, alias="OutputControl:Table:Style"),
    ]
    output_control_reporting_tolerances: Annotated[
        Optional[Dict[str, OutputControlReportingTolerances]],
        Field(None, alias="OutputControl:ReportingTolerances"),
    ]
    output_variable: Annotated[
        Optional[Dict[str, OutputVariable]], Field(None, alias="Output:Variable")
    ]
    output_meter: Annotated[
        Optional[Dict[str, OutputMeter]], Field(None, alias="Output:Meter")
    ]
    output_meter_meter_file_only: Annotated[
        Optional[Dict[str, OutputMeterMeterFileOnly]],
        Field(None, alias="Output:Meter:MeterFileOnly"),
    ]
    meter_custom: Annotated[
        Optional[Dict[str, MeterCustom]], Field(None, alias="Meter:Custom")
    ]
    meter_custom_decrement: Annotated[
        Optional[Dict[str, MeterCustomDecrement]],
        Field(None, alias="Meter:CustomDecrement"),
    ]
    output_control_files: Annotated[
        Optional[Dict[str, OutputControlFiles]],
        Field(None, alias="OutputControl:Files"),
    ]
    output_control_timestamp: Annotated[
        Optional[Dict[str, OutputControlTimestamp]],
        Field(None, alias="OutputControl:Timestamp"),
    ]
    output_json: Annotated[
        Optional[Dict[str, OutputJson]], Field(None, alias="Output:JSON")
    ]
    output_sq_lite: Annotated[
        Optional[Dict[str, OutputSqLite]], Field(None, alias="Output:SQLite")
    ]
    output_environmental_impact_factors: Annotated[
        Optional[Dict[str, OutputEnvironmentalImpactFactors]],
        Field(None, alias="Output:EnvironmentalImpactFactors"),
    ]
    environmental_impact_factors: Annotated[
        Optional[Dict[str, EnvironmentalImpactFactors]],
        Field(None, alias="EnvironmentalImpactFactors"),
    ]
    fuel_factors: Annotated[
        Optional[Dict[str, FuelFactors]], Field(None, alias="FuelFactors")
    ]
    output_diagnostics: Annotated[
        Optional[Dict[str, OutputDiagnostics]], Field(None, alias="Output:Diagnostics")
    ]
