# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.unchecked_base_model import UncheckedBaseModel
from .array_json_schema_property import ArrayJsonSchemaProperty
from .object_json_schema_property import ObjectJsonSchemaProperty
import typing
from .asr_conversational_config import AsrConversationalConfig
from .turn_config import TurnConfig
from .tts_conversational_config import TtsConversationalConfig
from .conversation_config import ConversationConfig
from .language_preset import LanguagePreset
from .agent_config_api_model import AgentConfigApiModel
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ..core.pydantic_utilities import update_forward_refs


class ConversationalConfigApiModel(UncheckedBaseModel):
    asr: typing.Optional[AsrConversationalConfig] = None
    turn: typing.Optional[TurnConfig] = None
    tts: typing.Optional[TtsConversationalConfig] = None
    conversation: typing.Optional[ConversationConfig] = None
    language_presets: typing.Optional[typing.Dict[str, LanguagePreset]] = None
    agent: typing.Optional[AgentConfigApiModel] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(ArrayJsonSchemaProperty, ConversationalConfigApiModel=ConversationalConfigApiModel)
update_forward_refs(ObjectJsonSchemaProperty, ConversationalConfigApiModel=ConversationalConfigApiModel)
