# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .project_snapshot_upload_response_model import ProjectSnapshotUploadResponseModel
from .character_alignment_model import CharacterAlignmentModel
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ProjectSnapshotExtendedResponseModel(UncheckedBaseModel):
    project_snapshot_id: str = pydantic.Field()
    """
    The ID of the project snapshot.
    """

    project_id: str = pydantic.Field()
    """
    The ID of the project.
    """

    created_at_unix: int = pydantic.Field()
    """
    The creation date of the project snapshot.
    """

    name: str = pydantic.Field()
    """
    The name of the project snapshot.
    """

    audio_upload: typing.Optional[ProjectSnapshotUploadResponseModel] = pydantic.Field(default=None)
    """
    The audio upload of the project snapshot.
    """

    zip_upload: typing.Optional[ProjectSnapshotUploadResponseModel] = pydantic.Field(default=None)
    """
    The zip upload of the project snapshot.
    """

    character_alignments: typing.List[CharacterAlignmentModel]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
