# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.unchecked_base_model import UncheckedBaseModel
from .array_json_schema_property import ArrayJsonSchemaProperty
from .object_json_schema_property import ObjectJsonSchemaProperty
import typing
from .webhook_tool_api_schema_config_method import WebhookToolApiSchemaConfigMethod
from .literal_json_schema_property import LiteralJsonSchemaProperty
from .query_params_json_schema import QueryParamsJsonSchema
from .webhook_tool_api_schema_config_request_headers_value import WebhookToolApiSchemaConfigRequestHeadersValue
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ..core.pydantic_utilities import update_forward_refs


class WebhookToolApiSchemaConfig(UncheckedBaseModel):
    """
    Configuration for a webhook that will be called by an LLM tool.
    """

    url: str
    method: typing.Optional[WebhookToolApiSchemaConfigMethod] = None
    path_params_schema: typing.Optional[typing.Dict[str, LiteralJsonSchemaProperty]] = None
    query_params_schema: typing.Optional[QueryParamsJsonSchema] = None
    request_body_schema: typing.Optional[ObjectJsonSchemaProperty] = None
    request_headers: typing.Optional[typing.Dict[str, WebhookToolApiSchemaConfigRequestHeadersValue]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(ArrayJsonSchemaProperty, WebhookToolApiSchemaConfig=WebhookToolApiSchemaConfig)
update_forward_refs(ObjectJsonSchemaProperty, WebhookToolApiSchemaConfig=WebhookToolApiSchemaConfig)
