/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.runtime.RayRuntime;
import io.ray.api.runtime.RayRuntimeFactory;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.RayDevRuntime;
import io.ray.runtime.RayNativeRuntime;
import io.ray.runtime.config.RayConfig;
import io.ray.runtime.config.RunMode;
import io.ray.runtime.generated.Common;
import io.ray.runtime.util.LoggingUtil;
import io.ray.runtime.util.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRayRuntimeFactory
implements RayRuntimeFactory {
    @Override
    public RayRuntime createRayRuntime() {
        RayConfig rayConfig = RayConfig.create();
        LoggingUtil.setupLogging(rayConfig);
        SystemConfig.setup(rayConfig);
        Logger logger = LoggerFactory.getLogger(DefaultRayRuntimeFactory.class);
        if (rayConfig.workerMode == Common.WorkerType.WORKER) {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error(String.format("Uncaught worker exception in thread %s", t), e));
        }
        try {
            logger.debug("Initializing runtime with config: {}", (Object)rayConfig);
            AbstractRayRuntime runtime = rayConfig.runMode == RunMode.LOCAL ? new RayDevRuntime(rayConfig) : new RayNativeRuntime(rayConfig);
            runtime.start();
            return runtime;
        }
        catch (Exception e2) {
            logger.error("Failed to initialize ray runtime, with config " + rayConfig, e2);
            throw new RuntimeException("Failed to initialize ray runtime", e2);
        }
    }
}

