# Generated by Django 2.2.12 on 2020-05-27 09:30

from django.db import migrations


def delete_change_permissions(apps, schema_editor):
    Permission = apps.get_model("auth", "Permission")
    ContentType = apps.get_model("contenttypes.ContentType")
    db_alias = schema_editor.connection.alias
    try:
        content_type = ContentType.objects.using(db_alias).get(
            model="donationexportlog", app_label="wagtaildonate"
        )
    except ContentType.DoesNotExist:
        pass
    else:
        Permission.objects.using(db_alias).filter(
            content_type=content_type,
            codename__in=[
                "add_donationexportlog",
                "delete_donationexportlog",
                "change_donationexportlog",
            ],
        ).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("wagtaildonate", "0023_optins"),
        ("auth", "0009_alter_user_last_name_max_length"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="donationexportlog", options={"default_permissions": ["view"]}
        ),
        migrations.RunPython(delete_change_permissions, migrations.RunPython.noop),
    ]
