"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
/**
 * Code configuration providing the location to a Flink application JAR file.
 */
class ApplicationCode {
    /**
     * Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket
     * @param fileKey - a key pointing to a Flink JAR file
     * @param objectVersion - an optional version string for the provided fileKey
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
exports.ApplicationCode = ApplicationCode;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "@aws-cdk/aws-kinesisanalytics-flink-alpha.ApplicationCode", version: "2.141.0-alpha.0" };
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        return this._asset?.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,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