# Generated by Django 3.0.4 on 2020-05-01 16:00

import _socket
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_crypto_fields.fields.encrypted_text_field
import django_revision.revision_field
import edc_action_item.managers
import edc_adverse_event.model_mixins.death_report_tmg_model_mixin
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_protocol.validators
import edc_utils.date
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("edc_adverse_event", "0003_auto_20191026_2231"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("edc_action_item", "0024_auto_20191024_1000"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="AeInitial",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "ae_study_relation_possibility",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        max_length=10,
                        verbose_name="Is the incident related to the patient involvement in the study?",
                    ),
                ),
                (
                    "ae_cause",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Has a reason other than the specified study drug been identified as the cause of the event(s)?",
                    ),
                ),
                (
                    "ae_cause_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name='If "Yes", specify',
                    ),
                ),
                (
                    "ae_treatment",
                    models.TextField(
                        verbose_name="Specify action taken for treatment of AE:"
                    ),
                ),
                (
                    "ae_auto_created",
                    models.BooleanField(default=False, editable=False, max_length=25),
                ),
                (
                    "ae_auto_created_criteria",
                    models.CharField(default="N/A", editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "ae_classification_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ae_description",
                    models.TextField(verbose_name="Adverse Event (AE) description"),
                ),
                (
                    "ae_awareness_date",
                    models.DateField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="AE Awareness date",
                    ),
                ),
                (
                    "ae_start_date",
                    models.DateField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Actual Start Date of AE",
                    ),
                ),
                (
                    "ae_grade",
                    models.CharField(
                        choices=[
                            ("3", "Grade III - Severe"),
                            ("4", "Grade 4 - Life-threatening"),
                            ("5", "Grade 5 - Death"),
                        ],
                        max_length=25,
                        verbose_name="Severity of AE",
                    ),
                ),
                (
                    "study_drug_relation",
                    models.CharField(
                        choices=[
                            ("not_related", "Not related"),
                            ("unlikely_related", "Unlikely related"),
                            ("possibly_related", "Possibly related"),
                            ("probably_related", "Probably related"),
                            ("definitely_related", "Definitely related"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Relation to study drug:",
                    ),
                ),
                (
                    "sae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="(i.e. results in death, in-patient hospitalisation/prolongation, significant disability or is life-threatening)",
                        max_length=5,
                        verbose_name="Is this event a SAE?",
                    ),
                ),
                (
                    "susar",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, SUSAR must be reported to Principal Investigator and TMG immediately,",
                        max_length=5,
                        verbose_name="Is this a Suspected Unexpected Serious Adverse Reaction (SUSAR)?",
                    ),
                ),
                (
                    "susar_reported",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="Is SUSAR reported?",
                    ),
                ),
                (
                    "tmg_report_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="AEs ≥ Grade 4 or SAE must be reported to the Trial Management Group (TMG) within 24 hours",
                        null=True,
                        verbose_name="Date and time AE reported to TMG",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_classification",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_adverse_event.AeClassification",
                        verbose_name="Adverse Event (AE) Classification",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "sae_reason",
                    models.ForeignKey(
                        help_text="If subject deceased, submit a Death Report",
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_adverse_event.SaeReason",
                        verbose_name='If "Yes", reason for SAE:',
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "AE Initial Report", "abstract": False,},
            managers=[
                ("on_site", edc_action_item.managers.ActionIdentifierSiteManager()),
                ("objects", edc_action_item.managers.ActionIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="DeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "death_datetime",
                    models.DateTimeField(
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and Time of Death",
                    ),
                ),
                (
                    "death_as_inpatient",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Death as inpatient",
                    ),
                ),
                (
                    "cause_of_death_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("narrative", models.TextField(verbose_name="Narrative")),
                (
                    "death_location_type",
                    models.CharField(
                        choices=[
                            ("home", "At home"),
                            ("hospital_clinic", "Hospital/clinic"),
                            ("home", "Elsewhere"),
                        ],
                        max_length=50,
                        verbose_name="Where did the participant die?",
                    ),
                ),
                (
                    "death_location_name",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If death occurred at hospital / clinic, please give name of the facility",
                    ),
                ),
                (
                    "informant_contacts",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text=" (Encryption: AES local)",
                        max_length=71,
                        null=True,
                    ),
                ),
                (
                    "informant_relationship",
                    models.CharField(
                        choices=[
                            ("husband_wife", "Husband/wife"),
                            ("Parent", "Parent"),
                            ("child", "Child"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        max_length=50,
                        verbose_name="Informants relationship to the participant?",
                    ),
                ),
                (
                    "other_informant_relationship",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "death_certificate",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is a death certificate is available?",
                    ),
                ),
                (
                    "secondary_cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name='If "Other" above, please specify',
                    ),
                ),
                (
                    "study_day",
                    models.IntegerField(
                        default=0, editable=False, help_text="not used"
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "cause_of_death",
                    models.ForeignKey(
                        help_text="Main cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Main cause of death",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "secondary_cause_of_death",
                    models.ForeignKey(
                        help_text="Secondary cause of death in the opinion of the local study doctor and local PI",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="secondary_cause_of_death",
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Secondary cause of death",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "Death Report", "abstract": False,},
            managers=[
                ("on_site", edc_action_item.managers.ActionIdentifierSiteManager()),
                ("objects", edc_action_item.managers.ActionIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalDeathReportTmgSecond",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name='If "Other" above, please specify',
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, explain in the narrative below",
                        max_length=15,
                        null=True,
                        verbose_name="Is the cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "narrative",
                    models.TextField(blank=True, null=True, verbose_name="Narrative"),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "cause_of_death",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Main cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Main cause of death",
                    ),
                ),
                (
                    "death_report",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_ae.DeathReport",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Death Report TMG (2nd)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDeathReportTmg",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name='If "Other" above, please specify',
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, explain in the narrative below",
                        max_length=15,
                        null=True,
                        verbose_name="Is the cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "narrative",
                    models.TextField(blank=True, null=True, verbose_name="Narrative"),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "cause_of_death",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Main cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Main cause of death",
                    ),
                ),
                (
                    "death_report",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_ae.DeathReport",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Death Report TMG (1st)",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalDeathReport",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "death_datetime",
                    models.DateTimeField(
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and Time of Death",
                    ),
                ),
                (
                    "death_as_inpatient",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Death as inpatient",
                    ),
                ),
                (
                    "cause_of_death_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                ("narrative", models.TextField(verbose_name="Narrative")),
                (
                    "death_location_type",
                    models.CharField(
                        choices=[
                            ("home", "At home"),
                            ("hospital_clinic", "Hospital/clinic"),
                            ("home", "Elsewhere"),
                        ],
                        max_length=50,
                        verbose_name="Where did the participant die?",
                    ),
                ),
                (
                    "death_location_name",
                    models.CharField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If death occurred at hospital / clinic, please give name of the facility",
                    ),
                ),
                (
                    "informant_contacts",
                    django_crypto_fields.fields.encrypted_text_field.EncryptedTextField(
                        blank=True,
                        help_text=" (Encryption: AES local)",
                        max_length=71,
                        null=True,
                    ),
                ),
                (
                    "informant_relationship",
                    models.CharField(
                        choices=[
                            ("husband_wife", "Husband/wife"),
                            ("Parent", "Parent"),
                            ("child", "Child"),
                            ("unknown", "Unknown"),
                            ("OTHER", "Other"),
                        ],
                        max_length=50,
                        verbose_name="Informants relationship to the participant?",
                    ),
                ),
                (
                    "other_informant_relationship",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "death_certificate",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Is a death certificate is available?",
                    ),
                ),
                (
                    "secondary_cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name='If "Other" above, please specify',
                    ),
                ),
                (
                    "study_day",
                    models.IntegerField(
                        default=0, editable=False, help_text="not used"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "cause_of_death",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Main cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Main cause of death",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "secondary_cause_of_death",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="Secondary cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Secondary cause of death",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Death Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAeTmg",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "ae_received_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time AE form received:",
                    ),
                ),
                (
                    "clinical_review_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time of clinical review: ",
                    ),
                ),
                (
                    "ae_description",
                    models.TextField(
                        blank=True, null=True, verbose_name="Description of AE:"
                    ),
                ),
                (
                    "investigator_comments",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="This investigator's comments:",
                    ),
                ),
                (
                    "ae_classification",
                    models.CharField(blank=True, max_length=150, null=True),
                ),
                (
                    "ae_classification_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "original_report_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, explain in the narrative below",
                        max_length=15,
                        null=True,
                        verbose_name="Does this investigator agree with the original AE report?",
                    ),
                ),
                (
                    "narrative",
                    models.TextField(blank=True, null=True, verbose_name="Narrative"),
                ),
                (
                    "officials_notified",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time regulatory authorities notified (SUSARs)",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical AE TMG Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAeSusar",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "submitted_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="AE SUSAR submitted on",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical AE SUSAR Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAeInitial",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "ae_study_relation_possibility",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        max_length=10,
                        verbose_name="Is the incident related to the patient involvement in the study?",
                    ),
                ),
                (
                    "ae_cause",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Has a reason other than the specified study drug been identified as the cause of the event(s)?",
                    ),
                ),
                (
                    "ae_cause_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name='If "Yes", specify',
                    ),
                ),
                (
                    "ae_treatment",
                    models.TextField(
                        verbose_name="Specify action taken for treatment of AE:"
                    ),
                ),
                (
                    "ae_auto_created",
                    models.BooleanField(default=False, editable=False, max_length=25),
                ),
                (
                    "ae_auto_created_criteria",
                    models.CharField(default="N/A", editable=False, max_length=50),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "ae_classification_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "ae_description",
                    models.TextField(verbose_name="Adverse Event (AE) description"),
                ),
                (
                    "ae_awareness_date",
                    models.DateField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="AE Awareness date",
                    ),
                ),
                (
                    "ae_start_date",
                    models.DateField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Actual Start Date of AE",
                    ),
                ),
                (
                    "ae_grade",
                    models.CharField(
                        choices=[
                            ("3", "Grade III - Severe"),
                            ("4", "Grade 4 - Life-threatening"),
                            ("5", "Grade 5 - Death"),
                        ],
                        max_length=25,
                        verbose_name="Severity of AE",
                    ),
                ),
                (
                    "study_drug_relation",
                    models.CharField(
                        choices=[
                            ("not_related", "Not related"),
                            ("unlikely_related", "Unlikely related"),
                            ("possibly_related", "Possibly related"),
                            ("probably_related", "Probably related"),
                            ("definitely_related", "Definitely related"),
                            ("N/A", "Not applicable"),
                        ],
                        max_length=25,
                        null=True,
                        verbose_name="Relation to study drug:",
                    ),
                ),
                (
                    "sae",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="(i.e. results in death, in-patient hospitalisation/prolongation, significant disability or is life-threatening)",
                        max_length=5,
                        verbose_name="Is this event a SAE?",
                    ),
                ),
                (
                    "susar",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If yes, SUSAR must be reported to Principal Investigator and TMG immediately,",
                        max_length=5,
                        verbose_name="Is this a Suspected Unexpected Serious Adverse Reaction (SUSAR)?",
                    ),
                ),
                (
                    "susar_reported",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=5,
                        verbose_name="Is SUSAR reported?",
                    ),
                ),
                (
                    "tmg_report_datetime",
                    models.DateTimeField(
                        blank=True,
                        help_text="AEs ≥ Grade 4 or SAE must be reported to the Trial Management Group (TMG) within 24 hours",
                        null=True,
                        verbose_name="Date and time AE reported to TMG",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_classification",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.AeClassification",
                        verbose_name="Adverse Event (AE) Classification",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "sae_reason",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        help_text="If subject deceased, submit a Death Report",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_adverse_event.SaeReason",
                        verbose_name='If "Yes", reason for SAE:',
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical AE Initial Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAeFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=30)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "outcome",
                    models.CharField(
                        choices=[
                            ("continuing/update", "Continuing/Update"),
                            ("increase_from_g3", "Severity increased from Grade III"),
                            ("recovered", "Recovered/Resolved"),
                            ("recovering", "Recovering/Resolving at end of study"),
                            ("not_recovered", "Not Recovered/Resolved at end of study"),
                            ("LTFU", "Unknown/Lost to follow-up"),
                            ("recovered_with_sequelae", "Recovered with sequelae"),
                            ("dead", "Death"),
                        ],
                        max_length=25,
                    ),
                ),
                (
                    "outcome_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future]
                    ),
                ),
                (
                    "ae_grade",
                    models.CharField(
                        choices=[
                            ("4", "Grade 4 - Life-threatening"),
                            ("5", "Grade 5 - Death"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If severity increased, indicate grade",
                    ),
                ),
                (
                    "relevant_history",
                    models.TextField(
                        help_text="Indicate Adverse Event, clinical results,medications given, dosage,treatment plan and outcomes.",
                        max_length=1000,
                        verbose_name="Description summary of Adverse Event outcome",
                    ),
                ),
                (
                    "followup",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        help_text="If NO, this will be considered the final report",
                        max_length=15,
                        verbose_name="Is a follow-up to this report required?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical AE Follow-up Report",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="DeathReportTmg",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                (
                    "cause_of_death_other",
                    models.CharField(
                        blank=True,
                        max_length=100,
                        null=True,
                        verbose_name='If "Other" above, please specify',
                    ),
                ),
                (
                    "cause_of_death_agreed",
                    models.CharField(
                        blank=True,
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, explain in the narrative below",
                        max_length=15,
                        null=True,
                        verbose_name="Is the cause of death agreed between study doctor and TMG member?",
                    ),
                ),
                (
                    "narrative",
                    models.TextField(blank=True, null=True, verbose_name="Narrative"),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "cause_of_death",
                    models.ForeignKey(
                        help_text="Main cause of death in the opinion of the local study doctor and local PI",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_adverse_event.CauseOfDeath",
                        verbose_name="Main cause of death",
                    ),
                ),
                (
                    "death_report",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_ae.DeathReport",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Death Report TMG (1st)",
                "verbose_name_plural": "Death Report TMG (1st)",
                "abstract": False,
            },
            managers=[
                (
                    "on_site",
                    edc_adverse_event.model_mixins.death_report_tmg_model_mixin.DeathReportTmgSiteManager(),
                ),
                (
                    "objects",
                    edc_adverse_event.model_mixins.death_report_tmg_model_mixin.DeathReportTmgManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AeTmg",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "ae_received_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time AE form received:",
                    ),
                ),
                (
                    "clinical_review_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time of clinical review: ",
                    ),
                ),
                (
                    "ae_description",
                    models.TextField(
                        blank=True, null=True, verbose_name="Description of AE:"
                    ),
                ),
                (
                    "investigator_comments",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="This investigator's comments:",
                    ),
                ),
                (
                    "ae_classification",
                    models.CharField(blank=True, max_length=150, null=True),
                ),
                (
                    "ae_classification_other",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=250,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "original_report_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If No, explain in the narrative below",
                        max_length=15,
                        null=True,
                        verbose_name="Does this investigator agree with the original AE report?",
                    ),
                ),
                (
                    "narrative",
                    models.TextField(blank=True, null=True, verbose_name="Narrative"),
                ),
                (
                    "officials_notified",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time regulatory authorities notified (SUSARs)",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "AE TMG Report", "abstract": False,},
            managers=[
                ("on_site", edc_action_item.managers.ActionIdentifierSiteManager()),
                ("objects", edc_action_item.managers.ActionIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="AeSusar",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "submitted_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="AE SUSAR submitted on",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "AE SUSAR Report", "abstract": False,},
            managers=[
                ("on_site", edc_action_item.managers.ActionIdentifierSiteManager()),
                ("objects", edc_action_item.managers.ActionIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="AeFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        blank=True,
                        default=django_audit_fields.models.audit_model_mixin.utcnow,
                    ),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=30, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        verbose_name="Report date and time",
                    ),
                ),
                (
                    "outcome",
                    models.CharField(
                        choices=[
                            ("continuing/update", "Continuing/Update"),
                            ("increase_from_g3", "Severity increased from Grade III"),
                            ("recovered", "Recovered/Resolved"),
                            ("recovering", "Recovering/Resolving at end of study"),
                            ("not_recovered", "Not Recovered/Resolved at end of study"),
                            ("LTFU", "Unknown/Lost to follow-up"),
                            ("recovered_with_sequelae", "Recovered with sequelae"),
                            ("dead", "Death"),
                        ],
                        max_length=25,
                    ),
                ),
                (
                    "outcome_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future]
                    ),
                ),
                (
                    "ae_grade",
                    models.CharField(
                        choices=[
                            ("4", "Grade 4 - Life-threatening"),
                            ("5", "Grade 5 - Death"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="If severity increased, indicate grade",
                    ),
                ),
                (
                    "relevant_history",
                    models.TextField(
                        help_text="Indicate Adverse Event, clinical results,medications given, dosage,treatment plan and outcomes.",
                        max_length=1000,
                        verbose_name="Description summary of Adverse Event outcome",
                    ),
                ),
                (
                    "followup",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="Yes",
                        help_text="If NO, this will be considered the final report",
                        max_length=15,
                        verbose_name="Is a follow-up to this report required?",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "ae_initial",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="mapitio_ae.AeInitial",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.ActionItem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.Site",
                    ),
                ),
            ],
            options={"verbose_name": "AE Follow-up Report", "abstract": False,},
            managers=[
                ("on_site", edc_action_item.managers.ActionIdentifierSiteManager()),
                ("objects", edc_action_item.managers.ActionIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="DeathReportTmgSecond",
            fields=[],
            options={
                "verbose_name": "Death Report TMG (2nd)",
                "verbose_name_plural": "Death Report TMG (2nd)",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("mapitio_ae.deathreporttmg",),
            managers=[
                (
                    "on_site",
                    edc_adverse_event.model_mixins.death_report_tmg_model_mixin.DeathReportTmgSecondSiteManager(),
                ),
                (
                    "objects",
                    edc_adverse_event.model_mixins.death_report_tmg_model_mixin.DeathReportTmgSecondManager(),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="deathreporttmg",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_2900c3_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="deathreport",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_208260_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="aetmg",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_5ad0ff_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="aesusar",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_3c46f4_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="aeinitial",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_8b22bc_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="aefollowup",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="mapitio_ae__subject_779f86_idx",
            ),
        ),
    ]
