from django.conf import settings
from edc_constants.constants import (
    NORMAL,
    NOT_DONE,
    OTHER,
    DEAD,
    NOT_APPLICABLE,
    UNKNOWN,
)
from edc_list_data import PreloadData
from mapitio_prn.constants import (
    WITHDRAWAL,
    TRANSFERRED,
    LATE_EXCLUSION,
    OTHER_RX_DISCONTINUATION,
)

list_data = {
    "mapitio_lists.echofindings": [
        (NORMAL, "Normal"),
        ("aorta", "Aorta (abnormal)"),
        ("left_atrium_size", "Left atrium size and function (abnormal)"),
        ("left_vetricular_size", "Left ventricular size and function (abnormal)"),
        ("pericardial_effusions", "Pericardial effusions (present)"),
        ("pulmonary_hypertension", "Pulmonary hypertension (present)"),
        ("right_atrium_size", "Right atrium size and function (abnormal)"),
        ("right_ventricular_size", "Right ventricular size and function (abnormal)"),
        ("valvular_function", "Valvular function (abnormal)"),
        (NOT_DONE, "Not done ---"),
        (OTHER, "Other finding(s) ..."),
    ],
    "mapitio_lists.ecgfindings": [
        (NORMAL, "Normal"),
        ("heart_arrhythmias", "Heart arrhythmias"),
        ("ischaemic_heart_disease", "Ischaemic heart disease"),
        ("left_ventricular_hypertrophy", "Left ventricular hypertrophy"),
        (NOT_DONE, "Not done ---"),
        (OTHER, "Other finding(s) ..."),
    ],
    "mapitio_lists.chestxrayfindings": [
        (NORMAL, "Normal"),
        ("cardiomegaly", "Cardiomegaly"),
        ("pcp", "PCP"),
        ("pleural_effusion", "Pleural effusion"),
        ("pneumonia", "Pneumonia"),
        (NOT_DONE, "Not done ---"),
        (OTHER, "Other finding(s) ..."),
    ],
    "mapitio_lists.cholesterolmedications": [
        ("atorvastatin", "Atorvastatin"),
        ("simvastatin", "Simvastatin"),
        (NOT_APPLICABLE, "Not applicable  ---"),
        (OTHER, "Other treatment (specify below)"),
    ],
    "mapitio_lists.conditions": [
        ("diabetes", "Patient has high blood sugar (Diabetes)"),
        ("hiv_infection", "Patient has HIV infection (HIV+)"),
        ("hypertension", "Patient has high blood pressure (Hypertension)"),
    ],
    "mapitio_lists.offstudyreasons": [
        ("completed_followup", "Patient completed 12 months of follow-up"),
        ("clinical_endpoint", "Patient reached a clinical endpoint"),
        ("toxicity", "Patient experienced an unacceptable toxicity"),
        (
            "mapitiorcurrent_illness",
            "Intercurrent illness which prevents further treatment",
        ),
        ("lost_to_followup", "Patient lost to follow-up"),
        (DEAD, "Patient reported/known to have died"),
        (WITHDRAWAL, "Patient withdrew consent to participate further"),
        (LATE_EXCLUSION, "Patient fulfilled late exclusion criteria*"),
        (TRANSFERRED, "Patient has been transferred to another health centre"),
        (
            OTHER_RX_DISCONTINUATION,
            "Other condition that justifies the discontinuation of "
            "treatment in the clinician’s opinion (specify below)",
        ),
        (OTHER, "Other reason (specify below) ...",),
    ],
    "mapitio_lists.hypertensionmedications": [
        ("aldactone", "Aldactone"),
        ("amlodipine", "Amlodipine"),
        ("asomex", "Asomex"),
        ("atenolol", "Atenolol"),
        ("bendroflumethiazide", "Bendroflumethiazide"),
        ("captopril", "Captopril"),
        ("carvedilol", "Carvedilol"),
        ("enalapril", "Enalapril"),
        ("frusemide", "Frusemide"),
        ("losartan", "Losartan"),
        ("metoprolol", "Metoprolol"),
        ("nifedipine", "Nifedipine"),
        ("ramipril", "Ramipril"),
        ("simvastatin", "Simvastatin"),
        ("valsartan", "Valsartan"),
        (UNKNOWN, "Unknown  ---"),
        (NOT_APPLICABLE, "Not applicable  ---"),
        (OTHER, "Other treatment (specify below) ..."),
    ],
    "mapitio_lists.arvregimens": [
        (NOT_APPLICABLE, "Not applicable  ---"),
        ("ABC_3TC_ATV_r", "ABC + 3TC + ATV/r"),
        ("ABC_3TC_LPV_r", "ABC + 3TC + LPV/r"),
        ("AZT_3TC_ATV_r", "AZT + 3TC + ATV/r"),
        ("AZT_3TC_EFV", "AZT + 3TC + EFV"),
        ("AZT_3TC_LPV_r", "AZT + 3TC + LPV/r"),
        ("AZT_3TC_NVP", "AZT + 3TC + NVP"),
        ("D4T_3TC_NVP", "D4T + 3TC + NVP"),
        ("DTG_ABC/3TC_ATV_r", "DTG + (ABC/3TC) + ATV/r"),
        ("TDF_3TC_ATV_r", "TDF + 3TC + ATV/r"),
        ("TDF_3TC_DTG", "TDF + 3TC + DTG"),
        ("TDF_3TC_EFV", "TDF + 3TC + EFV"),
        ("TDF_3TC_LPV_r", "TDF + 3TC + LPV/r"),
        ("TDF_FTC_ATV_r", "TDF + FTC + ATV/r"),
        ("TDF_FTC_EFV", "TDF + FTC + EFV"),
        ("TDF_FTC_LPV_r", "TDF + FTC + LPV/r"),
        ("ZDV_3TC_EFV", "ZDV + 3TC + EFV"),
        ("ZDV_3TC_NVP", "ZDV + 3TC + NVP"),
        ("ZDV_LPV_NVP", "ZDV + LPV + NVP"),
        (OTHER, "Other, specify ..."),
    ],
    "mapitio_lists.visitreasons": [
        ("clinic_review", "Clinic Review"),
        ("drug_refill", "Drug Refill"),
        ("unscheduled", "Unscheduled"),
        ("unwell", "Feeling unwell (self referral)"),
    ],
    "mapitio_lists.diabetesmedications": [
        ("glibenclamide_s", "Glibenclamide (S)"),
        ("gliclazide_s", "Gliclazide (S)"),
        ("glimepiride_s", "Glimepiride (S)"),
        ("glipizide_s", "Glipizide (S)"),
        ("insulin", "Insulin"),
        ("metformin_b", "Metformin (B)"),
        (UNKNOWN, "Unknown  ---"),
        (NOT_APPLICABLE, "Not applicable  ---"),
        (OTHER, "Other, specify ..."),
    ],
}


if settings.APP_NAME != "mapitio_lists":
    preload_data = PreloadData(list_data=list_data)
