# Generated by Django 2.2.4 on 2019-08-29 20:51

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('psu_base', '0009_auto_20190822_1702'),
    ]

    operations = [
        migrations.CreateModel(
            name='Email',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app_code', models.CharField(help_text='Application that this email belongs to.', max_length=15, verbose_name='Application Code')),
                ('url', models.CharField(blank=True, help_text='This holds the URL from which the email was sent', max_length=128, null=True)),
                ('initiator', models.CharField(blank=True, help_text='This holds the logged-in user (which could be a provisional email address)', max_length=128, null=True)),
                ('date_created', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(help_text='Indicates the status of the email (sent, failed, etc)', max_length=1)),
                ('error_message', models.CharField(blank=True, help_text='Holds any error that may have been encountered', max_length=128, null=True)),
                ('subject', models.CharField(help_text='Email subject', max_length=128)),
                ('content', models.CharField(help_text='Email content', max_length=4000)),
                ('sender', models.CharField(help_text='Email address the email was sent from', max_length=128)),
                ('to', models.CharField(blank=True, help_text='Email addresses the email was sent to', max_length=4000, null=True)),
                ('cc', models.CharField(blank=True, help_text='Email addresses the email was copied to', max_length=4000, null=True)),
                ('bcc', models.CharField(blank=True, help_text='Email addresses the email was blind-copied to', max_length=4000, null=True)),
                ('email_template', models.CharField(blank=True, help_text='This holds the path of the template used for the email', max_length=128, null=True)),
                ('context', models.CharField(blank=True, help_text='Email addresses the email was blind-copied to', max_length=4000, null=True)),
                ('max_recipients', models.IntegerField(help_text='The maximum number of addresses this email could have been sent to')),
            ],
        ),
    ]
