# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDbNodeConsoleHistoryContentResult',
    'AwaitableGetDbNodeConsoleHistoryContentResult',
    'get_db_node_console_history_content',
    'get_db_node_console_history_content_output',
]

@pulumi.output_type
class GetDbNodeConsoleHistoryContentResult:
    """
    A collection of values returned by getDbNodeConsoleHistoryContent.
    """
    def __init__(__self__, console_history_id=None, db_node_id=None, id=None):
        if console_history_id and not isinstance(console_history_id, str):
            raise TypeError("Expected argument 'console_history_id' to be a str")
        pulumi.set(__self__, "console_history_id", console_history_id)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="consoleHistoryId")
    def console_history_id(self) -> str:
        return pulumi.get(self, "console_history_id")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDbNodeConsoleHistoryContentResult(GetDbNodeConsoleHistoryContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeConsoleHistoryContentResult(
            console_history_id=self.console_history_id,
            db_node_id=self.db_node_id,
            id=self.id)


def get_db_node_console_history_content(console_history_id: Optional[str] = None,
                                        db_node_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeConsoleHistoryContentResult:
    """
    This data source provides details about a specific Db Node Console History Content resource in Oracle Cloud Infrastructure Database service.

    Retrieves the specified database node console history contents upto a megabyte.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_history_content = oci.Database.get_db_node_console_history_content(console_history_id=oci_core_console_history["test_console_history"]["id"],
        db_node_id=oci_database_db_node["test_db_node"]["id"])
    ```


    :param str console_history_id: The OCID of the console history.
    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['consoleHistoryId'] = console_history_id
    __args__['dbNodeId'] = db_node_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeConsoleHistoryContent:getDbNodeConsoleHistoryContent', __args__, opts=opts, typ=GetDbNodeConsoleHistoryContentResult).value

    return AwaitableGetDbNodeConsoleHistoryContentResult(
        console_history_id=pulumi.get(__ret__, 'console_history_id'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_db_node_console_history_content)
def get_db_node_console_history_content_output(console_history_id: Optional[pulumi.Input[str]] = None,
                                               db_node_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodeConsoleHistoryContentResult]:
    """
    This data source provides details about a specific Db Node Console History Content resource in Oracle Cloud Infrastructure Database service.

    Retrieves the specified database node console history contents upto a megabyte.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_history_content = oci.Database.get_db_node_console_history_content(console_history_id=oci_core_console_history["test_console_history"]["id"],
        db_node_id=oci_database_db_node["test_db_node"]["id"])
    ```


    :param str console_history_id: The OCID of the console history.
    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
