# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApplicationApplicationLogConfigArgs',
    'ApplicationDriverShapeConfigArgs',
    'ApplicationExecutorShapeConfigArgs',
    'ApplicationParameterArgs',
    'InvokeRunApplicationLogConfigArgs',
    'InvokeRunDriverShapeConfigArgs',
    'InvokeRunExecutorShapeConfigArgs',
    'InvokeRunParameterArgs',
    'PoolConfigurationArgs',
    'PoolConfigurationShapeConfigArgs',
    'PoolPoolMetricArgs',
    'PoolPoolMetricActivelyUsedNodeCountArgs',
    'PoolScheduleArgs',
    'PrivateEndpointScanDetailArgs',
    'RunStatementOutputArgs',
    'RunStatementOutputDataArgs',
    'SqlEndpointDriverShapeConfigArgs',
    'SqlEndpointExecutorShapeConfigArgs',
    'SqlEndpointNetworkConfigurationArgs',
    'SqlEndpointNetworkConfigurationAccessControlRuleArgs',
    'GetApplicationsFilterArgs',
    'GetInvokeRunsFilterArgs',
    'GetPoolsFilterArgs',
    'GetPrivateEndpointsFilterArgs',
    'GetRunLogsFilterArgs',
    'GetRunStatementsFilterArgs',
    'GetSqlEndpointsFilterArgs',
]

@pulumi.input_type
class ApplicationApplicationLogConfigArgs:
    def __init__(__self__, *,
                 log_group_id: pulumi.Input[str],
                 log_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_group_id: (Updatable) The log group id for where log objects will be for Data Flow Runs.
        :param pulumi.Input[str] log_id: (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")

    @log_id.setter
    def log_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_id", value)


@pulumi.input_type
class ApplicationDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class ApplicationExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class ApplicationParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param pulumi.Input[str] value: (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        (Updatable) The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class InvokeRunApplicationLogConfigArgs:
    def __init__(__self__, *,
                 log_group_id: pulumi.Input[str],
                 log_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] log_group_id: The log group id for where log objects will be for Data Flow Runs.
        :param pulumi.Input[str] log_id: The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        pulumi.set(__self__, "log_group_id", log_group_id)
        pulumi.set(__self__, "log_id", log_id)

    @property
    @pulumi.getter(name="logGroupId")
    def log_group_id(self) -> pulumi.Input[str]:
        """
        The log group id for where log objects will be for Data Flow Runs.
        """
        return pulumi.get(self, "log_group_id")

    @log_group_id.setter
    def log_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_group_id", value)

    @property
    @pulumi.getter(name="logId")
    def log_id(self) -> pulumi.Input[str]:
        """
        The log id of the log object the Application Logs of Data Flow Run will be shipped to.
        """
        return pulumi.get(self, "log_id")

    @log_id.setter
    def log_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "log_id", value)


@pulumi.input_type
class InvokeRunDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class InvokeRunExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class InvokeRunParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        :param pulumi.Input[str] value: The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value of the parameter. It must be a string of 0 or more characters of any kind. Examples: "" (empty string), "10", "mydata.xml", "${x}"
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PoolConfigurationArgs:
    def __init__(__self__, *,
                 max: Optional[pulumi.Input[int]] = None,
                 min: Optional[pulumi.Input[int]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_config: Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']] = None):
        """
        :param pulumi.Input[int] max: (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        :param pulumi.Input[int] min: (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        :param pulumi.Input[str] shape: (Updatable) The compute shape of the resources you would like to provision.
        :param pulumi.Input['PoolConfigurationShapeConfigArgs'] shape_config: (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)

    @property
    @pulumi.getter
    def max(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Maximum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max", value)

    @property
    @pulumi.getter
    def min(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Minimum number of compute instances in the pool for a given compute shape.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compute shape of the resources you would like to provision.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']]:
        """
        (Updatable) This is used to configure the shape of the driver or executor if a flexible shape is used.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['PoolConfigurationShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)


@pulumi.input_type
class PoolConfigurationShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: (Updatable) The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class PoolPoolMetricArgs:
    def __init__(__self__, *,
                 active_runs_count: Optional[pulumi.Input[str]] = None,
                 actively_used_node_counts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]] = None,
                 time_last_metrics_updated: Optional[pulumi.Input[str]] = None,
                 time_last_started: Optional[pulumi.Input[str]] = None,
                 time_last_stopped: Optional[pulumi.Input[str]] = None,
                 time_last_used: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] active_runs_count: The number of runs that are currently running that are using this pool.
        :param pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]] actively_used_node_counts: A count of the nodes that are currently being used for each shape in this pool.
        :param pulumi.Input[str] time_last_metrics_updated: The last time the mertics were updated for this.
        :param pulumi.Input[str] time_last_started: The last time this pool was started.
        :param pulumi.Input[str] time_last_stopped: The last time this pool was stopped.
        :param pulumi.Input[str] time_last_used: The last time a run used this pool.
        """
        if active_runs_count is not None:
            pulumi.set(__self__, "active_runs_count", active_runs_count)
        if actively_used_node_counts is not None:
            pulumi.set(__self__, "actively_used_node_counts", actively_used_node_counts)
        if time_last_metrics_updated is not None:
            pulumi.set(__self__, "time_last_metrics_updated", time_last_metrics_updated)
        if time_last_started is not None:
            pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped is not None:
            pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_last_used is not None:
            pulumi.set(__self__, "time_last_used", time_last_used)

    @property
    @pulumi.getter(name="activeRunsCount")
    def active_runs_count(self) -> Optional[pulumi.Input[str]]:
        """
        The number of runs that are currently running that are using this pool.
        """
        return pulumi.get(self, "active_runs_count")

    @active_runs_count.setter
    def active_runs_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_runs_count", value)

    @property
    @pulumi.getter(name="activelyUsedNodeCounts")
    def actively_used_node_counts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]]:
        """
        A count of the nodes that are currently being used for each shape in this pool.
        """
        return pulumi.get(self, "actively_used_node_counts")

    @actively_used_node_counts.setter
    def actively_used_node_counts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolPoolMetricActivelyUsedNodeCountArgs']]]]):
        pulumi.set(self, "actively_used_node_counts", value)

    @property
    @pulumi.getter(name="timeLastMetricsUpdated")
    def time_last_metrics_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last time the mertics were updated for this.
        """
        return pulumi.get(self, "time_last_metrics_updated")

    @time_last_metrics_updated.setter
    def time_last_metrics_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_metrics_updated", value)

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[pulumi.Input[str]]:
        """
        The last time this pool was started.
        """
        return pulumi.get(self, "time_last_started")

    @time_last_started.setter
    def time_last_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_started", value)

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[pulumi.Input[str]]:
        """
        The last time this pool was stopped.
        """
        return pulumi.get(self, "time_last_stopped")

    @time_last_stopped.setter
    def time_last_stopped(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_stopped", value)

    @property
    @pulumi.getter(name="timeLastUsed")
    def time_last_used(self) -> Optional[pulumi.Input[str]]:
        """
        The last time a run used this pool.
        """
        return pulumi.get(self, "time_last_used")

    @time_last_used.setter
    def time_last_used(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_used", value)


@pulumi.input_type
class PoolPoolMetricActivelyUsedNodeCountArgs:
    def __init__(__self__, *,
                 logical_shape: Optional[pulumi.Input[str]] = None,
                 pool_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] logical_shape: The compute shape of the nodes that the count is for.
        :param pulumi.Input[int] pool_count: The node count of this compute shape.
        """
        if logical_shape is not None:
            pulumi.set(__self__, "logical_shape", logical_shape)
        if pool_count is not None:
            pulumi.set(__self__, "pool_count", pool_count)

    @property
    @pulumi.getter(name="logicalShape")
    def logical_shape(self) -> Optional[pulumi.Input[str]]:
        """
        The compute shape of the nodes that the count is for.
        """
        return pulumi.get(self, "logical_shape")

    @logical_shape.setter
    def logical_shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_shape", value)

    @property
    @pulumi.getter(name="poolCount")
    def pool_count(self) -> Optional[pulumi.Input[int]]:
        """
        The node count of this compute shape.
        """
        return pulumi.get(self, "pool_count")

    @pool_count.setter
    def pool_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "pool_count", value)


@pulumi.input_type
class PoolScheduleArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[int]] = None,
                 stop_time: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] day_of_week: (Updatable) Day of the week SUN-SAT
        :param pulumi.Input[int] start_time: (Updatable) Hour of the day to start or stop pool.
        :param pulumi.Input[int] stop_time: (Updatable) Hour of the day to stop the pool.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if stop_time is not None:
            pulumi.set(__self__, "stop_time", stop_time)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Day of the week SUN-SAT
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Hour of the day to start or stop pool.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Hour of the day to stop the pool.
        """
        return pulumi.get(self, "stop_time")

    @stop_time.setter
    def stop_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stop_time", value)


@pulumi.input_type
class PrivateEndpointScanDetailArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] fqdn: (Updatable) A fully-qualified domain name (FQDN).
        :param pulumi.Input[str] port: (Updatable) The port number of the FQDN
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A fully-qualified domain name (FQDN).
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The port number of the FQDN
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class RunStatementOutputArgs:
    def __init__(__self__, *,
                 datas: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]] = None,
                 error_name: Optional[pulumi.Input[str]] = None,
                 error_value: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tracebacks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]] datas: An object representing execution output of a statement.
        :param pulumi.Input[str] error_name: The name of the error in the statement output.
        :param pulumi.Input[str] error_value: The value of the error in the statement output.
        :param pulumi.Input[str] status: Status of the statement output.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tracebacks: The traceback of the statement output.
        """
        if datas is not None:
            pulumi.set(__self__, "datas", datas)
        if error_name is not None:
            pulumi.set(__self__, "error_name", error_name)
        if error_value is not None:
            pulumi.set(__self__, "error_value", error_value)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tracebacks is not None:
            pulumi.set(__self__, "tracebacks", tracebacks)

    @property
    @pulumi.getter
    def datas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]]:
        """
        An object representing execution output of a statement.
        """
        return pulumi.get(self, "datas")

    @datas.setter
    def datas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunStatementOutputDataArgs']]]]):
        pulumi.set(self, "datas", value)

    @property
    @pulumi.getter(name="errorName")
    def error_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the error in the statement output.
        """
        return pulumi.get(self, "error_name")

    @error_name.setter
    def error_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_name", value)

    @property
    @pulumi.getter(name="errorValue")
    def error_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the error in the statement output.
        """
        return pulumi.get(self, "error_value")

    @error_value.setter
    def error_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_value", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the statement output.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tracebacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The traceback of the statement output.
        """
        return pulumi.get(self, "tracebacks")

    @tracebacks.setter
    def tracebacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tracebacks", value)


@pulumi.input_type
class RunStatementOutputDataArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        :param pulumi.Input[str] value: The statement code execution output in html format.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the `StatementOutputData` like `TEXT_PLAIN`, `TEXT_HTML` or `IMAGE_PNG`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The statement code execution output in html format.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class SqlEndpointDriverShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class SqlEndpointExecutorShapeConfigArgs:
    def __init__(__self__, *,
                 memory_in_gbs: Optional[pulumi.Input[float]] = None,
                 ocpus: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] memory_in_gbs: The amount of memory used for the driver or executors.
        :param pulumi.Input[float] ocpus: The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        if memory_in_gbs is not None:
            pulumi.set(__self__, "memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            pulumi.set(__self__, "ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory used for the driver or executors.
        """
        return pulumi.get(self, "memory_in_gbs")

    @memory_in_gbs.setter
    def memory_in_gbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory_in_gbs", value)

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of OCPUs used for the driver or executors. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")

    @ocpus.setter
    def ocpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpus", value)


@pulumi.input_type
class SqlEndpointNetworkConfigurationArgs:
    def __init__(__self__, *,
                 network_type: pulumi.Input[str],
                 access_control_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]] = None,
                 host_name_prefix: Optional[pulumi.Input[str]] = None,
                 private_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 public_endpoint_ip: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vcn_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] network_type: The type of network configuration.
        :param pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]] access_control_rules: A list of SecureAccessControlRule's to which access is limited to
        :param pulumi.Input[str] host_name_prefix: The host name prefix.
        :param pulumi.Input[str] private_endpoint_ip: Ip Address of private endpoint
        :param pulumi.Input[str] public_endpoint_ip: Ip Address of public endpoint
        :param pulumi.Input[str] subnet_id: The VCN Subnet OCID.
        :param pulumi.Input[str] vcn_id: The VCN OCID.
        """
        pulumi.set(__self__, "network_type", network_type)
        if access_control_rules is not None:
            pulumi.set(__self__, "access_control_rules", access_control_rules)
        if host_name_prefix is not None:
            pulumi.set(__self__, "host_name_prefix", host_name_prefix)
        if private_endpoint_ip is not None:
            pulumi.set(__self__, "private_endpoint_ip", private_endpoint_ip)
        if public_endpoint_ip is not None:
            pulumi.set(__self__, "public_endpoint_ip", public_endpoint_ip)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Input[str]:
        """
        The type of network configuration.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="accessControlRules")
    def access_control_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]]:
        """
        A list of SecureAccessControlRule's to which access is limited to
        """
        return pulumi.get(self, "access_control_rules")

    @access_control_rules.setter
    def access_control_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlEndpointNetworkConfigurationAccessControlRuleArgs']]]]):
        pulumi.set(self, "access_control_rules", value)

    @property
    @pulumi.getter(name="hostNamePrefix")
    def host_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The host name prefix.
        """
        return pulumi.get(self, "host_name_prefix")

    @host_name_prefix.setter
    def host_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name_prefix", value)

    @property
    @pulumi.getter(name="privateEndpointIp")
    def private_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ip Address of private endpoint
        """
        return pulumi.get(self, "private_endpoint_ip")

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_endpoint_ip", value)

    @property
    @pulumi.getter(name="publicEndpointIp")
    def public_endpoint_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Ip Address of public endpoint
        """
        return pulumi.get(self, "public_endpoint_ip")

    @public_endpoint_ip.setter
    def public_endpoint_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_endpoint_ip", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VCN Subnet OCID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VCN OCID.
        """
        return pulumi.get(self, "vcn_id")

    @vcn_id.setter
    def vcn_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_id", value)


@pulumi.input_type
class SqlEndpointNetworkConfigurationAccessControlRuleArgs:
    def __init__(__self__, *,
                 ip_notation: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 vcn_ips: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ip_notation: The type of IP notation.
        :param pulumi.Input[str] value: The associated value of the selected IP notation.
        :param pulumi.Input[str] vcn_ips: A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        if ip_notation is not None:
            pulumi.set(__self__, "ip_notation", ip_notation)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if vcn_ips is not None:
            pulumi.set(__self__, "vcn_ips", vcn_ips)

    @property
    @pulumi.getter(name="ipNotation")
    def ip_notation(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP notation.
        """
        return pulumi.get(self, "ip_notation")

    @ip_notation.setter
    def ip_notation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_notation", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The associated value of the selected IP notation.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="vcnIps")
    def vcn_ips(self) -> Optional[pulumi.Input[str]]:
        """
        A comma-separated IP or CIDR address for VCN OCID IP notation selection.
        """
        return pulumi.get(self, "vcn_ips")

    @vcn_ips.setter
    def vcn_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vcn_ips", value)


@pulumi.input_type
class GetApplicationsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetInvokeRunsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameter.  It must be a string of one or more word characters (a-z, A-Z, 0-9, _). Examples: "iterations", "input_file"
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetPoolsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetPrivateEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetRunLogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetRunStatementsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSqlEndpointsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


