# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 connection_type: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 technology_type: pulumi.Input[str],
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 connection_factory: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_url: Optional[pulumi.Input[str]] = None,
                 consumer_properties: Optional[pulumi.Input[str]] = None,
                 core_site_xml: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 jndi_connection_factory: Optional[pulumi.Input[str]] = None,
                 jndi_initial_context_factory: Optional[pulumi.Input[str]] = None,
                 jndi_provider_url: Optional[pulumi.Input[str]] = None,
                 jndi_security_credentials: Optional[pulumi.Input[str]] = None,
                 jndi_security_principal: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 producer_properties: Optional[pulumi.Input[str]] = None,
                 public_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_method: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[str]] = None,
                 service_account_key_file: Optional[pulumi.Input[str]] = None,
                 session_mode: Optional[pulumi.Input[str]] = None,
                 should_use_jndi: Optional[pulumi.Input[bool]] = None,
                 should_validate_server_certificate: Optional[pulumi.Input[bool]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 ssl_cert: Optional[pulumi.Input[str]] = None,
                 ssl_crl: Optional[pulumi.Input[str]] = None,
                 ssl_key: Optional[pulumi.Input[str]] = None,
                 ssl_key_password: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None,
                 trust_store_password: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 wallet: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[str] connection_type: (Updatable) The connection type.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] technology_type: The Kafka (e.g. Confluent) Schema Registry technology type.
        :param pulumi.Input[str] access_key_id: (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] account_key: (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        :param pulumi.Input[str] account_name: (Updatable) Sets the Azure storage account name.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]] additional_attributes: (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        :param pulumi.Input[str] authentication_type: (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] azure_tenant_id: (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]] bootstrap_servers: (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        :param pulumi.Input[str] client_id: (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        :param pulumi.Input[str] client_secret: (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        :param pulumi.Input[str] connection_factory: (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        :param pulumi.Input[str] connection_string: (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        :param pulumi.Input[str] connection_url: (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        :param pulumi.Input[str] consumer_properties: (Updatable) The base64 encoded content of the consumer.properties file.
        :param pulumi.Input[str] core_site_xml: (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        :param pulumi.Input[str] database_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        :param pulumi.Input[str] database_name: (Updatable) The name of the database.
        :param pulumi.Input[str] db_system_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] endpoint: (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        :param pulumi.Input[str] fingerprint: (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host: (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
               For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        :param pulumi.Input[str] jndi_connection_factory: (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        :param pulumi.Input[str] jndi_initial_context_factory: (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        :param pulumi.Input[str] jndi_provider_url: (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        :param pulumi.Input[str] jndi_security_credentials: (Updatable) The password associated to the principal.
        :param pulumi.Input[str] jndi_security_principal: (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        :param pulumi.Input[str] key_id: (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param pulumi.Input[str] key_store: (Updatable) The base64 encoded content of the KeyStore file.
        :param pulumi.Input[str] key_store_password: (Updatable) The KeyStore password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[str] password: (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        :param pulumi.Input[int] port: (Updatable) The port of an endpoint usually specified for a connection.
        :param pulumi.Input[str] private_ip: (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
               The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        :param pulumi.Input[str] private_key_file: (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] private_key_passphrase: (Updatable) Password if the private key file is encrypted.
        :param pulumi.Input[str] producer_properties: (Updatable) The base64 encoded content of the producer.properties file.
        :param pulumi.Input[str] public_key_fingerprint: (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] region: (Updatable) The name of the region. e.g.: us-ashburn-1
        :param pulumi.Input[str] routing_method: (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        :param pulumi.Input[str] sas_token: (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        :param pulumi.Input[str] secret_access_key: (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] security_protocol: (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] servers: (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        :param pulumi.Input[str] service_account_key_file: (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        :param pulumi.Input[str] session_mode: (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param pulumi.Input[bool] should_use_jndi: (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        :param pulumi.Input[bool] should_validate_server_certificate: (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        :param pulumi.Input[str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        :param pulumi.Input[str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[str] ssl_key_password: (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        :param pulumi.Input[str] ssl_mode: (Updatable) SSL modes for PostgreSQL.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        :param pulumi.Input[str] tenancy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        :param pulumi.Input[str] trust_store: (Updatable) The base64 encoded content of the TrustStore file.
        :param pulumi.Input[str] trust_store_password: (Updatable) The TrustStore password.
        :param pulumi.Input[str] url: (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        :param pulumi.Input[str] user_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        :param pulumi.Input[str] username: (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        :param pulumi.Input[str] vault_id: (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        :param pulumi.Input[str] wallet: (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "technology_type", technology_type)
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if azure_tenant_id is not None:
            pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if bootstrap_servers is not None:
            pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if connection_factory is not None:
            pulumi.set(__self__, "connection_factory", connection_factory)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if consumer_properties is not None:
            pulumi.set(__self__, "consumer_properties", consumer_properties)
        if core_site_xml is not None:
            pulumi.set(__self__, "core_site_xml", core_site_xml)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if jndi_connection_factory is not None:
            pulumi.set(__self__, "jndi_connection_factory", jndi_connection_factory)
        if jndi_initial_context_factory is not None:
            pulumi.set(__self__, "jndi_initial_context_factory", jndi_initial_context_factory)
        if jndi_provider_url is not None:
            pulumi.set(__self__, "jndi_provider_url", jndi_provider_url)
        if jndi_security_credentials is not None:
            pulumi.set(__self__, "jndi_security_credentials", jndi_security_credentials)
        if jndi_security_principal is not None:
            pulumi.set(__self__, "jndi_security_principal", jndi_security_principal)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_store is not None:
            pulumi.set(__self__, "key_store", key_store)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_key_file is not None:
            pulumi.set(__self__, "private_key_file", private_key_file)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if producer_properties is not None:
            pulumi.set(__self__, "producer_properties", producer_properties)
        if public_key_fingerprint is not None:
            pulumi.set(__self__, "public_key_fingerprint", public_key_fingerprint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_method is not None:
            pulumi.set(__self__, "routing_method", routing_method)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service_account_key_file is not None:
            pulumi.set(__self__, "service_account_key_file", service_account_key_file)
        if session_mode is not None:
            pulumi.set(__self__, "session_mode", session_mode)
        if should_use_jndi is not None:
            pulumi.set(__self__, "should_use_jndi", should_use_jndi)
        if should_validate_server_certificate is not None:
            pulumi.set(__self__, "should_validate_server_certificate", should_validate_server_certificate)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_crl is not None:
            pulumi.set(__self__, "ssl_crl", ssl_crl)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_key_password is not None:
            pulumi.set(__self__, "ssl_key_password", ssl_key_password)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if stream_pool_id is not None:
            pulumi.set(__self__, "stream_pool_id", stream_pool_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if trust_store is not None:
            pulumi.set(__self__, "trust_store", trust_store)
        if trust_store_password is not None:
            pulumi.set(__self__, "trust_store_password", trust_store_password)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if wallet is not None:
            pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The connection type.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> pulumi.Input[str]:
        """
        The Kafka (e.g. Confluent) Schema Registry technology type.
        """
        return pulumi.get(self, "technology_type")

    @technology_type.setter
    def technology_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "technology_type", value)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Sets the Azure storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]:
        """
        (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_tenant_id", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]]:
        """
        (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        """
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="connectionFactory")
    def connection_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        """
        return pulumi.get(self, "connection_factory")

    @connection_factory.setter
    def connection_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_factory", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        """
        return pulumi.get(self, "connection_url")

    @connection_url.setter
    def connection_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_url", value)

    @property
    @pulumi.getter(name="consumerProperties")
    def consumer_properties(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the consumer.properties file.
        """
        return pulumi.get(self, "consumer_properties")

    @consumer_properties.setter
    def consumer_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_properties", value)

    @property
    @pulumi.getter(name="coreSiteXml")
    def core_site_xml(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        """
        return pulumi.get(self, "core_site_xml")

    @core_site_xml.setter
    def core_site_xml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_site_xml", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
        For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="jndiConnectionFactory")
    def jndi_connection_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        """
        return pulumi.get(self, "jndi_connection_factory")

    @jndi_connection_factory.setter
    def jndi_connection_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_connection_factory", value)

    @property
    @pulumi.getter(name="jndiInitialContextFactory")
    def jndi_initial_context_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        """
        return pulumi.get(self, "jndi_initial_context_factory")

    @jndi_initial_context_factory.setter
    def jndi_initial_context_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_initial_context_factory", value)

    @property
    @pulumi.getter(name="jndiProviderUrl")
    def jndi_provider_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        """
        return pulumi.get(self, "jndi_provider_url")

    @jndi_provider_url.setter
    def jndi_provider_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_provider_url", value)

    @property
    @pulumi.getter(name="jndiSecurityCredentials")
    def jndi_security_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password associated to the principal.
        """
        return pulumi.get(self, "jndi_security_credentials")

    @jndi_security_credentials.setter
    def jndi_security_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_security_credentials", value)

    @property
    @pulumi.getter(name="jndiSecurityPrincipal")
    def jndi_security_principal(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        """
        return pulumi.get(self, "jndi_security_principal")

    @jndi_security_principal.setter
    def jndi_security_principal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_security_principal", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the KeyStore file.
        """
        return pulumi.get(self, "key_store")

    @key_store.setter
    def key_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The KeyStore password.
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "private_key_file")

    @private_key_file.setter
    def private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_file", value)

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Password if the private key file is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @property
    @pulumi.getter(name="producerProperties")
    def producer_properties(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the producer.properties file.
        """
        return pulumi.get(self, "producer_properties")

    @producer_properties.setter
    def producer_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "producer_properties", value)

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "public_key_fingerprint")

    @public_key_fingerprint.setter
    def public_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_fingerprint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the region. e.g.: us-ashburn-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingMethod")
    def routing_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        """
        return pulumi.get(self, "routing_method")

    @routing_method.setter
    def routing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_method", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="serviceAccountKeyFile")
    def service_account_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        """
        return pulumi.get(self, "service_account_key_file")

    @service_account_key_file.setter
    def service_account_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_key_file", value)

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @session_mode.setter
    def session_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_mode", value)

    @property
    @pulumi.getter(name="shouldUseJndi")
    def should_use_jndi(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        """
        return pulumi.get(self, "should_use_jndi")

    @should_use_jndi.setter
    def should_use_jndi(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_use_jndi", value)

    @property
    @pulumi.getter(name="shouldValidateServerCertificate")
    def should_validate_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        """
        return pulumi.get(self, "should_validate_server_certificate")

    @should_validate_server_certificate.setter
    def should_validate_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_validate_server_certificate", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cert", value)

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @ssl_crl.setter
    def ssl_crl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_crl", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter(name="sslKeyPassword")
    def ssl_key_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        """
        return pulumi.get(self, "ssl_key_password")

    @ssl_key_password.setter
    def ssl_key_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_key_password", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) SSL modes for PostgreSQL.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        """
        return pulumi.get(self, "stream_pool_id")

    @stream_pool_id.setter
    def stream_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_pool_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the TrustStore file.
        """
        return pulumi.get(self, "trust_store")

    @trust_store.setter
    def trust_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store", value)

    @property
    @pulumi.getter(name="trustStorePassword")
    def trust_store_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The TrustStore password.
        """
        return pulumi.get(self, "trust_store_password")

    @trust_store_password.setter
    def trust_store_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store_password", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter
    def wallet(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

    @wallet.setter
    def wallet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_factory: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 connection_url: Optional[pulumi.Input[str]] = None,
                 consumer_properties: Optional[pulumi.Input[str]] = None,
                 core_site_xml: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]] = None,
                 jndi_connection_factory: Optional[pulumi.Input[str]] = None,
                 jndi_initial_context_factory: Optional[pulumi.Input[str]] = None,
                 jndi_provider_url: Optional[pulumi.Input[str]] = None,
                 jndi_security_credentials: Optional[pulumi.Input[str]] = None,
                 jndi_security_principal: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 producer_properties: Optional[pulumi.Input[str]] = None,
                 public_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_method: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[str]] = None,
                 service_account_key_file: Optional[pulumi.Input[str]] = None,
                 session_mode: Optional[pulumi.Input[str]] = None,
                 should_use_jndi: Optional[pulumi.Input[bool]] = None,
                 should_validate_server_certificate: Optional[pulumi.Input[bool]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 ssl_cert: Optional[pulumi.Input[str]] = None,
                 ssl_crl: Optional[pulumi.Input[str]] = None,
                 ssl_key: Optional[pulumi.Input[str]] = None,
                 ssl_key_password: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 technology_type: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None,
                 trust_store_password: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 wallet: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[str] access_key_id: (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] account_key: (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        :param pulumi.Input[str] account_name: (Updatable) Sets the Azure storage account name.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]] additional_attributes: (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        :param pulumi.Input[str] authentication_type: (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] azure_tenant_id: (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]] bootstrap_servers: (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        :param pulumi.Input[str] client_id: (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        :param pulumi.Input[str] client_secret: (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[str] connection_factory: (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        :param pulumi.Input[str] connection_string: (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        :param pulumi.Input[str] connection_type: (Updatable) The connection type.
        :param pulumi.Input[str] connection_url: (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        :param pulumi.Input[str] consumer_properties: (Updatable) The base64 encoded content of the consumer.properties file.
        :param pulumi.Input[str] core_site_xml: (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        :param pulumi.Input[str] database_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        :param pulumi.Input[str] database_name: (Updatable) The name of the database.
        :param pulumi.Input[str] db_system_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] endpoint: (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        :param pulumi.Input[str] fingerprint: (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host: (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
               For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]] ingress_ips: List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        :param pulumi.Input[str] jndi_connection_factory: (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        :param pulumi.Input[str] jndi_initial_context_factory: (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        :param pulumi.Input[str] jndi_provider_url: (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        :param pulumi.Input[str] jndi_security_credentials: (Updatable) The password associated to the principal.
        :param pulumi.Input[str] jndi_security_principal: (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        :param pulumi.Input[str] key_id: (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param pulumi.Input[str] key_store: (Updatable) The base64 encoded content of the KeyStore file.
        :param pulumi.Input[str] key_store_password: (Updatable) The KeyStore password.
        :param pulumi.Input[str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[str] password: (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        :param pulumi.Input[int] port: (Updatable) The port of an endpoint usually specified for a connection.
        :param pulumi.Input[str] private_ip: (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
               The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        :param pulumi.Input[str] private_key_file: (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] private_key_passphrase: (Updatable) Password if the private key file is encrypted.
        :param pulumi.Input[str] producer_properties: (Updatable) The base64 encoded content of the producer.properties file.
        :param pulumi.Input[str] public_key_fingerprint: (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] region: (Updatable) The name of the region. e.g.: us-ashburn-1
        :param pulumi.Input[str] routing_method: (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        :param pulumi.Input[str] sas_token: (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        :param pulumi.Input[str] secret_access_key: (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] security_protocol: (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] servers: (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        :param pulumi.Input[str] service_account_key_file: (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        :param pulumi.Input[str] session_mode: (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param pulumi.Input[bool] should_use_jndi: (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        :param pulumi.Input[bool] should_validate_server_certificate: (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        :param pulumi.Input[str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        :param pulumi.Input[str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[str] ssl_key_password: (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        :param pulumi.Input[str] ssl_mode: (Updatable) SSL modes for PostgreSQL.
        :param pulumi.Input[str] state: Possible lifecycle states for connection.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] technology_type: The Kafka (e.g. Confluent) Schema Registry technology type.
        :param pulumi.Input[str] tenancy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] trust_store: (Updatable) The base64 encoded content of the TrustStore file.
        :param pulumi.Input[str] trust_store_password: (Updatable) The TrustStore password.
        :param pulumi.Input[str] url: (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        :param pulumi.Input[str] user_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        :param pulumi.Input[str] username: (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        :param pulumi.Input[str] vault_id: (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        :param pulumi.Input[str] wallet: (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if access_key_id is not None:
            pulumi.set(__self__, "access_key_id", access_key_id)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if azure_tenant_id is not None:
            pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if bootstrap_servers is not None:
            pulumi.set(__self__, "bootstrap_servers", bootstrap_servers)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_factory is not None:
            pulumi.set(__self__, "connection_factory", connection_factory)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if consumer_properties is not None:
            pulumi.set(__self__, "consumer_properties", consumer_properties)
        if core_site_xml is not None:
            pulumi.set(__self__, "core_site_xml", core_site_xml)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ingress_ips is not None:
            pulumi.set(__self__, "ingress_ips", ingress_ips)
        if jndi_connection_factory is not None:
            pulumi.set(__self__, "jndi_connection_factory", jndi_connection_factory)
        if jndi_initial_context_factory is not None:
            pulumi.set(__self__, "jndi_initial_context_factory", jndi_initial_context_factory)
        if jndi_provider_url is not None:
            pulumi.set(__self__, "jndi_provider_url", jndi_provider_url)
        if jndi_security_credentials is not None:
            pulumi.set(__self__, "jndi_security_credentials", jndi_security_credentials)
        if jndi_security_principal is not None:
            pulumi.set(__self__, "jndi_security_principal", jndi_security_principal)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_store is not None:
            pulumi.set(__self__, "key_store", key_store)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_key_file is not None:
            pulumi.set(__self__, "private_key_file", private_key_file)
        if private_key_passphrase is not None:
            pulumi.set(__self__, "private_key_passphrase", private_key_passphrase)
        if producer_properties is not None:
            pulumi.set(__self__, "producer_properties", producer_properties)
        if public_key_fingerprint is not None:
            pulumi.set(__self__, "public_key_fingerprint", public_key_fingerprint)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_method is not None:
            pulumi.set(__self__, "routing_method", routing_method)
        if sas_token is not None:
            pulumi.set(__self__, "sas_token", sas_token)
        if secret_access_key is not None:
            pulumi.set(__self__, "secret_access_key", secret_access_key)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)
        if service_account_key_file is not None:
            pulumi.set(__self__, "service_account_key_file", service_account_key_file)
        if session_mode is not None:
            pulumi.set(__self__, "session_mode", session_mode)
        if should_use_jndi is not None:
            pulumi.set(__self__, "should_use_jndi", should_use_jndi)
        if should_validate_server_certificate is not None:
            pulumi.set(__self__, "should_validate_server_certificate", should_validate_server_certificate)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_crl is not None:
            pulumi.set(__self__, "ssl_crl", ssl_crl)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_key_password is not None:
            pulumi.set(__self__, "ssl_key_password", ssl_key_password)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_pool_id is not None:
            pulumi.set(__self__, "stream_pool_id", stream_pool_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if technology_type is not None:
            pulumi.set(__self__, "technology_type", technology_type)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trust_store is not None:
            pulumi.set(__self__, "trust_store", trust_store)
        if trust_store_password is not None:
            pulumi.set(__self__, "trust_store_password", trust_store_password)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if wallet is not None:
            pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "access_key_id")

    @access_key_id.setter
    def access_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key_id", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Sets the Azure storage account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]:
        """
        (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authentication_type", value)

    @property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        """
        return pulumi.get(self, "azure_tenant_id")

    @azure_tenant_id.setter
    def azure_tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_tenant_id", value)

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]]:
        """
        (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        """
        return pulumi.get(self, "bootstrap_servers")

    @bootstrap_servers.setter
    def bootstrap_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionBootstrapServerArgs']]]]):
        pulumi.set(self, "bootstrap_servers", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionFactory")
    def connection_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        """
        return pulumi.get(self, "connection_factory")

    @connection_factory.setter
    def connection_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_factory", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The connection type.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        """
        return pulumi.get(self, "connection_url")

    @connection_url.setter
    def connection_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_url", value)

    @property
    @pulumi.getter(name="consumerProperties")
    def consumer_properties(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the consumer.properties file.
        """
        return pulumi.get(self, "consumer_properties")

    @consumer_properties.setter
    def consumer_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_properties", value)

    @property
    @pulumi.getter(name="coreSiteXml")
    def core_site_xml(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        """
        return pulumi.get(self, "core_site_xml")

    @core_site_xml.setter
    def core_site_xml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "core_site_xml", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
        For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]]:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @ingress_ips.setter
    def ingress_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]]):
        pulumi.set(self, "ingress_ips", value)

    @property
    @pulumi.getter(name="jndiConnectionFactory")
    def jndi_connection_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        """
        return pulumi.get(self, "jndi_connection_factory")

    @jndi_connection_factory.setter
    def jndi_connection_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_connection_factory", value)

    @property
    @pulumi.getter(name="jndiInitialContextFactory")
    def jndi_initial_context_factory(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        """
        return pulumi.get(self, "jndi_initial_context_factory")

    @jndi_initial_context_factory.setter
    def jndi_initial_context_factory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_initial_context_factory", value)

    @property
    @pulumi.getter(name="jndiProviderUrl")
    def jndi_provider_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        """
        return pulumi.get(self, "jndi_provider_url")

    @jndi_provider_url.setter
    def jndi_provider_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_provider_url", value)

    @property
    @pulumi.getter(name="jndiSecurityCredentials")
    def jndi_security_credentials(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password associated to the principal.
        """
        return pulumi.get(self, "jndi_security_credentials")

    @jndi_security_credentials.setter
    def jndi_security_credentials(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_security_credentials", value)

    @property
    @pulumi.getter(name="jndiSecurityPrincipal")
    def jndi_security_principal(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        """
        return pulumi.get(self, "jndi_security_principal")

    @jndi_security_principal.setter
    def jndi_security_principal(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jndi_security_principal", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the KeyStore file.
        """
        return pulumi.get(self, "key_store")

    @key_store.setter
    def key_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The KeyStore password.
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "private_key_file")

    @private_key_file.setter
    def private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_file", value)

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Password if the private key file is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @private_key_passphrase.setter
    def private_key_passphrase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key_passphrase", value)

    @property
    @pulumi.getter(name="producerProperties")
    def producer_properties(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the producer.properties file.
        """
        return pulumi.get(self, "producer_properties")

    @producer_properties.setter
    def producer_properties(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "producer_properties", value)

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "public_key_fingerprint")

    @public_key_fingerprint.setter
    def public_key_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_fingerprint", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the region. e.g.: us-ashburn-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routingMethod")
    def routing_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        """
        return pulumi.get(self, "routing_method")

    @routing_method.setter
    def routing_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "routing_method", value)

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        """
        return pulumi.get(self, "sas_token")

    @sas_token.setter
    def sas_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_token", value)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_access_key", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="serviceAccountKeyFile")
    def service_account_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        """
        return pulumi.get(self, "service_account_key_file")

    @service_account_key_file.setter
    def service_account_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_key_file", value)

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @session_mode.setter
    def session_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_mode", value)

    @property
    @pulumi.getter(name="shouldUseJndi")
    def should_use_jndi(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        """
        return pulumi.get(self, "should_use_jndi")

    @should_use_jndi.setter
    def should_use_jndi(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_use_jndi", value)

    @property
    @pulumi.getter(name="shouldValidateServerCertificate")
    def should_validate_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        """
        return pulumi.get(self, "should_validate_server_certificate")

    @should_validate_server_certificate.setter
    def should_validate_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "should_validate_server_certificate", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cert", value)

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @ssl_crl.setter
    def ssl_crl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_crl", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter(name="sslKeyPassword")
    def ssl_key_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        """
        return pulumi.get(self, "ssl_key_password")

    @ssl_key_password.setter
    def ssl_key_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_key_password", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) SSL modes for PostgreSQL.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Possible lifecycle states for connection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        """
        return pulumi.get(self, "stream_pool_id")

    @stream_pool_id.setter
    def stream_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_pool_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Kafka (e.g. Confluent) Schema Registry technology type.
        """
        return pulumi.get(self, "technology_type")

    @technology_type.setter
    def technology_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "technology_type", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The base64 encoded content of the TrustStore file.
        """
        return pulumi.get(self, "trust_store")

    @trust_store.setter
    def trust_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store", value)

    @property
    @pulumi.getter(name="trustStorePassword")
    def trust_store_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The TrustStore password.
        """
        return pulumi.get(self, "trust_store_password")

    @trust_store_password.setter
    def trust_store_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store_password", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter
    def wallet(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

    @wallet.setter
    def wallet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wallet", value)


class Connection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionAdditionalAttributeArgs']]]]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionBootstrapServerArgs']]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_factory: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 connection_url: Optional[pulumi.Input[str]] = None,
                 consumer_properties: Optional[pulumi.Input[str]] = None,
                 core_site_xml: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 jndi_connection_factory: Optional[pulumi.Input[str]] = None,
                 jndi_initial_context_factory: Optional[pulumi.Input[str]] = None,
                 jndi_provider_url: Optional[pulumi.Input[str]] = None,
                 jndi_security_credentials: Optional[pulumi.Input[str]] = None,
                 jndi_security_principal: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 producer_properties: Optional[pulumi.Input[str]] = None,
                 public_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_method: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[str]] = None,
                 service_account_key_file: Optional[pulumi.Input[str]] = None,
                 session_mode: Optional[pulumi.Input[str]] = None,
                 should_use_jndi: Optional[pulumi.Input[bool]] = None,
                 should_validate_server_certificate: Optional[pulumi.Input[bool]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 ssl_cert: Optional[pulumi.Input[str]] = None,
                 ssl_crl: Optional[pulumi.Input[str]] = None,
                 ssl_key: Optional[pulumi.Input[str]] = None,
                 ssl_key_password: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 technology_type: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None,
                 trust_store_password: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 wallet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.golden_gate.Connection("testConnection",
            compartment_id=var["compartment_id"],
            connection_type=var["connection_connection_type"],
            display_name=var["connection_display_name"],
            technology_type=var["connection_technology_type"],
            access_key_id=oci_kms_key["test_key"]["id"],
            account_key=var["connection_account_key"],
            account_name=var["connection_account_name"],
            additional_attributes=[oci.golden_gate.ConnectionAdditionalAttributeArgs(
                name=var["connection_additional_attributes_name"],
                value=var["connection_additional_attributes_value"],
            )],
            authentication_type=var["connection_authentication_type"],
            azure_tenant_id=oci_golden_gate_azure_tenant["test_azure_tenant"]["id"],
            bootstrap_servers=[oci.golden_gate.ConnectionBootstrapServerArgs(
                host=var["connection_bootstrap_servers_host"],
                port=var["connection_bootstrap_servers_port"],
                private_ip=var["connection_bootstrap_servers_private_ip"],
            )],
            client_id=oci_golden_gate_client["test_client"]["id"],
            client_secret=var["connection_client_secret"],
            connection_factory=var["connection_connection_factory"],
            connection_string=var["connection_connection_string"],
            connection_url=var["connection_connection_url"],
            consumer_properties=var["connection_consumer_properties"],
            core_site_xml=var["connection_core_site_xml"],
            database_id=oci_database_database["test_database"]["id"],
            database_name=oci_database_database["test_database"]["name"],
            db_system_id=oci_database_db_system["test_db_system"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
            description=var["connection_description"],
            endpoint=var["connection_endpoint"],
            fingerprint=var["connection_fingerprint"],
            freeform_tags={
                "bar-key": "value",
            },
            host=var["connection_host"],
            jndi_connection_factory=var["connection_jndi_connection_factory"],
            jndi_initial_context_factory=var["connection_jndi_initial_context_factory"],
            jndi_provider_url=var["connection_jndi_provider_url"],
            jndi_security_credentials=var["connection_jndi_security_credentials"],
            jndi_security_principal=var["connection_jndi_security_principal"],
            key_id=oci_kms_key["test_key"]["id"],
            key_store=var["connection_key_store"],
            key_store_password=var["connection_key_store_password"],
            nsg_ids=var["connection_nsg_ids"],
            password=var["connection_password"],
            port=var["connection_port"],
            private_ip=var["connection_private_ip"],
            private_key_file=var["connection_private_key_file"],
            private_key_passphrase=var["connection_private_key_passphrase"],
            producer_properties=var["connection_producer_properties"],
            public_key_fingerprint=var["connection_public_key_fingerprint"],
            region=var["connection_region"],
            routing_method=var["connection_routing_method"],
            sas_token=var["connection_sas_token"],
            secret_access_key=var["connection_secret_access_key"],
            security_protocol=var["connection_security_protocol"],
            servers=var["connection_servers"],
            service_account_key_file=var["connection_service_account_key_file"],
            session_mode=var["connection_session_mode"],
            should_use_jndi=var["connection_should_use_jndi"],
            should_validate_server_certificate=var["connection_should_validate_server_certificate"],
            ssl_ca=var["connection_ssl_ca"],
            ssl_cert=var["connection_ssl_cert"],
            ssl_crl=var["connection_ssl_crl"],
            ssl_key=var["connection_ssl_key"],
            ssl_key_password=var["connection_ssl_key_password"],
            ssl_mode=var["connection_ssl_mode"],
            stream_pool_id=oci_streaming_stream_pool["test_stream_pool"]["id"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            tenancy_id=oci_identity_tenancy["test_tenancy"]["id"],
            trust_store=var["connection_trust_store"],
            trust_store_password=var["connection_trust_store_password"],
            url=var["connection_url"],
            user_id=oci_identity_user["test_user"]["id"],
            username=var["connection_username"],
            vault_id=oci_kms_vault["test_vault"]["id"],
            wallet=var["connection_wallet"])
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:GoldenGate/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] account_key: (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        :param pulumi.Input[str] account_name: (Updatable) Sets the Azure storage account name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionAdditionalAttributeArgs']]]] additional_attributes: (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        :param pulumi.Input[str] authentication_type: (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] azure_tenant_id: (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionBootstrapServerArgs']]]] bootstrap_servers: (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        :param pulumi.Input[str] client_id: (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        :param pulumi.Input[str] client_secret: (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[str] connection_factory: (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        :param pulumi.Input[str] connection_string: (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        :param pulumi.Input[str] connection_type: (Updatable) The connection type.
        :param pulumi.Input[str] connection_url: (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        :param pulumi.Input[str] consumer_properties: (Updatable) The base64 encoded content of the consumer.properties file.
        :param pulumi.Input[str] core_site_xml: (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        :param pulumi.Input[str] database_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        :param pulumi.Input[str] database_name: (Updatable) The name of the database.
        :param pulumi.Input[str] db_system_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] endpoint: (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        :param pulumi.Input[str] fingerprint: (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host: (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
               For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        :param pulumi.Input[str] jndi_connection_factory: (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        :param pulumi.Input[str] jndi_initial_context_factory: (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        :param pulumi.Input[str] jndi_provider_url: (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        :param pulumi.Input[str] jndi_security_credentials: (Updatable) The password associated to the principal.
        :param pulumi.Input[str] jndi_security_principal: (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        :param pulumi.Input[str] key_id: (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param pulumi.Input[str] key_store: (Updatable) The base64 encoded content of the KeyStore file.
        :param pulumi.Input[str] key_store_password: (Updatable) The KeyStore password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[str] password: (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        :param pulumi.Input[int] port: (Updatable) The port of an endpoint usually specified for a connection.
        :param pulumi.Input[str] private_ip: (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
               The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        :param pulumi.Input[str] private_key_file: (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] private_key_passphrase: (Updatable) Password if the private key file is encrypted.
        :param pulumi.Input[str] producer_properties: (Updatable) The base64 encoded content of the producer.properties file.
        :param pulumi.Input[str] public_key_fingerprint: (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] region: (Updatable) The name of the region. e.g.: us-ashburn-1
        :param pulumi.Input[str] routing_method: (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        :param pulumi.Input[str] sas_token: (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        :param pulumi.Input[str] secret_access_key: (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] security_protocol: (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] servers: (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        :param pulumi.Input[str] service_account_key_file: (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        :param pulumi.Input[str] session_mode: (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param pulumi.Input[bool] should_use_jndi: (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        :param pulumi.Input[bool] should_validate_server_certificate: (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        :param pulumi.Input[str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        :param pulumi.Input[str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[str] ssl_key_password: (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        :param pulumi.Input[str] ssl_mode: (Updatable) SSL modes for PostgreSQL.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        :param pulumi.Input[str] technology_type: The Kafka (e.g. Confluent) Schema Registry technology type.
        :param pulumi.Input[str] tenancy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        :param pulumi.Input[str] trust_store: (Updatable) The base64 encoded content of the TrustStore file.
        :param pulumi.Input[str] trust_store_password: (Updatable) The TrustStore password.
        :param pulumi.Input[str] url: (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        :param pulumi.Input[str] user_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        :param pulumi.Input[str] username: (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        :param pulumi.Input[str] vault_id: (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        :param pulumi.Input[str] wallet: (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Connection resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.golden_gate.Connection("testConnection",
            compartment_id=var["compartment_id"],
            connection_type=var["connection_connection_type"],
            display_name=var["connection_display_name"],
            technology_type=var["connection_technology_type"],
            access_key_id=oci_kms_key["test_key"]["id"],
            account_key=var["connection_account_key"],
            account_name=var["connection_account_name"],
            additional_attributes=[oci.golden_gate.ConnectionAdditionalAttributeArgs(
                name=var["connection_additional_attributes_name"],
                value=var["connection_additional_attributes_value"],
            )],
            authentication_type=var["connection_authentication_type"],
            azure_tenant_id=oci_golden_gate_azure_tenant["test_azure_tenant"]["id"],
            bootstrap_servers=[oci.golden_gate.ConnectionBootstrapServerArgs(
                host=var["connection_bootstrap_servers_host"],
                port=var["connection_bootstrap_servers_port"],
                private_ip=var["connection_bootstrap_servers_private_ip"],
            )],
            client_id=oci_golden_gate_client["test_client"]["id"],
            client_secret=var["connection_client_secret"],
            connection_factory=var["connection_connection_factory"],
            connection_string=var["connection_connection_string"],
            connection_url=var["connection_connection_url"],
            consumer_properties=var["connection_consumer_properties"],
            core_site_xml=var["connection_core_site_xml"],
            database_id=oci_database_database["test_database"]["id"],
            database_name=oci_database_database["test_database"]["name"],
            db_system_id=oci_database_db_system["test_db_system"]["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
            description=var["connection_description"],
            endpoint=var["connection_endpoint"],
            fingerprint=var["connection_fingerprint"],
            freeform_tags={
                "bar-key": "value",
            },
            host=var["connection_host"],
            jndi_connection_factory=var["connection_jndi_connection_factory"],
            jndi_initial_context_factory=var["connection_jndi_initial_context_factory"],
            jndi_provider_url=var["connection_jndi_provider_url"],
            jndi_security_credentials=var["connection_jndi_security_credentials"],
            jndi_security_principal=var["connection_jndi_security_principal"],
            key_id=oci_kms_key["test_key"]["id"],
            key_store=var["connection_key_store"],
            key_store_password=var["connection_key_store_password"],
            nsg_ids=var["connection_nsg_ids"],
            password=var["connection_password"],
            port=var["connection_port"],
            private_ip=var["connection_private_ip"],
            private_key_file=var["connection_private_key_file"],
            private_key_passphrase=var["connection_private_key_passphrase"],
            producer_properties=var["connection_producer_properties"],
            public_key_fingerprint=var["connection_public_key_fingerprint"],
            region=var["connection_region"],
            routing_method=var["connection_routing_method"],
            sas_token=var["connection_sas_token"],
            secret_access_key=var["connection_secret_access_key"],
            security_protocol=var["connection_security_protocol"],
            servers=var["connection_servers"],
            service_account_key_file=var["connection_service_account_key_file"],
            session_mode=var["connection_session_mode"],
            should_use_jndi=var["connection_should_use_jndi"],
            should_validate_server_certificate=var["connection_should_validate_server_certificate"],
            ssl_ca=var["connection_ssl_ca"],
            ssl_cert=var["connection_ssl_cert"],
            ssl_crl=var["connection_ssl_crl"],
            ssl_key=var["connection_ssl_key"],
            ssl_key_password=var["connection_ssl_key_password"],
            ssl_mode=var["connection_ssl_mode"],
            stream_pool_id=oci_streaming_stream_pool["test_stream_pool"]["id"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            tenancy_id=oci_identity_tenancy["test_tenancy"]["id"],
            trust_store=var["connection_trust_store"],
            trust_store_password=var["connection_trust_store_password"],
            url=var["connection_url"],
            user_id=oci_identity_user["test_user"]["id"],
            username=var["connection_username"],
            vault_id=oci_kms_vault["test_vault"]["id"],
            wallet=var["connection_wallet"])
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:GoldenGate/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_id: Optional[pulumi.Input[str]] = None,
                 account_key: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionAdditionalAttributeArgs']]]]] = None,
                 authentication_type: Optional[pulumi.Input[str]] = None,
                 azure_tenant_id: Optional[pulumi.Input[str]] = None,
                 bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionBootstrapServerArgs']]]]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_factory: Optional[pulumi.Input[str]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 connection_url: Optional[pulumi.Input[str]] = None,
                 consumer_properties: Optional[pulumi.Input[str]] = None,
                 core_site_xml: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 jndi_connection_factory: Optional[pulumi.Input[str]] = None,
                 jndi_initial_context_factory: Optional[pulumi.Input[str]] = None,
                 jndi_provider_url: Optional[pulumi.Input[str]] = None,
                 jndi_security_credentials: Optional[pulumi.Input[str]] = None,
                 jndi_security_principal: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 key_store_password: Optional[pulumi.Input[str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 private_key_file: Optional[pulumi.Input[str]] = None,
                 private_key_passphrase: Optional[pulumi.Input[str]] = None,
                 producer_properties: Optional[pulumi.Input[str]] = None,
                 public_key_fingerprint: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routing_method: Optional[pulumi.Input[str]] = None,
                 sas_token: Optional[pulumi.Input[str]] = None,
                 secret_access_key: Optional[pulumi.Input[str]] = None,
                 security_protocol: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[str]] = None,
                 service_account_key_file: Optional[pulumi.Input[str]] = None,
                 session_mode: Optional[pulumi.Input[str]] = None,
                 should_use_jndi: Optional[pulumi.Input[bool]] = None,
                 should_validate_server_certificate: Optional[pulumi.Input[bool]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 ssl_cert: Optional[pulumi.Input[str]] = None,
                 ssl_crl: Optional[pulumi.Input[str]] = None,
                 ssl_key: Optional[pulumi.Input[str]] = None,
                 ssl_key_password: Optional[pulumi.Input[str]] = None,
                 ssl_mode: Optional[pulumi.Input[str]] = None,
                 stream_pool_id: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 technology_type: Optional[pulumi.Input[str]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None,
                 trust_store_password: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 user_id: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 wallet: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["access_key_id"] = access_key_id
            __props__.__dict__["account_key"] = account_key
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["additional_attributes"] = additional_attributes
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["azure_tenant_id"] = azure_tenant_id
            __props__.__dict__["bootstrap_servers"] = bootstrap_servers
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_factory"] = connection_factory
            __props__.__dict__["connection_string"] = connection_string
            if connection_type is None and not opts.urn:
                raise TypeError("Missing required property 'connection_type'")
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["connection_url"] = connection_url
            __props__.__dict__["consumer_properties"] = consumer_properties
            __props__.__dict__["core_site_xml"] = core_site_xml
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["host"] = host
            __props__.__dict__["jndi_connection_factory"] = jndi_connection_factory
            __props__.__dict__["jndi_initial_context_factory"] = jndi_initial_context_factory
            __props__.__dict__["jndi_provider_url"] = jndi_provider_url
            __props__.__dict__["jndi_security_credentials"] = jndi_security_credentials
            __props__.__dict__["jndi_security_principal"] = jndi_security_principal
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["key_store"] = key_store
            __props__.__dict__["key_store_password"] = None if key_store_password is None else pulumi.Output.secret(key_store_password)
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            __props__.__dict__["private_ip"] = private_ip
            __props__.__dict__["private_key_file"] = None if private_key_file is None else pulumi.Output.secret(private_key_file)
            __props__.__dict__["private_key_passphrase"] = None if private_key_passphrase is None else pulumi.Output.secret(private_key_passphrase)
            __props__.__dict__["producer_properties"] = producer_properties
            __props__.__dict__["public_key_fingerprint"] = public_key_fingerprint
            __props__.__dict__["region"] = region
            __props__.__dict__["routing_method"] = routing_method
            __props__.__dict__["sas_token"] = sas_token
            __props__.__dict__["secret_access_key"] = secret_access_key
            __props__.__dict__["security_protocol"] = security_protocol
            __props__.__dict__["servers"] = servers
            __props__.__dict__["service_account_key_file"] = service_account_key_file
            __props__.__dict__["session_mode"] = session_mode
            __props__.__dict__["should_use_jndi"] = should_use_jndi
            __props__.__dict__["should_validate_server_certificate"] = should_validate_server_certificate
            __props__.__dict__["ssl_ca"] = ssl_ca
            __props__.__dict__["ssl_cert"] = ssl_cert
            __props__.__dict__["ssl_crl"] = ssl_crl
            __props__.__dict__["ssl_key"] = ssl_key
            __props__.__dict__["ssl_key_password"] = None if ssl_key_password is None else pulumi.Output.secret(ssl_key_password)
            __props__.__dict__["ssl_mode"] = ssl_mode
            __props__.__dict__["stream_pool_id"] = stream_pool_id
            __props__.__dict__["subnet_id"] = subnet_id
            if technology_type is None and not opts.urn:
                raise TypeError("Missing required property 'technology_type'")
            __props__.__dict__["technology_type"] = technology_type
            __props__.__dict__["tenancy_id"] = tenancy_id
            __props__.__dict__["trust_store"] = trust_store
            __props__.__dict__["trust_store_password"] = None if trust_store_password is None else pulumi.Output.secret(trust_store_password)
            __props__.__dict__["url"] = url
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["username"] = username
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["wallet"] = wallet
            __props__.__dict__["ingress_ips"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["keyStorePassword", "password", "privateKeyFile", "privateKeyPassphrase", "sslKeyPassword", "trustStorePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'oci:GoldenGate/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_id: Optional[pulumi.Input[str]] = None,
            account_key: Optional[pulumi.Input[str]] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionAdditionalAttributeArgs']]]]] = None,
            authentication_type: Optional[pulumi.Input[str]] = None,
            azure_tenant_id: Optional[pulumi.Input[str]] = None,
            bootstrap_servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionBootstrapServerArgs']]]]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_factory: Optional[pulumi.Input[str]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            connection_url: Optional[pulumi.Input[str]] = None,
            consumer_properties: Optional[pulumi.Input[str]] = None,
            core_site_xml: Optional[pulumi.Input[str]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            db_system_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            host: Optional[pulumi.Input[str]] = None,
            ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionIngressIpArgs']]]]] = None,
            jndi_connection_factory: Optional[pulumi.Input[str]] = None,
            jndi_initial_context_factory: Optional[pulumi.Input[str]] = None,
            jndi_provider_url: Optional[pulumi.Input[str]] = None,
            jndi_security_credentials: Optional[pulumi.Input[str]] = None,
            jndi_security_principal: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            key_store: Optional[pulumi.Input[str]] = None,
            key_store_password: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            private_key_file: Optional[pulumi.Input[str]] = None,
            private_key_passphrase: Optional[pulumi.Input[str]] = None,
            producer_properties: Optional[pulumi.Input[str]] = None,
            public_key_fingerprint: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            routing_method: Optional[pulumi.Input[str]] = None,
            sas_token: Optional[pulumi.Input[str]] = None,
            secret_access_key: Optional[pulumi.Input[str]] = None,
            security_protocol: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[str]] = None,
            service_account_key_file: Optional[pulumi.Input[str]] = None,
            session_mode: Optional[pulumi.Input[str]] = None,
            should_use_jndi: Optional[pulumi.Input[bool]] = None,
            should_validate_server_certificate: Optional[pulumi.Input[bool]] = None,
            ssl_ca: Optional[pulumi.Input[str]] = None,
            ssl_cert: Optional[pulumi.Input[str]] = None,
            ssl_crl: Optional[pulumi.Input[str]] = None,
            ssl_key: Optional[pulumi.Input[str]] = None,
            ssl_key_password: Optional[pulumi.Input[str]] = None,
            ssl_mode: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            stream_pool_id: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            technology_type: Optional[pulumi.Input[str]] = None,
            tenancy_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            trust_store: Optional[pulumi.Input[str]] = None,
            trust_store_password: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None,
            user_id: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            vault_id: Optional[pulumi.Input[str]] = None,
            wallet: Optional[pulumi.Input[str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key_id: (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] account_key: (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        :param pulumi.Input[str] account_name: (Updatable) Sets the Azure storage account name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionAdditionalAttributeArgs']]]] additional_attributes: (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        :param pulumi.Input[str] authentication_type: (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] azure_tenant_id: (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionBootstrapServerArgs']]]] bootstrap_servers: (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        :param pulumi.Input[str] client_id: (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        :param pulumi.Input[str] client_secret: (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        :param pulumi.Input[str] connection_factory: (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        :param pulumi.Input[str] connection_string: (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        :param pulumi.Input[str] connection_type: (Updatable) The connection type.
        :param pulumi.Input[str] connection_url: (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        :param pulumi.Input[str] consumer_properties: (Updatable) The base64 encoded content of the consumer.properties file.
        :param pulumi.Input[str] core_site_xml: (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        :param pulumi.Input[str] database_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        :param pulumi.Input[str] database_name: (Updatable) The name of the database.
        :param pulumi.Input[str] db_system_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        :param pulumi.Input[str] description: (Updatable) Metadata about this specific object.
        :param pulumi.Input[str] display_name: (Updatable) An object's Display Name.
        :param pulumi.Input[str] endpoint: (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        :param pulumi.Input[str] fingerprint: (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host: (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
               For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConnectionIngressIpArgs']]]] ingress_ips: List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        :param pulumi.Input[str] jndi_connection_factory: (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        :param pulumi.Input[str] jndi_initial_context_factory: (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        :param pulumi.Input[str] jndi_provider_url: (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        :param pulumi.Input[str] jndi_security_credentials: (Updatable) The password associated to the principal.
        :param pulumi.Input[str] jndi_security_principal: (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        :param pulumi.Input[str] key_id: (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        :param pulumi.Input[str] key_store: (Updatable) The base64 encoded content of the KeyStore file.
        :param pulumi.Input[str] key_store_password: (Updatable) The KeyStore password.
        :param pulumi.Input[str] lifecycle_details: Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        :param pulumi.Input[str] password: (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        :param pulumi.Input[int] port: (Updatable) The port of an endpoint usually specified for a connection.
        :param pulumi.Input[str] private_ip: (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
               The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        :param pulumi.Input[str] private_key_file: (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] private_key_passphrase: (Updatable) Password if the private key file is encrypted.
        :param pulumi.Input[str] producer_properties: (Updatable) The base64 encoded content of the producer.properties file.
        :param pulumi.Input[str] public_key_fingerprint: (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        :param pulumi.Input[str] region: (Updatable) The name of the region. e.g.: us-ashburn-1
        :param pulumi.Input[str] routing_method: (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        :param pulumi.Input[str] sas_token: (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        :param pulumi.Input[str] secret_access_key: (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        :param pulumi.Input[str] security_protocol: (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        :param pulumi.Input[str] servers: (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        :param pulumi.Input[str] service_account_key_file: (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        :param pulumi.Input[str] session_mode: (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        :param pulumi.Input[bool] should_use_jndi: (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        :param pulumi.Input[bool] should_validate_server_certificate: (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        :param pulumi.Input[str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        :param pulumi.Input[str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[str] ssl_key_password: (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        :param pulumi.Input[str] ssl_mode: (Updatable) SSL modes for PostgreSQL.
        :param pulumi.Input[str] state: Possible lifecycle states for connection.
        :param pulumi.Input[str] stream_pool_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        :param pulumi.Input[str] subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        :param pulumi.Input[Mapping[str, Any]] system_tags: The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        :param pulumi.Input[str] technology_type: The Kafka (e.g. Confluent) Schema Registry technology type.
        :param pulumi.Input[str] tenancy_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_updated: The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] trust_store: (Updatable) The base64 encoded content of the TrustStore file.
        :param pulumi.Input[str] trust_store_password: (Updatable) The TrustStore password.
        :param pulumi.Input[str] url: (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        :param pulumi.Input[str] user_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        :param pulumi.Input[str] username: (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        :param pulumi.Input[str] vault_id: (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        :param pulumi.Input[str] wallet: (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["access_key_id"] = access_key_id
        __props__.__dict__["account_key"] = account_key
        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["additional_attributes"] = additional_attributes
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["azure_tenant_id"] = azure_tenant_id
        __props__.__dict__["bootstrap_servers"] = bootstrap_servers
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_factory"] = connection_factory
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["connection_url"] = connection_url
        __props__.__dict__["consumer_properties"] = consumer_properties
        __props__.__dict__["core_site_xml"] = core_site_xml
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host"] = host
        __props__.__dict__["ingress_ips"] = ingress_ips
        __props__.__dict__["jndi_connection_factory"] = jndi_connection_factory
        __props__.__dict__["jndi_initial_context_factory"] = jndi_initial_context_factory
        __props__.__dict__["jndi_provider_url"] = jndi_provider_url
        __props__.__dict__["jndi_security_credentials"] = jndi_security_credentials
        __props__.__dict__["jndi_security_principal"] = jndi_security_principal
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_store"] = key_store
        __props__.__dict__["key_store_password"] = key_store_password
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["private_key_file"] = private_key_file
        __props__.__dict__["private_key_passphrase"] = private_key_passphrase
        __props__.__dict__["producer_properties"] = producer_properties
        __props__.__dict__["public_key_fingerprint"] = public_key_fingerprint
        __props__.__dict__["region"] = region
        __props__.__dict__["routing_method"] = routing_method
        __props__.__dict__["sas_token"] = sas_token
        __props__.__dict__["secret_access_key"] = secret_access_key
        __props__.__dict__["security_protocol"] = security_protocol
        __props__.__dict__["servers"] = servers
        __props__.__dict__["service_account_key_file"] = service_account_key_file
        __props__.__dict__["session_mode"] = session_mode
        __props__.__dict__["should_use_jndi"] = should_use_jndi
        __props__.__dict__["should_validate_server_certificate"] = should_validate_server_certificate
        __props__.__dict__["ssl_ca"] = ssl_ca
        __props__.__dict__["ssl_cert"] = ssl_cert
        __props__.__dict__["ssl_crl"] = ssl_crl
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["ssl_key_password"] = ssl_key_password
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_pool_id"] = stream_pool_id
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["technology_type"] = technology_type
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trust_store"] = trust_store
        __props__.__dict__["trust_store_password"] = trust_store_password
        __props__.__dict__["url"] = url
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["username"] = username
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["wallet"] = wallet
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Access key ID to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "access_key_id")

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> pulumi.Output[str]:
        """
        (Updatable) Azure storage account key. This property is required when 'authenticationType' is set to 'SHARED_KEY'. e.g.: pa3WbhVATzj56xD4DH1VjOUhApRGEGHvOo58eQJVWIzX+j8j4CUVFcTjpIqDSRaSa1Wo2LbWY5at+AStEgLOIQ==
        """
        return pulumi.get(self, "account_key")

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Sets the Azure storage account name.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> pulumi.Output[Sequence['outputs.ConnectionAdditionalAttribute']]:
        """
        (Updatable) An array of name-value pair attribute entries. Used as additional parameters in connection string.
        """
        return pulumi.get(self, "additional_attributes")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Authentication type for Java Message Service.  If not provided, default is NONE. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Azure tenant ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 14593954-d337-4a61-a364-9f758c64f97f
        """
        return pulumi.get(self, "azure_tenant_id")

    @property
    @pulumi.getter(name="bootstrapServers")
    def bootstrap_servers(self) -> pulumi.Output[Sequence['outputs.ConnectionBootstrapServer']]:
        """
        (Updatable) Kafka bootstrap. Equivalent of bootstrap.servers configuration property in Kafka: list of KafkaBootstrapServer objects specified by host/port. Used for establishing the initial connection to the Kafka cluster. Example: `"server1.example.com:9092,server2.example.com:9092"`
        """
        return pulumi.get(self, "bootstrap_servers")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Azure client ID of the application. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: 06ecaabf-8b80-4ec8-a0ec-20cbf463703d
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        (Updatable) Azure client secret (aka application password) for authentication. This property is required when 'authenticationType' is set to 'AZURE_ACTIVE_DIRECTORY'. e.g.: dO29Q~F5-VwnA.lZdd11xFF_t5NAXCaGwDl9NbT1
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionFactory")
    def connection_factory(self) -> pulumi.Output[str]:
        """
        (Updatable) The of Java class implementing javax.jms.ConnectionFactory interface supplied by the Java Message Service provider. e.g.: 'com.stc.jmsjca.core.JConnectionFactoryXA'
        """
        return pulumi.get(self, "connection_factory")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        (Updatable) Connection string. AZURE_SYNAPSE_ANALYTICS e.g.: 'jdbc:sqlserver://<synapse-workspace>.sql.azuresynapse.net:1433;database=<db-name>;encrypt=true;trustServerCertificate=false;hostNameInCertificate=*.sql.azuresynapse.net;loginTimeout=300;', MONGODB e.g.: 'mongodb://mongodb0.example.com:27017/recordsrecords'.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The connection type.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> pulumi.Output[str]:
        """
        (Updatable) JDBC connection URL. e.g.: 'jdbc:snowflake://<account_name>.snowflakecomputing.com/?warehouse=<warehouse-name>&db=<db-name>'
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="consumerProperties")
    def consumer_properties(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the consumer.properties file.
        """
        return pulumi.get(self, "consumer_properties")

    @property
    @pulumi.getter(name="coreSiteXml")
    def core_site_xml(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the Hadoop Distributed File System configuration file (core-site.xml).
        """
        return pulumi.get(self, "core_site_xml")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Autonomous Json Database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Tags defined for this resource. Each key is predefined and scoped to a namespace.  Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Metadata about this specific object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) An object's Display Name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        (Updatable) Azure Storage service endpoint. e.g: https://test.blob.core.windows.net
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        (Updatable) Fingerprint required by TLS security protocol. Eg.: '6152b2dfbff200f973c5074a5b91d06ab3b472c07c09a1ea57bb7fd406cdce9c'
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.  Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        (Updatable) The name or address of a host. In case of Generic connection type host and port separated by colon. Example: `"server.example.com:1234"`
        For multiple hosts, provide a comma separated list. Example: `"server1.example.com:1000,server1.example.com:2000"`
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> pulumi.Output[Sequence['outputs.ConnectionIngressIp']]:
        """
        List of ingress IP addresses from where the GoldenGate deployment connects to this connection's privateIp.  Customers may optionally set up ingress security rules to restrict traffic from these IP addresses.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="jndiConnectionFactory")
    def jndi_connection_factory(self) -> pulumi.Output[str]:
        """
        (Updatable) The Connection Factory can be looked up using this name. e.g.: 'ConnectionFactory'
        """
        return pulumi.get(self, "jndi_connection_factory")

    @property
    @pulumi.getter(name="jndiInitialContextFactory")
    def jndi_initial_context_factory(self) -> pulumi.Output[str]:
        """
        (Updatable) The implementation of javax.naming.spi.InitialContextFactory interface that the client uses to obtain initial naming context. e.g.: 'org.apache.activemq.jndi.ActiveMQInitialContextFactory'
        """
        return pulumi.get(self, "jndi_initial_context_factory")

    @property
    @pulumi.getter(name="jndiProviderUrl")
    def jndi_provider_url(self) -> pulumi.Output[str]:
        """
        (Updatable) The URL that Java Message Service will use to contact the JNDI provider. e.g.: 'tcp://myjms.host.domain:61616?jms.prefetchPolicy.all=1000'
        """
        return pulumi.get(self, "jndi_provider_url")

    @property
    @pulumi.getter(name="jndiSecurityCredentials")
    def jndi_security_credentials(self) -> pulumi.Output[str]:
        """
        (Updatable) The password associated to the principal.
        """
        return pulumi.get(self, "jndi_security_credentials")

    @property
    @pulumi.getter(name="jndiSecurityPrincipal")
    def jndi_security_principal(self) -> pulumi.Output[str]:
        """
        (Updatable) Specifies the identity of the principal (user) to be authenticated. e.g.: 'admin2'
        """
        return pulumi.get(self, "jndi_security_principal")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Refers to the customer's master key OCID.  If provided, it references a key to manage secrets. Customers must add policies to permit GoldenGate to use this key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the KeyStore file.
        """
        return pulumi.get(self, "key_store")

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> pulumi.Output[str]:
        """
        (Updatable) The KeyStore password.
        """
        return pulumi.get(self, "key_store_password")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Describes the object's current state in detail. For example, it can be used to provide actionable information for a resource in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        (Updatable) The password Oracle GoldenGate uses to connect the associated system of the given technology. It must conform to the specific security requirements including length, case sensitivity, and so on.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        (Updatable) The port of an endpoint usually specified for a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        (Updatable) Deprecated: this field will be removed in future versions. Either specify the private IP in the connectionString or host  field, or make sure the host name is resolvable in the target VCN.
        The private IP address of the connection's endpoint in the customer's VCN, typically a database endpoint or a big data endpoint (e.g. Kafka bootstrap server). In case the privateIp is provided, the subnetId must also be provided. In case the privateIp (and the subnetId) is not provided it is assumed the datasource is publicly accessible. In case the connection is accessible only privately, the lack of privateIp will result in not being able to access the connection.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateKeyFile")
    def private_key_file(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the private key file (PEM file) corresponding to the API key of the fingerprint. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "private_key_file")

    @property
    @pulumi.getter(name="privateKeyPassphrase")
    def private_key_passphrase(self) -> pulumi.Output[str]:
        """
        (Updatable) Password if the private key file is encrypted.
        """
        return pulumi.get(self, "private_key_passphrase")

    @property
    @pulumi.getter(name="producerProperties")
    def producer_properties(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the producer.properties file.
        """
        return pulumi.get(self, "producer_properties")

    @property
    @pulumi.getter(name="publicKeyFingerprint")
    def public_key_fingerprint(self) -> pulumi.Output[str]:
        """
        (Updatable) The fingerprint of the API Key of the user specified by the userId. See documentation: https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/managingcredentials.htm
        """
        return pulumi.get(self, "public_key_fingerprint")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the region. e.g.: us-ashburn-1
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routingMethod")
    def routing_method(self) -> pulumi.Output[str]:
        """
        (Updatable) Controls the network traffic direction to the target: SHARED_SERVICE_ENDPOINT: Traffic flows through the Goldengate Service's network to public hosts. Cannot be used for private targets.  SHARED_DEPLOYMENT_ENDPOINT: Network traffic flows from the assigned deployment's private endpoint through the deployment's subnet. DEDICATED_ENDPOINT: A dedicated private endpoint is created in the target VCN subnet for the connection. The subnetId is required when DEDICATED_ENDPOINT networking is selected.
        """
        return pulumi.get(self, "routing_method")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> pulumi.Output[str]:
        """
        (Updatable) Credential that uses a shared access signature (SAS) to authenticate to an Azure Service. This property is required when 'authenticationType' is set to 'SHARED_ACCESS_SIGNATURE'. e.g.: ?sv=2020-06-08&ss=bfqt&srt=sco&sp=rwdlacupyx&se=2020-09-10T20:27:28Z&st=2022-08-05T12:27:28Z&spr=https&sig=C1IgHsiLBmTSStYkXXGLTP8it0xBrArcgCqOsZbXwIQ%3D
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Output[str]:
        """
        (Updatable) Secret access key to access the Amazon S3 bucket. e.g.: "this-is-not-the-secret"
        """
        return pulumi.get(self, "secret_access_key")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> pulumi.Output[str]:
        """
        (Updatable) Security protocol for Java Message Service. If not provided, default is PLAIN. Optional until 2024-06-27, in the release after it will be made required.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[str]:
        """
        (Updatable) Comma separated list of Elasticsearch server addresses, specified as host:port entries, where :port is optional.  If port is not specified, it defaults to 9200. Used for establishing the initial connection to the Elasticsearch cluster. Example: `"server1.example.com:4000,server2.example.com:4000"`
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="serviceAccountKeyFile")
    def service_account_key_file(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the service account key file containing the credentials required to use Google Cloud Storage.
        """
        return pulumi.get(self, "service_account_key_file")

    @property
    @pulumi.getter(name="sessionMode")
    def session_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) The mode of the database connection session to be established by the data client. 'REDIRECT' - for a RAC database, 'DIRECT' - for a non-RAC database. Connection to a RAC database involves a redirection received from the SCAN listeners to the database node to connect to. By default the mode would be DIRECT.
        """
        return pulumi.get(self, "session_mode")

    @property
    @pulumi.getter(name="shouldUseJndi")
    def should_use_jndi(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set to true, Java Naming and Directory Interface (JNDI) properties should be provided.
        """
        return pulumi.get(self, "should_use_jndi")

    @property
    @pulumi.getter(name="shouldValidateServerCertificate")
    def should_validate_server_certificate(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set to true, the driver validates the certificate that is sent by the database server.
        """
        return pulumi.get(self, "should_validate_server_certificate")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> pulumi.Output[str]:
        """
        (Updatable) Database Certificate - The base64 encoded content of pem file containing the server public key (for 1-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> pulumi.Output[str]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> pulumi.Output[str]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[str]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter(name="sslKeyPassword")
    def ssl_key_password(self) -> pulumi.Output[str]:
        """
        (Updatable) The password for the cert inside of the KeyStore. In case it differs from the KeyStore password, it should be provided.
        """
        return pulumi.get(self, "ssl_key_password")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) SSL modes for PostgreSQL.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Possible lifecycle states for connection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPoolId")
    def stream_pool_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the stream pool being referenced.
        """
        return pulumi.get(self, "stream_pool_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target subnet of the dedicated connection.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The system tags associated with this resource, if any. The system tags are set by Oracle Cloud Infrastructure services. Each key is predefined and scoped to namespaces.  For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{orcl-cloud: {free-tier-retain: true}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> pulumi.Output[str]:
        """
        The Kafka (e.g. Confluent) Schema Registry technology type.
        """
        return pulumi.get(self, "technology_type")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the related Oracle Cloud Infrastructure tenancy.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the resource was last updated. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> pulumi.Output[str]:
        """
        (Updatable) The base64 encoded content of the TrustStore file.
        """
        return pulumi.get(self, "trust_store")

    @property
    @pulumi.getter(name="trustStorePassword")
    def trust_store_password(self) -> pulumi.Output[str]:
        """
        (Updatable) The TrustStore password.
        """
        return pulumi.get(self, "trust_store_password")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        (Updatable) Kafka Schema Registry URL. e.g.: 'https://server1.us.oracle.com:8081'
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure user who will access the Oracle NoSQL database. The user must have write access to the table they want to connect to.
        """
        return pulumi.get(self, "user_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        (Updatable) The username Oracle GoldenGate uses to connect the associated system of the given technology. This username must already exist and be available by the system/application to be connected to and must conform to the case sensitivty requirments defined in it.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Refers to the customer's vault OCID.  If provided, it references a vault where GoldenGate can manage secrets. Customers must add policies to permit GoldenGate to manage secrets contained within this vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> pulumi.Output[str]:
        """
        (Updatable) The wallet contents Oracle GoldenGate uses to make connections to a database.  This attribute is expected to be base64 encoded. 

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

