# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMediaAssetsResult',
    'AwaitableGetMediaAssetsResult',
    'get_media_assets',
    'get_media_assets_output',
]

@pulumi.output_type
class GetMediaAssetsResult:
    """
    A collection of values returned by getMediaAssets.
    """
    def __init__(__self__, bucket=None, compartment_id=None, display_name=None, distribution_channel_id=None, filters=None, id=None, master_media_asset_id=None, media_asset_collections=None, media_workflow_job_id=None, object=None, parent_media_asset_id=None, source_media_workflow_id=None, source_media_workflow_version=None, state=None, type=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if distribution_channel_id and not isinstance(distribution_channel_id, str):
            raise TypeError("Expected argument 'distribution_channel_id' to be a str")
        pulumi.set(__self__, "distribution_channel_id", distribution_channel_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if master_media_asset_id and not isinstance(master_media_asset_id, str):
            raise TypeError("Expected argument 'master_media_asset_id' to be a str")
        pulumi.set(__self__, "master_media_asset_id", master_media_asset_id)
        if media_asset_collections and not isinstance(media_asset_collections, list):
            raise TypeError("Expected argument 'media_asset_collections' to be a list")
        pulumi.set(__self__, "media_asset_collections", media_asset_collections)
        if media_workflow_job_id and not isinstance(media_workflow_job_id, str):
            raise TypeError("Expected argument 'media_workflow_job_id' to be a str")
        pulumi.set(__self__, "media_workflow_job_id", media_workflow_job_id)
        if object and not isinstance(object, str):
            raise TypeError("Expected argument 'object' to be a str")
        pulumi.set(__self__, "object", object)
        if parent_media_asset_id and not isinstance(parent_media_asset_id, str):
            raise TypeError("Expected argument 'parent_media_asset_id' to be a str")
        pulumi.set(__self__, "parent_media_asset_id", parent_media_asset_id)
        if source_media_workflow_id and not isinstance(source_media_workflow_id, str):
            raise TypeError("Expected argument 'source_media_workflow_id' to be a str")
        pulumi.set(__self__, "source_media_workflow_id", source_media_workflow_id)
        if source_media_workflow_version and not isinstance(source_media_workflow_version, str):
            raise TypeError("Expected argument 'source_media_workflow_version' to be a str")
        pulumi.set(__self__, "source_media_workflow_version", source_media_workflow_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        The name of the object storage bucket where this represented asset is located.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The compartment ID of the lock.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="distributionChannelId")
    def distribution_channel_id(self) -> Optional[str]:
        return pulumi.get(self, "distribution_channel_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMediaAssetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterMediaAssetId")
    def master_media_asset_id(self) -> Optional[str]:
        """
        The ID of the senior most asset from which this asset is derived.
        """
        return pulumi.get(self, "master_media_asset_id")

    @property
    @pulumi.getter(name="mediaAssetCollections")
    def media_asset_collections(self) -> Sequence['outputs.GetMediaAssetsMediaAssetCollectionResult']:
        """
        The list of media_asset_collection.
        """
        return pulumi.get(self, "media_asset_collections")

    @property
    @pulumi.getter(name="mediaWorkflowJobId")
    def media_workflow_job_id(self) -> Optional[str]:
        """
        The ID of the MediaWorkflowJob used to produce this asset.
        """
        return pulumi.get(self, "media_workflow_job_id")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        The object storage object name that identifies this asset.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="parentMediaAssetId")
    def parent_media_asset_id(self) -> Optional[str]:
        """
        The ID of the parent asset from which this asset is derived.
        """
        return pulumi.get(self, "parent_media_asset_id")

    @property
    @pulumi.getter(name="sourceMediaWorkflowId")
    def source_media_workflow_id(self) -> Optional[str]:
        """
        The ID of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_id")

    @property
    @pulumi.getter(name="sourceMediaWorkflowVersion")
    def source_media_workflow_version(self) -> Optional[str]:
        """
        The version of the MediaWorkflow used to produce this asset.
        """
        return pulumi.get(self, "source_media_workflow_version")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the MediaAsset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the media asset.
        """
        return pulumi.get(self, "type")


class AwaitableGetMediaAssetsResult(GetMediaAssetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMediaAssetsResult(
            bucket=self.bucket,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            distribution_channel_id=self.distribution_channel_id,
            filters=self.filters,
            id=self.id,
            master_media_asset_id=self.master_media_asset_id,
            media_asset_collections=self.media_asset_collections,
            media_workflow_job_id=self.media_workflow_job_id,
            object=self.object,
            parent_media_asset_id=self.parent_media_asset_id,
            source_media_workflow_id=self.source_media_workflow_id,
            source_media_workflow_version=self.source_media_workflow_version,
            state=self.state,
            type=self.type)


def get_media_assets(bucket: Optional[str] = None,
                     compartment_id: Optional[str] = None,
                     display_name: Optional[str] = None,
                     distribution_channel_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetMediaAssetsFilterArgs']]] = None,
                     master_media_asset_id: Optional[str] = None,
                     media_workflow_job_id: Optional[str] = None,
                     object: Optional[str] = None,
                     parent_media_asset_id: Optional[str] = None,
                     source_media_workflow_id: Optional[str] = None,
                     source_media_workflow_version: Optional[str] = None,
                     state: Optional[str] = None,
                     type: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMediaAssetsResult:
    """
    This data source provides the list of Media Assets in Oracle Cloud Infrastructure Media Services service.

    Returns a list of MediaAssetSummary.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_assets = oci.MediaServices.get_media_assets(bucket=var["media_asset_bucket"],
        compartment_id=var["compartment_id"],
        display_name=var["media_asset_display_name"],
        distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
        master_media_asset_id=oci_media_services_media_asset["test_media_asset"]["id"],
        media_workflow_job_id=oci_media_services_media_workflow_job["test_media_workflow_job"]["id"],
        object=var["media_asset_object"],
        parent_media_asset_id=oci_media_services_media_asset["test_media_asset"]["id"],
        source_media_workflow_id=oci_media_services_media_workflow["test_media_workflow"]["id"],
        source_media_workflow_version=var["media_asset_source_media_workflow_version"],
        state=var["media_asset_state"],
        type=var["media_asset_type"])
    ```


    :param str bucket: Filter MediaAsset by the bucket where the object is stored.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str distribution_channel_id: Unique DistributionChannel identifier.
    :param str master_media_asset_id: Unique MediaAsset identifier of the first asset upload.
    :param str media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset, if this parameter is supplied then the workflow ID must also be supplied.
    :param str object: Filter MediaAsset by the name of the object in object storage.
    :param str parent_media_asset_id: Unique MediaAsset identifier of the asset from which this asset is derived.
    :param str source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
    :param str source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    :param str type: Filter MediaAsset by the asset type.
    """
    __args__ = dict()
    __args__['bucket'] = bucket
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['distributionChannelId'] = distribution_channel_id
    __args__['filters'] = filters
    __args__['masterMediaAssetId'] = master_media_asset_id
    __args__['mediaWorkflowJobId'] = media_workflow_job_id
    __args__['object'] = object
    __args__['parentMediaAssetId'] = parent_media_asset_id
    __args__['sourceMediaWorkflowId'] = source_media_workflow_id
    __args__['sourceMediaWorkflowVersion'] = source_media_workflow_version
    __args__['state'] = state
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:MediaServices/getMediaAssets:getMediaAssets', __args__, opts=opts, typ=GetMediaAssetsResult).value

    return AwaitableGetMediaAssetsResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        distribution_channel_id=pulumi.get(__ret__, 'distribution_channel_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        master_media_asset_id=pulumi.get(__ret__, 'master_media_asset_id'),
        media_asset_collections=pulumi.get(__ret__, 'media_asset_collections'),
        media_workflow_job_id=pulumi.get(__ret__, 'media_workflow_job_id'),
        object=pulumi.get(__ret__, 'object'),
        parent_media_asset_id=pulumi.get(__ret__, 'parent_media_asset_id'),
        source_media_workflow_id=pulumi.get(__ret__, 'source_media_workflow_id'),
        source_media_workflow_version=pulumi.get(__ret__, 'source_media_workflow_version'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_media_assets)
def get_media_assets_output(bucket: Optional[pulumi.Input[Optional[str]]] = None,
                            compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                            display_name: Optional[pulumi.Input[Optional[str]]] = None,
                            distribution_channel_id: Optional[pulumi.Input[Optional[str]]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMediaAssetsFilterArgs']]]]] = None,
                            master_media_asset_id: Optional[pulumi.Input[Optional[str]]] = None,
                            media_workflow_job_id: Optional[pulumi.Input[Optional[str]]] = None,
                            object: Optional[pulumi.Input[Optional[str]]] = None,
                            parent_media_asset_id: Optional[pulumi.Input[Optional[str]]] = None,
                            source_media_workflow_id: Optional[pulumi.Input[Optional[str]]] = None,
                            source_media_workflow_version: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            type: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMediaAssetsResult]:
    """
    This data source provides the list of Media Assets in Oracle Cloud Infrastructure Media Services service.

    Returns a list of MediaAssetSummary.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_media_assets = oci.MediaServices.get_media_assets(bucket=var["media_asset_bucket"],
        compartment_id=var["compartment_id"],
        display_name=var["media_asset_display_name"],
        distribution_channel_id=oci_mysql_channel["test_channel"]["id"],
        master_media_asset_id=oci_media_services_media_asset["test_media_asset"]["id"],
        media_workflow_job_id=oci_media_services_media_workflow_job["test_media_workflow_job"]["id"],
        object=var["media_asset_object"],
        parent_media_asset_id=oci_media_services_media_asset["test_media_asset"]["id"],
        source_media_workflow_id=oci_media_services_media_workflow["test_media_workflow"]["id"],
        source_media_workflow_version=var["media_asset_source_media_workflow_version"],
        state=var["media_asset_state"],
        type=var["media_asset_type"])
    ```


    :param str bucket: Filter MediaAsset by the bucket where the object is stored.
    :param str compartment_id: The ID of the compartment in which to list resources.
    :param str display_name: A filter to return only the resources that match the entire display name given.
    :param str distribution_channel_id: Unique DistributionChannel identifier.
    :param str master_media_asset_id: Unique MediaAsset identifier of the first asset upload.
    :param str media_workflow_job_id: The ID of the MediaWorkflowJob used to produce this asset, if this parameter is supplied then the workflow ID must also be supplied.
    :param str object: Filter MediaAsset by the name of the object in object storage.
    :param str parent_media_asset_id: Unique MediaAsset identifier of the asset from which this asset is derived.
    :param str source_media_workflow_id: The ID of the MediaWorkflow used to produce this asset.
    :param str source_media_workflow_version: The version of the MediaWorkflow used to produce this asset.
    :param str state: A filter to return only the resources with lifecycleState matching the given lifecycleState.
    :param str type: Filter MediaAsset by the asset type.
    """
    ...
