# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSupportedCommitmentsResult',
    'AwaitableGetSupportedCommitmentsResult',
    'get_supported_commitments',
    'get_supported_commitments_output',
]

@pulumi.output_type
class GetSupportedCommitmentsResult:
    """
    A collection of values returned by getSupportedCommitments.
    """
    def __init__(__self__, compartment_id=None, filters=None, host_shape_name=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if host_shape_name and not isinstance(host_shape_name, str):
            raise TypeError("Expected argument 'host_shape_name' to be a str")
        pulumi.set(__self__, "host_shape_name", host_shape_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSupportedCommitmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="hostShapeName")
    def host_shape_name(self) -> Optional[str]:
        return pulumi.get(self, "host_shape_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSupportedCommitmentsItemResult']:
        """
        A list of the supported Commitments.
        """
        return pulumi.get(self, "items")


class AwaitableGetSupportedCommitmentsResult(GetSupportedCommitmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSupportedCommitmentsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            host_shape_name=self.host_shape_name,
            id=self.id,
            items=self.items)


def get_supported_commitments(compartment_id: Optional[str] = None,
                              filters: Optional[Sequence[pulumi.InputType['GetSupportedCommitmentsFilterArgs']]] = None,
                              host_shape_name: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSupportedCommitmentsResult:
    """
    This data source provides the list of Supported Commitments in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported Commitments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_commitments = oci.Ocvp.get_supported_commitments(compartment_id=var["compartment_id"],
        host_shape_name=oci_core_shape["test_shape"]["name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str host_shape_name: A filter to return only resources that match or support the given ESXi host shape.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['hostShapeName'] = host_shape_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Ocvp/getSupportedCommitments:getSupportedCommitments', __args__, opts=opts, typ=GetSupportedCommitmentsResult).value

    return AwaitableGetSupportedCommitmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        host_shape_name=pulumi.get(__ret__, 'host_shape_name'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_supported_commitments)
def get_supported_commitments_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                     filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSupportedCommitmentsFilterArgs']]]]] = None,
                                     host_shape_name: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSupportedCommitmentsResult]:
    """
    This data source provides the list of Supported Commitments in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

    Lists supported Commitments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_supported_commitments = oci.Ocvp.get_supported_commitments(compartment_id=var["compartment_id"],
        host_shape_name=oci_core_shape["test_shape"]["name"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str host_shape_name: A filter to return only resources that match or support the given ESXi host shape.
    """
    ...
