/*
 * Decompiled with CFR 0.152.
 */
package io.ray.api.id;

import io.ray.api.id.BaseId;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class ActorId
extends BaseId
implements Serializable {
    private static final int UNIQUE_BYTES_LENGTH = 4;
    public static final int LENGTH = 6;
    public static final ActorId NIL = ActorId.nil();

    private ActorId(byte[] id) {
        super(id);
    }

    public static ActorId fromByteBuffer(ByteBuffer bb) {
        return new ActorId(ActorId.byteBuffer2Bytes(bb));
    }

    public static ActorId fromBytes(byte[] bytes) {
        return new ActorId(bytes);
    }

    private static ActorId nil() {
        byte[] b = new byte[6];
        Arrays.fill(b, (byte)-1);
        return new ActorId(b);
    }

    public static ActorId fromRandom() {
        byte[] b = new byte[6];
        new Random().nextBytes(b);
        return new ActorId(b);
    }

    @Override
    public int size() {
        return 6;
    }
}

