/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime;

import io.ray.api.exception.RayException;
import io.ray.api.runtime.RayRuntime;
import io.ray.runtime.AbstractRayRuntime;
import io.ray.runtime.RayRuntimeInternal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RayRuntimeProxy
implements InvocationHandler {
    private AbstractRayRuntime obj;

    private RayRuntimeProxy(AbstractRayRuntime obj) {
        this.obj = obj;
    }

    public AbstractRayRuntime getRuntimeObject() {
        return this.obj;
    }

    static RayRuntimeInternal newInstance(AbstractRayRuntime obj) {
        return (RayRuntimeInternal)Proxy.newProxyInstance(obj.getClass().getClassLoader(), new Class[]{RayRuntimeInternal.class}, (InvocationHandler)new RayRuntimeProxy(obj));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isInterfaceMethod(method) && !method.getName().equals("shutdown") && !method.getName().equals("setAsyncContext")) {
            this.checkIsContextSet();
        }
        try {
            return method.invoke((Object)this.obj, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    private boolean isInterfaceMethod(Method method) {
        try {
            RayRuntime.class.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void checkIsContextSet() {
        if (!this.obj.isContextSet.get().booleanValue()) {
            throw new RayException("`Ray.wrap***` is not called on the current thread. If you want to use Ray API in your own threads, please wrap your executable with `Ray.wrap***`.");
        }
    }
}

