/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.actor;

import com.google.common.base.Preconditions;
import io.ray.api.BaseActor;
import io.ray.api.id.ActorId;
import io.ray.runtime.actor.NativeRayJavaActor;
import io.ray.runtime.actor.NativeRayPyActor;
import io.ray.runtime.generated.Common;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public abstract class NativeRayActor
implements BaseActor,
Externalizable {
    byte[] actorId;
    private Common.Language language;

    NativeRayActor(byte[] actorId, Common.Language language) {
        Preconditions.checkState(!ActorId.fromBytes(actorId).isNil());
        this.actorId = actorId;
        this.language = language;
    }

    NativeRayActor() {
    }

    public static NativeRayActor create(byte[] actorId, Common.Language language) {
        switch (language) {
            case JAVA: {
                return new NativeRayJavaActor(actorId);
            }
            case PYTHON: {
                return new NativeRayPyActor(actorId);
            }
        }
        throw new IllegalStateException("Unknown actor handle language: " + language);
    }

    @Override
    public ActorId getId() {
        return ActorId.fromBytes(this.actorId);
    }

    public Common.Language getLanguage() {
        return this.language;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(NativeRayActor.nativeSerialize(this.actorId));
        out.writeObject(this.language);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.actorId = NativeRayActor.nativeDeserialize((byte[])in.readObject());
        this.language = (Common.Language)in.readObject();
    }

    public byte[] toBytes() {
        return NativeRayActor.nativeSerialize(this.actorId);
    }

    public static NativeRayActor fromBytes(byte[] bytes) {
        byte[] actorId = NativeRayActor.nativeDeserialize(bytes);
        Common.Language language = Common.Language.forNumber(NativeRayActor.nativeGetLanguage(actorId));
        Preconditions.checkNotNull(language);
        return NativeRayActor.create(actorId, language);
    }

    protected void finalize() {
    }

    private static native int nativeGetLanguage(byte[] var0);

    static native List<String> nativeGetActorCreationTaskFunctionDescriptor(byte[] var0);

    private static native byte[] nativeSerialize(byte[] var0);

    private static native byte[] nativeDeserialize(byte[] var0);
}

