/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.context;

import com.google.common.base.Preconditions;
import io.ray.api.id.ActorId;
import io.ray.api.id.JobId;
import io.ray.api.id.TaskId;
import io.ray.api.id.UniqueId;
import io.ray.runtime.context.WorkerContext;
import io.ray.runtime.generated.Common;
import io.ray.runtime.task.LocalModeTaskSubmitter;

public class LocalModeWorkerContext
implements WorkerContext {
    private final JobId jobId;
    private ThreadLocal<Common.TaskSpec> currentTask = new ThreadLocal();
    private final ThreadLocal<UniqueId> currentWorkerId = new ThreadLocal();

    public LocalModeWorkerContext(JobId jobId) {
        this.jobId = jobId;
    }

    @Override
    public UniqueId getCurrentWorkerId() {
        return this.currentWorkerId.get();
    }

    public void setCurrentWorkerId(UniqueId workerId) {
        this.currentWorkerId.set(workerId);
    }

    @Override
    public JobId getCurrentJobId() {
        return this.jobId;
    }

    @Override
    public ActorId getCurrentActorId() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        if (taskSpec == null) {
            return ActorId.NIL;
        }
        return LocalModeTaskSubmitter.getActorId(taskSpec);
    }

    @Override
    public ClassLoader getCurrentClassLoader() {
        return null;
    }

    @Override
    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
    }

    @Override
    public Common.TaskType getCurrentTaskType() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        Preconditions.checkNotNull(taskSpec, "Current task is not set.");
        return taskSpec.getType();
    }

    @Override
    public TaskId getCurrentTaskId() {
        Common.TaskSpec taskSpec = this.currentTask.get();
        Preconditions.checkState(taskSpec != null);
        return TaskId.fromBytes(taskSpec.getTaskId().toByteArray());
    }

    public void setCurrentTask(Common.TaskSpec taskSpec) {
        this.currentTask.set(taskSpec);
    }
}

