/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.gcs;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClient {
    private static final int JEDIS_POOL_SIZE = 1;
    private JedisPool jedisPool;

    public RedisClient(String redisAddress) {
        this(redisAddress, null);
    }

    public RedisClient(String redisAddress, String password) {
        String[] ipAndPort = redisAddress.split(":");
        if (ipAndPort.length != 2) {
            throw new IllegalArgumentException("The argument redisAddress should be formatted as ip:port.");
        }
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(1);
        this.jedisPool = Strings.isNullOrEmpty(password) ? new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, ipAndPort[0], Integer.parseInt(ipAndPort[1]), 30000) : new JedisPool(jedisPoolConfig, ipAndPort[0], Integer.parseInt(ipAndPort[1]), 30000, password);
    }

    public Long set(String key, String value, String field) {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (field == null) {
                jedis.set(key, value);
                Long l = 1L;
                return l;
            }
            Long l = jedis.hset(key, field, value);
            return l;
        }
    }

    public String hmset(String key, Map<String, String> hash) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.hmset(key, hash);
            return string;
        }
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            Map<byte[], byte[]> map = jedis.hgetAll(key);
            return map;
        }
    }

    public String get(String key, String field) {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (field == null) {
                String string = jedis.get(key);
                return string;
            }
            String string = jedis.hget(key, field);
            return string;
        }
    }

    public byte[] get(byte[] key) {
        return this.get(key, null);
    }

    public byte[] get(byte[] key, byte[] field) {
        try (Jedis jedis = this.jedisPool.getResource();){
            if (field == null) {
                byte[] byArray = jedis.get(key);
                return byArray;
            }
            byte[] byArray = jedis.hget(key, field);
            return byArray;
        }
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        try (Jedis jedis = this.jedisPool.getResource();){
            List<byte[]> list = jedis.lrange(key, start, end);
            return list;
        }
    }

    public boolean exists(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.exists(key);
            return bl;
        }
    }

    public long incr(byte[] key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            long l = jedis.incr(key).intValue();
            return l;
        }
    }
}

