/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.util;

import io.ray.api.id.BaseId;

public class IdUtil {
    public static long murmurHashCode(BaseId id) {
        return IdUtil.murmurHash64A(id.getBytes(), id.size(), 0);
    }

    private static long murmurHash64A(byte[] data, int length, int seed) {
        long m3 = -4132994306676758123L;
        int r = 47;
        long h2 = (long)seed & 0xFFFFFFFFL ^ (long)length * -4132994306676758123L;
        int length8 = length / 8;
        for (int i = 0; i < length8; ++i) {
            int i8 = i * 8;
            long k = ((long)data[i8] & 0xFFL) + (((long)data[i8 + 1] & 0xFFL) << 8) + (((long)data[i8 + 2] & 0xFFL) << 16) + (((long)data[i8 + 3] & 0xFFL) << 24) + (((long)data[i8 + 4] & 0xFFL) << 32) + (((long)data[i8 + 5] & 0xFFL) << 40) + (((long)data[i8 + 6] & 0xFFL) << 48) + (((long)data[i8 + 7] & 0xFFL) << 56);
            k *= -4132994306676758123L;
            k ^= k >>> 47;
            h2 ^= (k *= -4132994306676758123L);
            h2 *= -4132994306676758123L;
        }
        int remaining = length % 8;
        if (remaining >= 7) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 6] & 0xFF) << 48;
        }
        if (remaining >= 6) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 5] & 0xFF) << 40;
        }
        if (remaining >= 5) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 4] & 0xFF) << 32;
        }
        if (remaining >= 4) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 3] & 0xFF) << 24;
        }
        if (remaining >= 3) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 2] & 0xFF) << 16;
        }
        if (remaining >= 2) {
            h2 ^= (long)(data[(length & 0xFFFFFFF8) + 1] & 0xFF) << 8;
        }
        if (remaining >= 1) {
            h2 ^= (long)(data[length & 0xFFFFFFF8] & 0xFF);
            h2 *= -4132994306676758123L;
        }
        h2 ^= h2 >>> 47;
        h2 *= -4132994306676758123L;
        h2 ^= h2 >>> 47;
        return h2;
    }
}

