/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import io.ray.api.RayActor;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import io.ray.streaming.runtime.worker.JobWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ExecutionGraph
implements Serializable {
    private final String jobName;
    private Map<String, String> jobConfig;
    private Map<Integer, ExecutionJobVertex> executionJobVertexMap;
    private int maxParallelism;
    private long buildTime;
    private AtomicInteger executionVertexIdGenerator = new AtomicInteger(0);

    public ExecutionGraph(String jobName) {
        this.jobName = jobName;
        this.buildTime = System.currentTimeMillis();
    }

    public String getJobName() {
        return this.jobName;
    }

    public List<ExecutionJobVertex> getExecutionJobVertexList() {
        return new ArrayList<ExecutionJobVertex>(this.executionJobVertexMap.values());
    }

    public Map<Integer, ExecutionJobVertex> getExecutionJobVertexMap() {
        return this.executionJobVertexMap;
    }

    public void setExecutionJobVertexMap(Map<Integer, ExecutionJobVertex> executionJobVertexMap) {
        this.executionJobVertexMap = executionJobVertexMap;
    }

    public Map<String, String> getJobConfig() {
        return this.jobConfig;
    }

    public void setJobConfig(Map<String, String> jobConfig) {
        this.jobConfig = jobConfig;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public void setMaxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public int generateExecutionVertexId() {
        return this.executionVertexIdGenerator.getAndIncrement();
    }

    public AtomicInteger getExecutionVertexIdGenerator() {
        return this.executionVertexIdGenerator;
    }

    public List<ExecutionVertex> getAllExecutionVertices() {
        return this.executionJobVertexMap.values().stream().map(ExecutionJobVertex::getExecutionVertices).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<ExecutionVertex> getAllAddedExecutionVertices() {
        return this.executionJobVertexMap.values().stream().map(ExecutionJobVertex::getExecutionVertices).flatMap(Collection::stream).filter(vertex -> vertex.is2Add()).collect(Collectors.toList());
    }

    public ExecutionVertex getExecutionJobVertexByJobVertexId(int vertexId) {
        for (ExecutionJobVertex executionJobVertex : this.executionJobVertexMap.values()) {
            for (ExecutionVertex executionVertex : executionJobVertex.getExecutionVertices()) {
                if (executionVertex.getId() != vertexId) continue;
                return executionVertex;
            }
        }
        throw new RuntimeException("Vertex " + vertexId + " does not exist!");
    }

    public List<RayActor<JobWorker>> getAllActors() {
        return this.getActorsFromJobVertices(this.getExecutionJobVertexList());
    }

    public List<RayActor<JobWorker>> getSourceActors() {
        List<ExecutionJobVertex> executionJobVertices = this.getExecutionJobVertexList().stream().filter(ExecutionJobVertex::isSourceVertex).collect(Collectors.toList());
        return this.getActorsFromJobVertices(executionJobVertices);
    }

    public List<RayActor<JobWorker>> getNonSourceActors() {
        List<ExecutionJobVertex> executionJobVertices = this.getExecutionJobVertexList().stream().filter(executionJobVertex -> executionJobVertex.isTransformationVertex() || executionJobVertex.isSinkVertex()).collect(Collectors.toList());
        return this.getActorsFromJobVertices(executionJobVertices);
    }

    public List<RayActor<JobWorker>> getSinkActors() {
        List<ExecutionJobVertex> executionJobVertices = this.getExecutionJobVertexList().stream().filter(ExecutionJobVertex::isSinkVertex).collect(Collectors.toList());
        return this.getActorsFromJobVertices(executionJobVertices);
    }

    public List<RayActor<JobWorker>> getActorsFromJobVertices(List<ExecutionJobVertex> executionJobVertices) {
        return executionJobVertices.stream().map(ExecutionJobVertex::getExecutionVertices).flatMap(Collection::stream).map(ExecutionVertex::getWorkerActor).collect(Collectors.toList());
    }
}

