/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import io.ray.streaming.api.partition.Partition;
import io.ray.streaming.jobgraph.JobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobVertex;

public class ExecutionJobEdge {
    private final ExecutionJobVertex sourceVertex;
    private final ExecutionJobVertex targetVertex;
    private final Partition partition;
    private final String executionJobEdgeIndex;

    public ExecutionJobEdge(ExecutionJobVertex sourceVertex, ExecutionJobVertex targetVertex, JobEdge jobEdge) {
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.partition = jobEdge.getPartition();
        this.executionJobEdgeIndex = this.generateExecutionJobEdgeIndex();
    }

    private String generateExecutionJobEdgeIndex() {
        return this.sourceVertex.getJobVertexId() + "\u2014" + this.targetVertex.getJobVertexId();
    }

    public ExecutionJobVertex getSourceVertex() {
        return this.sourceVertex;
    }

    public ExecutionJobVertex getTargetVertex() {
        return this.targetVertex;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("srcVertex", this.sourceVertex).add("targetVertex", this.targetVertex).add("partition", this.partition).add("executionJobEdgeIndex", this.executionJobEdgeIndex).toString();
    }
}

