/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.resource;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.ray.api.id.UniqueId;
import io.ray.streaming.runtime.core.resource.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resources
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Resources.class);
    private List<Container> registerContainers = new ArrayList<Container>();

    public ImmutableList<Container> getRegisteredContainers() {
        return ImmutableList.copyOf(this.registerContainers);
    }

    public void registerContainer(Container container) {
        LOG.info("Add container {} to registry list.", (Object)container);
        this.registerContainers.add(container);
    }

    public void unRegisterContainer(List<UniqueId> deletedUniqueIds) {
        Iterator<Container> iter = this.registerContainers.iterator();
        while (iter.hasNext()) {
            Container deletedContainer = iter.next();
            if (!deletedUniqueIds.contains(deletedContainer.getNodeId())) continue;
            LOG.info("Remove container {} from registry list.", (Object)deletedContainer);
            iter.remove();
        }
    }

    public ImmutableMap<UniqueId, Container> getRegisteredContainerMap() {
        return ImmutableMap.copyOf(this.registerContainers.stream().collect(Collectors.toMap(Container::getNodeId, c -> c)));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("registerContainers", this.registerContainers).toString();
    }
}

